/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.search;

import java.io.File;
import org.apache.hop.core.config.DescribedVariable;
import org.apache.hop.core.config.DescribedVariablesConfigFile;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableCallback;
import org.apache.hop.ui.hopgui.HopGui;

public class HopGuiDescribedVariableSearchable
implements ISearchable<DescribedVariable> {
    private DescribedVariable describedVariable;
    private String configFilename;

    public HopGuiDescribedVariableSearchable(DescribedVariable describedVariable, String configFilename) {
        this.describedVariable = describedVariable;
        this.configFilename = configFilename;
    }

    public String getLocation() {
        return "A variable in : " + (this.configFilename == null ? HopConfig.getInstance().getConfigFilename() : this.configFilename);
    }

    public String getName() {
        return this.describedVariable.getName();
    }

    public String getType() {
        return "Variable";
    }

    public String getFilename() {
        return this.configFilename == null ? HopConfig.getInstance().getConfigFilename() : this.configFilename;
    }

    public DescribedVariable getSearchableObject() {
        return this.describedVariable;
    }

    public ISearchableCallback getSearchCallback() {
        return (searchable, searchResult) -> {
            String realConfigFilename = HopGui.getInstance().getVariables().resolve(this.configFilename);
            if (realConfigFilename == null) {
                HopGui.getInstance().menuToolsEditConfigVariables();
            } else if (new File(realConfigFilename).exists()) {
                DescribedVariablesConfigFile configFile = new DescribedVariablesConfigFile(realConfigFilename);
                configFile.readFromFile();
                HopGui.editConfigFile(HopGui.getInstance().getShell(), realConfigFilename, configFile, searchResult.getComponent());
            }
        };
    }
}

