/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.pluginexplorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

@HopPerspectivePlugin(id="500-HopPluginExplorerPerspective", name="i18n::PluginExplorerPerspective.Name", description="The Hop Plugin Explorer Perspective", image="ui/images/plugin.svg")
@GuiPlugin(description="i18n::PluginExplorerPerspective.GuiPlugin.Description")
public class HopPluginExplorePerspective
implements IHopPerspective {
    public static final Class<?> PKG = HopPluginExplorePerspective.class;
    public static final String ID_PERSPECTIVE_TOOLBAR_ITEM = "20030-perspective-plugins";
    private HopGui hopGui;
    private Composite composite;
    private CCombo wPluginType;
    private TableView wPluginView;
    private Map<String, List<Object[]>> dataMap;
    private Map<String, IRowMeta> metaMap;
    private String[] pluginsType;
    private String selectedPluginType;

    @Override
    public String getId() {
        return "plugin-explorer";
    }

    @Override
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler activeFileTypeHandler) {
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Collections.emptyList();
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.loadPlugin();
        PropsUi props = PropsUi.getInstance();
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)formData);
        Label label = new Label(this.composite, 16384);
        label.setText(BaseMessages.getString(PKG, (String)"PluginExplorerPerspective.PluginType.Label", (String[])new String[0]));
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, props.getMargin());
        label.setLayoutData((Object)fdlFields);
        this.wPluginType = new CCombo(this.composite, 18440);
        this.wPluginType.setItems(this.pluginsType);
        this.wPluginType.setText(this.selectedPluginType);
        props.setLook((Control)this.wPluginType);
        FormData fdlSubject = new FormData();
        fdlSubject.left = new FormAttachment((Control)label, props.getMargin());
        fdlSubject.top = new FormAttachment((Control)label, 0, 0x1000000);
        this.wPluginType.setLayoutData((Object)fdlSubject);
        this.wPluginType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HopPluginExplorePerspective.this.selectedPluginType = HopPluginExplorePerspective.this.wPluginType.getText();
                HopPluginExplorePerspective.this.refresh();
            }
        });
        IRowMeta rowMeta = this.metaMap.get(this.selectedPluginType);
        ColumnInfo[] colinf = new ColumnInfo[rowMeta.size()];
        for (int i = 0; i < rowMeta.size(); ++i) {
            IValueMeta v = rowMeta.getValueMeta(i);
            colinf[i] = new ColumnInfo(v.getName(), 1, v.isNumeric());
            colinf[i].setToolTip(v.toStringMeta());
            colinf[i].setValueMeta(v);
        }
        this.wPluginView = new TableView((IVariables)new Variables(), this.composite, 67586, colinf, 0, null, props);
        this.wPluginView.setShowingBlueNullValues(true);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wPluginType, props.getMargin());
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wPluginView.setLayoutData(fdFields);
        this.refresh();
    }

    private void loadPlugin() {
        try {
            this.metaMap = new HashMap<String, IRowMeta>();
            this.dataMap = new HashMap<String, List<Object[]>>();
            PluginRegistry registry = PluginRegistry.getInstance();
            List pluginTypeClasses = registry.getPluginTypes();
            for (Class pluginTypeClass : pluginTypeClasses) {
                IPluginType pluginTypeInterface = registry.getPluginType(pluginTypeClass);
                if (pluginTypeInterface.isFragment()) continue;
                String name = pluginTypeInterface.getName();
                RowBuffer pluginInformation = registry.getPluginInformation(pluginTypeClass);
                this.metaMap.put(name, pluginInformation.getRowMeta());
                this.dataMap.put(name, pluginInformation.getBuffer());
            }
            this.pluginsType = this.metaMap.keySet().toArray(new String[this.metaMap.size()]);
            Arrays.sort(this.pluginsType);
            this.selectedPluginType = "";
            if (!this.metaMap.isEmpty()) {
                this.selectedPluginType = this.pluginsType[0];
            }
        }
        catch (HopPluginException e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"PluginExplorerPerspective.Error.CollectPlugin.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PluginExplorerPerspective.Error.CollectPlugin.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    protected void refresh() {
        this.wPluginView.clearAll();
        IRowMeta rowMeta = this.metaMap.get(this.selectedPluginType);
        List<Object[]> buffer = this.dataMap.get(this.selectedPluginType);
        Table table = this.wPluginView.getTable();
        table.setRedraw(false);
        for (int i = 0; i < buffer.size(); ++i) {
            TableItem item = i == 0 ? table.getItem(i) : new TableItem(table, 0);
            Object[] row = buffer.get(i);
            item.setText(0, Integer.toString(i + 1));
            for (int column = 0; column < rowMeta.size(); ++column) {
                try {
                    IValueMeta vm = rowMeta.getValueMeta(column);
                    String value = vm.getString(row[column]);
                    if (value == null) continue;
                    item.setText(column + 1, value);
                    item.setForeground(column + 1, GuiResource.getInstance().getColorBlack());
                    continue;
                }
                catch (HopValueException hopValueException) {
                    // empty catch block
                }
            }
        }
        if (!this.wPluginView.isDisposed()) {
            this.wPluginView.optWidth(true, buffer.size());
            table.setRedraw(true);
        }
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        return false;
    }

    @Override
    public List<TabItemHandler> getItems() {
        return null;
    }

    @Override
    public void navigateToPreviousFile() {
    }

    @Override
    public void navigateToNextFile() {
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        return false;
    }

    @Override
    public boolean hasNavigationNextFile() {
        return false;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        ArrayList<IGuiContextHandler> handlers = new ArrayList<IGuiContextHandler>();
        return handlers;
    }

    @Override
    public List<ISearchable> getSearchables() {
        ArrayList<ISearchable> searchables = new ArrayList<ISearchable>();
        return searchables;
    }
}

