/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file.types.log;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class LogExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler
implements IExplorerFileTypeHandler {
    private Text wText;

    public LogExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    @Override
    public void renderFile(Composite composite) {
        this.wText = new Text(composite, 770);
        PropsUi.getInstance().setLook((Control)this.wText, 1);
        this.wText.setEditable(false);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment(0, 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.wText.setLayoutData((Object)fdText);
        File file = new File(this.explorerFile.getFilename());
        if (file.exists()) {
            try {
                String contents = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                this.wText.setText(contents);
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error reading contents of file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
            }
        }
    }
}

