/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline.delegates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IUndo;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopGuiPipelineClipboardDelegate {
    private static final Class<?> PKG = HopGui.class;
    public static final String XML_TAG_PIPELINE_TRANSFORMS = "pipeline-transforms";
    private static final String XML_TAG_TRANSFORMS = "transforms";
    private HopGui hopGui;
    private HopGuiPipelineGraph pipelineGraph;
    private ILogChannel log;

    public HopGuiPipelineClipboardDelegate(HopGui hopGui, HopGuiPipelineGraph pipelineGraph) {
        this.hopGui = hopGui;
        this.pipelineGraph = pipelineGraph;
        this.log = hopGui.getLog();
    }

    public void toClipboard(String clipText) {
        try {
            GuiResource.getInstance().toClipboard(clipText);
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionCopyToClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionCopyToClipboard.Message", (String[])new String[0]), e);
        }
    }

    public String fromClipboard() {
        try {
            return GuiResource.getInstance().fromClipboard();
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionPasteFromClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.ExceptionPasteFromClipboard.Message", (String[])new String[0]), e);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pasteXml(PipelineMeta pipelineMeta, String clipcontent, Point loc) {
        try {
            void var20_39;
            Document doc = XmlHandler.loadXmlString((String)clipcontent);
            Node pipelineNode = XmlHandler.getSubNode((Node)doc, (String)XML_TAG_PIPELINE_TRANSFORMS);
            pipelineMeta.unselectAll();
            Node transformsNode = XmlHandler.getSubNode((Node)pipelineNode, (String)XML_TAG_TRANSFORMS);
            int nr = XmlHandler.countNodes((Node)transformsNode, (String)"transform");
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopGui.Log.FoundTransforms", (String[])new String[]{"" + nr}) + loc);
            }
            Object[] transforms = new TransformMeta[nr];
            ArrayList<String> transformOldNames = new ArrayList<String>(nr);
            Point min = new Point(99999999, 99999999);
            for (int i = 0; i < nr; ++i) {
                Node transformNode = XmlHandler.getSubNodeByNr((Node)transformsNode, (String)"transform", (int)i);
                transforms[i] = new TransformMeta(transformNode, this.hopGui.getMetadataProvider());
                if (loc == null) continue;
                Point p = transforms[i].getLocation();
                if (min.x > p.x) {
                    min.x = p.x;
                }
                if (min.y <= p.y) continue;
                min.y = p.y;
            }
            Node hopsNode = XmlHandler.getSubNode((Node)pipelineNode, (String)"order");
            nr = XmlHandler.countNodes((Node)hopsNode, (String)"hop");
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopGui.Log.FoundHops", (String[])new String[]{"" + nr}));
            }
            Object[] hops = new PipelineHopMeta[nr];
            for (int i = 0; i < nr; ++i) {
                Node hopNode = XmlHandler.getSubNodeByNr((Node)hopsNode, (String)"hop", (int)i);
                hops[i] = new PipelineHopMeta(hopNode, Arrays.asList(transforms));
            }
            Point offset = new Point(loc.x - min.x, loc.y - min.y);
            int[] position = new int[transforms.length];
            for (int i = 0; i < transforms.length; ++i) {
                Point p = transforms[i].getLocation();
                String name = transforms[i].getName();
                PropsUi.setLocation((IGuiPosition)transforms[i], p.x + offset.x, p.y + offset.y);
                transformOldNames.add(name);
                transforms[i].setName(pipelineMeta.getAlternativeTransformName(name));
                pipelineMeta.addTransform(transforms[i]);
                position[i] = pipelineMeta.indexOfTransform(transforms[i]);
                transforms[i].setSelected(true);
            }
            for (PipelineHopMeta pipelineHopMeta : hops) {
                pipelineMeta.addPipelineHop(pipelineHopMeta);
            }
            Node notesNode = XmlHandler.getSubNode((Node)pipelineNode, (String)"notepads");
            nr = XmlHandler.countNodes((Node)notesNode, (String)"notepad");
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"HopGui.Log.FoundNotepads", (String[])new String[]{"" + nr}));
            }
            Object[] notes = new NotePadMeta[nr];
            for (int i = 0; i < notes.length; ++i) {
                Node node = XmlHandler.getSubNodeByNr((Node)notesNode, (String)"notepad", (int)i);
                notes[i] = new NotePadMeta(node);
                Point p = notes[i].getLocation();
                PropsUi.setLocation((IGuiPosition)notes[i], p.x + offset.x, p.y + offset.y);
                pipelineMeta.addNote(notes[i]);
                notes[i].setSelected(true);
            }
            for (TransformMeta transformMeta : transforms) {
                ITransformMeta smi = transformMeta.getTransform();
                smi.searchInfoAndTargetTransforms(pipelineMeta.getTransforms());
            }
            Node errorHandlingNode = XmlHandler.getSubNode((Node)pipelineNode, (String)"transform_error_handling");
            int n = XmlHandler.countNodes((Node)errorHandlingNode, (String)"error");
            for (int i = 0; i < n; ++i) {
                Node node = XmlHandler.getSubNodeByNr((Node)errorHandlingNode, (String)"error", (int)i);
                TransformErrorMeta transformErrorMeta = new TransformErrorMeta(node, pipelineMeta.getTransforms());
                int srcTransformPos = transformOldNames.indexOf(transformErrorMeta.getSourceTransform().getName());
                int tgtTransformPos = transformOldNames.indexOf(transformErrorMeta.getTargetTransform().getName());
                TransformMeta sourceTransform = pipelineMeta.findTransform(transforms[srcTransformPos].getName());
                if (sourceTransform != null) {
                    sourceTransform.setTransformErrorMeta(transformErrorMeta);
                }
                sourceTransform.setTransformErrorMeta(null);
                if (tgtTransformPos < 0) continue;
                sourceTransform.setTransformErrorMeta(transformErrorMeta);
                TransformMeta targetTransform = pipelineMeta.findTransform(transforms[tgtTransformPos].getName());
                transformErrorMeta.setSourceTransform(sourceTransform);
                transformErrorMeta.setTargetTransform(targetTransform);
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, transforms, position, false);
            int[] hopPos = new int[hops.length];
            boolean bl = false;
            while (var20_39 < hops.length) {
                hopPos[var20_39] = pipelineMeta.indexOfPipelineHop(hops[var20_39]);
                ++var20_39;
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, hops, hopPos, true);
            int[] nArray = new int[notes.length];
            for (int i = 0; i < notes.length; ++i) {
                nArray[i] = pipelineMeta.indexOfNote(notes[i]);
            }
            this.hopGui.undoDelegate.addUndoNew((IUndo)pipelineMeta, notes, nArray, true);
        }
        catch (HopException e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnablePasteTransforms.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopGui.Dialog.UnablePasteTransforms.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.pipelineGraph.redraw();
    }

    public void copySelected(PipelineMeta pipelineMeta, List<TransformMeta> transforms, List<NotePadMeta> notes) {
        if (transforms == null || transforms.size() == 0) {
            return;
        }
        StringBuilder xml = new StringBuilder(5000).append(XmlHandler.getXmlHeader());
        try {
            xml.append(XmlHandler.openTag((String)XML_TAG_PIPELINE_TRANSFORMS)).append(Const.CR);
            xml.append(XmlHandler.openTag((String)XML_TAG_TRANSFORMS)).append(Const.CR);
            for (TransformMeta transform : transforms) {
                xml.append(transform.getXml());
            }
            xml.append(XmlHandler.closeTag((String)XML_TAG_TRANSFORMS)).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"order")).append(Const.CR);
            for (TransformMeta transform1 : transforms) {
                for (TransformMeta transform2 : transforms) {
                    PipelineHopMeta hop;
                    if (transform1 == transform2 || (hop = pipelineMeta.findPipelineHop(transform1, transform2, true)) == null) continue;
                    xml.append(hop.getXml()).append(Const.CR);
                }
            }
            xml.append(XmlHandler.closeTag((String)"order")).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"notepads")).append(Const.CR);
            if (notes != null) {
                for (NotePadMeta note : notes) {
                    xml.append(note.getXml());
                }
            }
            xml.append(XmlHandler.closeTag((String)"notepads")).append(Const.CR);
            xml.append(XmlHandler.openTag((String)"transform_error_handling")).append(Const.CR);
            for (TransformMeta transform : transforms) {
                if (transform.getTransformErrorMeta() == null) continue;
                xml.append(transform.getTransformErrorMeta().getXml()).append(Const.CR);
            }
            xml.append(XmlHandler.closeTag((String)"transform_error_handling")).append(Const.CR);
            xml.append(XmlHandler.closeTag((String)XML_TAG_PIPELINE_TRANSFORMS)).append(Const.CR);
            this.toClipboard(xml.toString());
        }
        catch (Exception ex) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error encoding to XML", ex);
        }
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public HopGuiPipelineGraph getPipelineGraph() {
        return this.pipelineGraph;
    }

    public void setPipelineGraph(HopGuiPipelineGraph pipelineGraph) {
        this.pipelineGraph = pipelineGraph;
    }
}

