/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.util.Arrays;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AboutDialog
extends Dialog {
    private static final Class<?> PKG = AboutDialog.class;
    private static final String[] PROPERTIES = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vm.vendor", "java.specification.version", "java.class.path", "file.encoding", "HOP_CONFIG_FOLDER", "HOP_PLATFORM_RUNTIME", "HOP_PLUGIN_BASE_FOLDERS", "HOP_SHARED_JDBC_FOLDER"};
    private Shell shell;

    public AboutDialog(Shell parent) {
        super(parent, 0);
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        PropsUi props = PropsUi.getInstance();
        this.shell = new Shell(parent, 268503152);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AboutDialog.Title", (String[])new String[0]));
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.setSize(700, 500);
        this.shell.setMinimumSize(450, 300);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        props.setLook((Control)this.shell);
        Composite composite = new Composite((Composite)this.shell, 0);
        FormData fdLink = new FormData();
        fdLink.top = new FormAttachment(0, 0);
        fdLink.left = new FormAttachment(0, 0);
        fdLink.right = new FormAttachment(100, 0);
        composite.setLayoutData((Object)fdLink);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        props.setLook((Control)composite);
        Label wLogo = new Label(composite, 0x1000000);
        wLogo.setImage(SwtSvgImageUtil.getImageAsResource(display, "ui/images/logo_hop.svg").getAsBitmapForSize((Device)display, 100, 100));
        wLogo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 3));
        Label wName = new Label(composite, 0x1000000);
        wName.setText("Apache Hop\n(Incubating)");
        wName.setFont(GuiResource.getInstance().getFontBold());
        wName.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        props.setLook((Control)wName);
        Label wVersion = new Label(composite, 0x1000000);
        wVersion.setText(HopGui.class.getPackage().getImplementationVersion());
        wVersion.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        props.setLook((Control)wVersion);
        Link wLink = new Link(composite, 66);
        wLink.setText("<a href=\"https://hop.apache.org\">hop.apache.org</a>");
        wLink.addListener(13, e -> Program.launch((String)"https://hop.apache.org"));
        wLink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        props.setLook((Control)wLink);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk}, 4, null);
        Text wText = new Text((Composite)this.shell, 2890);
        wText.setText(this.getProperties());
        FormData fdText = new FormData();
        fdText.top = new FormAttachment((Control)composite, 4);
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.bottom = new FormAttachment((Control)wOk, -4);
        wText.setLayoutData((Object)fdText);
        props.setLook((Control)wText);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AboutDialog.this.ok();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private String getProperties() {
        StringBuilder builder = new StringBuilder();
        Arrays.sort(PROPERTIES);
        for (String name : PROPERTIES) {
            builder.append(name);
            builder.append('=');
            builder.append(System.getProperty(name, ""));
            builder.append('\n');
        }
        return builder.toString();
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

