/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.gui;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElements;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GuiCompositeWidgets {
    private IVariables variables;
    private Map<String, Control> labelsMap;
    private Map<String, Control> widgetsMap;
    private int maxNrItems;
    private int nrItems;
    private IGuiPluginCompositeWidgetsListener compositeWidgetsListener;

    public GuiCompositeWidgets(IVariables variables) {
        this(variables, 0);
    }

    public GuiCompositeWidgets(IVariables variables, int maxNrItems) {
        this.variables = variables;
        this.maxNrItems = maxNrItems;
        this.labelsMap = new HashMap<String, Control>();
        this.widgetsMap = new HashMap<String, Control>();
        this.nrItems = 0;
        this.compositeWidgetsListener = null;
    }

    public void createCompositeWidgets(Object sourceData, String parentKey, Composite parent, String parentGuiElementId, Control lastControl) {
        String key;
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(key = StringUtils.isEmpty((String)parentKey) ? sourceData.getClass().getName() : parentKey, parentGuiElementId);
        if (guiElements == null) {
            System.err.println("Create widgets: no GUI elements found for parent: " + key + ", parent ID: " + parentGuiElementId);
            return;
        }
        this.addCompositeWidgets(sourceData, parent, guiElements, lastControl);
        if (this.compositeWidgetsListener != null) {
            this.compositeWidgetsListener.widgetsCreated(this);
        }
        parent.layout(true, true);
    }

    private Control addCompositeWidgets(Object sourceObject, Composite parent, GuiElements guiElements, Control lastControl) {
        if (guiElements.isIgnored()) {
            return lastControl;
        }
        PropsUi props = PropsUi.getInstance();
        Label label = null;
        Control control = null;
        if (guiElements.getId() != null) {
            if (StringUtils.isNotEmpty((String)guiElements.getLabel())) {
                label = new Label(parent, 131076);
                props.setLook((Control)label);
                label.setText(Const.NVL((String)guiElements.getLabel(), (String)""));
                if (StringUtils.isNotEmpty((String)guiElements.getToolTip())) {
                    label.setToolTipText(guiElements.getToolTip());
                }
                FormData fdLabel = new FormData();
                fdLabel.left = new FormAttachment(0, 0);
                fdLabel.top = lastControl == null ? new FormAttachment(0, props.getMargin()) : new FormAttachment(lastControl, props.getMargin());
                fdLabel.right = new FormAttachment(35, 0);
                label.setLayoutData((Object)fdLabel);
                this.labelsMap.put(guiElements.getId(), (Control)label);
            }
            switch (guiElements.getType()) {
                case TEXT: {
                    control = this.getTextControl(parent, guiElements, props);
                    break;
                }
                case CHECKBOX: {
                    control = this.getCheckboxControl(parent, guiElements, props);
                    break;
                }
                case COMBO: {
                    control = this.getComboControl(sourceObject, parent, guiElements, props);
                    break;
                }
            }
            if (control != null) {
                FormData fdControl = new FormData();
                if (label != null) {
                    fdControl.left = new FormAttachment(35, props.getMargin());
                    fdControl.right = new FormAttachment(100, 0);
                    fdControl.top = new FormAttachment((Control)label, 0, 0x1000000);
                } else {
                    fdControl.left = new FormAttachment(35, props.getMargin());
                    fdControl.right = new FormAttachment(100, 0);
                    fdControl.top = lastControl != null ? new FormAttachment(lastControl, props.getMargin()) : new FormAttachment(0, 0);
                }
                control.setLayoutData((Object)fdControl);
                return control;
            }
            return lastControl;
        }
        Control previousControl = lastControl;
        List children = guiElements.getChildren();
        Collections.sort(children);
        for (GuiElements child : guiElements.getChildren()) {
            previousControl = this.addCompositeWidgets(sourceObject, parent, child, previousControl);
            ++this.nrItems;
        }
        while (this.nrItems < this.maxNrItems) {
            label = new Label(parent, 131076);
            props.setLook((Control)label);
            label.setText("                                                                    ");
            FormData fdLabel = new FormData();
            fdLabel.left = new FormAttachment(0, 0);
            fdLabel.top = previousControl == null ? new FormAttachment(0, 0) : new FormAttachment(previousControl, props.getMargin());
            fdLabel.right = new FormAttachment(35, 0);
            label.setLayoutData((Object)fdLabel);
            previousControl = label;
            ++this.nrItems;
        }
        return previousControl;
    }

    private Control getComboControl(Object sourceObject, Composite parent, GuiElements guiElements, PropsUi props) {
        Object control;
        String[] comboItems = this.getEnumValues(guiElements.getFieldClass());
        if (comboItems == null) {
            comboItems = StringUtils.isNotEmpty((String)guiElements.getGetComboValuesMethod()) ? this.getComboItems(sourceObject, guiElements.getGetComboValuesMethod()) : new String[]{};
        }
        if (guiElements.isVariablesEnabled()) {
            ComboVar comboVar = new ComboVar(this.variables, parent, 18436);
            props.setLook((Control)comboVar);
            this.widgetsMap.put(guiElements.getId(), (Control)comboVar);
            comboVar.setItems(comboItems);
            control = comboVar;
        } else {
            Combo combo = new Combo(parent, 18436);
            props.setLook((Control)combo);
            combo.setItems(comboItems);
            this.widgetsMap.put(guiElements.getId(), (Control)combo);
            control = combo;
        }
        this.addModifyListener((Control)control, guiElements.getId());
        return control;
    }

    private String[] getEnumValues(Class<?> fieldClass) {
        try {
            if (fieldClass.isEnum()) {
                ?[] enumConstants = fieldClass.getEnumConstants();
                String[] values = new String[enumConstants.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = enumConstants[i].toString();
                }
                return values;
            }
            return null;
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error finding enum values of field class: " + fieldClass.getName(), (Throwable)e);
            return null;
        }
    }

    private Control getCheckboxControl(Composite parent, GuiElements guiElements, PropsUi props) {
        Button button = new Button(parent, 16416);
        props.setLook((Control)button);
        this.widgetsMap.put(guiElements.getId(), (Control)button);
        this.addModifyListener((Control)button, guiElements.getId());
        Button control = button;
        return control;
    }

    private Control getTextControl(Composite parent, GuiElements guiElements, PropsUi props) {
        Object control;
        if (guiElements.isVariablesEnabled()) {
            TextVar textVar = new TextVar(this.variables, parent, 18436);
            props.setLook((Control)textVar);
            if (guiElements.isPassword()) {
                textVar.setEchoChar('*');
            }
            this.widgetsMap.put(guiElements.getId(), (Control)textVar);
            this.addModifyListener((Control)textVar.getTextWidget(), guiElements.getId());
            control = textVar;
        } else {
            Text text = new Text(parent, 18436);
            props.setLook((Control)text);
            if (guiElements.isPassword()) {
                text.setEchoChar('*');
            }
            this.widgetsMap.put(guiElements.getId(), (Control)text);
            this.addModifyListener((Control)text, guiElements.getId());
            control = text;
        }
        return control;
    }

    private void addModifyListener(Control control, String widgetId) {
        if (control instanceof Button) {
            control.addListener(13, event -> this.notifyWidgetModified(event, control, widgetId));
        } else if (control instanceof Combo || control instanceof ComboVar) {
            control.addListener(13, event -> this.notifyWidgetModified(event, control, widgetId));
            control.addListener(24, event -> this.notifyWidgetModified(event, control, widgetId));
        } else {
            control.addListener(24, event -> this.notifyWidgetModified(event, control, widgetId));
        }
    }

    protected void notifyWidgetModified(Event event, Control control, String widgetId) {
        if (this.compositeWidgetsListener != null) {
            this.compositeWidgetsListener.widgetModified(this, control, widgetId);
        }
    }

    private String[] getComboItems(Object sourceObject, String getComboValuesMethod) {
        try {
            Method method = sourceObject.getClass().getMethod(getComboValuesMethod, ILogChannel.class, IHopMetadataProvider.class);
            if (method == null) {
                throw new HopException("Unable to find method '" + getComboValuesMethod + "' with parameters ILogChannel and IHopMetadataProvider in object '" + sourceObject + "'");
            }
            List names = (List)method.invoke(sourceObject, LogChannel.UI, HopGui.getInstance().getMetadataProvider());
            return names.toArray(new String[0]);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting list of combo items for method '" + getComboValuesMethod + "' on source object: " + sourceObject, (Throwable)e);
            return new String[0];
        }
    }

    public void setWidgetsContents(Object sourceData, Composite parentComposite, String parentGuiElementId) {
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(sourceData.getClass().getName(), parentGuiElementId);
        if (guiElements == null) {
            return;
        }
        this.setWidgetsData(sourceData, guiElements);
        if (this.compositeWidgetsListener != null) {
            this.compositeWidgetsListener.widgetsCreated(this);
        }
        parentComposite.layout(true, true);
    }

    private void setWidgetsData(Object sourceData, GuiElements guiElements) {
        if (guiElements.isIgnored()) {
            return;
        }
        if (guiElements.getId() != null) {
            Control control = this.widgetsMap.get(guiElements.getId());
            if (control != null) {
                Object value = null;
                try {
                    value = new PropertyDescriptor(guiElements.getFieldName(), sourceData.getClass()).getReadMethod().invoke(sourceData, new Object[0]);
                }
                catch (Exception e) {
                    System.err.println("Unable to get value for field: '" + guiElements.getFieldName() + "' : " + e.getMessage());
                    e.printStackTrace();
                }
                String stringValue = value == null ? "" : Const.NVL((String)value.toString(), (String)"");
                switch (guiElements.getType()) {
                    case TEXT: {
                        if (guiElements.isVariablesEnabled()) {
                            TextVar textVar = (TextVar)control;
                            textVar.setText(stringValue);
                            break;
                        }
                        Text text = (Text)control;
                        text.setText(stringValue);
                        break;
                    }
                    case CHECKBOX: {
                        Button button = (Button)control;
                        button.setSelection(((Boolean)value).booleanValue());
                        break;
                    }
                    case COMBO: {
                        if (guiElements.isVariablesEnabled()) {
                            ComboVar comboVar = (ComboVar)control;
                            comboVar.setText(stringValue);
                            break;
                        }
                        Combo combo = (Combo)control;
                        combo.setText(stringValue);
                        break;
                    }
                    default: {
                        System.err.println("WARNING: setting data on widget with ID " + guiElements.getId() + " : not implemented type " + guiElements.getType() + " yet.");
                        break;
                    }
                }
            } else {
                System.err.println("Widget not found to set value on for id: " + guiElements.getId() + ", label: " + guiElements.getLabel());
            }
        } else {
            for (GuiElements child : guiElements.getChildren()) {
                this.setWidgetsData(sourceData, child);
            }
        }
    }

    public void getWidgetsContents(Object sourceData, String parentGuiElementId) {
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(sourceData.getClass().getName(), parentGuiElementId);
        if (guiElements == null) {
            System.err.println("getWidgetsContents: no GUI elements found for class: " + sourceData.getClass().getName() + ", parent ID: " + parentGuiElementId);
            return;
        }
        this.getWidgetsData(sourceData, guiElements);
    }

    private void getWidgetsData(Object sourceData, GuiElements guiElements) {
        if (guiElements.isIgnored()) {
            return;
        }
        if (guiElements.getId() != null) {
            Control control = this.widgetsMap.get(guiElements.getId());
            if (control != null) {
                Object value = null;
                switch (guiElements.getType()) {
                    case TEXT: {
                        if (guiElements.isVariablesEnabled()) {
                            TextVar textVar = (TextVar)control;
                            value = textVar.getText();
                            break;
                        }
                        Text text = (Text)control;
                        value = text.getText();
                        break;
                    }
                    case CHECKBOX: {
                        Button button = (Button)control;
                        value = button.getSelection();
                        break;
                    }
                    case COMBO: {
                        if (guiElements.isVariablesEnabled()) {
                            ComboVar comboVar = (ComboVar)control;
                            value = comboVar.getText();
                            break;
                        }
                        Combo combo = (Combo)control;
                        value = combo.getText();
                        break;
                    }
                    default: {
                        System.err.println("WARNING: getting data from widget with ID " + guiElements.getId() + " : not implemented type " + guiElements.getType() + " yet.");
                    }
                }
                try {
                    Class fieldClass = guiElements.getFieldClass();
                    if (fieldClass.isEnum()) {
                        Class enumClass = fieldClass;
                        if (value != null) {
                            value = Enum.valueOf(enumClass, value.toString());
                        }
                    }
                    new PropertyDescriptor(guiElements.getFieldName(), sourceData.getClass()).getWriteMethod().invoke(sourceData, value);
                }
                catch (Exception e) {
                    System.err.println("Unable to set value '" + value + "'on field: '" + guiElements.getFieldName() + "' : " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("Widget not found to set value on for id: " + guiElements.getId() + ", label: " + guiElements.getLabel());
            }
        } else {
            for (GuiElements child : guiElements.getChildren()) {
                this.getWidgetsData(sourceData, child);
            }
        }
    }

    public IGuiPluginCompositeWidgetsListener getWidgetsListener() {
        return this.compositeWidgetsListener;
    }

    public void setWidgetsListener(IGuiPluginCompositeWidgetsListener listener) {
        this.compositeWidgetsListener = listener;
    }

    public void enableWidgets(Object sourceData, String parentGuiElementId, boolean enabled) {
        GuiRegistry registry = GuiRegistry.getInstance();
        GuiElements guiElements = registry.findGuiElements(sourceData.getClass().getName(), parentGuiElementId);
        if (guiElements == null) {
            System.err.println("enableWidgets: no GUI elements found for class: " + sourceData.getClass().getName() + ", parent ID: " + parentGuiElementId);
            return;
        }
        this.enableWidget(sourceData, guiElements, enabled);
    }

    private void enableWidget(Object sourceData, GuiElements guiElements, boolean enabled) {
        if (guiElements.isIgnored()) {
            return;
        }
        if (guiElements.getId() != null) {
            if (!guiElements.getId().matches("driverClass")) {
                Control label = this.labelsMap.get(guiElements.getId());
                Control widget = this.widgetsMap.get(guiElements.getId());
                if (label != null) {
                    label.setEnabled(enabled);
                } else {
                    System.err.println("Label not found to enable/disable: " + guiElements);
                }
                if (widget != null) {
                    widget.setEnabled(enabled);
                } else {
                    System.err.println("Widget not found to enable/disable: " + guiElements);
                }
            }
        } else {
            for (GuiElements child : guiElements.getChildren()) {
                this.enableWidget(sourceData, child, enabled);
            }
        }
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public Map<String, Control> getLabelsMap() {
        return this.labelsMap;
    }

    public void setLabelsMap(Map<String, Control> labelsMap) {
        this.labelsMap = labelsMap;
    }

    public Map<String, Control> getWidgetsMap() {
        return this.widgetsMap;
    }

    public void setWidgetsMap(Map<String, Control> widgetsMap) {
        this.widgetsMap = widgetsMap;
    }
}

