/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TransformFieldsDialog
extends Dialog {
    private static final Class<?> PKG = TransformFieldsDialog.class;
    private TableView wFields;
    private final IRowMeta input;
    private Shell shell;
    private final PropsUi props;
    private String transformName;
    private final IVariables variables;
    private String shellText;
    private String originText;
    private boolean showEditButton = true;

    public TransformFieldsDialog(Shell parent, IVariables variables, int style, String transformName, IRowMeta input) {
        super(parent, style);
        this.transformName = transformName;
        this.input = input;
        this.variables = variables;
        this.props = PropsUi.getInstance();
        this.shellText = BaseMessages.getString(PKG, (String)"TransformFieldsDialog.Title", (String[])new String[0]);
        this.originText = BaseMessages.getString(PKG, (String)"TransformFieldsDialog.Name.Label", (String[])new String[0]);
        this.showEditButton = true;
    }

    public Object open() {
        Button[] buttons;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        this.shell.setText(this.shellText);
        int margin = this.props.getMargin();
        if (this.showEditButton) {
            Button wEdit = new Button((Composite)this.shell, 8);
            wEdit.setText(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.Buttons.EditOrigin", (String[])new String[0]));
            wEdit.addListener(13, e -> this.edit());
            Button wCancel = new Button((Composite)this.shell, 8);
            wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            wCancel.addListener(13, e -> this.cancel());
            buttons = new Button[]{wEdit, wCancel};
        } else {
            Button wClose = new Button((Composite)this.shell, 8);
            wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
            wClose.addListener(13, e -> this.cancel());
            buttons = new Button[]{wClose};
        }
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons, margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 0);
        wlTransformName.setText(this.originText);
        this.props.setLook((Control)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        Text wTransformName = new Text((Composite)this.shell, 16396);
        wTransformName.setText(this.transformName);
        this.props.setLook((Control)wTransformName);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment((Control)wlTransformName, margin);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        wTransformName.setLayoutData((Object)fdTransformName);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)wlTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.input.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Fieldname", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Type", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.ConversionMask", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Length", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Precision", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Origin", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.StorageType", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Currency", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Decimal", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Group", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.TrimType", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.TableCol.Comments", (String[])new String[0]), 1, false, true)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, true, null, this.props);
        this.wFields.optWidth(true);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)buttons[0], -margin * 2);
        this.wFields.setLayoutData(fdFields);
        this.wFields.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TransformFieldsDialog.this.edit();
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.edit(), c -> this.cancel());
        return this.transformName;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        for (int i = 0; i < this.input.size(); ++i) {
            TableItem item = this.wFields.table.getItem(i);
            IValueMeta v = this.input.getValueMeta(i);
            int idx = 1;
            if (v.getName() != null) {
                item.setText(idx++, v.getName());
            }
            item.setText(idx++, v.getTypeDesc());
            item.setText(idx++, Const.NVL((String)v.getConversionMask(), (String)""));
            item.setText(idx++, v.getLength() < 0 ? "-" : "" + v.getLength());
            item.setText(idx++, v.getPrecision() < 0 ? "-" : "" + v.getPrecision());
            item.setText(idx++, Const.NVL((String)v.getOrigin(), (String)""));
            item.setText(idx++, ValueMetaBase.getStorageTypeCode((int)v.getStorageType()));
            item.setText(idx++, Const.NVL((String)v.getCurrencySymbol(), (String)""));
            item.setText(idx++, Const.NVL((String)v.getDecimalSymbol(), (String)""));
            item.setText(idx++, Const.NVL((String)v.getGroupingSymbol(), (String)""));
            item.setText(idx++, ValueMetaBase.getTrimTypeDesc((int)v.getTrimType()));
            item.setText(idx++, Const.NVL((String)v.getComments(), (String)""));
        }
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void edit() {
        int idx = this.wFields.table.getSelectionIndex();
        if (idx >= 0) {
            this.transformName = this.wFields.table.getItem(idx).getText(5);
            this.dispose();
        } else {
            this.transformName = null;
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.OriginTransform.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransformFieldsDialog.OriginTransform.Message", (String[])new String[0]));
            mb.open();
        }
    }

    public String getShellText() {
        return this.shellText;
    }

    public void setShellText(String shellText) {
        this.shellText = shellText;
    }

    public String getOriginText() {
        return this.originText;
    }

    public void setOriginText(String originText) {
        this.originText = originText;
    }

    public boolean isShowEditButton() {
        return this.showEditButton;
    }

    public void setShowEditButton(boolean showEditButton) {
        this.showEditButton = showEditButton;
    }
}

