/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.lang.reflect.InvocationTargetException;
import org.apache.hop.core.Const;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressMonitorDialog {
    private static final Class<?> PKG = ProgressMonitorDialog.class;
    protected Shell parent;
    protected Shell shell;
    private Display display;
    protected IProgressMonitor progressMonitor;
    private Label wlImage;
    private Label wlTask;
    private Label wlSubTask;
    private ProgressBar wProgressBar;
    private boolean isCancelled;
    private InvocationTargetException targetException;
    private InterruptedException interruptedException;

    public ProgressMonitorDialog(Shell parent) {
        this.parent = parent;
        this.progressMonitor = new ProgressMonitor();
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        PropsUi props = PropsUi.getInstance();
        this.shell = new Shell(this.parent, 0x10 | (cancelable ? 64 : 0));
        this.shell.setText(BaseMessages.getString(PKG, (String)"ProgressMonitorDialog.Shell.Title", (String[])new String[0]));
        props.setLook((Control)this.shell);
        this.display = this.shell.getDisplay();
        FormLayout formLayout = new FormLayout();
        formLayout.marginTop = 5;
        formLayout.marginLeft = 5;
        formLayout.marginRight = 5;
        formLayout.marginBottom = 5;
        int margin = 4;
        this.shell.setLayout((Layout)formLayout);
        this.wlImage = new Label((Composite)this.shell, 0);
        this.wlImage.setImage(GuiResource.getInstance().getImageHopUi());
        props.setLook((Control)this.wlImage);
        FormData fdlImage = new FormData();
        fdlImage.right = new FormAttachment(100, 0);
        fdlImage.top = new FormAttachment(0, 0);
        this.wlImage.setLayoutData((Object)fdlImage);
        this.wlTask = new Label((Composite)this.shell, 16384);
        this.wlTask.setText(BaseMessages.getString(PKG, (String)"ProgressMonitorDialog.InitialTaskLabel", (String[])new String[0]));
        props.setLook((Control)this.wlTask);
        FormData fdlTask = new FormData();
        fdlTask.left = new FormAttachment(0, 0);
        fdlTask.top = new FormAttachment(0, 0);
        fdlTask.right = new FormAttachment((Control)this.wlImage, -margin);
        this.wlTask.setLayoutData((Object)fdlTask);
        this.wlSubTask = new Label((Composite)this.shell, 16384);
        this.wlSubTask.setText(BaseMessages.getString(PKG, (String)"ProgressMonitorDialog.InitialSubTaskLabel", (String[])new String[0]));
        props.setLook((Control)this.wlSubTask);
        FormData fdlSubTask = new FormData();
        fdlSubTask.left = new FormAttachment(0, 0);
        fdlSubTask.top = new FormAttachment((Control)this.wlTask, margin);
        fdlSubTask.right = new FormAttachment((Control)this.wlImage, -margin);
        this.wlSubTask.setLayoutData((Object)fdlSubTask);
        this.wProgressBar = new ProgressBar((Composite)this.shell, 256);
        this.wProgressBar.setMinimum(0);
        this.wProgressBar.setMaximum(100);
        this.wProgressBar.setSelection(0);
        FormData fdProgressBar = new FormData();
        fdProgressBar.left = new FormAttachment(0, 0);
        fdProgressBar.right = new FormAttachment((Control)this.wlImage, -margin);
        fdProgressBar.top = new FormAttachment((Control)this.wlSubTask, margin);
        this.wProgressBar.setLayoutData((Object)fdProgressBar);
        if (cancelable) {
            Button wCancel = new Button((Composite)this.shell, 8);
            wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
            wCancel.addListener(13, e -> {
                this.isCancelled = true;
            });
            BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wCancel}, margin, (Control)this.wProgressBar);
        }
        BaseTransformDialog.setSize(this.shell);
        this.shell.addListener(21, e -> {
            e.doit = false;
            this.isCancelled = true;
        });
        this.shell.open();
        Cursor oldCursor = this.shell.getCursor();
        this.parent.setCursor(this.display.getSystemCursor(1));
        Runnable longRunnable = () -> new Thread(() -> {
            try {
                runnable.run(this.progressMonitor);
            }
            catch (InvocationTargetException e) {
                this.targetException = e;
            }
            catch (InterruptedException e) {
                this.interruptedException = e;
            }
        }).start();
        this.display.asyncExec(longRunnable);
        try {
            while (!this.shell.isDisposed()) {
                if (this.interruptedException != null) {
                    this.dispose();
                    throw this.interruptedException;
                }
                if (this.targetException != null) {
                    this.dispose();
                    throw this.targetException;
                }
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }
        finally {
            this.parent.setCursor(oldCursor);
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    private void dispose() {
        this.display.asyncExec(() -> {
            PropsUi.getInstance().setScreen(new WindowProperty(this.shell));
            this.shell.dispose();
        });
    }

    private class ProgressMonitor
    implements IProgressMonitor {
        private ProgressMonitor() {
        }

        public void beginTask(String message, int nrWorks) {
            ProgressMonitorDialog.this.display.asyncExec(() -> {
                Shell shell = ProgressMonitorDialog.this.shell;
                synchronized (shell) {
                    if (ProgressMonitorDialog.this.shell.isDisposed() || ProgressMonitorDialog.this.wlTask.isDisposed()) {
                        return;
                    }
                    try {
                        ProgressMonitorDialog.this.wlTask.setText(Const.NVL((String)message, (String)""));
                        ProgressMonitorDialog.this.wProgressBar.setMaximum(nrWorks);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        public void subTask(String message) {
            ProgressMonitorDialog.this.display.asyncExec(() -> {
                Shell shell = ProgressMonitorDialog.this.shell;
                synchronized (shell) {
                    if (ProgressMonitorDialog.this.shell.isDisposed() || ProgressMonitorDialog.this.wlSubTask.isDisposed()) {
                        return;
                    }
                    try {
                        ProgressMonitorDialog.this.wlSubTask.setText(Const.NVL((String)message, (String)""));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        public boolean isCanceled() {
            return ProgressMonitorDialog.this.isCancelled;
        }

        public void worked(int nrWorks) {
            ProgressMonitorDialog.this.display.asyncExec(() -> {
                Shell shell = ProgressMonitorDialog.this.shell;
                synchronized (shell) {
                    if (ProgressMonitorDialog.this.shell.isDisposed() || ProgressMonitorDialog.this.wlTask.isDisposed()) {
                        return;
                    }
                    try {
                        ProgressMonitorDialog.this.wProgressBar.setSelection(nrWorks);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        public void done() {
            ProgressMonitorDialog.this.dispose();
        }

        public void setTaskName(String taskName) {
            ProgressMonitorDialog.this.display.asyncExec(() -> {
                Shell shell = ProgressMonitorDialog.this.shell;
                synchronized (shell) {
                    if (ProgressMonitorDialog.this.shell.isDisposed() || ProgressMonitorDialog.this.wlTask.isDisposed()) {
                        return;
                    }
                    try {
                        ProgressMonitorDialog.this.wlTask.setText(Const.NVL((String)taskName, (String)""));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

