/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class EnterStringsDialog
extends Dialog {
    private static final Class<?> PKG = EnterStringsDialog.class;
    private TableView wFields;
    private Shell shell;
    private RowMetaAndData strings;
    private PropsUi props;
    private boolean readOnly;
    private String message;
    private String title;
    private Image shellImage;

    public EnterStringsDialog(Shell parent, int style, RowMetaAndData strings) {
        super(parent, style);
        this.strings = strings;
        this.props = PropsUi.getInstance();
        this.readOnly = false;
        this.title = BaseMessages.getString(PKG, (String)"EnterStringsDialog.Title", (String[])new String[0]);
        this.message = BaseMessages.getString(PKG, (String)"EnterStringsDialog.Message", (String[])new String[0]);
    }

    public RowMetaAndData open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3184);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        int margin = this.props.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(this.message);
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.strings.getRowMeta().size();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"EnterStringsDialog.StringName.Label", (String[])new String[0]), 1, false, this.readOnly), new ColumnInfo(BaseMessages.getString(PKG, (String)"EnterStringsDialog.StringValue.Label", (String[])new String[0]), 1, false, this.readOnly)};
        this.wFields = new TableView(Variables.getADefaultVariableSpace(), (Composite)this.shell, 67586, columns, nrRows, null, this.props);
        this.wFields.setReadonly(this.readOnly);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, 30);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        this.getData();
        if (this.shellImage != null) {
            this.shell.setImage(this.shellImage);
        }
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.strings;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.strings != null) {
            for (int i = 0; i < this.strings.getRowMeta().size(); ++i) {
                String string;
                IValueMeta valueMeta = this.strings.getRowMeta().getValueMeta(i);
                Object valueData = this.strings.getData()[i];
                try {
                    string = valueMeta.getString(valueData);
                }
                catch (HopValueException e) {
                    string = "";
                }
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, valueMeta.getName());
                if (Utils.isEmpty((CharSequence)string)) continue;
                item.setText(2, string);
            }
        }
        this.wFields.sortTable(1);
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.strings = null;
        this.dispose();
    }

    private void ok() {
        if (this.readOnly) {
            int nrNonEmptyFields = this.wFields.nrNonEmpty();
            for (int i = 0; i < nrNonEmptyFields; ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                String name = item.getText(1);
                for (int j = 0; j < this.strings.getRowMeta().size(); ++j) {
                    IValueMeta valueMeta = this.strings.getRowMeta().getValueMeta(j);
                    if (!valueMeta.getName().equalsIgnoreCase(name)) continue;
                    String stringValue = item.getText(2);
                    this.strings.getData()[j] = stringValue;
                }
            }
        } else {
            this.strings.clear();
            int nrNonEmptyFields = this.wFields.nrNonEmpty();
            for (int i = 0; i < nrNonEmptyFields; ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                String name = item.getText(1);
                String value = item.getText(2);
                this.strings.addValue((IValueMeta)new ValueMetaString(name), (Object)value);
            }
        }
        this.dispose();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setShellImage(Image shellImage) {
        this.shellImage = shellImage;
    }
}

