/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.Props;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.config.plugin.ConfigPluginType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.i18n.GlobalMessages;
import org.apache.hop.i18n.LanguageChoice;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnterOptionsDialog
extends Dialog {
    private static final Class<?> PKG = EnterOptionsDialog.class;
    public static final String GUI_WIDGETS_PARENT_ID = "EnterOptionsDialog-GuiWidgetsParent";
    public static final String STRING_USAGE_WARNING_PARAMETER = "EnterOptionsRestartWarning";
    private Display display;
    private CTabFolder wTabFolder;
    private FontData fixedFontData;
    private FontData graphFontData;
    private FontData noteFontData;
    private Font fixedFont;
    private Font graphFont;
    private Font noteFont;
    private RGB backgroundRGB;
    private RGB graphColorRGB;
    private RGB tabColorRGB;
    private Color background;
    private Color graphColor;
    private Color tabColor;
    private Canvas wFFont;
    private Canvas wGFont;
    private Canvas wNFont;
    private Canvas wBGColor;
    private Canvas wGrColor;
    private Canvas wTabColor;
    private Text wFilename;
    private Text wIconSize;
    private Text wLineWidth;
    private Text wDefaultPreview;
    private Text wMiddlePct;
    private Text wGridSize;
    private Button wOriginalLook;
    private Button wDarkMode;
    private Button wShowCanvasGrid;
    private Button wUseCache;
    private Button wOpenLast;
    private Button wAutoSave;
    private Button wAutoSplit;
    private Button wCopyDistrib;
    private Button wExitWarning;
    private Combo wDefaultLocale;
    private Shell shell;
    private PropsUi props = PropsUi.getInstance();
    private int middle;
    private int margin;
    private Button wToolTip;
    private Button wHelpTip;
    private Button wbUseDoubleClick;
    private Button wbUseGlobalFileBookmarks;
    private Button wAutoCollapse;
    private List<PluginWidgetContents> pluginWidgetContentsList = new ArrayList<PluginWidgetContents>();

    public EnterOptionsDialog(Shell parent) {
        super(parent, 0);
    }

    public Props open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.getData();
        this.shell = new Shell(parent, 268503152);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = this.props.getMargin();
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.addGeneralTab();
        this.addLookTab();
        this.addPluginTabs();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, this.margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        wOk.addListener(13, e -> this.ok());
        wCancel.addListener(13, e -> this.cancel());
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.props;
    }

    private void addLookTab() {
        int h = 40;
        CTabItem wLookTab = new CTabItem(this.wTabFolder, 0);
        wLookTab.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.LookAndFeel.Label", (String[])new String[0]));
        ScrolledComposite sLookComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        sLookComp.setLayout((Layout)new FillLayout());
        Composite wLookComp = new Composite((Composite)sLookComp, 0);
        this.props.setLook((Control)wLookComp);
        FormLayout lookLayout = new FormLayout();
        lookLayout.marginWidth = 3;
        lookLayout.marginHeight = 3;
        wLookComp.setLayout((Layout)lookLayout);
        int nr = 0;
        Label wlFFont = new Label(wLookComp, 131072);
        wlFFont.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.FixedWidthFont.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFFont);
        FormData fdlFFont = new FormData();
        fdlFFont.left = new FormAttachment(0, 0);
        fdlFFont.right = new FormAttachment(this.middle, -this.margin);
        fdlFFont.top = new FormAttachment(0, nr * h + this.margin + 10);
        wlFFont.setLayoutData((Object)fdlFFont);
        Button wdFFont = new Button(wLookComp, 0x1000008);
        this.props.setLook((Control)wdFFont);
        FormData fddFFont = this.layoutResetOptionButton(wdFFont);
        fddFFont.right = new FormAttachment(100, 0);
        fddFFont.top = new FormAttachment(0, nr * h + this.margin);
        fddFFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wdFFont.setLayoutData((Object)fddFFont);
        wdFFont.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EnterOptionsDialog.this.fixedFontData = new FontData(PropsUi.getInstance().getFixedFont().getName(), PropsUi.getInstance().getFixedFont().getHeight(), PropsUi.getInstance().getFixedFont().getStyle());
                EnterOptionsDialog.this.fixedFont.dispose();
                EnterOptionsDialog.this.fixedFont = new Font((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.fixedFontData);
                EnterOptionsDialog.this.wFFont.redraw();
            }
        });
        Button wbFFont = new Button(wLookComp, 8);
        this.props.setLook((Control)wbFFont);
        FormData fdbFFont = this.layoutEditOptionButton(wbFFont);
        fdbFFont.right = new FormAttachment((Control)wdFFont, -this.margin);
        fdbFFont.top = new FormAttachment(0, nr * h + this.margin);
        fdbFFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wbFFont.setLayoutData((Object)fdbFFont);
        wbFFont.addListener(13, e -> {
            FontDialog fd = new FontDialog(this.shell);
            fd.setFontList(new FontData[]{this.fixedFontData});
            FontData newfd = fd.open();
            if (newfd != null) {
                this.fixedFontData = newfd;
                this.fixedFont.dispose();
                this.fixedFont = new Font((Device)this.display, this.fixedFontData);
                this.wFFont.redraw();
            }
        });
        this.wFFont = new Canvas(wLookComp, 2048);
        this.props.setLook((Control)this.wFFont);
        FormData fdFFont = new FormData();
        fdFFont.left = new FormAttachment(this.middle, 0);
        fdFFont.right = new FormAttachment((Control)wbFFont, -this.margin);
        fdFFont.top = new FormAttachment(0, this.margin);
        fdFFont.bottom = new FormAttachment(0, h);
        this.wFFont.setLayoutData((Object)fdFFont);
        this.wFFont.addPaintListener(pe -> {
            pe.gc.setFont(this.fixedFont);
            Rectangle max = this.wFFont.getBounds();
            String name = this.fixedFontData.getName() + " - " + this.fixedFontData.getHeight();
            Point size = pe.gc.textExtent(name);
            pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
        });
        ++nr;
        Label wlGFont = new Label(wLookComp, 131072);
        wlGFont.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GraphFont.Label", (String[])new String[0]));
        this.props.setLook((Control)wlGFont);
        FormData fdlGFont = new FormData();
        fdlGFont.left = new FormAttachment(0, 0);
        fdlGFont.right = new FormAttachment(this.middle, -this.margin);
        fdlGFont.top = new FormAttachment(0, nr * h + this.margin + 10);
        wlGFont.setLayoutData((Object)fdlGFont);
        Button wdGFont = new Button(wLookComp, 8);
        this.props.setLook((Control)wdGFont);
        FormData fddGFont = this.layoutResetOptionButton(wdGFont);
        fddGFont.right = new FormAttachment(100, 0);
        fddGFont.top = new FormAttachment(0, nr * h + this.margin);
        fddGFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wdGFont.setLayoutData((Object)fddGFont);
        wdGFont.addListener(13, e -> {
            this.graphFont.dispose();
            this.graphFontData = this.props.getDefaultFontData();
            this.graphFont = new Font((Device)this.display, this.graphFontData);
            this.wGFont.redraw();
        });
        Button wbGFont = new Button(wLookComp, 8);
        this.props.setLook((Control)wbGFont);
        FormData fdbGFont = this.layoutEditOptionButton(wbGFont);
        fdbGFont.right = new FormAttachment((Control)wdGFont, -this.margin);
        fdbGFont.top = new FormAttachment(0, nr * h + this.margin);
        fdbGFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wbGFont.setLayoutData((Object)fdbGFont);
        wbGFont.addListener(13, e -> {
            FontDialog fd = new FontDialog(this.shell);
            fd.setFontList(new FontData[]{this.graphFontData});
            FontData newfd = fd.open();
            if (newfd != null) {
                this.graphFontData = newfd;
                this.graphFont.dispose();
                this.graphFont = new Font((Device)this.display, this.graphFontData);
                this.wGFont.redraw();
            }
        });
        this.wGFont = new Canvas(wLookComp, 2048);
        this.props.setLook((Control)this.wGFont);
        FormData fdGFont = new FormData();
        fdGFont.left = new FormAttachment(this.middle, 0);
        fdGFont.right = new FormAttachment((Control)wbGFont, -this.margin);
        fdGFont.top = new FormAttachment(0, nr * h + this.margin);
        fdGFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        this.wGFont.setLayoutData((Object)fdGFont);
        this.wGFont.addPaintListener(pe -> {
            pe.gc.setFont(this.graphFont);
            Rectangle max = this.wGFont.getBounds();
            String name = this.graphFontData.getName() + " - " + this.graphFontData.getHeight();
            Point size = pe.gc.textExtent(name);
            pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
        });
        ++nr;
        Label wlNFont = new Label(wLookComp, 131072);
        wlNFont.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.NoteFont.Label", (String[])new String[0]));
        this.props.setLook((Control)wlNFont);
        FormData fdlNFont = new FormData();
        fdlNFont.left = new FormAttachment(0, 0);
        fdlNFont.right = new FormAttachment(this.middle, -this.margin);
        fdlNFont.top = new FormAttachment(0, nr * h + this.margin + 10);
        wlNFont.setLayoutData((Object)fdlNFont);
        Button wdNFont = new Button(wLookComp, 8);
        this.props.setLook((Control)wdNFont);
        FormData fddNFont = this.layoutResetOptionButton(wdNFont);
        fddNFont.right = new FormAttachment(100, 0);
        fddNFont.top = new FormAttachment(0, nr * h + this.margin);
        fddNFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wdNFont.setLayoutData((Object)fddNFont);
        wdNFont.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EnterOptionsDialog.this.noteFontData = EnterOptionsDialog.this.props.getDefaultFontData();
                EnterOptionsDialog.this.noteFont.dispose();
                EnterOptionsDialog.this.noteFont = new Font((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.noteFontData);
                EnterOptionsDialog.this.wNFont.redraw();
            }
        });
        Button wbNFont = new Button(wLookComp, 8);
        this.props.setLook((Control)wbNFont);
        FormData fdbNFont = this.layoutEditOptionButton(wbNFont);
        fdbNFont.right = new FormAttachment((Control)wdNFont, -this.margin);
        fdbNFont.top = new FormAttachment(0, nr * h + this.margin);
        fdbNFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wbNFont.setLayoutData((Object)fdbNFont);
        wbNFont.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FontDialog fd = new FontDialog(EnterOptionsDialog.this.shell);
                fd.setFontList(new FontData[]{EnterOptionsDialog.this.noteFontData});
                FontData newfd = fd.open();
                if (newfd != null) {
                    EnterOptionsDialog.this.noteFontData = newfd;
                    EnterOptionsDialog.this.noteFont.dispose();
                    EnterOptionsDialog.this.noteFont = new Font((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.noteFontData);
                    EnterOptionsDialog.this.wNFont.redraw();
                }
            }
        });
        this.wNFont = new Canvas(wLookComp, 2048);
        this.props.setLook((Control)this.wNFont);
        FormData fdNFont = new FormData();
        fdNFont.left = new FormAttachment(this.middle, 0);
        fdNFont.right = new FormAttachment((Control)wbNFont, -this.margin);
        fdNFont.top = new FormAttachment(0, nr * h + this.margin);
        fdNFont.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        this.wNFont.setLayoutData((Object)fdNFont);
        this.wNFont.addPaintListener(pe -> {
            pe.gc.setFont(this.noteFont);
            Rectangle max = this.wNFont.getBounds();
            String name = this.noteFontData.getName() + " - " + this.noteFontData.getHeight();
            Point size = pe.gc.textExtent(name);
            pe.gc.drawText(name, (max.width - size.x) / 2, (max.height - size.y) / 2, true);
        });
        ++nr;
        Label wlBGColor = new Label(wLookComp, 131072);
        wlBGColor.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.BackgroundColor.Label", (String[])new String[0]));
        this.props.setLook((Control)wlBGColor);
        FormData fdlBGColor = new FormData();
        fdlBGColor.left = new FormAttachment(0, 0);
        fdlBGColor.right = new FormAttachment(this.middle, -this.margin);
        fdlBGColor.top = new FormAttachment(0, nr * h + this.margin + 10);
        wlBGColor.setLayoutData((Object)fdlBGColor);
        Button wdBGcolor = new Button(wLookComp, 8);
        this.props.setLook((Control)wdBGcolor);
        FormData fddBGColor = this.layoutResetOptionButton(wdBGcolor);
        fddBGColor.right = new FormAttachment(100, 0);
        fddBGColor.top = new FormAttachment(0, nr * h + this.margin);
        fddBGColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wdBGcolor.setLayoutData((Object)fddBGColor);
        wdBGcolor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EnterOptionsDialog.this.background.dispose();
                EnterOptionsDialog.this.backgroundRGB = new RGB(255, 255, 255);
                EnterOptionsDialog.this.background = new Color((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.backgroundRGB);
                EnterOptionsDialog.this.wBGColor.setBackground(EnterOptionsDialog.this.background);
                EnterOptionsDialog.this.wBGColor.redraw();
            }
        });
        Button wbBGColor = new Button(wLookComp, 8);
        this.props.setLook((Control)wbBGColor);
        FormData fdbBGColor = this.layoutEditOptionButton(wbBGColor);
        fdbBGColor.right = new FormAttachment((Control)wdBGcolor, -this.margin);
        fdbBGColor.top = new FormAttachment(0, nr * h + this.margin);
        fdbBGColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wbBGColor.setLayoutData((Object)fdbBGColor);
        wbBGColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ColorDialog cd = new ColorDialog(EnterOptionsDialog.this.shell);
                cd.setRGB(EnterOptionsDialog.this.props.getBackgroundRGB());
                RGB newbg = cd.open();
                if (newbg != null) {
                    EnterOptionsDialog.this.backgroundRGB = newbg;
                    EnterOptionsDialog.this.background.dispose();
                    EnterOptionsDialog.this.background = new Color((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.backgroundRGB);
                    EnterOptionsDialog.this.wBGColor.setBackground(EnterOptionsDialog.this.background);
                    EnterOptionsDialog.this.wBGColor.redraw();
                }
            }
        });
        this.wBGColor = new Canvas(wLookComp, 2048);
        this.props.setLook((Control)this.wBGColor);
        this.wBGColor.setBackground(this.background);
        FormData fdBGColor = new FormData();
        fdBGColor.left = new FormAttachment(this.middle, 0);
        fdBGColor.right = new FormAttachment((Control)wbBGColor, -this.margin);
        fdBGColor.top = new FormAttachment(0, nr * h + this.margin);
        fdBGColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        this.wBGColor.setLayoutData((Object)fdBGColor);
        ++nr;
        Label wlGrColor = new Label(wLookComp, 131072);
        wlGrColor.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.BackgroundColorGraph.Label", (String[])new String[0]));
        this.props.setLook((Control)wlGrColor);
        FormData fdlGrColor = new FormData();
        fdlGrColor.left = new FormAttachment(0, 0);
        fdlGrColor.right = new FormAttachment(this.middle, -this.margin);
        fdlGrColor.top = new FormAttachment(0, nr * h + this.margin + 10);
        wlGrColor.setLayoutData((Object)fdlGrColor);
        Button wdGrColor = new Button(wLookComp, 8);
        this.props.setLook((Control)wdGrColor);
        FormData fddGrColor = this.layoutResetOptionButton(wdGrColor);
        fddGrColor.right = new FormAttachment(100, 0);
        fddGrColor.top = new FormAttachment(0, nr * h + this.margin);
        fddGrColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wdGrColor.setLayoutData((Object)fddGrColor);
        wdGrColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EnterOptionsDialog.this.graphColor.dispose();
                EnterOptionsDialog.this.graphColorRGB = new RGB(255, 255, 255);
                EnterOptionsDialog.this.graphColor = new Color((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.graphColorRGB);
                EnterOptionsDialog.this.wGrColor.setBackground(EnterOptionsDialog.this.graphColor);
                EnterOptionsDialog.this.wGrColor.redraw();
            }
        });
        Button wbGrColor = new Button(wLookComp, 8);
        this.props.setLook((Control)wbGrColor);
        FormData fdbGrColor = this.layoutEditOptionButton(wbGrColor);
        fdbGrColor.right = new FormAttachment((Control)wdGrColor, -this.margin);
        fdbGrColor.top = new FormAttachment(0, nr * h + this.margin);
        fdbGrColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wbGrColor.setLayoutData((Object)fdbGrColor);
        wbGrColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ColorDialog cd = new ColorDialog(EnterOptionsDialog.this.shell);
                cd.setRGB(EnterOptionsDialog.this.props.getGraphColorRGB());
                RGB newbg = cd.open();
                if (newbg != null) {
                    EnterOptionsDialog.this.graphColorRGB = newbg;
                    EnterOptionsDialog.this.graphColor.dispose();
                    EnterOptionsDialog.this.graphColor = new Color((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.graphColorRGB);
                    EnterOptionsDialog.this.wGrColor.setBackground(EnterOptionsDialog.this.graphColor);
                    EnterOptionsDialog.this.wGrColor.redraw();
                }
            }
        });
        this.wGrColor = new Canvas(wLookComp, 2048);
        this.props.setLook((Control)this.wGrColor);
        this.wGrColor.setBackground(this.graphColor);
        FormData fdGrColor = new FormData();
        fdGrColor.left = new FormAttachment(this.middle, 0);
        fdGrColor.right = new FormAttachment((Control)wbGrColor, -this.margin);
        fdGrColor.top = new FormAttachment(0, nr * h + this.margin);
        fdGrColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        this.wGrColor.setLayoutData((Object)fdGrColor);
        ++nr;
        Label wlTabColor = new Label(wLookComp, 131072);
        wlTabColor.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.TabColor.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTabColor);
        FormData fdlTabColor = new FormData();
        fdlTabColor.left = new FormAttachment(0, 0);
        fdlTabColor.right = new FormAttachment(this.middle, -this.margin);
        fdlTabColor.top = new FormAttachment(0, nr * h + this.margin + 10);
        wlTabColor.setLayoutData((Object)fdlTabColor);
        Button wdTabColor = new Button(wLookComp, 0x1000008);
        this.props.setLook((Control)wdTabColor);
        FormData fddTabColor = this.layoutResetOptionButton(wdTabColor);
        fddTabColor.right = new FormAttachment(100, 0);
        fddTabColor.top = new FormAttachment(0, nr * h + this.margin);
        fddTabColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wdTabColor.setLayoutData((Object)fddTabColor);
        wdTabColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                EnterOptionsDialog.this.tabColor.dispose();
                EnterOptionsDialog.this.tabColorRGB = new RGB(240, 240, 240);
                EnterOptionsDialog.this.tabColor = new Color((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.tabColorRGB);
                EnterOptionsDialog.this.wTabColor.setBackground(EnterOptionsDialog.this.tabColor);
                EnterOptionsDialog.this.wTabColor.redraw();
            }
        });
        Button wbTabColor = new Button(wLookComp, 8);
        this.props.setLook((Control)wbTabColor);
        FormData fdbTabColor = this.layoutEditOptionButton(wbTabColor);
        fdbTabColor.right = new FormAttachment((Control)wdTabColor, -this.margin);
        fdbTabColor.top = new FormAttachment(0, nr * h + this.margin);
        fdbTabColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        wbTabColor.setLayoutData((Object)fdbTabColor);
        wbTabColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ColorDialog cd = new ColorDialog(EnterOptionsDialog.this.shell);
                cd.setRGB(EnterOptionsDialog.this.props.getTabColorRGB());
                RGB newbg = cd.open();
                if (newbg != null) {
                    EnterOptionsDialog.this.tabColorRGB = newbg;
                    EnterOptionsDialog.this.tabColor.dispose();
                    EnterOptionsDialog.this.tabColor = new Color((Device)EnterOptionsDialog.this.display, EnterOptionsDialog.this.tabColorRGB);
                    EnterOptionsDialog.this.wTabColor.setBackground(EnterOptionsDialog.this.tabColor);
                    EnterOptionsDialog.this.wTabColor.redraw();
                }
            }
        });
        this.wTabColor = new Canvas(wLookComp, 2048);
        this.props.setLook((Control)this.wTabColor);
        this.wTabColor.setBackground(this.tabColor);
        FormData fdTabColor = new FormData();
        fdTabColor.left = new FormAttachment(this.middle, 0);
        fdTabColor.right = new FormAttachment((Control)wbTabColor, -this.margin);
        fdTabColor.top = new FormAttachment(0, nr * h + this.margin);
        fdTabColor.bottom = new FormAttachment(0, (nr + 1) * h + this.margin);
        this.wTabColor.setLayoutData((Object)fdTabColor);
        Label wlIconSize = new Label(wLookComp, 131072);
        wlIconSize.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.IconSize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlIconSize);
        FormData fdlIconSize = new FormData();
        fdlIconSize.left = new FormAttachment(0, 0);
        fdlIconSize.right = new FormAttachment(this.middle, -this.margin);
        fdlIconSize.top = new FormAttachment((Control)this.wTabColor, this.margin);
        wlIconSize.setLayoutData((Object)fdlIconSize);
        this.wIconSize = new Text(wLookComp, 18436);
        this.wIconSize.setText(Integer.toString(this.props.getIconSize()));
        this.props.setLook((Control)this.wIconSize);
        FormData fdIconSize = new FormData();
        fdIconSize.left = new FormAttachment(this.middle, 0);
        fdIconSize.right = new FormAttachment(100, -this.margin);
        fdIconSize.top = new FormAttachment((Control)wlIconSize, 0, 0x1000000);
        this.wIconSize.setLayoutData((Object)fdIconSize);
        Label wlLineWidth = new Label(wLookComp, 131072);
        wlLineWidth.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.LineWidth.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLineWidth);
        FormData fdlLineWidth = new FormData();
        fdlLineWidth.left = new FormAttachment(0, 0);
        fdlLineWidth.right = new FormAttachment(this.middle, -this.margin);
        fdlLineWidth.top = new FormAttachment((Control)this.wIconSize, this.margin);
        wlLineWidth.setLayoutData((Object)fdlLineWidth);
        this.wLineWidth = new Text(wLookComp, 18436);
        this.wLineWidth.setText(Integer.toString(this.props.getLineWidth()));
        this.props.setLook((Control)this.wLineWidth);
        FormData fdLineWidth = new FormData();
        fdLineWidth.left = new FormAttachment(this.middle, 0);
        fdLineWidth.right = new FormAttachment(100, -this.margin);
        fdLineWidth.top = new FormAttachment((Control)wlLineWidth, 0, 0x1000000);
        this.wLineWidth.setLayoutData((Object)fdLineWidth);
        Label wlMiddlePct = new Label(wLookComp, 131072);
        wlMiddlePct.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DialogMiddlePercentage.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMiddlePct);
        FormData fdlMiddlePct = new FormData();
        fdlMiddlePct.left = new FormAttachment(0, 0);
        fdlMiddlePct.right = new FormAttachment(this.middle, -this.margin);
        fdlMiddlePct.top = new FormAttachment((Control)this.wLineWidth, this.margin);
        wlMiddlePct.setLayoutData((Object)fdlMiddlePct);
        this.wMiddlePct = new Text(wLookComp, 18436);
        this.wMiddlePct.setText(Integer.toString(this.props.getMiddlePct()));
        this.props.setLook((Control)this.wMiddlePct);
        FormData fdMiddlePct = new FormData();
        fdMiddlePct.left = new FormAttachment(this.middle, 0);
        fdMiddlePct.right = new FormAttachment(100, -this.margin);
        fdMiddlePct.top = new FormAttachment((Control)wlMiddlePct, 0, 0x1000000);
        this.wMiddlePct.setLayoutData((Object)fdMiddlePct);
        Label wlGridSize = new Label(wLookComp, 131072);
        wlGridSize.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GridSize.Label", (String[])new String[0]));
        wlGridSize.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GridSize.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)wlGridSize);
        FormData fdlGridSize = new FormData();
        fdlGridSize.left = new FormAttachment(0, 0);
        fdlGridSize.right = new FormAttachment(this.middle, -this.margin);
        fdlGridSize.top = new FormAttachment((Control)this.wMiddlePct, this.margin);
        wlGridSize.setLayoutData((Object)fdlGridSize);
        this.wGridSize = new Text(wLookComp, 18436);
        this.wGridSize.setText(Integer.toString(this.props.getCanvasGridSize()));
        this.wGridSize.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.GridSize.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wGridSize);
        FormData fdGridSize = new FormData();
        fdGridSize.left = new FormAttachment(this.middle, 0);
        fdGridSize.right = new FormAttachment(100, -this.margin);
        fdGridSize.top = new FormAttachment((Control)this.wMiddlePct, this.margin);
        this.wGridSize.setLayoutData((Object)fdGridSize);
        Label wlShowCanvasGrid = new Label(wLookComp, 131072);
        wlShowCanvasGrid.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowCanvasGrid.Label", (String[])new String[0]));
        wlShowCanvasGrid.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ShowCanvasGrid.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)wlShowCanvasGrid);
        FormData fdlShowCanvasGrid = new FormData();
        fdlShowCanvasGrid.left = new FormAttachment(0, 0);
        fdlShowCanvasGrid.right = new FormAttachment(this.middle, -this.margin);
        fdlShowCanvasGrid.top = new FormAttachment((Control)this.wGridSize, this.margin);
        wlShowCanvasGrid.setLayoutData((Object)fdlShowCanvasGrid);
        this.wShowCanvasGrid = new Button(wLookComp, 32);
        this.props.setLook((Control)this.wShowCanvasGrid);
        this.wShowCanvasGrid.setSelection(this.props.isShowCanvasGridEnabled());
        FormData fdShowCanvasGrid = new FormData();
        fdShowCanvasGrid.left = new FormAttachment(this.middle, 0);
        fdShowCanvasGrid.right = new FormAttachment(100, -this.margin);
        fdShowCanvasGrid.top = new FormAttachment((Control)wlShowCanvasGrid, 0, 0x1000000);
        this.wShowCanvasGrid.setLayoutData((Object)fdShowCanvasGrid);
        Label wlOriginalLook = new Label(wLookComp, 131072);
        wlOriginalLook.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.UseOSLook.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOriginalLook);
        FormData fdlOriginalLook = new FormData();
        fdlOriginalLook.left = new FormAttachment(0, 0);
        fdlOriginalLook.top = new FormAttachment((Control)this.wShowCanvasGrid, this.margin);
        fdlOriginalLook.right = new FormAttachment(this.middle, -this.margin);
        wlOriginalLook.setLayoutData((Object)fdlOriginalLook);
        this.wOriginalLook = new Button(wLookComp, 32);
        this.props.setLook((Control)this.wOriginalLook);
        this.wOriginalLook.setSelection(this.props.isOSLookShown());
        FormData fdOriginalLook = new FormData();
        fdOriginalLook.left = new FormAttachment(this.middle, 0);
        fdOriginalLook.top = new FormAttachment((Control)wlOriginalLook, 0, 0x1000000);
        fdOriginalLook.right = new FormAttachment(100, 0);
        this.wOriginalLook.setLayoutData((Object)fdOriginalLook);
        Label wlDarkMode = new Label(wLookComp, 131072);
        wlDarkMode.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DarkMode.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDarkMode);
        FormData fdlDarkMode = new FormData();
        fdlDarkMode.left = new FormAttachment(0, 0);
        fdlDarkMode.top = new FormAttachment((Control)wlOriginalLook, 2 * this.margin);
        fdlDarkMode.right = new FormAttachment(this.middle, -this.margin);
        wlDarkMode.setLayoutData((Object)fdlDarkMode);
        this.wDarkMode = new Button(wLookComp, 32);
        this.wDarkMode.setSelection(this.props.isDarkMode());
        this.props.setLook((Control)this.wDarkMode);
        FormData fdDarkMode = new FormData();
        fdDarkMode.left = new FormAttachment(this.middle, 0);
        fdDarkMode.top = new FormAttachment((Control)wlDarkMode, 0, 0x1000000);
        fdDarkMode.right = new FormAttachment(100, 0);
        this.wDarkMode.setLayoutData((Object)fdDarkMode);
        Label wlDefaultLocale = new Label(wLookComp, 131072);
        wlDefaultLocale.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DefaultLocale.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDefaultLocale);
        FormData fdlDefaultLocale = new FormData();
        fdlDefaultLocale.left = new FormAttachment(0, 0);
        fdlDefaultLocale.right = new FormAttachment(this.middle, -this.margin);
        fdlDefaultLocale.top = new FormAttachment((Control)wlDarkMode, 2 * this.margin);
        wlDefaultLocale.setLayoutData((Object)fdlDefaultLocale);
        this.wDefaultLocale = new Combo(wLookComp, 18444);
        this.wDefaultLocale.setItems(GlobalMessages.localeDescr);
        this.props.setLook((Control)this.wDefaultLocale);
        FormData fdDefaultLocale = new FormData();
        fdDefaultLocale.left = new FormAttachment(this.middle, 0);
        fdDefaultLocale.right = new FormAttachment(100, -this.margin);
        fdDefaultLocale.top = new FormAttachment((Control)wlDefaultLocale, 0, 0x1000000);
        this.wDefaultLocale.setLayoutData((Object)fdDefaultLocale);
        int idxDefault = Const.indexOfString((String)LanguageChoice.getInstance().getDefaultLocale().toString(), (String[])GlobalMessages.localeCodes);
        if (idxDefault >= 0) {
            this.wDefaultLocale.select(idxDefault);
        }
        FormData fdLookComp = new FormData();
        fdLookComp.left = new FormAttachment(0, 0);
        fdLookComp.right = new FormAttachment(100, 0);
        fdLookComp.top = new FormAttachment(0, 0);
        fdLookComp.bottom = new FormAttachment(100, 100);
        wLookComp.setLayoutData((Object)fdLookComp);
        wLookComp.pack();
        Rectangle bounds = wLookComp.getBounds();
        sLookComp.setContent((Control)wLookComp);
        sLookComp.setExpandHorizontal(true);
        sLookComp.setExpandVertical(true);
        sLookComp.setMinWidth(bounds.width);
        sLookComp.setMinHeight(bounds.height);
        wLookTab.setControl((Control)sLookComp);
    }

    private void addGeneralTab() {
        CTabItem wGeneralTab = new CTabItem(this.wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.General.Label", (String[])new String[0]));
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        ScrolledComposite sGeneralComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        sGeneralComp.setLayout((Layout)new FillLayout());
        Composite wGeneralComp = new Composite((Composite)sGeneralComp, 0);
        this.props.setLook((Control)wGeneralComp);
        wGeneralComp.setLayout((Layout)generalLayout);
        Label wlFilename = new Label(wGeneralComp, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ConfigFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        fdlFilename.top = new FormAttachment(0, this.margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.wFilename = new Text(wGeneralComp, 18436);
        this.wFilename.setText(Const.NVL((String)HopConfig.getInstance().getConfigFilename(), (String)""));
        this.wFilename.setEditable(false);
        this.props.setLook((Control)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.right = new FormAttachment(100, -this.margin);
        fdFilename.top = new FormAttachment(0, this.margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        Text lastControl = this.wFilename;
        Label wlDefaultPreview = new Label(wGeneralComp, 131072);
        wlDefaultPreview.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.DefaultPreviewSize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDefaultPreview);
        FormData fdlDefaultPreview = new FormData();
        fdlDefaultPreview.left = new FormAttachment(0, 0);
        fdlDefaultPreview.right = new FormAttachment(this.middle, -this.margin);
        fdlDefaultPreview.top = new FormAttachment((Control)lastControl, this.margin);
        wlDefaultPreview.setLayoutData((Object)fdlDefaultPreview);
        this.wDefaultPreview = new Text(wGeneralComp, 18436);
        this.wDefaultPreview.setText(Integer.toString(this.props.getDefaultPreviewSize()));
        this.props.setLook((Control)this.wDefaultPreview);
        FormData fdDefaultPreview = new FormData();
        fdDefaultPreview.left = new FormAttachment(this.middle, 0);
        fdDefaultPreview.right = new FormAttachment(100, -this.margin);
        fdDefaultPreview.top = new FormAttachment((Control)wlDefaultPreview, 0, 0x1000000);
        this.wDefaultPreview.setLayoutData((Object)fdDefaultPreview);
        lastControl = this.wDefaultPreview;
        Label wlUseCache = new Label(wGeneralComp, 131072);
        wlUseCache.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.UseDatabaseCache.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUseCache);
        FormData fdlUseCache = new FormData();
        fdlUseCache.left = new FormAttachment(0, 0);
        fdlUseCache.top = new FormAttachment((Control)lastControl, this.margin);
        fdlUseCache.right = new FormAttachment(this.middle, -this.margin);
        wlUseCache.setLayoutData((Object)fdlUseCache);
        this.wUseCache = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wUseCache);
        this.wUseCache.setSelection(this.props.useDBCache());
        FormData fdUseCache = new FormData();
        fdUseCache.left = new FormAttachment(this.middle, 0);
        fdUseCache.top = new FormAttachment((Control)wlUseCache, 0, 0x1000000);
        fdUseCache.right = new FormAttachment(100, 0);
        this.wUseCache.setLayoutData((Object)fdUseCache);
        lastControl = wlUseCache;
        Label wlOpenLast = new Label(wGeneralComp, 131072);
        wlOpenLast.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.OpenLastFileStartup.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOpenLast);
        FormData fdlOpenLast = new FormData();
        fdlOpenLast.left = new FormAttachment(0, 0);
        fdlOpenLast.top = new FormAttachment((Control)lastControl, this.margin);
        fdlOpenLast.right = new FormAttachment(this.middle, -this.margin);
        wlOpenLast.setLayoutData((Object)fdlOpenLast);
        this.wOpenLast = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wOpenLast);
        this.wOpenLast.setSelection(this.props.openLastFile());
        FormData fdOpenLast = new FormData();
        fdOpenLast.left = new FormAttachment(this.middle, 0);
        fdOpenLast.top = new FormAttachment((Control)wlOpenLast, 0, 0x1000000);
        fdOpenLast.right = new FormAttachment(100, 0);
        this.wOpenLast.setLayoutData((Object)fdOpenLast);
        lastControl = wlOpenLast;
        Label wlAutoSave = new Label(wGeneralComp, 131072);
        wlAutoSave.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.AutoSave.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAutoSave);
        FormData fdlAutoSave = new FormData();
        fdlAutoSave.left = new FormAttachment(0, 0);
        fdlAutoSave.top = new FormAttachment((Control)lastControl, this.margin);
        fdlAutoSave.right = new FormAttachment(this.middle, -this.margin);
        wlAutoSave.setLayoutData((Object)fdlAutoSave);
        this.wAutoSave = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wAutoSave);
        this.wAutoSave.setSelection(this.props.getAutoSave());
        FormData fdAutoSave = new FormData();
        fdAutoSave.left = new FormAttachment(this.middle, 0);
        fdAutoSave.top = new FormAttachment((Control)wlAutoSave, 0, 0x1000000);
        fdAutoSave.right = new FormAttachment(100, 0);
        this.wAutoSave.setLayoutData((Object)fdAutoSave);
        lastControl = wlAutoSave;
        Label wlAutoSplit = new Label(wGeneralComp, 131072);
        wlAutoSplit.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.AutoSplitHops.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAutoSplit);
        FormData fdlAutoSplit = new FormData();
        fdlAutoSplit.left = new FormAttachment(0, 0);
        fdlAutoSplit.top = new FormAttachment((Control)lastControl, this.margin);
        fdlAutoSplit.right = new FormAttachment(this.middle, -this.margin);
        wlAutoSplit.setLayoutData((Object)fdlAutoSplit);
        this.wAutoSplit = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wAutoSplit);
        this.wAutoSplit.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.AutoSplitHops.Tooltip", (String[])new String[0]));
        this.wAutoSplit.setSelection(this.props.getAutoSplit());
        FormData fdAutoSplit = new FormData();
        fdAutoSplit.left = new FormAttachment(this.middle, 0);
        fdAutoSplit.top = new FormAttachment((Control)wlAutoSplit, 0, 0x1000000);
        fdAutoSplit.right = new FormAttachment(100, 0);
        this.wAutoSplit.setLayoutData((Object)fdAutoSplit);
        lastControl = wlAutoSplit;
        Label wlCopyDistrib = new Label(wGeneralComp, 131072);
        wlCopyDistrib.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.CopyOrDistributeDialog.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCopyDistrib);
        FormData fdlCopyDistrib = new FormData();
        fdlCopyDistrib.left = new FormAttachment(0, 0);
        fdlCopyDistrib.top = new FormAttachment((Control)lastControl, this.margin);
        fdlCopyDistrib.right = new FormAttachment(this.middle, -this.margin);
        wlCopyDistrib.setLayoutData((Object)fdlCopyDistrib);
        this.wCopyDistrib = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wCopyDistrib);
        this.wCopyDistrib.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.CopyOrDistributeDialog.Tooltip", (String[])new String[0]));
        this.wCopyDistrib.setSelection(this.props.showCopyOrDistributeWarning());
        FormData fdCopyDistrib = new FormData();
        fdCopyDistrib.left = new FormAttachment(this.middle, 0);
        fdCopyDistrib.top = new FormAttachment((Control)wlCopyDistrib, 0, 0x1000000);
        fdCopyDistrib.right = new FormAttachment(100, 0);
        this.wCopyDistrib.setLayoutData((Object)fdCopyDistrib);
        lastControl = wlCopyDistrib;
        Label wlExitWarning = new Label(wGeneralComp, 131072);
        wlExitWarning.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.AskOnExit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlExitWarning);
        FormData fdlExitWarning = new FormData();
        fdlExitWarning.left = new FormAttachment(0, 0);
        fdlExitWarning.top = new FormAttachment((Control)lastControl, this.margin);
        fdlExitWarning.right = new FormAttachment(this.middle, -this.margin);
        wlExitWarning.setLayoutData((Object)fdlExitWarning);
        this.wExitWarning = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wExitWarning);
        this.wExitWarning.setSelection(this.props.showExitWarning());
        FormData fdExitWarning = new FormData();
        fdExitWarning.left = new FormAttachment(this.middle, 0);
        fdExitWarning.top = new FormAttachment((Control)wlExitWarning, 0, 0x1000000);
        fdExitWarning.right = new FormAttachment(100, 0);
        this.wExitWarning.setLayoutData((Object)fdExitWarning);
        lastControl = wlExitWarning;
        Label wlClearCustom = new Label(wGeneralComp, 131072);
        wlClearCustom.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ClearCustomParameters.Label", (String[])new String[0]));
        this.props.setLook((Control)wlClearCustom);
        FormData fdlClearCustom = new FormData();
        fdlClearCustom.left = new FormAttachment(0, 0);
        fdlClearCustom.top = new FormAttachment((Control)lastControl, this.margin + 10);
        fdlClearCustom.right = new FormAttachment(this.middle, -this.margin);
        wlClearCustom.setLayoutData((Object)fdlClearCustom);
        Button wClearCustom = new Button(wGeneralComp, 8);
        this.props.setLook((Control)wClearCustom);
        FormData fdClearCustom = this.layoutResetOptionButton(wClearCustom);
        fdClearCustom.width += 6;
        fdClearCustom.height += 18;
        fdClearCustom.left = new FormAttachment(this.middle, 0);
        fdClearCustom.top = new FormAttachment((Control)wlClearCustom, 0, 0x1000000);
        wClearCustom.setLayoutData((Object)fdClearCustom);
        wClearCustom.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ClearCustomParameters.Tooltip", (String[])new String[0]));
        wClearCustom.addListener(13, e -> {
            MessageBox mb = new MessageBox(this.shell, 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ClearCustomParameters.Question", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ClearCustomParameters.Title", (String[])new String[0]));
            int id = mb.open();
            if (id == 64) {
                try {
                    this.props.clearCustomParameters();
                    MessageBox ok = new MessageBox(this.shell, 34);
                    ok.setMessage(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ClearCustomParameters.Confirmation", (String[])new String[0]));
                    ok.open();
                }
                catch (Exception ex) {
                    new ErrorDialog(this.shell, "Error", "Error clearing custom parameters, saving config file", ex);
                }
            }
        });
        lastControl = wClearCustom;
        Label wlAutoCollapse = new Label(wGeneralComp, 131072);
        wlAutoCollapse.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.EnableAutoCollapseCoreObjectTree.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAutoCollapse);
        FormData fdlAutoCollapse = new FormData();
        fdlAutoCollapse.left = new FormAttachment(0, 0);
        fdlAutoCollapse.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        fdlAutoCollapse.right = new FormAttachment(this.middle, -this.margin);
        wlAutoCollapse.setLayoutData((Object)fdlAutoCollapse);
        this.wAutoCollapse = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wAutoCollapse);
        this.wAutoCollapse.setSelection(this.props.getAutoCollapseCoreObjectsTree());
        FormData fdAutoCollapse = new FormData();
        fdAutoCollapse.left = new FormAttachment(this.middle, 0);
        fdAutoCollapse.top = new FormAttachment((Control)wlAutoCollapse, 0, 0x1000000);
        fdAutoCollapse.right = new FormAttachment(100, 0);
        this.wAutoCollapse.setLayoutData((Object)fdAutoCollapse);
        lastControl = wlAutoCollapse;
        Label wlToolTip = new Label(wGeneralComp, 131072);
        wlToolTip.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.ToolTipsEnabled.Label", (String[])new String[0]));
        this.props.setLook((Control)wlToolTip);
        FormData fdlToolTip = new FormData();
        fdlToolTip.left = new FormAttachment(0, 0);
        fdlToolTip.top = new FormAttachment((Control)lastControl, this.margin);
        fdlToolTip.right = new FormAttachment(this.middle, -this.margin);
        wlToolTip.setLayoutData((Object)fdlToolTip);
        this.wToolTip = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wToolTip);
        this.wToolTip.setSelection(this.props.showToolTips());
        FormData fdbToolTip = new FormData();
        fdbToolTip.left = new FormAttachment(this.middle, 0);
        fdbToolTip.top = new FormAttachment((Control)wlToolTip, 0, 0x1000000);
        fdbToolTip.right = new FormAttachment(100, 0);
        this.wToolTip.setLayoutData((Object)fdbToolTip);
        lastControl = wlToolTip;
        Label wlHelpTip = new Label(wGeneralComp, 131072);
        wlHelpTip.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.HelpToolTipsEnabled.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHelpTip);
        FormData fdlHelpTip = new FormData();
        fdlHelpTip.left = new FormAttachment(0, 0);
        fdlHelpTip.top = new FormAttachment((Control)lastControl, this.margin);
        fdlHelpTip.right = new FormAttachment(this.middle, -this.margin);
        wlHelpTip.setLayoutData((Object)fdlHelpTip);
        this.wHelpTip = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wHelpTip);
        this.wHelpTip.setSelection(this.props.isShowingHelpToolTips());
        FormData fdbHelpTip = new FormData();
        fdbHelpTip.left = new FormAttachment(this.middle, 0);
        fdbHelpTip.top = new FormAttachment((Control)wlHelpTip, 0, 0x1000000);
        fdbHelpTip.right = new FormAttachment(100, 0);
        this.wHelpTip.setLayoutData((Object)fdbHelpTip);
        lastControl = wlHelpTip;
        Label wlUseDoubleClick = new Label(wGeneralComp, 131072);
        wlUseDoubleClick.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.UseDoubleClickOnCanvas.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUseDoubleClick);
        FormData fdlUseDoubleClick = new FormData();
        fdlUseDoubleClick.left = new FormAttachment(0, 0);
        fdlUseDoubleClick.top = new FormAttachment((Control)lastControl, this.margin);
        fdlUseDoubleClick.right = new FormAttachment(this.middle, -this.margin);
        wlUseDoubleClick.setLayoutData((Object)fdlUseDoubleClick);
        this.wbUseDoubleClick = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wbUseDoubleClick);
        this.wbUseDoubleClick.setSelection(this.props.useDoubleClick());
        FormData fdbUseDoubleClick = new FormData();
        fdbUseDoubleClick.left = new FormAttachment(this.middle, 0);
        fdbUseDoubleClick.top = new FormAttachment((Control)wlUseDoubleClick, 0, 0x1000000);
        fdbUseDoubleClick.right = new FormAttachment(100, 0);
        this.wbUseDoubleClick.setLayoutData((Object)fdbUseDoubleClick);
        lastControl = wlUseDoubleClick;
        Label wlUseGlobalFileBookmarks = new Label(wGeneralComp, 131072);
        wlUseGlobalFileBookmarks.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.UseGlobalFileBookmarks.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUseGlobalFileBookmarks);
        FormData fdlUseGlobalFileBookmarks = new FormData();
        fdlUseGlobalFileBookmarks.left = new FormAttachment(0, 0);
        fdlUseGlobalFileBookmarks.top = new FormAttachment((Control)lastControl, this.margin);
        fdlUseGlobalFileBookmarks.right = new FormAttachment(this.middle, -this.margin);
        wlUseGlobalFileBookmarks.setLayoutData((Object)fdlUseGlobalFileBookmarks);
        this.wbUseGlobalFileBookmarks = new Button(wGeneralComp, 32);
        this.props.setLook((Control)this.wbUseGlobalFileBookmarks);
        this.wbUseGlobalFileBookmarks.setSelection(this.props.useGlobalFileBookmarks());
        FormData fdbUseGlobalFileBookmarks = new FormData();
        fdbUseGlobalFileBookmarks.left = new FormAttachment(this.middle, 0);
        fdbUseGlobalFileBookmarks.top = new FormAttachment((Control)wlUseGlobalFileBookmarks, 0, 0x1000000);
        fdbUseGlobalFileBookmarks.right = new FormAttachment(100, 0);
        this.wbUseGlobalFileBookmarks.setLayoutData((Object)fdbUseGlobalFileBookmarks);
        lastControl = this.wbUseGlobalFileBookmarks;
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 100);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.pack();
        Rectangle bounds = wGeneralComp.getBounds();
        sGeneralComp.setContent((Control)wGeneralComp);
        sGeneralComp.setExpandHorizontal(true);
        sGeneralComp.setExpandVertical(true);
        sGeneralComp.setMinWidth(bounds.width);
        sGeneralComp.setMinHeight(bounds.height);
        wGeneralTab.setControl((Control)sGeneralComp);
    }

    private void addPluginTabs() {
        HopGui hopGui = HopGui.getInstance();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List configPlugins = pluginRegistry.getPlugins(ConfigPluginType.class);
        for (IPlugin configPlugin : configPlugins) {
            try {
                Object emptySourceData = pluginRegistry.loadClass(configPlugin);
                GuiPlugin annotation = emptySourceData.getClass().getAnnotation(GuiPlugin.class);
                if (annotation == null) continue;
                Method method = emptySourceData.getClass().getMethod("getInstance", new Class[0]);
                Object sourceData = method.invoke(null, (Object[])null);
                CTabItem wPluginTab = new CTabItem(this.wTabFolder, 0);
                wPluginTab.setText(Const.NVL((String)TranslateUtil.translate((String)annotation.description(), emptySourceData.getClass()), (String)""));
                ScrolledComposite sOtherComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
                sOtherComp.setLayout((Layout)new FormLayout());
                Composite wPluginsComp = new Composite((Composite)sOtherComp, 0);
                this.props.setLook((Control)wPluginsComp);
                wPluginsComp.setLayout((Layout)new FormLayout());
                GuiCompositeWidgets compositeWidgets = new GuiCompositeWidgets(hopGui.getVariables(), 20);
                compositeWidgets.createCompositeWidgets(sourceData, null, wPluginsComp, GUI_WIDGETS_PARENT_ID, null);
                compositeWidgets.setWidgetsContents(sourceData, wPluginsComp, GUI_WIDGETS_PARENT_ID);
                if (sourceData instanceof IGuiPluginCompositeWidgetsListener) {
                    compositeWidgets.setWidgetsListener((IGuiPluginCompositeWidgetsListener)sourceData);
                }
                this.pluginWidgetContentsList.add(new PluginWidgetContents(compositeWidgets, sourceData));
                wPluginsComp.pack();
                Rectangle bounds = wPluginsComp.getBounds();
                sOtherComp.setContent((Control)wPluginsComp);
                sOtherComp.setExpandHorizontal(true);
                sOtherComp.setExpandVertical(true);
                sOtherComp.setMinWidth(bounds.width);
                sOtherComp.setMinHeight(bounds.height);
                wPluginTab.setControl((Control)sOtherComp);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error handling configuration options for config / GUI plugin " + configPlugin.getIds()[0], e);
            }
        }
    }

    private FormData layoutResetOptionButton(Button button) {
        FormData fd = new FormData();
        Image editButton = GuiResource.getInstance().getImageResetOption();
        if (editButton != null) {
            button.setImage(editButton);
            button.setBackground(GuiResource.getInstance().getColorWhite());
            fd.width = editButton.getBounds().width + 20;
            fd.height = editButton.getBounds().height;
        } else {
            button.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Reset", (String[])new String[0]));
        }
        button.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Reset.Tooltip", (String[])new String[0]));
        return fd;
    }

    private FormData layoutEditOptionButton(Button button) {
        FormData fd = new FormData();
        Image editButton = GuiResource.getInstance().getImageEdit();
        if (editButton != null) {
            button.setImage(editButton);
            button.setBackground(GuiResource.getInstance().getColorWhite());
            fd.width = editButton.getBounds().width + 20;
            fd.height = editButton.getBounds().height;
        } else {
            button.setText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Edit", (String[])new String[0]));
        }
        button.setToolTipText(BaseMessages.getString(PKG, (String)"EnterOptionsDialog.Button.Edit.Tooltip", (String[])new String[0]));
        return fd;
    }

    public void dispose() {
        this.fixedFont.dispose();
        this.graphFont.dispose();
        this.noteFont.dispose();
        this.background.dispose();
        this.graphColor.dispose();
        this.tabColor.dispose();
        this.shell.dispose();
    }

    public void getData() {
        this.fixedFontData = this.props.getFixedFont();
        this.fixedFont = new Font((Device)this.display, this.fixedFontData);
        this.graphFontData = this.props.getGraphFont();
        this.graphFontData.setHeight((int)((double)this.graphFontData.getHeight() * PropsUi.getNativeZoomFactor()));
        this.graphFont = new Font((Device)this.display, this.graphFontData);
        this.noteFontData = this.props.getNoteFont();
        this.noteFont = new Font((Device)this.display, this.noteFontData);
        this.backgroundRGB = this.props.getBackgroundRGB();
        if (this.backgroundRGB == null) {
            this.backgroundRGB = this.display.getSystemColor(22).getRGB();
        }
        this.background = new Color((Device)this.display, this.backgroundRGB);
        this.graphColorRGB = this.props.getGraphColorRGB();
        this.graphColor = new Color((Device)this.display, this.graphColorRGB);
        this.tabColorRGB = this.props.getTabColorRGB();
        this.tabColor = new Color((Device)this.display, this.tabColorRGB);
    }

    private void cancel() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.props = null;
        this.dispose();
    }

    private void ok() {
        this.props.setFixedFont(this.fixedFontData);
        this.props.setGraphFont(this.graphFontData);
        this.props.setNoteFont(this.noteFontData);
        this.props.setBackgroundRGB(this.backgroundRGB);
        this.props.setGraphColorRGB(this.graphColorRGB);
        this.props.setTabColorRGB(this.tabColorRGB);
        this.props.setIconSize(Const.toInt((String)this.wIconSize.getText(), (int)this.props.getIconSize()));
        this.props.setLineWidth(Const.toInt((String)this.wLineWidth.getText(), (int)this.props.getLineWidth()));
        this.props.setMiddlePct(Const.toInt((String)this.wMiddlePct.getText(), (int)this.props.getMiddlePct()));
        this.props.setCanvasGridSize(Const.toInt((String)this.wGridSize.getText(), (int)1));
        this.props.setDefaultPreviewSize(Const.toInt((String)this.wDefaultPreview.getText(), (int)this.props.getDefaultPreviewSize()));
        this.props.setUseDBCache(this.wUseCache.getSelection());
        this.props.setOpenLastFile(this.wOpenLast.getSelection());
        this.props.setAutoSave(this.wAutoSave.getSelection());
        this.props.setAutoSplit(this.wAutoSplit.getSelection());
        this.props.setShowCopyOrDistributeWarning(this.wCopyDistrib.getSelection());
        this.props.setShowCanvasGridEnabled(this.wShowCanvasGrid.getSelection());
        this.props.setExitWarningShown(this.wExitWarning.getSelection());
        this.props.setOSLookShown(this.wOriginalLook.getSelection());
        this.props.setDarkMode(this.wDarkMode.getSelection());
        this.props.setShowToolTips(this.wToolTip.getSelection());
        this.props.setAutoCollapseCoreObjectsTree(this.wAutoCollapse.getSelection());
        this.props.setShowingHelpToolTips(this.wHelpTip.getSelection());
        this.props.setUseDoubleClickOnCanvas(this.wbUseDoubleClick.getSelection());
        this.props.setUseGlobalFileBookmarks(this.wbUseGlobalFileBookmarks.getSelection());
        int defaultLocaleIndex = this.wDefaultLocale.getSelectionIndex();
        if (defaultLocaleIndex < 0 || defaultLocaleIndex >= GlobalMessages.localeCodes.length) {
            defaultLocaleIndex = 0;
        }
        String defaultLocale = GlobalMessages.localeCodes[defaultLocaleIndex];
        LanguageChoice.getInstance().setDefaultLocale(EnvUtil.createLocale((String)defaultLocale));
        for (PluginWidgetContents contents : this.pluginWidgetContentsList) {
            if (!(contents.sourceData instanceof IGuiPluginCompositeWidgetsListener)) continue;
            ((IGuiPluginCompositeWidgetsListener)contents.sourceData).persistContents(contents.compositeWidgets);
        }
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_USAGE_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"EnterOptionsDialog.RestartWarning.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"EnterOptionsDialog.RestartWarning.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"EnterOptionsDialog.RestartWarning.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"EnterOptionsDialog.RestartWarning.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_USAGE_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_USAGE_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        this.dispose();
    }

    private class PluginWidgetContents {
        public GuiCompositeWidgets compositeWidgets;
        public Object sourceData;

        public PluginWidgetContents(GuiCompositeWidgets compositeWidgets, Object sourceData) {
            this.compositeWidgets = compositeWidgets;
            this.sourceData = sourceData;
        }
    }
}

