/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EnterMappingDialog
extends Dialog {
    private static final Class<?> PKG = EnterMappingDialog.class;
    private org.eclipse.swt.widgets.List wSource;
    private org.eclipse.swt.widgets.List wTarget;
    private Button wSourceHide;
    private Button wTargetHide;
    private Button wSourceAuto;
    private Button wTargetAuto;
    private org.eclipse.swt.widgets.List wResult;
    private Shell shell;
    private final String[] sourceList;
    private final String[] targetList;
    private final PropsUi props = PropsUi.getInstance();
    private String sourceSeparator;
    private String targetSeparator;
    private List<SourceToTargetMapping> mappings;

    public EnterMappingDialog(Shell parent, String[] source, String[] target) {
        this(parent, source, target, new ArrayList<SourceToTargetMapping>());
    }

    public EnterMappingDialog(Shell parent, String[] source, String[] target, List<SourceToTargetMapping> mappings) {
        super(parent, 0);
        this.sourceList = source;
        this.targetList = target;
        this.mappings = mappings;
    }

    public List<SourceToTargetMapping> open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 268504304);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Title", (String[])new String[0]));
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        int margin = this.props.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wGuess = new Button((Composite)this.shell, 8);
        wGuess.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Button.Guess", (String[])new String[0]));
        wGuess.addListener(13, e -> this.guess());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wGuess, wCancel}, margin, null);
        this.wSourceHide = new Button((Composite)this.shell, 32);
        this.wSourceHide.setSelection(true);
        this.wSourceHide.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.HideUsedSources", (String[])new String[0]));
        this.props.setLook((Control)this.wSourceHide);
        FormData fdSourceHide = new FormData();
        fdSourceHide.left = new FormAttachment(0, 0);
        fdSourceHide.right = new FormAttachment(25, 0);
        fdSourceHide.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wSourceHide.setLayoutData((Object)fdSourceHide);
        this.wSourceHide.addListener(13, e -> this.refreshMappings());
        this.wTargetHide = new Button((Composite)this.shell, 32);
        this.wTargetHide.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.HideUsedTargets", (String[])new String[0]));
        this.wTargetHide.setSelection(true);
        this.props.setLook((Control)this.wTargetHide);
        FormData fdTargetHide = new FormData();
        fdTargetHide.left = new FormAttachment(25, margin * 2);
        fdTargetHide.right = new FormAttachment(50, 0);
        fdTargetHide.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wTargetHide.setLayoutData((Object)fdTargetHide);
        this.wTargetHide.addListener(13, e -> this.refreshMappings());
        this.wSourceAuto = new Button((Composite)this.shell, 32);
        this.wSourceAuto.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.AutoTargetSelection.Label", (String[])new String[0]));
        this.wSourceAuto.setSelection(true);
        this.props.setLook((Control)this.wSourceAuto);
        FormData fdSourceAuto = new FormData();
        fdSourceAuto.left = new FormAttachment(0, 0);
        fdSourceAuto.right = new FormAttachment(25, 0);
        fdSourceAuto.bottom = new FormAttachment((Control)this.wSourceHide, -margin);
        this.wSourceAuto.setLayoutData((Object)fdSourceAuto);
        this.wTargetAuto = new Button((Composite)this.shell, 32);
        this.wTargetAuto.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.AutoSourceSelection.Label", (String[])new String[0]));
        this.wTargetAuto.setSelection(false);
        this.props.setLook((Control)this.wTargetAuto);
        FormData fdTargetAuto = new FormData();
        fdTargetAuto.left = new FormAttachment(25, margin * 2);
        fdTargetAuto.right = new FormAttachment(50, 0);
        fdTargetAuto.bottom = new FormAttachment((Control)this.wTargetHide, -margin);
        this.wTargetAuto.setLayoutData((Object)fdTargetAuto);
        Label wlSource = new Label((Composite)this.shell, 0);
        wlSource.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.SourceFields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSource);
        FormData fdlSource = new FormData();
        fdlSource.left = new FormAttachment(0, 0);
        fdlSource.top = new FormAttachment(0, margin);
        wlSource.setLayoutData((Object)fdlSource);
        this.wSource = new org.eclipse.swt.widgets.List((Composite)this.shell, 133892);
        for (int i = 0; i < this.sourceList.length; ++i) {
            this.wSource.add(this.sourceList[i]);
        }
        this.props.setLook((Control)this.wSource);
        FormData fdSource = new FormData();
        fdSource.left = new FormAttachment(0, 0);
        fdSource.right = new FormAttachment(25, 0);
        fdSource.top = new FormAttachment((Control)wlSource, margin);
        fdSource.bottom = new FormAttachment((Control)this.wSourceAuto, -margin);
        this.wSource.setLayoutData((Object)fdSource);
        Label wlTarget = new Label((Composite)this.shell, 0);
        wlTarget.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.TargetFields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTarget);
        FormData fdlTarget = new FormData();
        fdlTarget.left = new FormAttachment((Control)this.wSource, margin * 2);
        fdlTarget.top = new FormAttachment(0, margin);
        wlTarget.setLayoutData((Object)fdlTarget);
        this.wTarget = new org.eclipse.swt.widgets.List((Composite)this.shell, 19204);
        for (int i = 0; i < this.targetList.length; ++i) {
            this.wTarget.add(this.targetList[i]);
        }
        this.props.setLook((Control)this.wTarget);
        FormData fdTarget = new FormData();
        fdTarget.left = new FormAttachment((Control)this.wSource, margin * 2);
        fdTarget.right = new FormAttachment(50, 0);
        fdTarget.top = new FormAttachment((Control)wlTarget, margin);
        fdTarget.bottom = new FormAttachment((Control)this.wTargetAuto, -margin);
        this.wTarget.setLayoutData((Object)fdTarget);
        Button wDelete = new Button((Composite)this.shell, 8);
        FormData fdDelete = new FormData();
        wDelete.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Button.Delete", (String[])new String[0]));
        fdDelete.left = new FormAttachment((Control)this.wTarget, margin * 2);
        fdDelete.top = new FormAttachment((Control)this.wTarget, 0, 0x1000000);
        wDelete.setLayoutData((Object)fdDelete);
        wDelete.addListener(13, e -> this.delete());
        Button wAdd = new Button((Composite)this.shell, 8);
        FormData fdAdd = new FormData();
        wAdd.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.Button.Add", (String[])new String[0]));
        fdAdd.left = new FormAttachment((Control)this.wTarget, margin * 2);
        fdAdd.right = new FormAttachment((Control)wDelete, 0, 131072);
        fdAdd.bottom = new FormAttachment((Control)wDelete, -2 * margin);
        wAdd.setLayoutData((Object)fdAdd);
        wAdd.addListener(13, e -> this.add());
        Label wlResult = new Label((Composite)this.shell, 0);
        wlResult.setText(BaseMessages.getString(PKG, (String)"EnterMappingDialog.ResultMappings.Label", (String[])new String[0]));
        this.props.setLook((Control)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment((Control)wDelete, margin * 2);
        fdlResult.top = new FormAttachment(0, margin);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new org.eclipse.swt.widgets.List((Composite)this.shell, 19202);
        for (String s : this.targetList) {
            this.wResult.add(s);
        }
        this.props.setLook((Control)this.wResult);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment((Control)wDelete, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        fdResult.top = new FormAttachment((Control)wlResult, margin);
        fdResult.bottom = new FormAttachment((Control)this.wSource, 0, 1024);
        this.wResult.setLayoutData((Object)fdResult);
        this.wSource.addListener(13, event -> {
            if (this.wSourceAuto.getSelection()) {
                this.findTarget();
            }
        });
        this.wSource.addListener(14, event -> this.add());
        this.wTarget.addListener(13, event -> {
            if (this.wTargetAuto.getSelection()) {
                this.findSource();
            }
        });
        this.wTarget.addListener(14, event -> this.add());
        this.getData();
        BaseTransformDialog.setSize(this.shell);
        this.shell.addListener(21, e -> this.cancel());
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.mappings;
    }

    private void guess() {
        String[] sortedSourceList = Arrays.copyOf(this.sourceList, this.sourceList.length);
        Arrays.sort(sortedSourceList, (s1, s2) -> s2.length() - s1.length());
        ArrayList<GuessPair> pList = new ArrayList<GuessPair>();
        for (int i = 0; i < this.sourceList.length; ++i) {
            int idx = Const.indexOfString((String)sortedSourceList[i], (String[])this.wSource.getItems());
            if (idx < 0) continue;
            pList.add(this.findTargetPair(idx));
        }
        Collections.sort(pList, (s1, s2) -> s1.getSrcIndex() - s2.getSrcIndex());
        for (GuessPair p : pList) {
            if (!p.getFound()) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(p.getSrcIndex(), p.getTargetIndex());
            this.mappings.add(mapping);
        }
        this.refreshMappings();
    }

    private void findTarget() {
        int sourceIndex = this.wSource.getSelectionIndex();
        GuessPair p = this.findTargetPair(sourceIndex);
        if (p.getFound()) {
            this.wTarget.setSelection(p.getTargetIndex());
        }
    }

    private GuessPair findTargetPair(int sourceIndex) {
        int index;
        GuessPair result = new GuessPair(sourceIndex);
        if (sourceIndex < 0) {
            return result;
        }
        String sourceString = this.wSource.getItem(sourceIndex).toUpperCase();
        String sourceValue = sourceString.toLowerCase();
        if (StringUtils.isNotEmpty((String)this.sourceSeparator) && (index = sourceValue.indexOf(this.sourceSeparator)) >= 0) {
            sourceValue = sourceValue.substring(index + this.sourceSeparator.length());
        }
        int minDistance = Integer.MAX_VALUE;
        int minTarget = -1;
        for (int i = 0; i < this.wTarget.getItemCount(); ++i) {
            int index2;
            String targetString = this.wTarget.getItem(i);
            String targetValue = targetString.toLowerCase();
            if (StringUtils.isNotEmpty((String)this.targetSeparator) && (index2 = targetValue.indexOf(this.targetSeparator)) >= 0) {
                targetValue = targetValue.substring(index2 + this.targetSeparator.length());
            }
            if (sourceValue.equals(targetValue)) {
                minDistance = 0;
                minTarget = i;
                break;
            }
            int distance = Utils.getDamerauLevenshteinDistance((String)sourceValue.toLowerCase(), (String)targetValue.toLowerCase());
            if (distance >= minDistance) continue;
            minDistance = distance;
            minTarget = i;
        }
        if (minTarget >= 0) {
            result.setTargetIndex(minTarget);
            result._found = true;
        }
        return result;
    }

    private boolean findSource() {
        boolean found = false;
        int targetIndex = this.wTarget.getSelectionIndex();
        String targetString = this.wTarget.getItem(targetIndex).toUpperCase();
        boolean first = true;
        for (int length = targetString.length(); !found && (length >= 2 || first); --length) {
            first = false;
            for (int i = 0; i < this.wSource.getItemCount() && !found; ++i) {
                if (this.wSource.getItem(i).toUpperCase().indexOf(targetString.substring(0, length)) < 0) continue;
                this.wSource.setSelection(i);
                found = true;
            }
        }
        return found;
    }

    private void add() {
        if (this.wSource.getSelectionCount() == 1 && this.wTarget.getSelectionCount() == 1) {
            String sourceString = this.wSource.getSelection()[0];
            String targetString = this.wTarget.getSelection()[0];
            int srcIndex = Const.indexOfString((String)sourceString, (String[])this.sourceList);
            int tgtIndex = Const.indexOfString((String)targetString, (String[])this.targetList);
            if (srcIndex >= 0 && tgtIndex >= 0) {
                SourceToTargetMapping mapping = new SourceToTargetMapping(srcIndex, tgtIndex);
                this.mappings.add(mapping);
                this.refreshMappings();
            }
        }
    }

    private void refreshMappings() {
        SourceToTargetMapping mapping;
        int a;
        this.wResult.removeAll();
        Collections.sort(this.mappings, Comparator.comparing(this::getMappingResultString));
        for (int i = 0; i < this.mappings.size(); ++i) {
            SourceToTargetMapping mapping2 = this.mappings.get(i);
            String mappingString = this.getMappingResultString(mapping2);
            this.wResult.add(mappingString);
        }
        this.wSource.removeAll();
        for (a = 0; a < this.sourceList.length; ++a) {
            boolean found = false;
            if (this.wSourceHide.getSelection()) {
                for (int b = 0; b < this.mappings.size() && !found; ++b) {
                    mapping = this.mappings.get(b);
                    if (mapping.getSourcePosition() != Const.indexOfString((String)this.sourceList[a], (String[])this.sourceList)) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.wSource.add(this.sourceList[a]);
        }
        this.wTarget.removeAll();
        for (a = 0; a < this.targetList.length; ++a) {
            boolean found = false;
            if (this.wTargetHide.getSelection()) {
                for (int b = 0; b < this.mappings.size() && !found; ++b) {
                    mapping = this.mappings.get(b);
                    if (mapping.getTargetPosition() != Const.indexOfString((String)this.targetList[a], (String[])this.targetList)) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.wTarget.add(this.targetList[a]);
        }
    }

    private String getMappingResultString(SourceToTargetMapping mapping) {
        return this.sourceList[mapping.getSourcePosition()] + " --> " + this.targetList[mapping.getTargetPosition()];
    }

    private void delete() {
        String[] result = this.wResult.getSelection();
        for (int i = result.length - 1; i >= 0; --i) {
            int idx = this.wResult.indexOf(result[i]);
            if (idx < 0 || idx >= this.mappings.size()) continue;
            this.mappings.remove(idx);
        }
        this.refreshMappings();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.refreshMappings();
    }

    private void cancel() {
        this.mappings = null;
        this.dispose();
    }

    private void ok() {
        this.dispose();
    }

    public String getSourceSeparator() {
        return this.sourceSeparator;
    }

    public void setSourceSeparator(String sourceSeparator) {
        this.sourceSeparator = sourceSeparator;
    }

    public String getTargetSeparator() {
        return this.targetSeparator;
    }

    public void setTargetSeparator(String targetSeparator) {
        this.targetSeparator = targetSeparator;
    }

    public class GuessPair {
        private int _srcIndex = -1;
        private int _targetIndex = -1;
        private boolean _found;

        public GuessPair(int src) {
            this._srcIndex = src;
            this._found = false;
        }

        public int getTargetIndex() {
            return this._targetIndex;
        }

        public void setTargetIndex(int targetIndex) {
            this._found = true;
            this._targetIndex = targetIndex;
        }

        public int getSrcIndex() {
            return this._srcIndex;
        }

        public void setSrcIndex(int srcIndex) {
            this._srcIndex = srcIndex;
        }

        public boolean getFound() {
            return this._found;
        }
    }
}

