/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class EditRowsDialog {
    private static final Class<?> PKG = EditRowsDialog.class;
    public static final int MAX_BINARY_STRING_PREVIEW_SIZE = 1000000;
    private Label wlMessage;
    private TableView wFields;
    private Button wOk;
    private Shell shell;
    private final List<Object[]> rowBuffer;
    private final PropsUi props;
    private String title;
    private String message;
    private Rectangle bounds;
    private int hscroll;
    private int vscroll;
    private int hmax;
    private int vmax;
    private IRowMeta rowMeta;
    private final ILogChannel log;
    protected int lineNr;
    private int style = 3312;
    private final Shell parentShell;
    private List<Object[]> outputList;
    private IRowMeta stringRowMeta;

    public EditRowsDialog(Shell parent, int style, String title, String message, IRowMeta rowMeta, List<Object[]> rowBuffer) {
        this.title = title;
        this.message = message;
        this.rowBuffer = rowBuffer;
        this.rowMeta = rowMeta;
        this.parentShell = parent;
        this.style = style != 0 ? style : this.style;
        this.props = PropsUi.getInstance();
        this.bounds = null;
        this.hscroll = -1;
        this.vscroll = -1;
        title = null;
        message = null;
        this.log = LogChannel.GENERAL;
    }

    public void setTitleMessage(String title, String message) {
        this.title = title;
        this.message = message;
    }

    public List<Object[]> open() {
        this.shell = new Shell(this.parentShell, this.style);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk, wCancel}, this.props.getMargin(), null);
        if (this.addFields()) {
            return null;
        }
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.outputList;
    }

    private boolean addFields() {
        int margin = this.props.getMargin();
        if (this.wlMessage == null) {
            this.wlMessage = new Label((Composite)this.shell, 16384);
            this.wlMessage.setText(this.message);
            this.props.setLook((Control)this.wlMessage);
            FormData fdlFields = new FormData();
            fdlFields.left = new FormAttachment(0, 0);
            fdlFields.right = new FormAttachment(100, 0);
            fdlFields.top = new FormAttachment(0, margin);
            this.wlMessage.setLayoutData((Object)fdlFields);
        } else {
            this.wFields.dispose();
        }
        if (this.rowMeta == null || this.rowMeta.size() == 0) {
            ShowMessageDialog dialog = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"EditRowsDialog.NoRowMeta.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"EditRowsDialog.NoRowMeta.Message", (String[])new String[0]));
            dialog.open();
            this.shell.dispose();
            return true;
        }
        ColumnInfo[] colinf = new ColumnInfo[this.rowMeta.size()];
        for (int i = 0; i < this.rowMeta.size(); ++i) {
            IValueMeta v = this.rowMeta.getValueMeta(i);
            colinf[i] = new ColumnInfo(v.getName(), 1, v.isNumeric());
            colinf[i].setToolTip(v.toStringMeta());
            colinf[i].setValueMeta(v);
        }
        this.wFields = new TableView((IVariables)new Variables(), (Composite)this.shell, 67586, colinf, this.rowBuffer.size(), null, this.props);
        this.wFields.setShowingBlueNullValues(true);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlMessage, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        this.shell.layout(true, true);
        return false;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.bounds = this.shell.getBounds();
        this.hscroll = this.wFields.getHorizontalBar().getSelection();
        this.vscroll = this.wFields.getVerticalBar().getSelection();
        this.shell.dispose();
    }

    private void getData() {
        this.shell.getDisplay().asyncExec(() -> {
            this.lineNr = 0;
            for (int i = 0; i < this.rowBuffer.size(); ++i) {
                TableItem item = this.wFields.table.getItem(i);
                Object[] row = this.rowBuffer.get(i);
                this.getDataForRow(item, row);
            }
            this.wFields.optWidth(true, 200);
        });
    }

    protected int getDataForRow(TableItem item, Object[] row) {
        String strNr;
        int nrErrors = 0;
        ++this.lineNr;
        try {
            strNr = this.wFields.getNumberColumn().getValueMeta().getString((Object)this.lineNr);
        }
        catch (Exception e) {
            strNr = Integer.toString(this.lineNr);
        }
        item.setText(0, strNr);
        for (int c = 0; c < this.rowMeta.size(); ++c) {
            String show;
            IValueMeta v = this.rowMeta.getValueMeta(c);
            try {
                show = v.getString(row[c]);
                if (v.isBinary() && show != null && show.length() > 1000000) {
                    show = show.substring(0, 1000000);
                }
            }
            catch (HopValueException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (++nrErrors < 25) {
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                show = null;
            }
            if (show != null) {
                item.setText(c + 1, show);
                item.setForeground(c + 1, GuiResource.getInstance().getColorBlack());
                continue;
            }
            item.setText(c + 1, "<null>");
            item.setForeground(c + 1, GuiResource.getInstance().getColorBlue());
        }
        return nrErrors;
    }

    @VisibleForTesting
    Object[] getRowForData(TableItem item, int rowNr) throws HopException {
        try {
            Object[] row = RowDataUtil.allocateRowData((int)this.rowMeta.size());
            for (int i = 0; i < this.rowMeta.size(); ++i) {
                IValueMeta valueMeta = this.rowMeta.getValueMeta(i);
                IValueMeta stringValueMeta = this.stringRowMeta.getValueMeta(i);
                int colnr = i + 1;
                if (this.isDisplayingNullValue(item, colnr)) {
                    row[i] = null;
                    continue;
                }
                String string = item.getText(colnr);
                if (stringValueMeta.isNull((Object)string)) {
                    string = null;
                }
                row[i] = valueMeta.convertDataFromString(string, stringValueMeta, null, null, 0);
            }
            return row;
        }
        catch (HopException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"EditRowsDialog.Error.ErrorGettingRowForData", (String[])new String[]{Integer.toString(rowNr)}), (Throwable)e);
        }
    }

    @VisibleForTesting
    boolean isDisplayingNullValue(TableItem item, int column) throws HopException {
        return GuiResource.getInstance().getColorBlue().equals((Object)item.getForeground(column));
    }

    private void ok() {
        try {
            this.stringRowMeta = new RowMeta();
            for (IValueMeta valueMeta : this.rowMeta.getValueMetaList()) {
                IValueMeta stringValueMeta = ValueMetaFactory.cloneValueMeta((IValueMeta)valueMeta, (int)2);
                this.stringRowMeta.addValueMeta(stringValueMeta);
            }
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            for (int i = 0; i < this.wFields.getItemCount(); ++i) {
                TableItem item = this.wFields.getTable().getItem(i);
                Object[] row = this.getRowForData(item, i + 1);
                list.add(row);
            }
            this.outputList = list;
            this.dispose();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", BaseMessages.getString(PKG, (String)"EditRowsDialog.ErrorConvertingData", (String[])new String[0]), e);
        }
    }

    private void cancel() {
        this.outputList = null;
        this.dispose();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle b) {
        this.bounds = b;
    }

    public int getHScroll() {
        return this.hscroll;
    }

    public void setHScroll(int s) {
        this.hscroll = s;
    }

    public int getVScroll() {
        return this.vscroll;
    }

    public void setVScroll(int s) {
        this.vscroll = s;
    }

    public int getHMax() {
        return this.hmax;
    }

    public void setHMax(int m) {
        this.hmax = m;
    }

    public int getVMax() {
        return this.vmax;
    }

    public void setVMax(int m) {
        this.vmax = m;
    }

    @VisibleForTesting
    void setRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }

    @VisibleForTesting
    void setStringRowMeta(IRowMeta stringRowMeta) {
        this.stringRowMeta = stringRowMeta;
    }
}

