/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.Props;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.AuditState;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.OsHelper;
import org.apache.hop.ui.hopgui.TextSizeUtilFacade;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class PropsUi
extends Props {
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static final String NO = "N";
    private static final String YES = "Y";
    private static double nativeZoomFactor;
    private static final String STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING = "ShowCopyOrDistributeWarning";
    private static final String SHOW_TOOL_TIPS = "ShowToolTips";
    private static final String SHOW_HELP_TOOL_TIPS = "ShowHelpToolTips";
    private static final String CANVAS_GRID_SIZE = "CanvasGridSize";
    private static final String LEGACY_PERSPECTIVE_MODE = "LegacyPerspectiveMode";
    private static final String DISABLE_BROWSER_ENVIRONMENT_CHECK = "DisableBrowserEnvironmentCheck";
    private static final String USE_DOUBLE_CLICK_ON_CANVAS = "UseDoubleClickOnCanvas";
    private static final String USE_GLOBAL_FILE_BOOKMARKS = "UseGlobalFileBookmarks";
    private static final String DARK_MODE = "DarkMode";
    private Map<RGB, RGB> contrastingColors;
    private static PropsUi instance;

    public static PropsUi getInstance() {
        if (instance == null) {
            instance = new PropsUi();
        }
        return instance;
    }

    private PropsUi() {
        if (EnvironmentUtils.getInstance().isWeb()) {
            nativeZoomFactor = 1.0;
        } else {
            org.eclipse.swt.graphics.Point extent = TextSizeUtilFacade.textExtent("The quick brown fox jumped over the lazy dog!");
            nativeZoomFactor = (double)extent.y / 16.0;
        }
        this.setDefault();
    }

    public void setDefault() {
        super.setDefault();
        Display display = Display.getCurrent();
        this.populateContrastingColors();
        if (!OsHelper.isWindows() & !EnvironmentUtils.getInstance().isWeb()) {
            if (Display.isSystemDarkTheme()) {
                this.setDarkMode(true);
                this.setOSLookShown(true);
            } else {
                this.setDarkMode(false);
                this.setOSLookShown(true);
            }
        } else {
            this.setOSLookShown(true);
        }
        if (display != null) {
            FontData fontData = this.getFixedFont();
            this.setProperty("FontFixedName", fontData.getName());
            this.setProperty("FontFixedSize", "" + fontData.getHeight());
            this.setProperty("FontFixedStyle", "" + fontData.getStyle());
            fontData = this.getDefaultFont();
            this.setProperty("FontDefaultName", fontData.getName());
            this.setProperty("FontDefaultSize", "" + fontData.getHeight());
            this.setProperty("FontDefaultStyle", "" + fontData.getStyle());
            fontData = this.getDefaultFont();
            this.setProperty("FontGraphName", fontData.getName());
            this.setProperty("FontGraphSize", "" + fontData.getHeight());
            this.setProperty("FontGraphStyle", "" + fontData.getStyle());
            fontData = this.getDefaultFont();
            this.setProperty("FontNoteName", fontData.getName());
            this.setProperty("FontNoteSize", "" + fontData.getHeight());
            this.setProperty("FontNoteStyle", "" + fontData.getStyle());
            RGB color = this.getBackgroundRGB();
            this.setProperty("BackgroundColorR", "" + color.red);
            this.setProperty("BackgroundColorG", "" + color.green);
            this.setProperty("BackgroundColorB", "" + color.blue);
            color = this.getGraphColorRGB();
            this.setProperty("GraphColorR", "" + color.red);
            this.setProperty("GraphColorG", "" + color.green);
            this.setProperty("GraphColorB", "" + color.blue);
            this.setProperty("IconSize", "" + this.getIconSize());
            this.setProperty("LineWidth", "" + this.getLineWidth());
            this.setProperty("MaxUndo", "" + this.getMaxUndo());
        }
        this.setUseGlobalFileBookmarks(true);
    }

    public void setFixedFont(FontData fd) {
        this.setProperty("FontFixedName", fd.getName());
        this.setProperty("FontFixedSize", "" + fd.getHeight());
        this.setProperty("FontFixedStyle", "" + fd.getStyle());
    }

    public FontData getFixedFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontFixedName", "Monospaced");
        int size = Const.toInt((String)this.getProperty("FontFixedSize"), (int)def.getHeight());
        int style = Const.toInt((String)this.getProperty("FontFixedStyle"), (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public void setDefaultFont(FontData fd) {
        if (fd != null) {
            this.setProperty("FontDefaultName", fd.getName());
            this.setProperty("FontDefaultSize", "" + fd.getHeight());
            this.setProperty("FontDefaultStyle", "" + fd.getStyle());
        }
    }

    public FontData getDefaultFont() {
        FontData def = this.getDefaultFontData();
        if (this.isOSLookShown()) {
            return def;
        }
        String name = this.getProperty("FontDefaultName", def.getName());
        int size = Const.toInt((String)this.getProperty("FontDefaultSize"), (int)def.getHeight());
        int style = Const.toInt((String)this.getProperty("FontDefaultStyle"), (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public void setGraphFont(FontData fd) {
        this.setProperty("FontGraphName", fd.getName());
        this.setProperty("FontGraphSize", "" + fd.getHeight());
        this.setProperty("FontGraphStyle", "" + fd.getStyle());
    }

    public FontData getGraphFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontGraphName", def.getName());
        int size = Const.toInt((String)this.getProperty("FontGraphSize"), (int)def.getHeight());
        int correctedSize = (int)Math.round((double)size / PropsUi.getNativeZoomFactor());
        int style = Const.toInt((String)this.getProperty("FontGraphStyle"), (int)def.getStyle());
        return new FontData(name, correctedSize, style);
    }

    public void setNoteFont(FontData fd) {
        this.setProperty("FontNoteName", fd.getName());
        this.setProperty("FontNoteSize", "" + fd.getHeight());
        this.setProperty("FontNoteStyle", "" + fd.getStyle());
    }

    public FontData getNoteFont() {
        FontData def = this.getDefaultFontData();
        String name = this.getProperty("FontNoteName", def.getName());
        String ssize = this.getProperty("FontNoteSize");
        String sstyle = this.getProperty("FontNoteStyle");
        int size = Const.toInt((String)ssize, (int)def.getHeight());
        int style = Const.toInt((String)sstyle, (int)def.getStyle());
        return new FontData(name, size, style);
    }

    public void setBackgroundRGB(RGB c) {
        this.setProperty("BackgroundColorR", c != null ? "" + c.red : "");
        this.setProperty("BackgroundColorG", c != null ? "" + c.green : "");
        this.setProperty("BackgroundColorB", c != null ? "" + c.blue : "");
    }

    public RGB getBackgroundRGB() {
        int r = Const.toInt((String)this.getProperty("BackgroundColorR"), (int)255);
        int g = Const.toInt((String)this.getProperty("BackgroundColorG"), (int)255);
        int b = Const.toInt((String)this.getProperty("BackgroundColorB"), (int)255);
        return new RGB(r, g, b);
    }

    public void setGraphColorRGB(RGB c) {
        this.setProperty("GraphColorR", "" + c.red);
        this.setProperty("GraphColorG", "" + c.green);
        this.setProperty("GraphColorB", "" + c.blue);
    }

    public RGB getGraphColorRGB() {
        int r = Const.toInt((String)this.getProperty("GraphColorR"), (int)255);
        int g = Const.toInt((String)this.getProperty("GraphColorG"), (int)255);
        int b = Const.toInt((String)this.getProperty("GraphColorB"), (int)255);
        return new RGB(r, g, b);
    }

    public void setTabColorRGB(RGB c) {
        this.setProperty("TabColorR", "" + c.red);
        this.setProperty("TabColorG", "" + c.green);
        this.setProperty("TabColorB", "" + c.blue);
    }

    public RGB getTabColorRGB() {
        int r = Const.toInt((String)this.getProperty("TabColorR"), (int)240);
        int g = Const.toInt((String)this.getProperty("TabColorG"), (int)240);
        int b = Const.toInt((String)this.getProperty("TabColorB"), (int)240);
        return new RGB(r, g, b);
    }

    public void setIconSize(int size) {
        this.setProperty("IconSize", "" + size);
    }

    public int getIconSize() {
        return Const.toInt((String)this.getProperty("IconSize"), (int)32);
    }

    public void setZoomFactor(double factor) {
        this.setProperty("ZoomFactor", Double.toString(factor));
    }

    public double getZoomFactor() {
        String zoomFactorString = this.getProperty("ZoomFactor");
        if (StringUtils.isNotEmpty((String)zoomFactorString)) {
            return Const.toDouble((String)zoomFactorString, (double)nativeZoomFactor);
        }
        return nativeZoomFactor;
    }

    public int getMargin() {
        return (int)Math.round(this.getZoomFactor() * 4.0);
    }

    public void setLineWidth(int width) {
        this.setProperty("LineWidth", "" + width);
    }

    public int getLineWidth() {
        return Const.toInt((String)this.getProperty("LineWidth"), (int)1);
    }

    public void setLastPipeline(String pipeline) {
        this.setProperty("LastPreviewPipeline", pipeline);
    }

    public String getLastPipeline() {
        return this.getProperty("LastPreviewPipeline", "");
    }

    public void setLastPreview(String[] lastpreview, int[] transformsize) {
        this.setProperty("LastPreviewTransform", "" + lastpreview.length);
        for (int i = 0; i < lastpreview.length; ++i) {
            this.setProperty("LastPreviewTransform" + (i + 1), lastpreview[i]);
            this.setProperty("LastPreviewSize" + (i + 1), "" + transformsize[i]);
        }
    }

    public String[] getLastPreview() {
        String snr = this.getProperty("LastPreviewTransform");
        int nr = Const.toInt((String)snr, (int)0);
        String[] lp = new String[nr];
        for (int i = 0; i < nr; ++i) {
            lp[i] = this.getProperty("LastPreviewTransform" + (i + 1), "");
        }
        return lp;
    }

    public int[] getLastPreviewSize() {
        String snr = this.getProperty("LastPreviewTransform");
        int nr = Const.toInt((String)snr, (int)0);
        int[] si = new int[nr];
        for (int i = 0; i < nr; ++i) {
            si[i] = Const.toInt((String)this.getProperty("LastPreviewSize" + (i + 1), ""), (int)0);
        }
        return si;
    }

    public FontData getDefaultFontData() {
        return Display.getCurrent().getSystemFont().getFontData()[0];
    }

    public void setMaxUndo(int max) {
        this.setProperty("MaxUndo", "" + max);
    }

    public int getMaxUndo() {
        return Const.toInt((String)this.getProperty("MaxUndo"), (int)100);
    }

    public void setMiddlePct(int pct) {
        this.setProperty("MiddlePct", "" + pct);
    }

    public int getMiddlePct() {
        return Const.toInt((String)this.getProperty("MiddlePct"), (int)35);
    }

    public void setScreen(WindowProperty windowProperty) {
        AuditManager.storeState((ILogChannel)LogChannel.UI, (String)HopNamespace.getNamespace(), (String)"shells", (String)windowProperty.getName(), windowProperty.getStateProperties());
    }

    public WindowProperty getScreen(String windowName) {
        if (windowName == null) {
            return null;
        }
        AuditState auditState = AuditManager.retrieveState((ILogChannel)LogChannel.UI, (String)HopNamespace.getNamespace(), (String)"shells", (String)windowName);
        if (auditState == null) {
            return null;
        }
        return new WindowProperty(windowName, auditState.getStateMap());
    }

    public void setOpenLastFile(boolean open) {
        this.setProperty("OpenLastFile", open ? YES : NO);
    }

    public boolean openLastFile() {
        String open = this.getProperty("OpenLastFile");
        return !NO.equalsIgnoreCase(open);
    }

    public void setAutoSave(boolean autosave) {
        this.setProperty("AutoSave", autosave ? YES : NO);
    }

    public boolean getAutoSave() {
        String autosave = this.getProperty("AutoSave");
        return YES.equalsIgnoreCase(autosave);
    }

    public void setSaveConfirmation(boolean saveconf) {
        this.setProperty("SaveConfirmation", saveconf ? YES : NO);
    }

    public boolean getSaveConfirmation() {
        String saveconf = this.getProperty("SaveConfirmation");
        return YES.equalsIgnoreCase(saveconf);
    }

    public void setAutoSplit(boolean autosplit) {
        this.setProperty("AutoSplit", autosplit ? YES : NO);
    }

    public boolean getAutoSplit() {
        String autosplit = this.getProperty("AutoSplit");
        return YES.equalsIgnoreCase(autosplit);
    }

    public void setAutoCollapseCoreObjectsTree(boolean autoCollapse) {
        this.setProperty("AutoCollapseCoreObjectsTree", autoCollapse ? YES : NO);
    }

    public boolean getAutoCollapseCoreObjectsTree() {
        String autoCollapse = this.getProperty("AutoCollapseCoreObjectsTree");
        return YES.equalsIgnoreCase(autoCollapse);
    }

    public void setExitWarningShown(boolean show) {
        this.setProperty("ShowExitWarning", show ? YES : NO);
    }

    public boolean isShowCanvasGridEnabled() {
        String showCanvas = this.getProperty("ShowCanvasGrid", NO);
        return YES.equalsIgnoreCase(showCanvas);
    }

    public void setShowCanvasGridEnabled(boolean anti) {
        this.setProperty("ShowCanvasGrid", anti ? YES : NO);
    }

    public boolean showExitWarning() {
        String show = this.getProperty("ShowExitWarning", YES);
        return YES.equalsIgnoreCase(show);
    }

    public boolean isOSLookShown() {
        String show = this.getProperty("ShowOSLook", NO);
        return YES.equalsIgnoreCase(show);
    }

    public void setOSLookShown(boolean show) {
        this.setProperty("ShowOSLook", show ? YES : NO);
    }

    public static void setGCFont(GC gc, Device device, FontData fontData) {
        if (Const.getSystemOs().startsWith("Windows")) {
            Font font = new Font(device, fontData);
            gc.setFont(font);
            font.dispose();
        } else {
            gc.setFont(device.getSystemFont());
        }
    }

    public void setLook(Control widget) {
        if (widget instanceof Combo) {
            return;
        }
        this.setLook(widget, 0);
        if (widget instanceof Composite) {
            for (Control child : ((Composite)widget).getChildren()) {
                this.setLook(child);
            }
        }
    }

    public void setLook(Control control, int style) {
        Button b;
        if (this.isOSLookShown() && style != 1) {
            return;
        }
        GuiResource gui = GuiResource.getInstance();
        Font font = null;
        Color background = null;
        Color foreground = null;
        switch (style) {
            case 0: {
                background = gui.getColorBackground();
                foreground = gui.getColorBlack();
                if (control instanceof Group && OS.indexOf("mac") > -1) {
                    control.addPaintListener(paintEvent -> {
                        paintEvent.gc.setForeground(gui.getColorBlack());
                        paintEvent.gc.setBackground(gui.getColorBackground());
                        paintEvent.gc.fillRectangle(2, 0, control.getBounds().width - 8, control.getBounds().height - 20);
                    });
                }
                font = null;
                break;
            }
            case 1: {
                if (!this.isOSLookShown()) {
                    foreground = gui.getColorBlack();
                    background = gui.getColorBackground();
                }
                font = gui.getFontFixed();
                break;
            }
            case 2: {
                foreground = gui.getColorBackground();
                background = gui.getColorBackground();
                font = null;
                break;
            }
            case 3: {
                foreground = gui.getColorBackground();
                background = gui.getColorBackground();
                font = gui.getFontNote();
                break;
            }
            case 4: {
                foreground = gui.getColorBackground();
                background = gui.getColorBackground();
                font = gui.getFontGraph();
                break;
            }
            case 6: {
                foreground = gui.getColorBackground();
                if (instance.isDarkMode()) {
                    background = GuiResource.getInstance().getColorBackground();
                    break;
                }
                background = GuiResource.getInstance().getColorDemoGray();
                break;
            }
            case 5: {
                background = GuiResource.getInstance().getColorWhite();
                CTabFolder tabFolder = (CTabFolder)control;
                tabFolder.setBorderVisible(true);
                Color c = GuiResource.getInstance().getColorTab();
                Color tabColor = new Color(c.getDevice(), c.getRed(), c.getGreen(), c.getBlue());
                tabFolder.setSelectionBackground(tabColor);
                break;
            }
            default: {
                background = gui.getColorBackground();
                font = null;
            }
        }
        if (font != null && !font.isDisposed()) {
            control.setFont(font);
        }
        if (background != null && !background.isDisposed()) {
            boolean setBackground = true;
            if (control instanceof Button && ((b = (Button)control).getStyle() & 8) != 0) {
                setBackground = false;
            }
            if (setBackground) {
                control.setBackground(background);
            }
        }
        if (foreground != null && !foreground.isDisposed()) {
            boolean setForeground = true;
            if (control instanceof Button && ((b = (Button)control).getStyle() & 8) != 0) {
                setForeground = false;
            }
            if (setForeground) {
                control.setForeground(foreground);
            }
        }
    }

    public static void setTableItemLook(TableItem item, Display disp) {
        if (!Const.getSystemOs().startsWith("Windows")) {
            return;
        }
        Color background = GuiResource.getInstance().getColorBackground();
        if (background != null) {
            item.setBackground(background);
        }
    }

    public static Display getDisplay() {
        return Display.getCurrent();
    }

    public void setDefaultPreviewSize(int size) {
        this.setProperty("DefaultPreviewSize", "" + size);
    }

    public int getDefaultPreviewSize() {
        return Const.toInt((String)this.getProperty("DefaultPreviewSize"), (int)1000);
    }

    public boolean showCopyOrDistributeWarning() {
        String show = this.getProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, YES);
        return YES.equalsIgnoreCase(show);
    }

    public void setShowCopyOrDistributeWarning(boolean show) {
        this.setProperty(STRING_SHOW_COPY_OR_DISTRIBUTE_WARNING, show ? YES : NO);
    }

    public void setDialogSize(Shell shell, String styleProperty) {
        String prop = this.getProperty(styleProperty);
        if (Utils.isEmpty((CharSequence)prop)) {
            return;
        }
        String[] xy = prop.split(",");
        if (xy.length != 2) {
            return;
        }
        shell.setSize(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
    }

    public boolean useDoubleClick() {
        return YES.equalsIgnoreCase(this.getProperty(USE_DOUBLE_CLICK_ON_CANVAS, NO));
    }

    public void setUseDoubleClickOnCanvas(boolean use) {
        this.setProperty(USE_DOUBLE_CLICK_ON_CANVAS, use ? YES : NO);
    }

    public boolean useGlobalFileBookmarks() {
        return YES.equalsIgnoreCase(this.getProperty(USE_GLOBAL_FILE_BOOKMARKS, YES));
    }

    public void setUseGlobalFileBookmarks(boolean use) {
        this.setProperty(USE_GLOBAL_FILE_BOOKMARKS, use ? YES : NO);
    }

    public boolean isDarkMode() {
        return YES.equalsIgnoreCase(this.getProperty(DARK_MODE, NO));
    }

    public void setDarkMode(boolean darkMode) {
        this.setProperty(DARK_MODE, darkMode ? YES : NO);
    }

    public boolean showToolTips() {
        return YES.equalsIgnoreCase(this.getProperty(SHOW_TOOL_TIPS, YES));
    }

    public void setShowToolTips(boolean show) {
        this.setProperty(SHOW_TOOL_TIPS, show ? YES : NO);
    }

    public boolean isShowingHelpToolTips() {
        return YES.equalsIgnoreCase(this.getProperty(SHOW_HELP_TOOL_TIPS, YES));
    }

    public void setShowingHelpToolTips(boolean show) {
        this.setProperty(SHOW_HELP_TOOL_TIPS, show ? YES : NO);
    }

    public int getCanvasGridSize() {
        return Const.toInt((String)this.getProperty(CANVAS_GRID_SIZE, "16"), (int)16);
    }

    public void setCanvasGridSize(int gridSize) {
        this.setProperty(CANVAS_GRID_SIZE, Integer.toString(gridSize));
    }

    public int getSupportedVersion(String property) {
        return Integer.parseInt(this.getProperty(property));
    }

    public boolean isBrowserEnvironmentCheckDisabled() {
        return YES.equalsIgnoreCase(this.getProperty(DISABLE_BROWSER_ENVIRONMENT_CHECK, NO));
    }

    public boolean isLegacyPerspectiveMode() {
        return YES.equalsIgnoreCase(this.getProperty(LEGACY_PERSPECTIVE_MODE, NO));
    }

    public static void setLocation(IGuiPosition guiElement, int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        guiElement.setLocation(PropsUi.calculateGridPosition(new Point(x, y)));
    }

    public static Point calculateGridPosition(Point p) {
        int gridSize = PropsUi.getInstance().getCanvasGridSize();
        if (gridSize > 1) {
            return new Point(gridSize * Math.round(p.x / gridSize), gridSize * Math.round(p.y / gridSize));
        }
        return p;
    }

    public boolean isIndicateSlowPipelineTransformsEnabled() {
        String indicate = this.getProperty("IndicateSlowPipelineTransforms", YES);
        return YES.equalsIgnoreCase(indicate);
    }

    public void setIndicateSlowPipelineTransformsEnabled(boolean indicate) {
        this.setProperty("IndicateSlowPipelineTransforms", indicate ? YES : NO);
    }

    public static double getNativeZoomFactor() {
        return nativeZoomFactor;
    }

    public static void setNativeZoomFactor(double nativeZoomFactor) {
        PropsUi.nativeZoomFactor = nativeZoomFactor;
    }

    private void populateContrastingColors() {
        this.contrastingColors = new HashMap<RGB, RGB>();
        this.contrastingColors.put(this.toRGB("#000000"), this.toRGB("#ffffff"));
        this.contrastingColors.put(this.toRGB("#0e3a5a"), this.toRGB("#c8e7fa"));
        this.contrastingColors.put(this.toRGB("#f0f0f0"), this.toRGB("#0f0f0f"));
        this.contrastingColors.put(this.toRGB("#e1e1e1"), this.toRGB("#303030"));
        this.contrastingColors.put(this.toRGB("#646464"), this.toRGB("#707070"));
        this.contrastingColors.put(this.toRGB("#ffd700"), this.toRGB("#0028ff"));
        this.contrastingColors.put(this.toRGB("#033d5d"), this.toRGB("#36b3f8"));
        this.contrastingColors.put(this.toRGB("#eeffaa"), this.toRGB("#556a00"));
        this.contrastingColors.put(this.toRGB("#c9e8fb"), this.toRGB("#0f88d2"));
        this.contrastingColors.put(new RGB(240, 240, 240), new RGB(15, 15, 15));
        this.contrastingColors.put(new RGB(225, 225, 225), new RGB(30, 30, 30));
        this.contrastingColors.put(new RGB(215, 215, 215), new RGB(40, 40, 40));
        this.contrastingColors.put(new RGB(100, 100, 100), new RGB(155, 155, 155));
        HashMap inverse = new HashMap();
        this.contrastingColors.keySet().stream().forEach(key -> inverse.put(this.contrastingColors.get(key), key));
        this.contrastingColors.putAll(inverse);
    }

    private RGB toRGB(String colorString) {
        int red = Integer.valueOf(colorString.substring(1, 3), 16);
        int green = Integer.valueOf(colorString.substring(3, 5), 16);
        int blue = Integer.valueOf(colorString.substring(5, 7), 16);
        return new RGB(red, green, blue);
    }

    public RGB contrastColor(RGB rgb) {
        RGB contrastingRGB;
        if (PropsUi.getInstance().isDarkMode() && (contrastingRGB = this.contrastingColors.get(rgb)) != null) {
            return contrastingRGB;
        }
        return rgb;
    }

    public RGB contrastColor(int r, int g, int b) {
        return this.contrastColor(new RGB(r, g, b));
    }

    public Map<String, String> getContrastingColorStrings() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (RGB rgb : this.contrastingColors.keySet()) {
            RGB contrastingRGB = this.contrastingColors.get(rgb);
            map.put(this.toColorString(rgb), this.toColorString(contrastingRGB));
            map.put(this.toColorString(rgb).toUpperCase(), this.toColorString(contrastingRGB));
        }
        return map;
    }

    private String toColorString(RGB rgb) {
        String r = Integer.toString(rgb.red, 16);
        r = r.length() == 1 ? "0" + r : r;
        String g = Integer.toString(rgb.green, 16);
        g = g.length() == 1 ? "0" + g : g;
        String b = Integer.toString(rgb.blue, 16);
        b = b.length() == 1 ? "0" + b : b;
        return ("#" + r + g + b).toLowerCase();
    }

    public Map<RGB, RGB> getContrastingColors() {
        return this.contrastingColors;
    }

    public void setContrastingColors(Map<RGB, RGB> contrastingColors) {
        this.contrastingColors = contrastingColors;
    }
}

