/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LockConflictError;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class LockFileError {
    public static final LockFileError TOO_MANY_WRITE_OPERATIONS = new LockFileError().withTag(Tag.TOO_MANY_WRITE_OPERATIONS);
    public static final LockFileError TOO_MANY_FILES = new LockFileError().withTag(Tag.TOO_MANY_FILES);
    public static final LockFileError NO_WRITE_PERMISSION = new LockFileError().withTag(Tag.NO_WRITE_PERMISSION);
    public static final LockFileError CANNOT_BE_LOCKED = new LockFileError().withTag(Tag.CANNOT_BE_LOCKED);
    public static final LockFileError FILE_NOT_SHARED = new LockFileError().withTag(Tag.FILE_NOT_SHARED);
    public static final LockFileError INTERNAL_ERROR = new LockFileError().withTag(Tag.INTERNAL_ERROR);
    public static final LockFileError OTHER = new LockFileError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathLookupValue;
    private LockConflictError lockConflictValue;

    private LockFileError() {
    }

    private LockFileError withTag(Tag _tag) {
        LockFileError result = new LockFileError();
        result._tag = _tag;
        return result;
    }

    private LockFileError withTagAndPathLookup(Tag _tag, LookupError pathLookupValue) {
        LockFileError result = new LockFileError();
        result._tag = _tag;
        result.pathLookupValue = pathLookupValue;
        return result;
    }

    private LockFileError withTagAndLockConflict(Tag _tag, LockConflictError lockConflictValue) {
        LockFileError result = new LockFileError();
        result._tag = _tag;
        result.lockConflictValue = lockConflictValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPathLookup() {
        return this._tag == Tag.PATH_LOOKUP;
    }

    public static LockFileError pathLookup(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LockFileError().withTagAndPathLookup(Tag.PATH_LOOKUP, value);
    }

    public LookupError getPathLookupValue() {
        if (this._tag != Tag.PATH_LOOKUP) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH_LOOKUP, but was Tag." + this._tag.name());
        }
        return this.pathLookupValue;
    }

    public boolean isTooManyWriteOperations() {
        return this._tag == Tag.TOO_MANY_WRITE_OPERATIONS;
    }

    public boolean isTooManyFiles() {
        return this._tag == Tag.TOO_MANY_FILES;
    }

    public boolean isNoWritePermission() {
        return this._tag == Tag.NO_WRITE_PERMISSION;
    }

    public boolean isCannotBeLocked() {
        return this._tag == Tag.CANNOT_BE_LOCKED;
    }

    public boolean isFileNotShared() {
        return this._tag == Tag.FILE_NOT_SHARED;
    }

    public boolean isLockConflict() {
        return this._tag == Tag.LOCK_CONFLICT;
    }

    public static LockFileError lockConflict(LockConflictError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LockFileError().withTagAndLockConflict(Tag.LOCK_CONFLICT, value);
    }

    public LockConflictError getLockConflictValue() {
        if (this._tag != Tag.LOCK_CONFLICT) {
            throw new IllegalStateException("Invalid tag: required Tag.LOCK_CONFLICT, but was Tag." + this._tag.name());
        }
        return this.lockConflictValue;
    }

    public boolean isInternalError() {
        return this._tag == Tag.INTERNAL_ERROR;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathLookupValue, this.lockConflictValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LockFileError) {
            LockFileError other = (LockFileError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH_LOOKUP: {
                    return this.pathLookupValue == other.pathLookupValue || this.pathLookupValue.equals(other.pathLookupValue);
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    return true;
                }
                case TOO_MANY_FILES: {
                    return true;
                }
                case NO_WRITE_PERMISSION: {
                    return true;
                }
                case CANNOT_BE_LOCKED: {
                    return true;
                }
                case FILE_NOT_SHARED: {
                    return true;
                }
                case LOCK_CONFLICT: {
                    return this.lockConflictValue == other.lockConflictValue || this.lockConflictValue.equals(other.lockConflictValue);
                }
                case INTERNAL_ERROR: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<LockFileError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LockFileError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH_LOOKUP: {
                    g.writeStartObject();
                    this.writeTag("path_lookup", g);
                    g.writeFieldName("path_lookup");
                    LookupError.Serializer.INSTANCE.serialize(value.pathLookupValue, g);
                    g.writeEndObject();
                    break;
                }
                case TOO_MANY_WRITE_OPERATIONS: {
                    g.writeString("too_many_write_operations");
                    break;
                }
                case TOO_MANY_FILES: {
                    g.writeString("too_many_files");
                    break;
                }
                case NO_WRITE_PERMISSION: {
                    g.writeString("no_write_permission");
                    break;
                }
                case CANNOT_BE_LOCKED: {
                    g.writeString("cannot_be_locked");
                    break;
                }
                case FILE_NOT_SHARED: {
                    g.writeString("file_not_shared");
                    break;
                }
                case LOCK_CONFLICT: {
                    g.writeStartObject();
                    this.writeTag("lock_conflict", g);
                    LockConflictError.Serializer.INSTANCE.serialize(value.lockConflictValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case INTERNAL_ERROR: {
                    g.writeString("internal_error");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public LockFileError deserialize(JsonParser p) throws IOException, JsonParseException {
            LockFileError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path_lookup".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path_lookup", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = LockFileError.pathLookup(fieldValue);
            } else if ("too_many_write_operations".equals(tag)) {
                value = TOO_MANY_WRITE_OPERATIONS;
            } else if ("too_many_files".equals(tag)) {
                value = TOO_MANY_FILES;
            } else if ("no_write_permission".equals(tag)) {
                value = NO_WRITE_PERMISSION;
            } else if ("cannot_be_locked".equals(tag)) {
                value = CANNOT_BE_LOCKED;
            } else if ("file_not_shared".equals(tag)) {
                value = FILE_NOT_SHARED;
            } else if ("lock_conflict".equals(tag)) {
                LockConflictError fieldValue = null;
                fieldValue = LockConflictError.Serializer.INSTANCE.deserialize(p, true);
                value = LockFileError.lockConflict(fieldValue);
            } else {
                value = "internal_error".equals(tag) ? INTERNAL_ERROR : OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH_LOOKUP,
        TOO_MANY_WRITE_OPERATIONS,
        TOO_MANY_FILES,
        NO_WRITE_PERMISSION,
        CANNOT_BE_LOCKED,
        FILE_NOT_SHARED,
        LOCK_CONFLICT,
        INTERNAL_ERROR,
        OTHER;

    }
}

