/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceupdate;

import com.google.common.annotations.VisibleForTesting;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.bind.XmlObject;
import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransform;
import org.apache.hop.pipeline.transforms.salesforceupdate.SalesforceUpdateData;
import org.apache.hop.pipeline.transforms.salesforceupdate.SalesforceUpdateMeta;
import org.apache.hop.pipeline.transforms.salesforceutils.SalesforceUtils;

public class SalesforceUpdate
extends SalesforceTransform<SalesforceUpdateMeta, SalesforceUpdateData> {
    private static final Class<?> PKG = SalesforceUpdateMeta.class;

    public SalesforceUpdate(TransformMeta transformMeta, SalesforceUpdateMeta meta, SalesforceUpdateData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (((SalesforceUpdateData)this.data).iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SalesforceUpdateData)this.data).sfBuffer = new SObject[((SalesforceUpdateMeta)this.meta).getBatchSizeInt()];
            ((SalesforceUpdateData)this.data).outputBuffer = new Object[((SalesforceUpdateMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceUpdateData)this.data).nrFields = ((SalesforceUpdateMeta)this.meta).getUpdateLookup().length;
            if (((SalesforceUpdateData)this.data).nrFields == 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceUpdateDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
            }
            ((SalesforceUpdateData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            ((SalesforceUpdateData)this.data).outputRowMeta = ((SalesforceUpdateData)this.data).inputRowMeta.clone();
            ((SalesforceUpdateMeta)this.meta).getFields(((SalesforceUpdateData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((SalesforceUpdateData)this.data).fieldnrs = new int[((SalesforceUpdateMeta)this.meta).getUpdateStream().length];
            for (int i = 0; i < ((SalesforceUpdateMeta)this.meta).getUpdateStream().length; ++i) {
                ((SalesforceUpdateData)this.data).fieldnrs[i] = this.getInputRowMeta().indexOfValue(((SalesforceUpdateMeta)this.meta).getUpdateStream()[i]);
                if (((SalesforceUpdateData)this.data).fieldnrs[i] >= 0) continue;
                throw new HopException("Field [" + ((SalesforceUpdateMeta)this.meta).getUpdateStream()[i] + "] couldn't be found in the input stream!");
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"SalesforceUpdate.log.Exception", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    @VisibleForTesting
    void writeToSalesForce(Object[] rowData) throws HopException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Called writeToSalesForce with " + ((SalesforceUpdateData)this.data).iBufferPos + " out of " + ((SalesforceUpdateMeta)this.meta).getBatchSizeInt());
            }
            if (((SalesforceUpdateData)this.data).iBufferPos < ((SalesforceUpdateMeta)this.meta).getBatchSizeInt()) {
                ArrayList<String> fieldsToNull = new ArrayList<String>();
                ArrayList<XmlObject> updatefields = new ArrayList<XmlObject>();
                for (int i = 0; i < ((SalesforceUpdateData)this.data).nrFields; ++i) {
                    boolean valueIsNull = ((SalesforceUpdateData)this.data).inputRowMeta.isNull(rowData, ((SalesforceUpdateData)this.data).fieldnrs[i]);
                    if (valueIsNull) {
                        fieldsToNull.add(SalesforceUtils.getFieldToNullName(this.log, ((SalesforceUpdateMeta)this.meta).getUpdateLookup()[i], ((SalesforceUpdateMeta)this.meta).getUseExternalId()[i]));
                        continue;
                    }
                    IValueMeta valueMeta = ((SalesforceUpdateData)this.data).inputRowMeta.getValueMeta(((SalesforceUpdateData)this.data).fieldnrs[i]);
                    Object value = rowData[((SalesforceUpdateData)this.data).fieldnrs[i]];
                    Object normalObject = this.normalizeValue(valueMeta, value);
                    updatefields.add(SalesforceConnection.createMessageElement(((SalesforceUpdateMeta)this.meta).getUpdateLookup()[i], normalObject, ((SalesforceUpdateMeta)this.meta).getUseExternalId()[i]));
                }
                SObject sobjPass = new SObject();
                sobjPass.setType(((SalesforceUpdateData)this.data).connection.getModule());
                if (updatefields.size() > 0) {
                    for (XmlObject element : updatefields) {
                        sobjPass.setSObjectField(element.getName().getLocalPart(), element.getValue());
                    }
                }
                if (fieldsToNull.size() > 0) {
                    sobjPass.setFieldsToNull(fieldsToNull.toArray(new String[fieldsToNull.size()]));
                }
                ((SalesforceUpdateData)this.data).sfBuffer[((SalesforceUpdateData)this.data).iBufferPos] = sobjPass;
                ((SalesforceUpdateData)this.data).outputBuffer[((SalesforceUpdateData)this.data).iBufferPos] = rowData;
                ++((SalesforceUpdateData)this.data).iBufferPos;
            }
            if (((SalesforceUpdateData)this.data).iBufferPos >= ((SalesforceUpdateMeta)this.meta).getBatchSizeInt()) {
                if (this.log.isDetailed()) {
                    this.logDetailed("Calling flush buffer from writeToSalesForce");
                }
                this.flushBuffers();
            }
        }
        catch (Exception e) {
            throw new HopException("\nFailed in writeToSalesForce: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws HopException {
        try {
            if (((SalesforceUpdateData)this.data).sfBuffer.length > ((SalesforceUpdateData)this.data).iBufferPos) {
                SObject[] smallBuffer = new SObject[((SalesforceUpdateData)this.data).iBufferPos];
                System.arraycopy(((SalesforceUpdateData)this.data).sfBuffer, 0, smallBuffer, 0, ((SalesforceUpdateData)this.data).iBufferPos);
                ((SalesforceUpdateData)this.data).sfBuffer = smallBuffer;
            }
            ((SalesforceUpdateData)this.data).saveResult = ((SalesforceUpdateData)this.data).connection.update(((SalesforceUpdateData)this.data).sfBuffer);
            int nr = ((SalesforceUpdateData)this.data).saveResult.length;
            for (int j = 0; j < nr; ++j) {
                if (((SalesforceUpdateData)this.data).saveResult[j].isSuccess()) {
                    String id = ((SalesforceUpdateData)this.data).saveResult[j].getId();
                    if (this.log.isDetailed()) {
                        this.logDetailed("Row updated with id: " + id);
                    }
                    Object[] newRow = RowDataUtil.resizeArray((Object[])((SalesforceUpdateData)this.data).outputBuffer[j], (int)((SalesforceUpdateData)this.data).outputRowMeta.size());
                    if (this.log.isDetailed()) {
                        this.logDetailed("The new row has an id value of : " + newRow[0]);
                    }
                    this.putRow(((SalesforceUpdateData)this.data).outputRowMeta, newRow);
                    this.incrementLinesUpdated();
                    if (!this.checkFeedback(this.getLinesInput()) || !this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpdate.log.LineRow", (String[])new String[]{"" + this.getLinesInput()}));
                    continue;
                }
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed("Found error from SalesForce and raising the exception");
                    }
                    Error err = ((SalesforceUpdateData)this.data).saveResult[j].getErrors()[0];
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceUpdate.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()}));
                }
                String errorMessage = "";
                for (int i = 0; i < ((SalesforceUpdateData)this.data).saveResult[j].getErrors().length; ++i) {
                    Error err = ((SalesforceUpdateData)this.data).saveResult[j].getErrors()[i];
                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"SalesforceUpdate.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()});
                }
                if (this.log.isDebug()) {
                    this.logDebug("Passing row to error transform");
                }
                this.putError(this.getInputRowMeta(), ((SalesforceUpdateData)this.data).outputBuffer[j], 1L, errorMessage, null, "SalesforceUpdate001");
            }
            ((SalesforceUpdateData)this.data).sfBuffer = new SObject[((SalesforceUpdateMeta)this.meta).getBatchSizeInt()];
            ((SalesforceUpdateData)this.data).outputBuffer = new Object[((SalesforceUpdateMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceUpdateData)this.data).iBufferPos = 0;
        }
        catch (Exception e) {
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                throw new HopException("\nFailed to update object, error message was: \n" + e.getMessage());
            }
            if (this.log.isDebug()) {
                this.logDebug("Passing row to error transform");
            }
            for (int i = 0; i < ((SalesforceUpdateData)this.data).iBufferPos; ++i) {
                this.putError(((SalesforceUpdateData)this.data).inputRowMeta, ((SalesforceUpdateData)this.data).outputBuffer[i], 1L, e.getMessage(), null, "SalesforceUpdate002");
            }
        }
        finally {
            if (((SalesforceUpdateData)this.data).saveResult != null) {
                ((SalesforceUpdateData)this.data).saveResult = null;
            }
        }
    }

    @Override
    public boolean init() {
        if (super.init()) {
            try {
                ((SalesforceUpdateData)this.data).connection.setRollbackAllChangesOnError(((SalesforceUpdateMeta)this.meta).isRollbackAllChangesOnError());
                ((SalesforceUpdateData)this.data).connection.connect();
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceUpdate.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        if (((SalesforceUpdateData)this.data).outputBuffer != null) {
            ((SalesforceUpdateData)this.data).outputBuffer = null;
        }
        if (((SalesforceUpdateData)this.data).sfBuffer != null) {
            ((SalesforceUpdateData)this.data).sfBuffer = null;
        }
        super.dispose();
    }
}

