/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinput;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputMeta;
import org.w3c.dom.Node;

public class SalesforceInputField
implements Cloneable {
    private static Class<?> PKG = SalesforceInputMeta.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInputField.TrimType.Both", (String[])new String[0])};
    @Injection(name="NAME", group="FIELDS")
    private String name;
    @Injection(name="FIELD", group="FIELDS")
    private String field;
    private int type;
    @Injection(name="LENGTH", group="FIELDS")
    private int length;
    @Injection(name="FORMAT", group="FIELDS")
    private String format;
    private int trimtype;
    @Injection(name="PRECISION", group="FIELDS")
    private int precision;
    @Injection(name="CURRENCY", group="FIELDS")
    private String currencySymbol;
    @Injection(name="DECIMAL", group="FIELDS")
    private String decimalSymbol;
    @Injection(name="GROUP", group="FIELDS")
    private String groupSymbol;
    @Injection(name="REPEAT", group="FIELDS")
    private boolean repeat;
    @Injection(name="ISIDLOOKUP", group="FIELDS")
    private boolean idlookup;
    private String[] samples;

    public SalesforceInputField(String fieldname) {
        this.name = fieldname;
        this.field = "";
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
        this.idlookup = false;
    }

    public SalesforceInputField() {
        this("");
    }

    public SalesforceInputField(Node fnode) throws HopTransformException {
        this.readData(fnode);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XmlHandler.openTag((String)"field")).append(Const.CR);
        retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"field", (String)this.getField()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"idlookup", (boolean)this.isIdLookup()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)this.getTypeDesc()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)this.getFormat()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)this.getGroupSymbol()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.getLength()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.getPrecision()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode()));
        retval.append("        ").append(XmlHandler.addTagValue((String)"repeat", (boolean)this.isRepeated()));
        retval.append("      ").append(XmlHandler.closeTag((String)"field")).append(Const.CR);
        return retval.toString();
    }

    public void readData(Node fnode) {
        this.setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
        this.setField(XmlHandler.getTagValue((Node)fnode, (String)"field"));
        this.setIdLookup("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"idlookup")));
        this.setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(SalesforceInputField.getTrimTypeByCode(XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return SalesforceInputField.getTrimTypeByCode(tt);
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            return (SalesforceInputField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String fieldvalue) {
        this.field = fieldvalue;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    @Injection(name="TYPE", group="FIELDS")
    public void setType(String typeDesc) {
        this.type = ValueMetaFactory.getIdForValueMeta((String)typeDesc);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return SalesforceInputField.getTrimTypeCode(this.trimtype);
    }

    public String getTrimTypeDesc() {
        return SalesforceInputField.getTrimTypeDesc(this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    @Injection(name="TRIM_TYPE", group="FIELDS")
    public void setTrimTypeDesc(String trimTypeDesc) {
        this.trimtype = SalesforceInputField.getTrimTypeByDesc(trimTypeDesc);
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean isIdLookup() {
        return this.idlookup;
    }

    public void setIdLookup(boolean idlookup) {
        this.idlookup = idlookup;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }
}

