/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rowsfromresult;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rowsfromresult.RowsFromResult;
import org.apache.hop.pipeline.transforms.rowsfromresult.RowsFromResultData;
import org.w3c.dom.Node;

@Transform(id="RowsFromResult", image="rowsfromresult.svg", name="i18n::BaseTransform.TypeLongDesc.RowsFromResult", description="i18n::BaseTransform.TypeTooltipDesc.RowsFromResult", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Workflow", documentationUrl="/pipeline/transforms/getrowsfromresult.html")
public class RowsFromResultMeta
extends BaseTransformMeta
implements ITransformMeta<RowsFromResult, RowsFromResultData> {
    private static final Class<?> PKG = RowsFromResult.class;
    private String[] fieldname;
    private int[] type;
    private int[] length;
    private int[] precision;

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public String[] getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String[] name) {
        this.fieldname = name;
    }

    public int[] getPrecision() {
        return this.precision;
    }

    public void setPrecision(int[] precision) {
        this.precision = precision;
    }

    public int[] getType() {
        return this.type;
    }

    public void setType(int[] type) {
        this.type = type;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        RowsFromResultMeta retval = (RowsFromResultMeta)((Object)super.clone());
        int nrFields = this.fieldname.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldname, 0, retval.fieldname, 0, nrFields);
        System.arraycopy(this.type, 0, retval.type, 0, nrFields);
        System.arraycopy(this.length, 0, retval.length, 0, nrFields);
        System.arraycopy(this.precision, 0, retval.precision, 0, nrFields);
        return retval;
    }

    public ITransform createTransform(TransformMeta transformMeta, RowsFromResultData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new RowsFromResult(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public void allocate(int nrFields) {
        this.fieldname = new String[nrFields];
        this.type = new int[nrFields];
        this.length = new int[nrFields];
        this.precision = new int[nrFields];
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>");
        for (int i = 0; i < this.fieldname.length; ++i) {
            retval.append("      <field>");
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.fieldname[i]));
            retval.append("        " + XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.type[i])));
            retval.append("        " + XmlHandler.addTagValue((String)"length", (int)this.length[i]));
            retval.append("        " + XmlHandler.addTagValue((String)"precision", (int)this.precision[i]));
            retval.append("        </field>");
        }
        retval.append("      </fields>");
        return retval.toString();
    }

    private void readData(Node transformNode) {
        Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
        int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            Node line = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            this.fieldname[i] = XmlHandler.getTagValue((Node)line, (String)"name");
            this.type[i] = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)line, (String)"type"));
            this.length[i] = Const.toInt((String)XmlHandler.getTagValue((Node)line, (String)"length"), (int)-2);
            this.precision[i] = Const.toInt((String)XmlHandler.getTagValue((Node)line, (String)"precision"), (int)-2);
        }
    }

    public void setDefault() {
        this.allocate(0);
    }

    public void getFields(IRowMeta r, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fieldname.length; ++i) {
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)this.fieldname[i], (int)this.type[i], (int)this.length[i], (int)this.precision[i]);
                v.setOrigin(origin);
                r.addValueMeta(v);
                continue;
            }
            catch (HopPluginException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RowsFromResultMeta.CheckResult.TransformExpectingNoReadingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowsFromResultMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public RowsFromResultData getTransformData() {
        return new RowsFromResultData();
    }
}

