/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.insertupdate;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProvidesModelerMeta;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.utils.RowMetaUtils;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdate;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="InsertUpdateMeta.Injection.", groups={"KEYS", "UPDATES"})
@Transform(id="InsertUpdate", image="insertupdate.svg", name="i18n::BaseTransform.TypeLongDesc.InsertUpdate", description="i18n::BaseTransform.TypeTooltipDesc.InsertUpdate", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/insertupdate.html")
public class InsertUpdateMeta
extends BaseTransformMeta
implements ITransformMeta<InsertUpdate, InsertUpdateData>,
IProvidesModelerMeta {
    private static final Class<?> PKG = InsertUpdateMeta.class;
    private IHopMetadataProvider metadataProvider;
    @Injection(name="SCHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tableName;
    private DatabaseMeta databaseMeta;
    @Injection(name="KEY_STREAM", group="KEYS")
    private String[] keyStream;
    @Injection(name="KEY_LOOKUP", group="KEYS")
    private String[] keyLookup;
    @Injection(name="KEY_CONDITION", group="KEYS")
    private String[] keyCondition;
    @Injection(name="KEY_STREAM2", group="KEYS")
    private String[] keyStream2;
    @Injection(name="UPDATE_LOOKUP", group="UPDATES")
    private String[] updateLookup;
    @Injection(name="UPDATE_STREAM", group="UPDATES")
    private String[] updateStream;
    @Injection(name="UPDATE_FLAG", group="UPDATES")
    private Boolean[] update;
    @Injection(name="COMMIT_SIZE")
    private String commitSize;
    @Injection(name="DO_NOT")
    private boolean updateBypassed;

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        try {
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.metadataProvider, (String)connectionName);
        }
        catch (HopXmlException e) {
            throw new RuntimeException("Unable to load connection '" + connectionName + "'", e);
        }
    }

    public String getCommitSizeVar() {
        return this.commitSize;
    }

    public int getCommitSize(IVariables vs) {
        this.commitSize = this.commitSize == null ? "0" : this.commitSize;
        return Integer.parseInt(vs.resolve(this.commitSize));
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public Boolean[] getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean[] update) {
        this.update = update;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
        this.update = new Boolean[nrvalues];
    }

    public Object clone() {
        InsertUpdateMeta retval = (InsertUpdateMeta)((Object)super.clone());
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        System.arraycopy(this.keyStream, 0, retval.keyStream, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        System.arraycopy(this.keyCondition, 0, retval.keyCondition, 0, nrkeys);
        System.arraycopy(this.keyStream2, 0, retval.keyStream2, 0, nrkeys);
        System.arraycopy(this.updateLookup, 0, retval.updateLookup, 0, nrvalues);
        System.arraycopy(this.updateStream, 0, retval.updateStream, 0, nrvalues);
        System.arraycopy(this.update, 0, retval.update, 0, nrvalues);
        return retval;
    }

    public InsertUpdate createTransform(TransformMeta transformMeta, InsertUpdateData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new InsertUpdate(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.metadataProvider = metadataProvider;
        try {
            int i;
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            String csize = XmlHandler.getTagValue((Node)transformNode, (String)"commit");
            this.commitSize = csize != null ? csize : "0";
            this.schemaName = XmlHandler.getTagValue((Node)transformNode, (String)"lookup", (String)"schema");
            this.tableName = XmlHandler.getTagValue((Node)transformNode, (String)"lookup", (String)"table");
            this.updateBypassed = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"update_bypassed"));
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"lookup");
            int nrkeys = XmlHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XmlHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XmlHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XmlHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XmlHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XmlHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                String updateValue;
                Node vnode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.updateLookup[i] = XmlHandler.getTagValue((Node)vnode, (String)"name");
                this.updateStream[i] = XmlHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.update[i] = (updateValue = XmlHandler.getTagValue((Node)vnode, (String)"update")) == null ? Boolean.TRUE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.UnableToReadTransformInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        int i;
        this.keyStream = null;
        this.updateLookup = null;
        this.databaseMeta = null;
        this.commitSize = "100";
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.DefaultTableName", (String[])new String[0]);
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ColumnName.ReturnField", (String[])new String[0]) + i;
            this.updateStream[i] = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ColumnName.NewName", (String[])new String[0]) + i;
            this.update[i] = Boolean.TRUE;
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(400);
        retval.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"commit", (String)this.commitSize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"update_bypassed", (boolean)this.updateBypassed));
        retval.append("    <lookup>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"table", (String)this.tableName));
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"field", (String)this.keyLookup[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"name2", (String)this.keyStream2[i]));
            retval.append("      </key>").append(Const.CR);
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <value>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"rename", (String)this.updateStream[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"update", (boolean)this.update[i]));
            retval.append("      </value>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        return retval.toString();
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            try {
                boolean errorFound;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    IRowMeta r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                    if (r != null) {
                        IValueMeta v;
                        String lufield;
                        int i;
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllLookupFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        for (i = 0; i < this.updateLookup.length; ++i) {
                            lufield = this.updateLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsToUpdateInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    int i;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (i = 0; i < this.keyStream.length; ++i) {
                        IValueMeta v = prev.searchValueMeta(this.keyStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = errorMessage + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    for (i = 0; i < this.keyStream2.length; ++i) {
                        IValueMeta v;
                        if (this.keyStream2[i] == null || this.keyStream2[i].length() <= 0 || (v = prev.searchValueMeta(this.keyStream2[i])) != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = errorMessage + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    for (i = 0; i < this.updateStream.length; ++i) {
                        String lufield = this.updateStream[i];
                        IValueMeta v = prev.searchValueMeta(lufield);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingInputStreamFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsFoundInInput2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement retval;
        block13: {
            retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    IRowMeta tableFields = RowMetaUtils.getRowMetaForUpdate((IRowMeta)prev, (String[])this.keyLookup, (String[])this.keyStream, (String[])this.updateLookup, (String[])this.updateStream);
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, variables, this.databaseMeta);
                        try {
                            String sql;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                            String crTable = db.getDDL(schemaTable, tableFields, null, false, null, true);
                            String crIndex = "";
                            String[] idxFields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idxFields = new String[this.keyLookup.length];
                                for (int i = 0; i < this.keyLookup.length; ++i) {
                                    idxFields[i] = this.keyLookup[i];
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingKeyFields", (String[])new String[0]));
                            }
                            if (idxFields != null && idxFields.length > 0 && !db.checkIndexExists(this.schemaName, this.tableName, idxFields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                crIndex = db.getCreateIndexStatement(schemaTable, indexname, idxFields, false, false, false, true);
                            }
                            if ((sql = crTable + crIndex).length() == 0) {
                                retval.setSql(null);
                                break block13;
                            }
                            retval.setSql(sql);
                        }
                        catch (HopException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (prev != null) {
            DatabaseImpact ii;
            IValueMeta v;
            int i;
            for (i = 0; i < this.keyLookup.length; ++i) {
                v = prev.searchValueMeta(this.keyStream[i]);
                ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                v = prev.searchValueMeta(this.updateStream[i]);
                ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.updateLookup[i], this.updateStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    public InsertUpdateData getTransformData() {
        return new InsertUpdateData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isUpdateBypassed() {
        return this.updateBypassed;
    }

    public void setUpdateBypassed(boolean updateBypassed) {
        this.updateBypassed = updateBypassed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realSchemaName = variables.resolve(this.schemaName);
        String realTableName = variables.resolve(this.tableName);
        if (this.databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.TableNotSpecified", (String[])new String[0]));
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFieldsMeta(realSchemaName, realTableName);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public RowMeta getRowMeta(IVariables variables, ITransformData transformData) {
        return (RowMeta)((InsertUpdateData)transformData).insertRowMeta;
    }

    public List<String> getDatabaseFields() {
        return Arrays.asList(this.updateLookup);
    }

    public List<String> getStreamFields() {
        return Arrays.asList(this.updateStream);
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        if (this.keyStream == null || this.keyStream.length == 0) {
            return;
        }
        int nrFields = this.keyStream.length;
        if (this.keyStream2.length < nrFields) {
            String[] newKeyStream2 = new String[nrFields];
            System.arraycopy(this.keyStream2, 0, newKeyStream2, 0, this.keyStream2.length);
            this.keyStream2 = newKeyStream2;
        }
    }
}

