/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.insertupdate;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateData;
import org.apache.hop.pipeline.transforms.insertupdate.InsertUpdateMeta;

public class InsertUpdate
extends BaseTransform<InsertUpdateMeta, InsertUpdateData>
implements ITransform<InsertUpdateMeta, InsertUpdateData> {
    private static final Class<?> PKG = InsertUpdateMeta.class;

    public InsertUpdate(TransformMeta transformMeta, InsertUpdateMeta meta, InsertUpdateData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    protected synchronized void lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] lookupRow = new Object[((InsertUpdateData)this.data).lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < ((InsertUpdateData)this.data).keynrs.length; ++i) {
            if (((InsertUpdateData)this.data).keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[((InsertUpdateData)this.data).keynrs[i]];
                ++lookupIndex;
            }
            if (((InsertUpdateData)this.data).keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[((InsertUpdateData)this.data).keynrs2[i]];
            ++lookupIndex;
        }
        ((InsertUpdateData)this.data).db.setValues(((InsertUpdateData)this.data).lookupParameterRowMeta, lookupRow, ((InsertUpdateData)this.data).prepStatementLookup);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.ValuesSetForLookup", (String[])new String[0]) + ((InsertUpdateData)this.data).lookupParameterRowMeta.getString(lookupRow));
        }
        Object[] add = ((InsertUpdateData)this.data).db.getLookup(((InsertUpdateData)this.data).prepStatementLookup);
        this.incrementLinesInput();
        if (add == null) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.InsertRow", (String[])new String[0]) + rowMeta.getString(row));
            }
            Object[] insertRow = new Object[((InsertUpdateData)this.data).valuenrs.length];
            for (int i = 0; i < ((InsertUpdateData)this.data).valuenrs.length; ++i) {
                insertRow[i] = row[((InsertUpdateData)this.data).valuenrs[i]];
            }
            ((InsertUpdateData)this.data).db.setValuesInsert(((InsertUpdateData)this.data).insertRowMeta, insertRow);
            ((InsertUpdateData)this.data).db.insertRow();
            this.incrementLinesOutput();
        } else if (!((InsertUpdateMeta)this.meta).isUpdateBypassed()) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.FoundRowForUpdate", (String[])new String[0]) + rowMeta.getString(row));
            }
            boolean update = false;
            for (int i = 0; i < ((InsertUpdateData)this.data).valuenrs.length; ++i) {
                Object rowvalue;
                Object retvalue;
                if (!((InsertUpdateMeta)this.meta).getUpdate()[i].booleanValue()) continue;
                IValueMeta valueMeta = rowMeta.getValueMeta(((InsertUpdateData)this.data).valuenrs[i]);
                IValueMeta retMeta = ((InsertUpdateData)this.data).db.getReturnRowMeta().getValueMeta(i);
                if (retMeta.compare(retvalue = add[i], valueMeta, rowvalue = row[((InsertUpdateData)this.data).valuenrs[i]]) == 0) continue;
                update = true;
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[((InsertUpdateData)this.data).updateParameterRowMeta.size()];
                int j = 0;
                for (i = 0; i < ((InsertUpdateData)this.data).valuenrs.length; ++i) {
                    if (!((InsertUpdateMeta)this.meta).getUpdate()[i].booleanValue()) continue;
                    updateRow[j] = row[((InsertUpdateData)this.data).valuenrs[i]];
                    ++j;
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[j + i] = lookupRow[i];
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.UpdateRow", (String[])new String[0]) + ((InsertUpdateData)this.data).lookupParameterRowMeta.getString(lookupRow));
                }
                ((InsertUpdateData)this.data).db.setValues(((InsertUpdateData)this.data).updateParameterRowMeta, updateRow, ((InsertUpdateData)this.data).prepStatementUpdate);
                ((InsertUpdateData)this.data).db.insertRow(((InsertUpdateData)this.data).prepStatementUpdate);
                this.incrementLinesUpdated();
            } else {
                this.incrementLinesSkipped();
            }
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.UpdateBypassed", (String[])new String[0]) + rowMeta.getString(row));
            }
            this.incrementLinesSkipped();
        }
    }

    public boolean processRow() throws HopException {
        block17: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                ((InsertUpdateData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((InsertUpdateMeta)this.meta).getFields(((InsertUpdateData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((InsertUpdateData)this.data).schemaTable = ((InsertUpdateMeta)this.meta).getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, ((InsertUpdateMeta)this.meta).getSchemaName(), ((InsertUpdateMeta)this.meta).getTableName());
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                ArrayList<Integer> keynrs = new ArrayList<Integer>(((InsertUpdateMeta)this.meta).getKeyStream().length);
                ArrayList<Integer> keynrs2 = new ArrayList<Integer>(((InsertUpdateMeta)this.meta).getKeyStream().length);
                for (i = 0; i < ((InsertUpdateMeta)this.meta).getKeyStream().length; ++i) {
                    int keynr2;
                    int keynr = this.getInputRowMeta().indexOfValue(((InsertUpdateMeta)this.meta).getKeyStream()[i]);
                    if (keynr < 0 && !"IS NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"InsertUpdate.Exception.FieldRequired", (String[])new String[]{((InsertUpdateMeta)this.meta).getKeyStream()[i]}));
                    }
                    keynrs.add(keynr);
                    if ("= ~NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                        keynrs.add(keynr);
                        keynrs2.add(-1);
                    }
                    if ((keynr2 = this.getInputRowMeta().indexOfValue(((InsertUpdateMeta)this.meta).getKeyStream2()[i])) < 0 && "BETWEEN".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"InsertUpdate.Exception.FieldRequired", (String[])new String[]{((InsertUpdateMeta)this.meta).getKeyStream2()[i]}));
                    }
                    keynrs2.add(keynr2);
                    if (!this.log.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.FieldHasDataNumbers", (String[])new String[]{((InsertUpdateMeta)this.meta).getKeyStream()[i]}) + "" + keynrs.get(keynrs.size() - 1));
                }
                ((InsertUpdateData)this.data).keynrs = ArrayUtils.toPrimitive((Integer[])keynrs.toArray(new Integer[0]));
                ((InsertUpdateData)this.data).keynrs2 = ArrayUtils.toPrimitive((Integer[])keynrs2.toArray(new Integer[0]));
                ((InsertUpdateData)this.data).valuenrs = new int[((InsertUpdateMeta)this.meta).getUpdateLookup().length];
                for (i = 0; i < ((InsertUpdateMeta)this.meta).getUpdateLookup().length; ++i) {
                    ((InsertUpdateData)this.data).valuenrs[i] = this.getInputRowMeta().indexOfValue(((InsertUpdateMeta)this.meta).getUpdateStream()[i]);
                    if (((InsertUpdateData)this.data).valuenrs[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"InsertUpdate.Exception.FieldRequired", (String[])new String[]{((InsertUpdateMeta)this.meta).getUpdateStream()[i]}));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.FieldHasDataNumbers", (String[])new String[]{((InsertUpdateMeta)this.meta).getUpdateStream()[i]}) + ((InsertUpdateData)this.data).valuenrs[i]);
                }
                this.setLookup(this.getInputRowMeta());
                ((InsertUpdateData)this.data).insertRowMeta = new RowMeta();
                for (i = 0; i < ((InsertUpdateMeta)this.meta).getUpdateLookup().length; ++i) {
                    IValueMeta insValue = ((InsertUpdateData)this.data).insertRowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getUpdateLookup()[i]);
                    if (insValue != null) {
                        throw new HopTransformException("The same column can't be inserted into the target row twice: " + insValue.getName());
                    }
                    IValueMeta insertValue = this.getInputRowMeta().searchValueMeta(((InsertUpdateMeta)this.meta).getUpdateStream()[i]).clone();
                    insertValue.setName(((InsertUpdateMeta)this.meta).getUpdateLookup()[i]);
                    ((InsertUpdateData)this.data).insertRowMeta.addValueMeta(insertValue);
                }
                ((InsertUpdateData)this.data).db.prepareInsert(((InsertUpdateData)this.data).insertRowMeta, this.resolve(((InsertUpdateMeta)this.meta).getSchemaName()), this.resolve(((InsertUpdateMeta)this.meta).getTableName()));
                if (!((InsertUpdateMeta)this.meta).isUpdateBypassed()) {
                    ArrayList<String> updateColumns = new ArrayList<String>();
                    for (int i2 = 0; i2 < ((InsertUpdateMeta)this.meta).getUpdate().length; ++i2) {
                        if (!((InsertUpdateMeta)this.meta).getUpdate()[i2].booleanValue()) continue;
                        updateColumns.add(((InsertUpdateMeta)this.meta).getUpdateLookup()[i2]);
                    }
                    this.prepareUpdate(this.getInputRowMeta());
                }
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                this.putRow(((InsertUpdateData)this.data).outputRowMeta, r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.ErrorInTransform", (String[])new String[0]), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block17;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "ISU001");
            }
        }
        return true;
    }

    public void setLookup(IRowMeta rowMeta) throws HopDatabaseException {
        int i;
        ((InsertUpdateData)this.data).lookupParameterRowMeta = new RowMeta();
        ((InsertUpdateData)this.data).lookupReturnRowMeta = new RowMeta();
        DatabaseMeta databaseMeta = ((InsertUpdateMeta)this.meta).getDatabaseMeta();
        String sql = "SELECT ";
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + databaseMeta.quoteField(((InsertUpdateMeta)this.meta).getUpdateLookup()[i]);
            ((InsertUpdateData)this.data).lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getUpdateStream()[i]).clone());
        }
        sql = sql + " FROM " + ((InsertUpdateData)this.data).schemaTable + " WHERE ";
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + " ( ( ";
            sql = sql + databaseMeta.quoteField(((InsertUpdateMeta)this.meta).getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]));
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                sql = sql + " " + ((InsertUpdateMeta)this.meta).getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                sql = sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + " CAST(? AS VARCHAR(256)) IS NULL " : sql + " ? IS NULL ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]));
                sql = sql + " ) OR ( " + databaseMeta.quoteField(((InsertUpdateMeta)this.meta).getKeyLookup()[i]) + " = ? ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]).clone());
            } else {
                sql = sql + " " + ((InsertUpdateMeta)this.meta).getKeyCondition()[i] + " ? ";
                ((InsertUpdateData)this.data).lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]));
            }
            sql = sql + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting preparedStatement to [" + sql + "]");
            }
            ((InsertUpdateData)this.data).prepStatementLookup = ((InsertUpdateData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(IRowMeta rowMeta) throws HopDatabaseException {
        int i;
        DatabaseMeta databaseMeta = ((InsertUpdateMeta)this.meta).getDatabaseMeta();
        ((InsertUpdateData)this.data).updateParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + ((InsertUpdateData)this.data).schemaTable + Const.CR;
        sql = sql + "SET ";
        boolean comma = false;
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getUpdateLookup().length; ++i) {
            if (!((InsertUpdateMeta)this.meta).getUpdate()[i].booleanValue()) continue;
            if (comma) {
                sql = sql + ",   ";
            } else {
                comma = true;
            }
            sql = sql + databaseMeta.quoteField(((InsertUpdateMeta)this.meta).getUpdateLookup()[i]);
            sql = sql + " = ?" + Const.CR;
            ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getUpdateStream()[i]).clone());
        }
        sql = sql + "WHERE ";
        for (i = 0; i < ((InsertUpdateMeta)this.meta).getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + " ( ( ";
            sql = sql + databaseMeta.quoteField(((InsertUpdateMeta)this.meta).getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]));
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                sql = sql + " " + ((InsertUpdateMeta)this.meta).getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(((InsertUpdateMeta)this.meta).getKeyCondition()[i])) {
                sql = sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]));
                sql = sql + " ) OR ( " + databaseMeta.quoteField(((InsertUpdateMeta)this.meta).getKeyLookup()[i]) + " = ?";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]).clone());
            } else {
                sql = sql + " " + ((InsertUpdateMeta)this.meta).getKeyCondition()[i] + " ? ";
                ((InsertUpdateData)this.data).updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(((InsertUpdateMeta)this.meta).getKeyStream()[i]).clone());
            }
            sql = sql + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting update preparedStatement to [" + sql + "]");
            }
            ((InsertUpdateData)this.data).prepStatementUpdate = ((InsertUpdateData)this.data).db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new HopDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                if (((InsertUpdateMeta)this.meta).getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((InsertUpdateData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((InsertUpdateMeta)this.meta).getDatabaseMeta());
                ((InsertUpdateData)this.data).db.connect();
                ((InsertUpdateData)this.data).db.setCommit(((InsertUpdateMeta)this.meta).getCommitSize((IVariables)this));
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
            }
        }
        return false;
    }

    public void batchComplete() throws HopException {
        this.commitBatch(false);
    }

    public void dispose() {
        this.commitBatch(true);
        super.dispose();
    }

    private void commitBatch(boolean dispose) {
        if (((InsertUpdateData)this.data).db != null) {
            try {
                if (!((InsertUpdateData)this.data).db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        ((InsertUpdateData)this.data).db.commit();
                    } else {
                        ((InsertUpdateData)this.data).db.rollback();
                    }
                }
                if (dispose) {
                    ((InsertUpdateData)this.data).db.closeUpdate();
                    ((InsertUpdateData)this.data).db.closeInsert();
                }
            }
            catch (HopDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"InsertUpdate.Log.UnableToCommitConnection", (String[])new String[0]) + e.toString());
                this.setErrors(1L);
            }
            finally {
                if (dispose) {
                    ((InsertUpdateData)this.data).db.disconnect();
                }
            }
        }
    }
}

