/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic.delay;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Uninterruptibles;
import org.joda.time.Duration;

public class SyntheticDelay {
    private static final long MASK = 65535L;
    private static final long HASH = 2611923443488327891L;
    private static final long INIT_PLAINTEXT = 50000L;

    public static long delay(Duration delay, double cpuUtilizationInMixedDelay, SyntheticOptions.DelayType delayType, Random rnd) {
        switch (delayType) {
            case CPU: {
                SyntheticDelay.cpuDelay(delay.getMillis());
                return 0L;
            }
            case SLEEP: {
                Uninterruptibles.sleepUninterruptibly((long)Math.max(0L, delay.getMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
                return delay.getMillis();
            }
            case MIXED: {
                long sleepMillis = 0L;
                for (long i = 0L; i < delay.getMillis(); ++i) {
                    if (rnd.nextDouble() < cpuUtilizationInMixedDelay) {
                        SyntheticDelay.delay(new Duration(1L), 0.0, SyntheticOptions.DelayType.CPU, rnd);
                        continue;
                    }
                    sleepMillis += SyntheticDelay.delay(new Duration(1L), 0.0, SyntheticOptions.DelayType.SLEEP, rnd);
                }
                return sleepMillis;
            }
        }
        throw new IllegalArgumentException("Unknown delay type " + (Object)((Object)delayType));
    }

    private static void cpuDelay(long delayMillis) {
        long cpuMicros = delayMillis * 1000L;
        Stopwatch timer = Stopwatch.createUnstarted();
        while (timer.elapsed(TimeUnit.MICROSECONDS) < cpuMicros) {
            long t;
            timer.start();
            long p = 50000L;
            while (((t = Hashing.murmur3_128().hashLong(p).asLong()) & 0xFFFFL) != 2259L) {
                ++p;
            }
            timer.stop();
        }
    }
}

