/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.beam.sdk.io.synthetic.SyntheticOptions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.commons.math3.distribution.ConstantRealDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.joda.time.Duration;

public class SyntheticSourceOptions
extends SyntheticOptions {
    private static final long serialVersionUID = 0L;
    @JsonProperty
    public long numRecords;
    @JsonProperty
    public long splitPointFrequencyRecords = 1L;
    @JsonDeserialize(using=SyntheticOptions.SamplerDeserializer.class)
    public SyntheticOptions.Sampler bundleSizeDistribution = SyntheticSourceOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(1.0));
    @JsonProperty
    public Integer forceNumInitialBundles;
    @JsonProperty
    public ProgressShape progressShape = ProgressShape.LINEAR;
    @JsonDeserialize(using=SyntheticOptions.SamplerDeserializer.class)
    final SyntheticOptions.Sampler initializeDelayDistribution = SyntheticSourceOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(0.0));
    @JsonDeserialize(using=SyntheticOptions.SamplerDeserializer.class)
    SyntheticOptions.Sampler processingTimeDelayDistribution = SyntheticSourceOptions.fromRealDistribution((RealDistribution)new ConstantRealDistribution(0.0));
    @JsonProperty
    public Integer watermarkSearchInAdvanceCount = 100;
    @JsonProperty
    public Integer watermarkDriftMillis = 0;

    public Duration nextInitializeDelay(long seed) {
        return Duration.millis((long)((long)this.initializeDelayDistribution.sample(seed)));
    }

    public Duration nextProcessingTimeDelay(long seed) {
        return Duration.millis((long)((long)this.processingTimeDelayDistribution.sample(seed)));
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.numRecords >= 0L ? 1 : 0) != 0, (String)"numRecords should be a non-negative number, but found %s.", (long)this.numRecords);
        Preconditions.checkNotNull((Object)this.bundleSizeDistribution, (Object)"bundleSizeDistribution");
        Preconditions.checkArgument((this.forceNumInitialBundles == null || this.forceNumInitialBundles > 0 ? 1 : 0) != 0, (String)"forceNumInitialBundles, if specified, must be positive, but found %s", (Object)this.forceNumInitialBundles);
        Preconditions.checkArgument((this.splitPointFrequencyRecords >= 0L ? 1 : 0) != 0, (String)"splitPointFrequencyRecords must be non-negative, but found %s", (long)this.splitPointFrequencyRecords);
    }

    public Record genRecord(long position) {
        long hashCodeOfPosition = this.hashFunction().hashLong(position).asLong();
        return new Record(this.genKvPair(hashCodeOfPosition), this.nextDelay(hashCodeOfPosition));
    }

    public static enum ProgressShape {
        LINEAR,
        LINEAR_REGRESSING;

    }

    public static class Record {
        public final KV<byte[], byte[]> kv;
        public final Duration sleepMsec;

        Record(KV<byte[], byte[]> kv, long sleepMsec) {
            this.kv = kv;
            this.sleepMsec = new Duration(sleepMsec);
        }
    }
}

