/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.synthetic.BundleSplitter;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.io.synthetic.delay.ReaderDelay;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SyntheticBoundedSource
extends OffsetBasedSource<KV<byte[], byte[]>> {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(SyntheticBoundedSource.class);
    private final SyntheticSourceOptions sourceOptions;
    private final BundleSplitter bundleSplitter;

    public SyntheticBoundedSource(SyntheticSourceOptions sourceOptions) {
        this(0L, sourceOptions.numRecords, sourceOptions);
    }

    public SyntheticBoundedSource(long startOffset, long endOffset, SyntheticSourceOptions sourceOptions) {
        super(startOffset, endOffset, 1L);
        this.sourceOptions = sourceOptions;
        this.bundleSplitter = new BundleSplitter(this.sourceOptions);
        LOG.debug("Constructing {}", (Object)this.toString());
    }

    public Coder<KV<byte[], byte[]>> getDefaultOutputCoder() {
        return KvCoder.of((Coder)ByteArrayCoder.of(), (Coder)ByteArrayCoder.of());
    }

    public long getBytesPerOffset() {
        return this.sourceOptions.bytesPerRecord >= 0L ? this.sourceOptions.bytesPerRecord : this.sourceOptions.keySizeBytes + this.sourceOptions.valueSizeBytes;
    }

    public void validate() {
        super.validate();
        this.sourceOptions.validate();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("options", (Object)this.sourceOptions).add("offsetRange", (Object)("[" + this.getStartOffset() + ", " + this.getEndOffset() + ")")).toString();
    }

    public final SyntheticBoundedSource createSourceForSubrange(long start, long end) {
        Preconditions.checkArgument((start >= this.getStartOffset() ? 1 : 0) != 0, (Object)("Start offset value " + start + " of the subrange cannot be smaller than the start offset value " + this.getStartOffset() + " of the parent source"));
        Preconditions.checkArgument((end <= this.getEndOffset() ? 1 : 0) != 0, (Object)("End offset value " + end + " of the subrange cannot be larger than the end offset value " + this.getEndOffset() + " of the parent source"));
        return new SyntheticBoundedSource(start, end, this.sourceOptions);
    }

    public long getMaxEndOffset(PipelineOptions options) {
        return this.getEndOffset();
    }

    public SyntheticSourceReader createReader(PipelineOptions pipelineOptions) {
        return new SyntheticSourceReader(this);
    }

    public List<SyntheticBoundedSource> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        int desiredNumBundles = this.sourceOptions.forceNumInitialBundles == null ? (int)Math.ceil(1.0 * (double)this.getEstimatedSizeBytes(options) / (double)desiredBundleSizeBytes) : this.sourceOptions.forceNumInitialBundles;
        List<SyntheticBoundedSource> res = this.bundleSplitter.getBundleSizes(desiredNumBundles, this.getStartOffset(), this.getEndOffset()).stream().map(offsetRange -> this.createSourceForSubrange(offsetRange.getFrom(), offsetRange.getTo())).collect(Collectors.toList());
        LOG.info("Split into {} bundles of sizes: {}", (Object)res.size(), res);
        return res;
    }

    private static class SyntheticSourceReader
    extends OffsetBasedSource.OffsetBasedReader<KV<byte[], byte[]>> {
        private final long splitPointFrequencyRecords;
        private KV<byte[], byte[]> currentKvPair;
        private long currentOffset;
        private boolean isAtSplitPoint;
        private ReaderDelay readerDelay;

        SyntheticSourceReader(SyntheticBoundedSource source) {
            super((OffsetBasedSource)source);
            this.readerDelay = new ReaderDelay(source.sourceOptions);
            this.currentKvPair = null;
            this.splitPointFrequencyRecords = ((SyntheticBoundedSource)source).sourceOptions.splitPointFrequencyRecords;
        }

        public synchronized SyntheticBoundedSource getCurrentSource() {
            return (SyntheticBoundedSource)super.getCurrentSource();
        }

        protected long getCurrentOffset() throws IllegalStateException {
            return this.currentOffset;
        }

        public KV<byte[], byte[]> getCurrent() throws NoSuchElementException {
            if (this.currentKvPair == null) {
                throw new NoSuchElementException("The current element is unavailable because either the reader is at the beginning of the input and start() or advance() wasn't called, or the last start() or advance() returned false.");
            }
            return this.currentKvPair;
        }

        public boolean allowsDynamicSplitting() {
            return this.splitPointFrequencyRecords > 0L;
        }

        protected final boolean startImpl() throws IOException {
            this.currentOffset = this.getCurrentSource().getStartOffset();
            if (this.splitPointFrequencyRecords > 0L) {
                while (this.currentOffset % this.splitPointFrequencyRecords != 0L) {
                    ++this.currentOffset;
                }
            }
            this.readerDelay.delayStart(this.currentOffset);
            this.isAtSplitPoint = true;
            --this.currentOffset;
            return this.advanceImpl();
        }

        protected boolean advanceImpl() {
            ++this.currentOffset;
            this.isAtSplitPoint = this.shouldSourceSplit();
            SyntheticSourceOptions.Record record = this.getCurrentSource().sourceOptions.genRecord(this.currentOffset);
            this.currentKvPair = record.kv;
            this.readerDelay.delayRecord(record);
            return true;
        }

        private boolean shouldSourceSplit() {
            return this.splitPointFrequencyRecords == 0L || this.currentOffset % this.splitPointFrequencyRecords == 0L;
        }

        public Double getFractionConsumed() {
            double realFractionConsumed = super.getFractionConsumed();
            SyntheticSourceOptions.ProgressShape shape = ((SyntheticBoundedSource)this.getCurrentSource()).sourceOptions.progressShape;
            switch (shape) {
                case LINEAR: {
                    return realFractionConsumed;
                }
                case LINEAR_REGRESSING: {
                    return 0.9 - 0.8 * realFractionConsumed;
                }
            }
            throw new AssertionError((Object)("Unexpected progress shape: " + (Object)((Object)shape)));
        }

        protected boolean isAtSplitPoint() throws NoSuchElementException {
            return this.isAtSplitPoint;
        }

        public void close() {
        }
    }
}

