/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.userdefinedjavaclass;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.BlockingRowSet;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transform.errorhandling.Stream;
import org.apache.hop.pipeline.transform.errorhandling.StreamIcon;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.FieldHelper;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.InfoTransformDefinition;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.TargetTransformDefinition;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UsageParameter;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClass;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClassData;
import org.apache.hop.pipeline.transforms.userdefinedjavaclass.UserDefinedJavaClassMeta;

public abstract class TransformClassBase {
    private static final Class<?> PKG = UserDefinedJavaClassMeta.class;
    protected boolean first = true;
    protected boolean updateRowMeta = true;
    protected UserDefinedJavaClass parent;
    protected UserDefinedJavaClassMeta meta;
    protected UserDefinedJavaClassData data;
    private final Map<String, FieldHelper> inFieldHelpers = new HashMap<String, FieldHelper>();
    private final Map<String, FieldHelper> infoFieldHelpers = new HashMap<String, FieldHelper>();
    private final Map<String, FieldHelper> outFieldHelpers = new HashMap<String, FieldHelper>();

    public TransformClassBase(UserDefinedJavaClass parent, UserDefinedJavaClassMeta meta, UserDefinedJavaClassData data) throws HopTransformException {
        this.parent = parent;
        this.meta = meta;
        this.data = data;
        try {
            data.inputRowMeta = this.getPipelineMeta().getPrevTransformFields((IVariables)parent, this.getTransformMeta()).clone();
            data.outputRowMeta = this.getPipelineMeta().getThisTransformFields((IVariables)parent, this.getTransformMeta(), null, data.inputRowMeta.clone());
            data.parameterMap = new HashMap<String, String>();
            for (UsageParameter usageParameter : meta.getUsageParameters()) {
                if (usageParameter.tag == null || usageParameter.value == null) continue;
                data.parameterMap.put(usageParameter.tag, usageParameter.value);
            }
            data.infoMap = new HashMap<String, String>();
            for (InfoTransformDefinition infoTransformDefinition : meta.getInfoTransformDefinitions()) {
                if (infoTransformDefinition.tag == null || infoTransformDefinition.transformMeta == null || infoTransformDefinition.transformMeta.getName() == null) continue;
                data.infoMap.put(infoTransformDefinition.tag, infoTransformDefinition.transformMeta.getName());
            }
            data.targetMap = new HashMap<String, String>();
            for (TargetTransformDefinition targetTransformDefinition : meta.getTargetTransformDefinitions()) {
                if (targetTransformDefinition.tag == null || targetTransformDefinition.transformMeta == null || targetTransformDefinition.transformMeta.getName() == null) continue;
                data.targetMap.put(targetTransformDefinition.tag, targetTransformDefinition.transformMeta.getName());
            }
        }
        catch (HopTransformException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void addResultFile(ResultFile resultFile) {
        this.parent.addResultFileImpl(resultFile);
    }

    public void addRowListener(IRowListener rowListener) {
        this.parent.addRowListenerImpl(rowListener);
    }

    public boolean checkFeedback(long lines) {
        return this.parent.checkFeedbackImpl(lines);
    }

    public void cleanup() {
        this.parent.cleanupImpl();
    }

    public long decrementLinesRead() {
        return this.parent.decrementLinesReadImpl();
    }

    public long decrementLinesWritten() {
        return this.parent.decrementLinesWrittenImpl();
    }

    public IRowSet findInputRowSet(String sourceTransform) throws HopTransformException {
        return this.parent.findInputRowSetImpl(sourceTransform);
    }

    public IRowSet findInputRowSet(String from, int fromcopy, String to, int tocopy) {
        return this.parent.findInputRowSetImpl(from, fromcopy, to, tocopy);
    }

    public IRowSet findOutputRowSet(String targetTransform) throws HopTransformException {
        return this.parent.findOutputRowSetImpl(targetTransform);
    }

    public IRowSet findOutputRowSet(String from, int fromcopy, String to, int tocopy) {
        return this.parent.findOutputRowSetImpl(from, fromcopy, to, tocopy);
    }

    public int getCopy() {
        return this.parent.getCopyImpl();
    }

    public IRowMeta getErrorRowMeta() {
        return this.parent.getErrorRowMetaImpl();
    }

    public long getErrors() {
        return this.parent.getErrorsImpl();
    }

    public IRowMeta getInputRowMeta() {
        return this.parent.getInputRowMetaImpl();
    }

    public List<IRowSet> getInputRowSets() {
        return this.parent.getInputRowSetsImpl();
    }

    public long getLinesInput() {
        return this.parent.getLinesInputImpl();
    }

    public long getLinesOutput() {
        return this.parent.getLinesOutputImpl();
    }

    public long getLinesRead() {
        return this.parent.getLinesReadImpl();
    }

    public long getLinesRejected() {
        return this.parent.getLinesRejectedImpl();
    }

    public long getLinesSkipped() {
        return this.parent.getLinesSkippedImpl();
    }

    public long getLinesUpdated() {
        return this.parent.getLinesUpdatedImpl();
    }

    public long getLinesWritten() {
        return this.parent.getLinesWrittenImpl();
    }

    public List<IRowSet> getOutputRowSets() {
        return this.parent.getOutputRowSetsImpl();
    }

    public String getPartitionId() {
        return this.parent.getPartitionId();
    }

    public Map<String, BlockingRowSet> getPartitionTargets() {
        return this.parent.getPartitionTargetsImpl();
    }

    public long getProcessed() {
        return this.parent.getProcessedImpl();
    }

    public int getRepartitioning() {
        return this.parent.getRepartitioningImpl();
    }

    public Map<String, ResultFile> getResultFiles() {
        return this.parent.getResultFilesImpl();
    }

    public Object[] getRow() throws HopException {
        Object[] row = this.parent.getRowImpl();
        if (this.updateRowMeta) {
            IRowMeta inputRowMeta;
            this.data.inputRowMeta = inputRowMeta = this.parent.getInputRowMeta();
            this.data.outputRowMeta = inputRowMeta == null ? null : this.getPipelineMeta().getThisTransformFields((IVariables)this.parent, this.getTransformMeta(), null, inputRowMeta.clone());
            this.updateRowMeta = false;
        }
        return row;
    }

    public Object[] getRowFrom(IRowSet rowSet) throws HopTransformException {
        return this.parent.getRowFromImpl(rowSet);
    }

    public List<IRowListener> getRowListeners() {
        return this.parent.getRowListenersImpl();
    }

    public EngineComponent.ComponentExecutionStatus getStatus() {
        return this.parent.getStatusImpl();
    }

    public String getStatusDescription() {
        return this.parent.getStatusDescriptionImpl();
    }

    public String getTransformPluginId() {
        return this.parent.getTransformPluginIdImpl();
    }

    public TransformMeta getTransformMeta() {
        return this.parent.getTransformMetaImpl();
    }

    public String getTransformName() {
        return this.parent.getTransformNameImpl();
    }

    public IPipelineEngine getPipeline() {
        return this.parent.getPipelineImpl();
    }

    public PipelineMeta getPipelineMeta() {
        return this.parent.getPipelineMetaImpl();
    }

    public String getVariable(String variableName) {
        return this.parent.getVariableImpl(variableName);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.parent.getVariableImpl(variableName, defaultValue);
    }

    public long incrementLinesInput() {
        return this.parent.incrementLinesInputImpl();
    }

    public long incrementLinesOutput() {
        return this.parent.incrementLinesOutputImpl();
    }

    public long incrementLinesRead() {
        return this.parent.incrementLinesReadImpl();
    }

    public long incrementLinesRejected() {
        return this.parent.incrementLinesRejectedImpl();
    }

    public long incrementLinesSkipped() {
        return this.parent.incrementLinesSkippedImpl();
    }

    public long incrementLinesUpdated() {
        return this.parent.incrementLinesUpdatedImpl();
    }

    public long incrementLinesWritten() {
        return this.parent.incrementLinesWrittenImpl();
    }

    public boolean init(ITransform transformMetaInterface, ITransformData iTransformData) {
        return this.parent.initImpl(transformMetaInterface, this.data);
    }

    public void initBeforeStart() throws HopTransformException {
        this.parent.initBeforeStartImpl();
    }

    public boolean isDistributed() {
        return this.parent.isDistributedImpl();
    }

    public boolean isInitialising() {
        return this.parent.isInitialisingImpl();
    }

    public boolean isPartitioned() {
        return this.parent.isPartitionedImpl();
    }

    public boolean isSafeModeEnabled() {
        return this.parent.isSafeModeEnabledImpl();
    }

    public boolean isStopped() {
        return this.parent.isStoppedImpl();
    }

    public void logBasic(String s) {
        this.parent.logBasicImpl(s);
    }

    public void logDebug(String s) {
        this.parent.logDebugImpl(s);
    }

    public void logDetailed(String s) {
        this.parent.logDetailedImpl(s);
    }

    public void logError(String s) {
        this.parent.logErrorImpl(s);
    }

    public void logError(String s, Throwable e) {
        this.parent.logErrorImpl(s, e);
    }

    public void logMinimal(String s) {
        this.parent.logMinimalImpl(s);
    }

    public void logRowlevel(String s) {
        this.parent.logRowlevelImpl(s);
    }

    public void logSummary() {
        this.parent.logSummaryImpl();
    }

    public void markStart() {
        this.parent.markStartImpl();
    }

    public void markStop() {
        this.parent.markStopImpl();
    }

    public boolean outputIsDone() {
        return this.parent.outputIsDoneImpl();
    }

    public abstract boolean processRow() throws HopException;

    public void putError(IRowMeta rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws HopTransformException {
        this.parent.putErrorImpl(rowMeta, row, nrErrors, errorDescriptions, fieldNames, errorCodes);
    }

    public void putRow(IRowMeta row, Object[] data) throws HopTransformException {
        this.parent.putRowImpl(row, data);
    }

    public void putRowTo(IRowMeta rowMeta, Object[] row, IRowSet rowSet) throws HopTransformException {
        this.parent.putRowToImpl(rowMeta, row, rowSet);
    }

    public void removeRowListener(IRowListener rowListener) {
        this.parent.removeRowListenerImpl(rowListener);
    }

    public int rowsetInputSize() {
        return this.parent.rowsetInputSizeImpl();
    }

    public int rowsetOutputSize() {
        return this.parent.rowsetOutputSizeImpl();
    }

    public void safeModeChecking(IRowMeta row) throws HopRowException {
        this.parent.safeModeCheckingImpl(row);
    }

    public void setErrors(long errors) {
        this.parent.setErrorsImpl(errors);
    }

    public void setInputRowMeta(IRowMeta rowMeta) {
        this.parent.setInputRowMetaImpl(rowMeta);
    }

    public void setInputRowSets(List<IRowSet> inputRowSets) {
        this.parent.setInputRowSetsImpl(inputRowSets);
    }

    public void setLinesInput(long newLinesInputValue) {
        this.parent.setLinesInputImpl(newLinesInputValue);
    }

    public void setLinesOutput(long newLinesOutputValue) {
        this.parent.setLinesOutputImpl(newLinesOutputValue);
    }

    public void setLinesRead(long newLinesReadValue) {
        this.parent.setLinesReadImpl(newLinesReadValue);
    }

    public void setLinesRejected(long linesRejected) {
        this.parent.setLinesRejectedImpl(linesRejected);
    }

    public void setLinesSkipped(long newLinesSkippedValue) {
        this.parent.setLinesSkippedImpl(newLinesSkippedValue);
    }

    public void setLinesUpdated(long newLinesUpdatedValue) {
        this.parent.setLinesUpdatedImpl(newLinesUpdatedValue);
    }

    public void setLinesWritten(long newLinesWrittenValue) {
        this.parent.setLinesWrittenImpl(newLinesWrittenValue);
    }

    public void setOutputDone() {
        this.parent.setOutputDoneImpl();
    }

    public void setOutputRowSets(List<IRowSet> outputRowSets) {
        this.parent.setOutputRowSetsImpl(outputRowSets);
    }

    public void setVariable(String variableName, String variableValue) {
        this.parent.setVariableImpl(variableName, variableValue);
    }

    public void stopAll() {
        this.parent.stopAllImpl();
    }

    public void stopRunning(ITransform transformMetaInterface, ITransformData iTransformData) throws HopException {
        this.parent.stopRunningImpl(transformMetaInterface, this.data);
    }

    public String toString() {
        return this.parent.toStringImpl();
    }

    public static String[] getInfoTransforms() {
        return null;
    }

    public static void getFields(boolean clearResultFields, IRowMeta row, String originTransformName, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, List<?> fields) throws HopTransformException {
        if (clearResultFields) {
            row.clear();
        }
        for (UserDefinedJavaClassMeta.FieldInfo fi : fields) {
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)fi.name, (int)fi.type);
                v.setLength(fi.length);
                v.setPrecision(fi.precision);
                v.setOrigin(originTransformName);
                row.addValueMeta(v);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public static ITransformIOMeta getTransformIOMeta(UserDefinedJavaClassMeta meta) {
        TransformIOMeta ioMeta = new TransformIOMeta(true, true, true, false, true, true);
        for (InfoTransformDefinition infoTransformDefinition : meta.getInfoTransformDefinitions()) {
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, infoTransformDefinition.transformMeta, infoTransformDefinition.description, StreamIcon.INFO, null));
        }
        for (TargetTransformDefinition targetTransformDefinition : meta.getTargetTransformDefinitions()) {
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.TARGET, targetTransformDefinition.transformMeta, targetTransformDefinition.description, StreamIcon.TARGET, null));
        }
        return ioMeta;
    }

    public String getParameter(String tag) {
        if (tag == null) {
            return null;
        }
        return this.parent.resolve(this.data.parameterMap.get(tag));
    }

    public IRowSet findInfoRowSet(String tag) throws HopException {
        if (tag == null) {
            return null;
        }
        String transformName = this.data.infoMap.get(tag);
        if (Utils.isEmpty((CharSequence)transformName)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindInfoTransformNameForTag", (String[])new String[]{tag}));
        }
        IRowSet rowSet = this.findInputRowSet(transformName);
        if (rowSet == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindInfoRowSetForTransform", (String[])new String[]{transformName}));
        }
        return rowSet;
    }

    public IRowSet findTargetRowSet(String tag) throws HopException {
        if (tag == null) {
            return null;
        }
        String transformName = this.data.targetMap.get(tag);
        if (Utils.isEmpty((CharSequence)transformName)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindTargetTransformNameForTag", (String[])new String[]{tag}));
        }
        IRowSet rowSet = this.findOutputRowSet(transformName);
        if (rowSet == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindTargetRowSetForTransform", (String[])new String[]{transformName}));
        }
        return rowSet;
    }

    public FieldHelper get(Fields type, String name) throws HopTransformException {
        FieldHelper fh;
        switch (type) {
            case In: {
                fh = this.inFieldHelpers.get(name);
                if (fh != null) break;
                try {
                    fh = new FieldHelper(this.data.inputRowMeta, name);
                }
                catch (IllegalArgumentException e) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindFieldHelper", (String[])new String[]{type.name(), name}));
                }
                this.inFieldHelpers.put(name, fh);
                break;
            }
            case Out: {
                fh = this.outFieldHelpers.get(name);
                if (fh != null) break;
                try {
                    fh = new FieldHelper(this.data.outputRowMeta, name);
                }
                catch (IllegalArgumentException e) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindFieldHelper", (String[])new String[]{type.name(), name}));
                }
                this.outFieldHelpers.put(name, fh);
                break;
            }
            case Info: {
                fh = this.infoFieldHelpers.get(name);
                if (fh != null) break;
                IRowMeta rmi = this.getPipelineMeta().getPrevInfoFields((IVariables)this.parent, this.getTransformName());
                try {
                    fh = new FieldHelper(rmi, name);
                }
                catch (IllegalArgumentException e) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.UnableToFindFieldHelper", (String[])new String[]{type.name(), name}));
                }
                this.infoFieldHelpers.put(name, fh);
                break;
            }
            default: {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"TransformClassBase.Exception.InvalidFieldsType", (String[])new String[]{type.name(), name}));
            }
        }
        return fh;
    }

    public Object[] createOutputRow(Object[] inputRow, int outputRowSize) {
        if (this.meta.isClearingResultFields()) {
            return RowDataUtil.allocateRowData((int)outputRowSize);
        }
        return RowDataUtil.createResizedCopy((Object[])inputRow, (int)outputRowSize);
    }

    public UserDefinedJavaClass getParent() {
        return this.parent;
    }

    public UserDefinedJavaClassMeta getMeta() {
        return this.meta;
    }

    public UserDefinedJavaClassData getData() {
        return this.data;
    }

    public static enum Fields {
        In,
        Out,
        Info;

    }
}

