/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.janino.JaninoMeta;
import org.apache.hop.pipeline.transforms.janino.JaninoMetaFunction;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class JaninoDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = JaninoMeta.class;
    private Text wTransformName;
    private TableView wFields;
    private final JaninoMeta currentMeta;
    private final JaninoMeta originalMeta;
    private final Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;

    public JaninoDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.currentMeta = (JaninoMeta)((Object)in);
        this.originalMeta = (JaninoMeta)((Object)this.currentMeta.clone());
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.currentMeta);
        ModifyListener lsMod = e -> this.currentMeta.setChanged();
        this.changed = this.currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JaninoDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"JaninoDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.currentMeta.getFormula() != null ? this.currentMeta.getFormula().length : 1;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JaninoDialog.NewField.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JaninoDialog.Janino.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JaninoDialog.ValueType.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"JaninoDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JaninoDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JaninoDialog.Replace.Column", (String[])new String[0]), 2, new String[0])};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"JaninoDialog.Log.UnableToFindInput", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wFields.addModifyListener(arg0 -> this.shell.getDisplay().asyncExec(() -> this.setComboBoxes()));
        this.getData();
        this.currentMeta.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        this.shell.getDisplay().syncExec(() -> {
            Set keySet = fields.keySet();
            ArrayList entries = new ArrayList(keySet);
            String[] fieldNames = entries.toArray(new String[entries.size()]);
            Const.sortStrings((String[])fieldNames);
            this.colinf[5].setComboValues(fieldNames);
        });
    }

    public void getData() {
        if (this.currentMeta.getFormula() != null) {
            for (int i = 0; i < this.currentMeta.getFormula().length; ++i) {
                JaninoMetaFunction fn = this.currentMeta.getFormula()[i];
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)fn.getFieldName(), (String)""));
                item.setText(2, Const.NVL((String)fn.getFormula(), (String)""));
                item.setText(3, Const.NVL((String)ValueMetaFactory.getValueMetaName((int)fn.getValueType()), (String)""));
                if (fn.getValueLength() >= 0) {
                    item.setText(4, "" + fn.getValueLength());
                }
                if (fn.getValuePrecision() >= 0) {
                    item.setText(5, "" + fn.getValuePrecision());
                }
                item.setText(6, Const.NVL((String)fn.getReplaceField(), (String)""));
            }
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.currentMeta.allocate(this.wFields.nrNonEmpty());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String fieldName = item.getText(1);
            String formula = item.getText(2);
            int valueType = ValueMetaFactory.getIdForValueMeta((String)item.getText(3));
            int valueLength = Const.toInt((String)item.getText(4), (int)-1);
            int valuePrecision = Const.toInt((String)item.getText(5), (int)-1);
            String replaceField = item.getText(6);
            this.currentMeta.getFormula()[i] = new JaninoMetaFunction(fieldName, formula, valueType, valueLength, valuePrecision, replaceField);
        }
        if (!this.originalMeta.equals((Object)this.currentMeta)) {
            this.currentMeta.setChanged();
            this.changed = this.currentMeta.hasChanged();
        }
        this.dispose();
    }
}

