/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamschemamerge;

import java.util.List;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transform.errorhandling.Stream;
import org.apache.hop.pipeline.transform.errorhandling.StreamIcon;
import org.apache.hop.pipeline.transforms.streamschemamerge.StreamSchemaMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class StreamSchemaDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = StreamSchemaMeta.class;
    private StreamSchemaMeta meta;
    private String[] previousTransforms;
    private Label wlTransforms;
    private TableView wTransforms;
    private FormData fdlTransforms;
    private FormData fdTransforms;

    public StreamSchemaDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, transformName);
        this.meta = (StreamSchemaMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.changed = this.meta.hasChanged();
        ModifyListener lsMod = e -> this.meta.setChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StreamSchemaTransform.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"StreamSchema.getPreviousTransforms.Label", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransforms = new Label((Composite)this.shell, 0);
        this.wlTransforms.setText(BaseMessages.getString(PKG, (String)"StreamSchemaTransformDialog.Transforms.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransforms);
        this.fdlTransforms = new FormData();
        this.fdlTransforms.left = new FormAttachment(0, 0);
        this.fdlTransforms.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wlTransforms.setLayoutData((Object)this.fdlTransforms);
        boolean FieldsCols = true;
        int FieldsRows = this.meta.getNumberOfTransforms();
        this.previousTransforms = this.pipelineMeta.getPrevTransformNames(this.transformName);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"StreamSchemaTransformDialog.TransformName.Column", (String[])new String[0]), 2, this.previousTransforms, false)};
        this.wTransforms = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdTransforms = new FormData();
        this.fdTransforms.left = new FormAttachment(0, 0);
        this.fdTransforms.top = new FormAttachment((Control)this.wlTransforms, margin);
        this.fdTransforms.right = new FormAttachment(100, 0);
        this.fdTransforms.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wTransforms.setLayoutData((Object)this.fdTransforms);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wGet.addListener(13, e -> this.get());
        this.populateDialog();
        this.meta.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void populateDialog() {
        Table table = this.wTransforms.table;
        if (this.meta.getNumberOfTransforms() > 0) {
            table.removeAll();
        }
        String[] TransformNames = this.meta.getTransformsToMerge();
        for (int i = 0; i < TransformNames.length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            if (TransformNames[i] == null) continue;
            ti.setText(1, TransformNames[i]);
        }
        this.wTransforms.removeEmptyRows();
        this.wTransforms.setRowNums();
        this.wTransforms.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void get() {
        this.wTransforms.removeAll();
        Table table = this.wTransforms.table;
        for (int i = 0; i < this.previousTransforms.length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, this.previousTransforms[i]);
        }
        this.wTransforms.removeEmptyRows();
        this.wTransforms.setRowNums();
        this.wTransforms.optWidth(true);
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void getMeta(String[] inputTransforms) {
        List infoStreams = this.meta.getTransformIOMeta().getInfoStreams();
        if (infoStreams.size() == 0 || inputTransforms.length < infoStreams.size()) {
            if (inputTransforms.length != 0) {
                for (String inputTransform : inputTransforms) {
                    this.meta.getTransformIOMeta().addStream((IStream)new Stream(IStream.StreamType.INFO, null, "", StreamIcon.INFO, null));
                }
                infoStreams = this.meta.getTransformIOMeta().getInfoStreams();
            }
        } else if (infoStreams.size() < inputTransforms.length) {
            int requiredStreams = inputTransforms.length - infoStreams.size();
            for (int i = 0; i < requiredStreams; ++i) {
                this.meta.getTransformIOMeta().addStream((IStream)new Stream(IStream.StreamType.INFO, null, "", StreamIcon.INFO, null));
            }
            infoStreams = this.meta.getTransformIOMeta().getInfoStreams();
        }
        int streamCount = infoStreams.size();
        String[] transformsToMerge = this.meta.getTransformsToMerge();
        for (int i = 0; i < streamCount; ++i) {
            String transform = transformsToMerge[i];
            IStream infoStream = (IStream)infoStreams.get(i);
            infoStream.setTransformMeta(this.pipelineMeta.findTransform(transform));
            infoStream.setSubject(transform);
        }
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        int nrtransforms = this.wTransforms.nrNonEmpty();
        String[] TransformNames = new String[nrtransforms];
        for (int i = 0; i < nrtransforms; ++i) {
            TableItem ti = this.wTransforms.getNonEmpty(i);
            TransformMeta tm = this.pipelineMeta.findTransform(ti.getText(1));
            if (tm == null) continue;
            TransformNames[i] = tm.getName();
        }
        this.meta.setTransformsToMerge(TransformNames);
        this.getMeta(TransformNames);
        this.dispose();
    }
}

