/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamschemamerge;

import java.util.ArrayList;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.streamschemamerge.SchemaMapper;
import org.apache.hop.pipeline.transforms.streamschemamerge.StreamSchemaData;
import org.apache.hop.pipeline.transforms.streamschemamerge.StreamSchemaMeta;

public class StreamSchema
extends BaseTransform<StreamSchemaMeta, StreamSchemaData>
implements ITransform<StreamSchemaMeta, StreamSchemaData> {
    public StreamSchema(TransformMeta transformMeta, StreamSchemaMeta meta, StreamSchemaData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
        pipeline.setSafeModeEnabled(false);
    }

    public boolean init() {
        ((StreamSchemaData)this.data).infoStreams = ((StreamSchemaMeta)this.meta).getTransformIOMeta().getInfoStreams();
        ((StreamSchemaData)this.data).numTransforms = ((StreamSchemaData)this.data).infoStreams.size();
        ((StreamSchemaData)this.data).rowMetas = new IRowMeta[((StreamSchemaData)this.data).numTransforms];
        ((StreamSchemaData)this.data).rowSets = new ArrayList<IRowSet>();
        ((StreamSchemaData)this.data).TransformNames = new String[((StreamSchemaData)this.data).numTransforms];
        return super.init();
    }

    public boolean processRow() throws HopException {
        Object[] incomingRow;
        if (this.first) {
            this.first = false;
            for (int i = 0; i < ((StreamSchemaData)this.data).infoStreams.size(); ++i) {
                ((StreamSchemaData)this.data).r = this.findInputRowSet(((StreamSchemaData)this.data).infoStreams.get(i).getTransformName());
                ((StreamSchemaData)this.data).rowSets.add(((StreamSchemaData)this.data).r);
                ((StreamSchemaData)this.data).TransformNames[i] = ((StreamSchemaData)this.data).r.getName();
                while (((StreamSchemaData)this.data).rowMetas[i] == null && !this.isStopped()) {
                    ((StreamSchemaData)this.data).rowMetas[i] = ((StreamSchemaData)this.data).r.getRowMeta();
                }
            }
            ((StreamSchemaData)this.data).schemaMapping = new SchemaMapper(((StreamSchemaData)this.data).rowMetas);
            ((StreamSchemaData)this.data).mapping = ((StreamSchemaData)this.data).schemaMapping.getMapping();
            ((StreamSchemaData)this.data).outputRowMeta = ((StreamSchemaData)this.data).schemaMapping.getRowMeta();
            this.setInputRowSets(((StreamSchemaData)this.data).rowSets);
            if (this.isDetailed()) {
                this.logDetailed("Finished generating mapping");
            }
        }
        if ((incomingRow = this.getRow()) == null) {
            this.setOutputDone();
            return false;
        }
        ((StreamSchemaData)this.data).currentName = ((IRowSet)this.getInputRowSets().get(this.getCurrentInputRowSetNr())).getName();
        for (int i = 0; i < ((StreamSchemaData)this.data).TransformNames.length; ++i) {
            if (!((StreamSchemaData)this.data).TransformNames[i].equals(((StreamSchemaData)this.data).currentName)) continue;
            ((StreamSchemaData)this.data).streamNum = i;
            break;
        }
        if (this.isRowLevel()) {
            this.logRowlevel(String.format("Current row from %s. This maps to stream number %d", ((StreamSchemaData)this.data).currentName, ((StreamSchemaData)this.data).streamNum));
        }
        Object[] outputRow = RowDataUtil.allocateRowData((int)((StreamSchemaData)this.data).outputRowMeta.size());
        ((StreamSchemaData)this.data).rowMapping = ((StreamSchemaData)this.data).mapping[((StreamSchemaData)this.data).streamNum];
        ((StreamSchemaData)this.data).inRowMeta = ((StreamSchemaData)this.data).rowMetas[((StreamSchemaData)this.data).streamNum];
        for (int j = 0; j < ((StreamSchemaData)this.data).inRowMeta.size(); ++j) {
            int newPos = ((StreamSchemaData)this.data).rowMapping[j];
            outputRow[newPos] = incomingRow[j];
        }
        this.putRow(((StreamSchemaData)this.data).outputRowMeta, outputRow);
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    public void dispose() {
        ((StreamSchemaData)this.data).outputRowMeta = null;
        ((StreamSchemaData)this.data).inRowMeta = null;
        ((StreamSchemaData)this.data).schemaMapping = null;
        ((StreamSchemaData)this.data).infoStreams = null;
        ((StreamSchemaData)this.data).rowSets = null;
        ((StreamSchemaData)this.data).rowMetas = null;
        ((StreamSchemaData)this.data).mapping = null;
        ((StreamSchemaData)this.data).currentName = null;
        ((StreamSchemaData)this.data).rowMapping = null;
        ((StreamSchemaData)this.data).TransformNames = null;
        ((StreamSchemaData)this.data).r = null;
        super.dispose();
    }
}

