/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableinput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transform.errorhandling.Stream;
import org.apache.hop.pipeline.transform.errorhandling.StreamIcon;
import org.apache.hop.pipeline.transforms.tableinput.TableInput;
import org.apache.hop.pipeline.transforms.tableinput.TableInputData;
import org.w3c.dom.Node;

@Transform(id="TableInput", image="tableinput.svg", name="i18n::TableInput.Name", description="i18n::TableInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/tableinput.html", keywords={"input, sql"})
@InjectionSupported(localizationPrefix="TableInputMeta.Injection.")
public class TableInputMeta
extends BaseTransformMeta
implements ITransformMeta<TableInput, TableInputData> {
    private static final Class<?> PKG = TableInputMeta.class;
    private IHopMetadataProvider metadataProvider;
    private DatabaseMeta databaseMeta;
    @Injection(name="SQL")
    private String sql;
    @Injection(name="LIMIT")
    private String rowLimit;
    @Injection(name="EXECUTE_FOR_EACH_ROW")
    private boolean executeEachInputRow;
    @Injection(name="REPLACE_VARIABLES")
    private boolean variableReplacementActive;

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        try {
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.metadataProvider, (String)connectionName);
        }
        catch (HopXmlException e) {
            throw new RuntimeException("Error loading conneciton '" + connectionName + "'", e);
        }
    }

    public boolean isExecuteEachInputRow() {
        return this.executeEachInputRow;
    }

    public void setExecuteEachInputRow(boolean oncePerRow) {
        this.executeEachInputRow = oncePerRow;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        TableInputMeta retval = (TableInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.metadataProvider = metadataProvider;
        try {
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)XmlHandler.getTagValue((Node)transformNode, (String)"connection"));
            this.sql = XmlHandler.getTagValue((Node)transformNode, (String)"sql");
            this.rowLimit = XmlHandler.getTagValue((Node)transformNode, (String)"limit");
            String lookupFromTransformName = XmlHandler.getTagValue((Node)transformNode, (String)"lookup");
            IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromTransformName);
            this.executeEachInputRow = "Y".equals(XmlHandler.getTagValue((Node)transformNode, (String)"execute_each_row"));
            this.variableReplacementActive = "Y".equals(XmlHandler.getTagValue((Node)transformNode, (String)"variables_active"));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "SELECT <values> FROM <table name> WHERE <conditions>";
        this.rowLimit = "0";
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.databaseMeta == null) {
            return;
        }
        boolean param = false;
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        this.databases = new Database[]{db};
        String sNewSql = this.sql;
        if (this.isVariableReplacementActive()) {
            sNewSql = db.resolve(this.sql);
            if (variables != null) {
                sNewSql = variables.resolve(sNewSql);
            }
        }
        IRowMeta add = null;
        try {
            add = db.getQueryFields(sNewSql, param);
        }
        catch (HopDatabaseException dbe) {
            throw new HopTransformException("Unable to get queryfields for SQL: " + Const.CR + sNewSql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                IValueMeta v = add.getValueMeta(i);
                v.setOrigin(origin);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                IRowMeta paramRowMeta = null;
                Object[] paramData = null;
                IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
                if (!Utils.isEmpty((CharSequence)infoStream.getTransformName())) {
                    param = true;
                    if (info.length > 0 && info[0] != null) {
                        paramRowMeta = info[0];
                        paramData = RowDataUtil.allocateRowData((int)paramRowMeta.size());
                    }
                }
                if ((add = db.getQueryFields(sNewSql, param, paramRowMeta, paramData)) == null) {
                    return;
                }
                for (int i = 0; i < add.size(); ++i) {
                    IValueMeta v = add.getValueMeta(i);
                    v.setOrigin(origin);
                }
                row.addRowMeta(add);
            }
            catch (HopException ke) {
                throw new HopTransformException("Unable to get queryfields for SQL: " + Const.CR + sNewSql, (Throwable)ke);
            }
            finally {
                db.disconnect();
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XmlHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    " + XmlHandler.addTagValue((String)"limit", (String)this.rowLimit));
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        retval.append("    " + XmlHandler.addTagValue((String)"lookup", (String)infoStream.getTransformName()));
        retval.append("    " + XmlHandler.addTagValue((String)"execute_each_row", (boolean)this.executeEachInputRow));
        retval.append("    " + XmlHandler.addTagValue((String)"variables_active", (boolean)this.variableReplacementActive));
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, "Connection exists", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, "Connection to database OK", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, "SQL statement is entered", (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                cr = new CheckResult(4, "SQL statement is missing.", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, "Please select or create a connection to use", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        if (!Utils.isEmpty((CharSequence)infoStream.getTransformName())) {
            boolean found = false;
            for (int i = 0; i < input.length; ++i) {
                if (!infoStream.getTransformName().equalsIgnoreCase(input[i])) continue;
                found = true;
            }
            if (found) {
                cr = new CheckResult(1, "Previous transform to read info from [" + infoStream.getTransformName() + "] is found.", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, "Previous transform to read info from [" + infoStream.getTransformName() + "] is not found.", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            int count = 0;
            for (int i = 0; i < this.sql.length(); ++i) {
                char c = this.sql.charAt(i);
                if (c == '\'') {
                    while ((c = this.sql.charAt(++i)) != '\'') {
                    }
                }
                if (c != '?') continue;
                ++count;
            }
            if (info != null) {
                if (count == info.size()) {
                    cr = new CheckResult(1, "This transform is expecting and receiving " + info.size() + " fields of input from the previous transform.", (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, "This transform is receiving " + info.size() + " but not the expected " + count + " fields of input from the previous transform.", (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, "Input transform name is not recognized!", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, "Transform is not expecting info from input transforms.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "No input expected, no input provided.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, TableInputData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new TableInput(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public TableInputData getTransformData() {
        return new TableInputData();
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        RowMeta out = new RowMeta();
        this.getFields((IRowMeta)out, transformMeta.getName(), new IRowMeta[]{info}, null, variables, metadataProvider);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                IValueMeta outvalue = out.getValueMeta(i);
                DatabaseImpact ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), transformMeta.getName(), this.sql, "read from one or more database tables via SQL statement");
                impact.add(ii);
            }
        }
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isVariableReplacementActive() {
        return this.variableReplacementActive;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.variableReplacementActive = variableReplacementActive;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"TableInputMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            ioMeta.addStream((IStream)stream);
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }

    public void setLookupFromTransform(TransformMeta transformMeta) {
        ((IStream)this.getTransformIOMeta().getInfoStreams().get(0)).setTransformMeta(transformMeta);
    }

    public TransformMeta getLookupFromTransform() {
        return ((IStream)this.getTransformIOMeta().getInfoStreams().get(0)).getTransformMeta();
    }
}

