/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mailinput;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.Message;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mailinput.BatchFolderIterator;
import org.apache.hop.pipeline.transforms.mailinput.MailInputData;
import org.apache.hop.pipeline.transforms.mailinput.MailInputMeta;
import org.apache.hop.pipeline.transforms.mailinput.SearchEnabledFolderIterator;
import org.apache.hop.workflow.actions.getpop.MailConnection;
import org.apache.hop.workflow.actions.getpop.MailConnectionMeta;

public class MailInput
extends BaseTransform<MailInputMeta, MailInputData>
implements ITransform<MailInputMeta, MailInputData> {
    private static final Class<?> PKG = MailInputMeta.class;
    private MessageParser instance = new MessageParser();

    public MailInput(TransformMeta transformMeta, MailInputMeta meta, MailInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] outputRowData = this.getOneRow();
        if (outputRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"MailInput.Log.OutputRow", (String[])new String[]{((MailInputData)this.data).outputRowMeta.getString(outputRowData)})});
        }
        this.putRow(((MailInputData)this.data).outputRowMeta, outputRowData);
        if (((MailInputData)this.data).rowlimit > 0 && ((MailInputData)this.data).rownr >= (long)((MailInputData)this.data).rowlimit) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public String[] getFolders(String realIMAPFolder) throws HopException {
        ((MailInputData)this.data).folderenr = 0;
        ((MailInputData)this.data).messagesCount = 0;
        ((MailInputData)this.data).rownr = 0L;
        String[] folderslist = null;
        if (((MailInputMeta)this.meta).isIncludeSubFolders()) {
            String[] folderslist0 = ((MailInputData)this.data).mailConn.returnAllFolders(realIMAPFolder);
            if (folderslist0 == null || folderslist0.length == 0) {
                String[] stringArray;
                if (((MailInputData)this.data).mailConn.getProtocol() == 2) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
                }
                folderslist = stringArray;
            } else {
                folderslist = new String[folderslist0.length + 1];
                folderslist[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
                for (int i = 0; i < folderslist0.length; ++i) {
                    folderslist[i + 1] = folderslist0[i];
                }
            }
        } else {
            String[] stringArray;
            if (((MailInputData)this.data).mailConn.getProtocol() == 2) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "";
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
            }
            folderslist = stringArray;
        }
        return folderslist;
    }

    private void applySearch(Date beginDate, Date endDate) {
        String realSearchSubject;
        String realSearchReceipient;
        String realSearchSender = this.resolve(((MailInputMeta)this.meta).getSenderSearchTerm());
        if (!Utils.isEmpty((CharSequence)realSearchSender)) {
            ((MailInputData)this.data).mailConn.setSenderTerm(realSearchSender, ((MailInputMeta)this.meta).isNotTermSenderSearch());
        }
        if (!Utils.isEmpty((CharSequence)(realSearchReceipient = this.resolve(((MailInputMeta)this.meta).getRecipientSearch())))) {
            ((MailInputData)this.data).mailConn.setReceipientTerm(realSearchReceipient);
        }
        if (!Utils.isEmpty((CharSequence)(realSearchSubject = this.resolve(((MailInputMeta)this.meta).getSubjectSearch())))) {
            ((MailInputData)this.data).mailConn.setSubjectTerm(realSearchSubject, ((MailInputMeta)this.meta).isNotTermSubjectSearch());
        }
        switch (((MailInputMeta)this.meta).getConditionOnReceivedDate()) {
            case 1: {
                ((MailInputData)this.data).mailConn.setReceivedDateTermEQ(beginDate);
                break;
            }
            case 3: {
                ((MailInputData)this.data).mailConn.setReceivedDateTermGT(beginDate);
                break;
            }
            case 2: {
                ((MailInputData)this.data).mailConn.setReceivedDateTermLT(beginDate);
                break;
            }
            case 4: {
                ((MailInputData)this.data).mailConn.setReceivedDateTermBetween(beginDate, endDate);
                break;
            }
        }
        if (!((MailInputData)this.data).usePOP) {
            switch (((MailInputMeta)this.meta).getValueImapList()) {
                case 1: {
                    ((MailInputData)this.data).mailConn.setFlagTermNew();
                    break;
                }
                case 2: {
                    ((MailInputData)this.data).mailConn.setFlagTermOld();
                    break;
                }
                case 3: {
                    ((MailInputData)this.data).mailConn.setFlagTermRead();
                    break;
                }
                case 4: {
                    ((MailInputData)this.data).mailConn.setFlagTermUnread();
                    break;
                }
                case 5: {
                    ((MailInputData)this.data).mailConn.setFlagTermFlagged();
                    break;
                }
                case 6: {
                    ((MailInputData)this.data).mailConn.setFlagTermNotFlagged();
                    break;
                }
                case 7: {
                    ((MailInputData)this.data).mailConn.setFlagTermDraft();
                    break;
                }
                case 8: {
                    ((MailInputData)this.data).mailConn.setFlagTermNotDraft();
                    break;
                }
            }
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)((MailInputData)this.data).outputRowMeta.size());
        return rowData;
    }

    private boolean isFolderExausted() {
        return ((MailInputData)this.data).folder == null || !((MailInputData)this.data).folderIterator.hasNext();
    }

    private Object[] getOneRow() throws HopException {
        while (this.isFolderExausted()) {
            if (this.openNextFolder()) continue;
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (((MailInputMeta)this.meta).isDynamicFolder()) {
            System.arraycopy(((MailInputData)this.data).readrow, 0, r, 0, ((MailInputData)this.data).readrow.length);
        }
        try {
            Message message = ((MailInputData)this.data).folderIterator.next();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FetchingMessage", (Object[])new Object[]{message.getMessageNumber()}));
            }
            try {
                this.instance.parseToArray(r, message);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (((MailInputMeta)this.meta).isStopOnError()) {
                    throw new HopException(msg, (Throwable)e);
                }
                this.logError(msg, e);
            }
            this.incrementLinesInput();
            ++((MailInputData)this.data).rownr;
        }
        catch (Exception e) {
            throw new HopException("Error adding values to row!", (Throwable)e);
        }
        return r;
    }

    private boolean openNextFolder() {
        try {
            if (!((MailInputMeta)this.meta).isDynamicFolder()) {
                if (((MailInputData)this.data).folderenr >= ((MailInputData)this.data).folders.length) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
            } else {
                String folderName;
                if (this.first) {
                    this.first = false;
                    ((MailInputData)this.data).readrow = this.getRow();
                    if (((MailInputData)this.data).readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    ((MailInputData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((MailInputData)this.data).outputRowMeta = ((MailInputData)this.data).inputRowMeta.clone();
                    ((MailInputMeta)this.meta).getFields(((MailInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((MailInputData)this.data).totalpreviousfields = ((MailInputData)this.data).inputRowMeta.size();
                    if (Utils.isEmpty((CharSequence)((MailInputMeta)this.meta).getFolderField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderFieldMissing", (String[])new String[0]));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    ((MailInputData)this.data).indexOfFolderField = ((MailInputData)this.data).inputRowMeta.indexOfValue(((MailInputMeta)this.meta).getFolderField());
                    if (((MailInputData)this.data).indexOfFolderField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderUnreachable", (String[])new String[]{((MailInputMeta)this.meta).getFolderField()}));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    folderName = ((MailInputData)this.data).inputRowMeta.getString(((MailInputData)this.data).readrow, ((MailInputData)this.data).indexOfFolderField);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FoldernameInStream", (String[])new String[]{((MailInputMeta)this.meta).getFolderField(), folderName}));
                    }
                    ((MailInputData)this.data).folders = this.getFolders(folderName);
                }
                if (((MailInputData)this.data).folderenr >= ((MailInputData)this.data).folders.length) {
                    ((MailInputData)this.data).readrow = this.getRow();
                    if (((MailInputData)this.data).readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    folderName = ((MailInputData)this.data).inputRowMeta.getString(((MailInputData)this.data).readrow, ((MailInputData)this.data).indexOfFolderField);
                    ((MailInputData)this.data).folders = this.getFolders(folderName);
                }
            }
            ((MailInputData)this.data).start = this.parseIntWithSubstitute(((MailInputMeta)this.meta).getStart());
            ((MailInputData)this.data).end = this.parseIntWithSubstitute(((MailInputMeta)this.meta).getEnd());
            ((MailInputData)this.data).folder = ((MailInputData)this.data).folders[((MailInputData)this.data).folderenr];
            ++((MailInputData)this.data).folderenr;
            if (!((MailInputData)this.data).usePOP && !Utils.isEmpty((CharSequence)((MailInputData)this.data).folder)) {
                ((MailInputData)this.data).mailConn.openFolder(((MailInputData)this.data).folder, false);
            } else {
                ((MailInputData)this.data).mailConn.openFolder(false);
            }
            if (((MailInputMeta)this.meta).useBatch() || !Utils.isEmpty((CharSequence)this.resolve(((MailInputMeta)this.meta).getFirstMails())) && Integer.parseInt(this.resolve(((MailInputMeta)this.meta).getFirstMails())) > 0) {
                Integer batchSize = ((MailInputMeta)this.meta).useBatch() ? ((MailInputMeta)this.meta).getBatchSize() : Integer.parseInt(this.resolve(((MailInputMeta)this.meta).getFirstMails()));
                Integer start = ((MailInputMeta)this.meta).useBatch() ? ((MailInputData)this.data).start : 1;
                Integer end = ((MailInputMeta)this.meta).useBatch() ? ((MailInputData)this.data).end : batchSize;
                ((MailInputData)this.data).folderIterator = new BatchFolderIterator(((MailInputData)this.data).mailConn.getFolder(), batchSize, start, end);
                if (((MailInputData)this.data).mailConn.getSearchTerm() != null) {
                    ((MailInputData)this.data).folderIterator = new SearchEnabledFolderIterator(((MailInputData)this.data).folderIterator, ((MailInputData)this.data).mailConn.getSearchTerm());
                }
            } else {
                ((MailInputData)this.data).mailConn.retrieveMessages();
                ((MailInputData)this.data).folderIterator = new ArrayIterator((Object)((MailInputData)this.data).mailConn.getMessages());
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.MessagesInFolder", (Object[])new Object[]{((MailInputData)this.data).folder, ((MailInputData)this.data).messagesCount}));
            }
        }
        catch (Exception e) {
            this.logError("Error opening folder " + ((MailInputData)this.data).folderenr + " " + ((MailInputData)this.data).folder + ": " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        if (!((MailInputMeta)this.meta).isDynamicFolder()) {
            try {
                ((MailInputData)this.data).outputRowMeta = new RowMeta();
                ((MailInputMeta)this.meta).getFields(((MailInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MailInput.ErrorInit", (String[])new String[]{e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
                return false;
            }
        }
        ((MailInputData)this.data).usePOP = ((MailInputMeta)this.meta).getProtocol().equals("POP3");
        String realserver = this.resolve(((MailInputMeta)this.meta).getServerName());
        if (((MailInputMeta)this.meta).getProtocol().equals(MailConnectionMeta.PROTOCOL_STRING_MBOX) && StringUtils.startsWith((String)realserver, (String)"file://")) {
            realserver = StringUtils.remove((String)realserver, (String)"file://");
        }
        String realusername = this.resolve(((MailInputMeta)this.meta).getUserName());
        String realpassword = Utils.resolvePassword((IVariables)this.variables, (String)((MailInputMeta)this.meta).getPassword());
        int realport = Const.toInt((String)this.resolve(((MailInputMeta)this.meta).getPort()), (int)-1);
        String realProxyUsername = this.resolve(((MailInputMeta)this.meta).getProxyUsername());
        if (!((MailInputMeta)this.meta).isDynamicFolder()) {
            String reallimitrow = this.resolve(((MailInputMeta)this.meta).getRowLimit());
            int limit = Const.toInt((String)reallimitrow, (int)0);
            if (limit == 0) {
                limit = this.getReadFirst(((MailInputMeta)this.meta).getProtocol());
            }
            ((MailInputData)this.data).rowlimit = limit;
        }
        Date beginDate = null;
        Date endDate = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            switch (((MailInputMeta)this.meta).getConditionOnReceivedDate()) {
                case 1: 
                case 2: 
                case 3: {
                    String realBeginDate = this.resolve(((MailInputMeta)this.meta).getReceivedDate1());
                    if (Utils.isEmpty((CharSequence)realBeginDate)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    break;
                }
                case 4: {
                    String realBeginDate = this.resolve(((MailInputMeta)this.meta).getReceivedDate1());
                    if (Utils.isEmpty((CharSequence)realBeginDate)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    String realEndDate = this.resolve(((MailInputMeta)this.meta).getReceivedDate2());
                    if (Utils.isEmpty((CharSequence)realEndDate)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    endDate = df.parse(realEndDate);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.SettingSearchTerms", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            this.stopAll();
        }
        try {
            ((MailInputData)this.data).mailConn = new MailConnection(this.log, MailConnectionMeta.getProtocolFromString((String)((MailInputMeta)this.meta).getProtocol(), (int)1), realserver, realport, realusername, realpassword, ((MailInputMeta)this.meta).isUseSSL(), ((MailInputMeta)this.meta).isUseProxy(), realProxyUsername);
            ((MailInputData)this.data).mailConn.connect();
            this.applySearch(beginDate, endDate);
            if (!((MailInputMeta)this.meta).isDynamicFolder()) {
                String realIMAPFolder = this.resolve(((MailInputMeta)this.meta).getIMAPFolder());
                ((MailInputData)this.data).folders = this.getFolders(realIMAPFolder);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.OpeningConnection", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            this.stopAll();
        }
        ((MailInputData)this.data).nrFields = ((MailInputMeta)this.meta).getInputFields() != null ? ((MailInputMeta)this.meta).getInputFields().length : 0;
        return true;
    }

    private int getReadFirst(String protocol) {
        if (protocol.equals("POP3")) {
            return Const.toInt((String)((MailInputMeta)this.meta).getFirstMails(), (int)0);
        }
        if (protocol.equals("IMAP")) {
            return Const.toInt((String)((MailInputMeta)this.meta).getFirstIMAPMails(), (int)0);
        }
        return 0;
    }

    public void dispose() {
        if (((MailInputData)this.data).mailConn != null) {
            try {
                ((MailInputData)this.data).mailConn.disconnect();
                ((MailInputData)this.data).mailConn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }

    private Integer parseIntWithSubstitute(String toParse) {
        if (!StringUtils.isEmpty((String)(toParse = this.resolve(toParse)))) {
            try {
                return Integer.parseInt(toParse);
            }
            catch (NumberFormatException e) {
                this.log.logError(e.getLocalizedMessage());
            }
        }
        return null;
    }

    class MessageParser {
        MessageParser() {
        }

        Object[] parseToArray(Object[] r, Message message) throws Exception {
            for (int i = 0; i < ((MailInputData)((MailInput)MailInput.this).data).nrFields; ++i) {
                int index = ((MailInputData)((MailInput)MailInput.this).data).totalpreviousfields + i;
                try {
                    switch (((MailInputMeta)MailInput.this.meta).getInputFields()[i].getColumn()) {
                        case 0: {
                            r[index] = (long)message.getMessageNumber();
                            break;
                        }
                        case 1: {
                            r[index] = message.getSubject();
                            break;
                        }
                        case 2: {
                            r[index] = StringUtils.join((Object[])message.getFrom(), (String)";");
                            break;
                        }
                        case 3: {
                            r[index] = StringUtils.join((Object[])message.getReplyTo(), (String)";");
                            break;
                        }
                        case 4: {
                            r[index] = StringUtils.join((Object[])message.getAllRecipients(), (String)";");
                            break;
                        }
                        case 5: {
                            r[index] = message.getDescription();
                            break;
                        }
                        case 6: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.getMessageBody(message);
                            break;
                        }
                        case 7: {
                            Date receivedDate = message.getReceivedDate();
                            r[index] = receivedDate != null ? new Date(receivedDate.getTime()) : null;
                            break;
                        }
                        case 8: {
                            Date sentDate = message.getSentDate();
                            r[index] = sentDate != null ? new Date(sentDate.getTime()) : null;
                            break;
                        }
                        case 9: {
                            r[index] = message.getContentType();
                            break;
                        }
                        case 10: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.getFolderName();
                            break;
                        }
                        case 11: {
                            r[index] = (long)message.getSize();
                            break;
                        }
                        case 15: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.isMessageDraft(message);
                            break;
                        }
                        case 14: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.isMessageFlagged(message);
                            break;
                        }
                        case 12: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.isMessageNew(message);
                            break;
                        }
                        case 13: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.isMessageRead(message);
                            break;
                        }
                        case 16: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.isMessageDeleted(message);
                            break;
                        }
                        case 17: {
                            r[index] = (long)((MailInputData)((MailInput)MailInput.this).data).mailConn.getAttachedFilesCount(message, null);
                            break;
                        }
                        case 18: {
                            String name = ((MailInputMeta)MailInput.this.meta).getInputFields()[i].getName();
                            String[] arr = new String[]{name};
                            Enumeration en = message.getMatchingHeaders(arr);
                            if (en == null) {
                                r[index] = "";
                                break;
                            }
                            ArrayList<String> headers = new ArrayList<String>();
                            while (en.hasMoreElements()) {
                                Header next = (Header)Header.class.cast(en.nextElement());
                                headers.add(next.getValue());
                            }
                            r[index] = headers.isEmpty() ? "" : StringUtils.join(headers, (String)";");
                            break;
                        }
                        case 19: {
                            r[index] = ((MailInputData)((MailInput)MailInput.this).data).mailConn.getMessageBodyContentType(message);
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    String errMsg = "Error adding value for field " + ((MailInputMeta)MailInput.this.meta).getInputFields()[i].getName();
                    throw new Exception(errMsg, e);
                }
            }
            return r;
        }
    }
}

