/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.edi2xml;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.edi2xml.Edi2Xml;
import org.apache.hop.pipeline.transforms.edi2xml.Edi2XmlData;
import org.w3c.dom.Node;

@Transform(id="TypeExitEdi2XmlTransform", image="EDI2XML.svg", name="i18n::BaseTransform.TypeLongDesc.Edi2Xml", description="i18n::BaseTransform.TypeTooltipDesc.Edi2Xml", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", documentationUrl="/pipeline/transforms/edi2xml.html")
public class Edi2XmlMeta
extends BaseTransformMeta
implements ITransformMeta<Edi2Xml, Edi2XmlData> {
    private static final Class<?> PKG = Edi2XmlMeta.class;
    private String outputField;
    private String inputField;

    public String getInputField() {
        return this.inputField;
    }

    public void setInputField(String inputField) {
        this.inputField = inputField;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public String getXml() throws HopValueException {
        StringBuilder retval = new StringBuilder();
        retval.append("   " + XmlHandler.addTagValue((String)"inputfield", (String)this.inputField));
        retval.append("   " + XmlHandler.addTagValue((String)"outputfield", (String)this.outputField));
        return retval.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.setInputField(XmlHandler.getNodeValue((Node)XmlHandler.getSubNode((Node)transformNode, (String)"inputfield")));
            this.setOutputField(XmlHandler.getNodeValue((Node)XmlHandler.getSubNode((Node)transformNode, (String)"outputfield")));
        }
        catch (Exception e) {
            throw new HopXmlException("Template Plugin Unable to read transform info from XML node", (Throwable)e);
        }
    }

    public void getFields(IRowMeta r, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaString extra = null;
        if (!Utils.isEmpty((CharSequence)this.getOutputField())) {
            extra = new ValueMetaString(variables.resolve(this.getOutputField()));
            extra.setOrigin(origin);
            r.addValueMeta((IValueMeta)extra);
        } else if (!Utils.isEmpty((CharSequence)this.getInputField())) {
            extra = r.searchValueMeta(variables.resolve(this.getInputField()));
        }
        if (extra != null) {
            extra.setStorageType(0);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving input from other transforms.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, "No input received from other transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        String realInputField = variables.resolve(this.getInputField());
        if (prev.searchValueMeta(realInputField) != null) {
            cr = new CheckResult(1, "Transform is seeing input field: " + realInputField, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            if (prev.searchValueMeta(realInputField).isString()) {
                cr = new CheckResult(1, "Field " + realInputField + " is a string type", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, "Field " + realInputField + " is not a string type!", (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, "Transform is not seeing input field: " + realInputField + "!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
        this.outputField = "edi_xml";
        this.inputField = "";
    }

    public Edi2Xml createTransform(TransformMeta transformMeta, Edi2XmlData data, int cnr, PipelineMeta pipelineMeta, Pipeline disp) {
        return new Edi2Xml(transformMeta, this, data, cnr, pipelineMeta, disp);
    }

    public Edi2XmlData getTransformData() {
        return new Edi2XmlData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

