/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filterrows;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Condition;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueMetaAndData;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transform.errorhandling.StreamIcon;
import org.apache.hop.pipeline.transforms.filterrows.FilterRows;
import org.apache.hop.pipeline.transforms.filterrows.FilterRowsData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="FilterRowsMeta.Injection.")
@Transform(id="FilterRows", image="filterrows.svg", name="i18n::BaseTransform.TypeLongDesc.FilterRows", description="i18n::BaseTransform.TypeTooltipDesc.FilterRows", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/filterrows.html")
public class FilterRowsMeta
extends BaseTransformMeta
implements ITransformMeta<FilterRows, FilterRowsData> {
    private static final Class<?> PKG = FilterRowsMeta.class;
    private Condition condition = new Condition();

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void allocate() {
        this.condition = new Condition();
    }

    public Object clone() {
        FilterRowsMeta retval = (FilterRowsMeta)((Object)super.clone());
        retval.setTrueTransformName(this.getTrueTransformName());
        retval.setFalseTransformName(this.getFalseTransformName());
        retval.condition = this.condition != null ? (Condition)this.condition.clone() : null;
        return retval;
    }

    public String getXml() throws HopException {
        StringBuilder retval = new StringBuilder(200);
        retval.append(XmlHandler.addTagValue((String)"send_true_to", (String)this.getTrueTransformName()));
        retval.append(XmlHandler.addTagValue((String)"send_false_to", (String)this.getFalseTransformName()));
        retval.append("    <compare>").append(Const.CR);
        if (this.condition != null) {
            retval.append(this.condition.getXml());
        }
        retval.append("    </compare>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.setTrueTransformName(XmlHandler.getTagValue((Node)transformNode, (String)"send_true_to"));
            this.setFalseTransformName(XmlHandler.getTagValue((Node)transformNode, (String)"send_false_to"));
            Node compare = XmlHandler.getSubNode((Node)transformNode, (String)"compare");
            Node condnode = XmlHandler.getSubNode((Node)compare, (String)"condition");
            if (condnode != null) {
                this.condition = new Condition(condnode);
            } else {
                this.condition = new Condition();
                int nrkeys = XmlHandler.countNodes((Node)compare, (String)"key");
                if (nrkeys == 1) {
                    Node knode = XmlHandler.getSubNodeByNr((Node)compare, (String)"key", (int)0);
                    String key = XmlHandler.getTagValue((Node)knode, (String)"name");
                    String value = XmlHandler.getTagValue((Node)knode, (String)"value");
                    String field = XmlHandler.getTagValue((Node)knode, (String)"field");
                    String comparator = XmlHandler.getTagValue((Node)knode, (String)"condition");
                    this.condition.setOperator(0);
                    this.condition.setLeftValuename(key);
                    this.condition.setFunction(Condition.getFunction((String)comparator));
                    this.condition.setRightValuename(field);
                    this.condition.setRightExact(new ValueMetaAndData("value", (Object)value));
                } else {
                    for (int i = 0; i < nrkeys; ++i) {
                        Node knode = XmlHandler.getSubNodeByNr((Node)compare, (String)"key", (int)i);
                        String key = XmlHandler.getTagValue((Node)knode, (String)"name");
                        String value = XmlHandler.getTagValue((Node)knode, (String)"value");
                        String field = XmlHandler.getTagValue((Node)knode, (String)"field");
                        String comparator = XmlHandler.getTagValue((Node)knode, (String)"condition");
                        Condition subc = new Condition();
                        if (i > 0) {
                            subc.setOperator(1);
                        } else {
                            subc.setOperator(0);
                        }
                        subc.setLeftValuename(key);
                        subc.setFunction(Condition.getFunction((String)comparator));
                        subc.setRightValuename(field);
                        subc.setRightExact(new ValueMetaAndData("value", (Object)value));
                        this.condition.addCondition(subc);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"FilterRowsMeta.Exception..UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.allocate();
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List targetStreams = this.getTransformIOMeta().getTargetStreams();
        for (IStream stream : targetStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String[] conditionField = this.condition.getUsedFields();
        for (int i = 0; i < conditionField.length; ++i) {
            int idx = rowMeta.indexOfValue(conditionField[i]);
            if (idx < 0) continue;
            IValueMeta valueMeta = rowMeta.getValueMeta(idx);
            valueMeta.setSortedDescending(false);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        String errorMessage = "";
        this.checkTarget(transformMeta, "true", this.getTrueTransformName(), output).ifPresent(remarks::add);
        this.checkTarget(transformMeta, "false", this.getFalseTransformName(), output).ifPresent(remarks::add);
        CheckResult cr = this.condition.isEmpty() ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoConditionSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.ConditionSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TransformReceivingFields", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            List<String> orphanFields = this.getOrphanFields(this.condition, prev);
            if (orphanFields.size() > 0) {
                errorMessage = BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.FieldsNotFoundFromPreviousTransform", (String[])new String[0]) + Const.CR;
                for (String field : orphanFields) {
                    errorMessage = errorMessage + "\t\t" + field + Const.CR;
                }
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.AllFieldsFoundInInputStream", (String[])new String[0]), (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    private Optional<CheckResult> checkTarget(TransformMeta transformMeta, String target, String targetTransformName, String[] output) {
        int trueTargetIdx;
        if (targetTransformName != null && (trueTargetIdx = Const.indexOfString((String)targetTransformName, (String[])output)) < 0) {
            return Optional.of(new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TargetTransformInvalid", (String[])new String[]{target, targetTransformName}), (ICheckResultSource)transformMeta));
        }
        return Optional.empty();
    }

    public FilterRows createTransform(TransformMeta transformMeta, FilterRowsData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new FilterRows(transformMeta, this, data, cnr, tr, pipeline);
    }

    public FilterRowsData getTransformData() {
        return new FilterRowsData();
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            ioMeta.addStream((IStream)new org.apache.hop.pipeline.transform.errorhandling.Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.True.Description", (String[])new String[0]), StreamIcon.TRUE, null));
            ioMeta.addStream((IStream)new org.apache.hop.pipeline.transform.errorhandling.Stream(IStream.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.False.Description", (String[])new String[0]), StreamIcon.FALSE, null));
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }

    public void handleStreamSelection(IStream stream) {
        TransformMeta trueTransform;
        TransformMeta falseTransform;
        List targets = this.getTransformIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        if (index == 0 && (falseTransform = ((IStream)targets.get(1)).getTransformMeta()) != null && falseTransform.equals((Object)stream.getTransformMeta())) {
            ((IStream)targets.get(1)).setTransformMeta(null);
        }
        if (index == 1 && (trueTransform = ((IStream)targets.get(0)).getTransformMeta()) != null && trueTransform.equals((Object)stream.getTransformMeta())) {
            ((IStream)targets.get(0)).setTransformMeta(null);
        }
    }

    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public List<String> getOrphanFields(Condition condition, IRowMeta prev) {
        ArrayList<String> orphans = new ArrayList<String>();
        if (condition == null || prev == null) {
            return orphans;
        }
        String[] key = condition.getUsedFields();
        for (int i = 0; i < key.length; ++i) {
            IValueMeta v;
            if (Utils.isEmpty((CharSequence)key[i]) || (v = prev.searchValueMeta(key[i])) != null) continue;
            orphans.add(key[i]);
        }
        return orphans;
    }

    public String getTrueTransformName() {
        return this.getTargetTransformName(0);
    }

    @Injection(name="SEND_TRUE_TRANSFORM")
    public void setTrueTransformName(String trueTransformName) {
        ((IStream)this.getTransformIOMeta().getTargetStreams().get(0)).setSubject(trueTransformName);
    }

    public String getFalseTransformName() {
        return this.getTargetTransformName(1);
    }

    @Injection(name="SEND_FALSE_TRANSFORM")
    public void setFalseTransformName(String falseTransformName) {
        ((IStream)this.getTransformIOMeta().getTargetStreams().get(1)).setSubject(falseTransformName);
    }

    private String getTargetTransformName(int streamIndex) {
        IStream stream = (IStream)this.getTransformIOMeta().getTargetStreams().get(streamIndex);
        return Stream.of(stream.getTransformName(), stream.getSubject()).filter(Objects::nonNull).findFirst().map(Object::toString).orElse(null);
    }

    public String getConditionXml() {
        String conditionXML = null;
        try {
            conditionXML = this.condition.getXml();
        }
        catch (HopValueException e) {
            this.log.logError(e.getMessage());
        }
        return conditionXML;
    }

    @Injection(name="CONDITION")
    public void setConditionXml(String conditionXml) {
        try {
            this.condition = new Condition(conditionXml);
        }
        catch (HopXmlException e) {
            this.log.logError(e.getMessage());
        }
    }
}

