/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fake;

import com.github.javafaker.Faker;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fake.FakeData;
import org.apache.hop.pipeline.transforms.fake.FakeField;
import org.apache.hop.pipeline.transforms.fake.FakeMeta;
import org.apache.hop.pipeline.transforms.fake.FakerType;

public class Fake
extends BaseTransform<FakeMeta, FakeData>
implements ITransform<FakeMeta, FakeData> {
    private static final Class<?> PKG = FakeMeta.class;

    public Fake(TransformMeta transformMeta, FakeMeta meta, FakeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((FakeData)this.data).faker = StringUtils.isNotEmpty((String)((FakeMeta)this.meta).getLocale()) ? new Faker(new Locale(this.resolve(((FakeMeta)this.meta).getLocale()))) : new Faker();
        ((FakeData)this.data).fakerTypes = new ArrayList<Object>();
        ((FakeData)this.data).fakerMethods = new ArrayList<Method>();
        for (FakeField field : ((FakeMeta)this.meta).getFields()) {
            if (!field.isValid()) continue;
            try {
                FakerType type = FakerType.valueOf(field.getType());
                Method fakerMethod = ((FakeData)this.data).faker.getClass().getMethod(type.getFakerMethod(), new Class[0]);
                Object fakerType = fakerMethod.invoke((Object)((FakeData)this.data).faker, new Object[0]);
                ((FakeData)this.data).fakerTypes.add(fakerType);
                Method topicMethod = fakerType.getClass().getMethod(field.getTopic(), new Class[0]);
                ((FakeData)this.data).fakerMethods.add(topicMethod);
            }
            catch (Exception e) {
                this.log.logError("Error getting faker object or method for type " + field.getType() + " and topic " + field.getTopic(), (Throwable)e);
                return false;
            }
        }
        return super.init();
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((FakeData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((FakeMeta)this.meta).getFields(((FakeData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        Object[] outputRowData = RowDataUtil.resizeArray((Object[])row, (int)((FakeData)this.data).outputRowMeta.size());
        int rowIndex = this.getInputRowMeta().size();
        int index = 0;
        for (FakeField field : ((FakeMeta)this.meta).getFields()) {
            if (!field.isValid()) continue;
            Object fakerType = ((FakeData)this.data).fakerTypes.get(index);
            Method fakerMethod = ((FakeData)this.data).fakerMethods.get(index);
            ++index;
            try {
                outputRowData[rowIndex++] = fakerMethod.invoke(fakerType, new Object[0]);
            }
            catch (Exception e) {
                throw new HopException("Error getting faker value for field " + field.getName() + ", type " + field.getType() + " and topic " + field.getTopic(), (Throwable)e);
            }
        }
        this.putRow(((FakeData)this.data).outputRowMeta, outputRowData);
        return true;
    }
}

