/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.waitforsql;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="WAIT_FOR_SQL", name="i18n::ActionWaitForSQL.Name", description="i18n::ActionWaitForSQL.Description", image="WaitForSQL.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", documentationUrl="/workflow/actions/waitforsql.html")
public class ActionWaitForSql
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWaitForSql.class;
    public boolean isClearResultList = true;
    public boolean isAddRowsResult = false;
    public boolean isUseVars = false;
    public boolean isCustomSql = false;
    public String customSql = null;
    private DatabaseMeta connection = null;
    public String tableName = null;
    public String schemaName = null;
    private String maximumTimeout = DEFAULT_MAXIMUM_TIMEOUT;
    private String checkCycleTime = DEFAULT_CHECK_CYCLE_TIME;
    private boolean successOnTimeout = false;
    private static final String selectCount = "SELECT count(*) FROM ";
    public static final String[] successConditionsDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountSmallerThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountSmallerOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWaitForSQL.SuccessWhenRowCountGreaterOrEqual.Label", (String[])new String[0])};
    public static final String[] successConditionsCode = new String[]{"rows_count_equal", "rows_count_different", "rows_count_smaller", "rows_count_smaller_equal", "rows_count_greater", "rows_count_greater_equal"};
    public static final int SUCCESS_CONDITION_ROWS_COUNT_EQUAL = 0;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER = 2;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER_EQUAL = 3;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER = 4;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER_EQUAL = 5;
    public String rowsCountValue = "0";
    public int successCondition = 4;
    private static String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private static String DEFAULT_CHECK_CYCLE_TIME = "60";

    public ActionWaitForSql(String n) {
        super(n, "");
    }

    public ActionWaitForSql() {
        this("");
    }

    public Object clone() {
        ActionWaitForSql je = (ActionWaitForSql)super.clone();
        return je;
    }

    public int getSuccessCondition() {
        return this.successCondition;
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsDesc.length; ++i) {
            if (!successConditionsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionWaitForSql.getSuccessConditionByCode(tt);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"tablename", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"success_condition", (String)ActionWaitForSql.getSuccessConditionCode(this.successCondition)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"rows_count_value", (String)this.rowsCountValue));
        retval.append("      ").append(XmlHandler.addTagValue((String)"is_custom_sql", (boolean)this.isCustomSql));
        retval.append("      ").append(XmlHandler.addTagValue((String)"is_usevars", (boolean)this.isUseVars));
        retval.append("      ").append(XmlHandler.addTagValue((String)"custom_sql", (String)this.customSql));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_rows_result", (boolean)this.isAddRowsResult));
        retval.append("      ").append(XmlHandler.addTagValue((String)"maximum_timeout", (String)this.maximumTimeout));
        retval.append("      ").append(XmlHandler.addTagValue((String)"check_cycle_time", (String)this.checkCycleTime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"success_on_timeout", (boolean)this.successOnTimeout));
        retval.append("      ").append(XmlHandler.addTagValue((String)"clear_result_rows", (boolean)this.isClearResultList));
        return retval.toString();
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionsCode.length) {
            return successConditionsCode[0];
        }
        return successConditionsCode[i];
    }

    private static int getSucessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionsDesc.length) {
            return successConditionsDesc[0];
        }
        return successConditionsDesc[i];
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
            this.schemaName = XmlHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tableName = XmlHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.successCondition = ActionWaitForSql.getSucessConditionByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)""));
            this.rowsCountValue = Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"rows_count_value"), (String)"0");
            this.isCustomSql = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"is_custom_sql"));
            this.isUseVars = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"is_usevars"));
            this.customSql = XmlHandler.getTagValue((Node)entrynode, (String)"custom_sql");
            this.isAddRowsResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_rows_result"));
            this.maximumTimeout = XmlHandler.getTagValue((Node)entrynode, (String)"maximum_timeout");
            this.checkCycleTime = XmlHandler.getTagValue((Node)entrynode, (String)"check_cycle_time");
            this.successOnTimeout = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"success_on_timeout"));
            this.isClearResultList = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"clear_result_rows"));
        }
        catch (HopException e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.UnableLoadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    protected void checkConnection() throws HopDatabaseException {
        Database dbchecked = null;
        try {
            dbchecked = new Database((ILoggingObject)this, (IVariables)this, this.connection);
            dbchecked.connect();
        }
        finally {
            if (dbchecked != null) {
                dbchecked.disconnect();
            }
        }
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        String realCustomSql = null;
        String realTablename = this.resolve(this.tableName);
        String realSchemaname = this.resolve(this.schemaName);
        if (this.connection == null) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.NoDbConnection", (String[])new String[0]));
            return result;
        }
        if (this.isCustomSql) {
            if (this.isClearResultList) {
                result.getRows().clear();
            }
            realCustomSql = this.customSql;
            if (this.isUseVars) {
                realCustomSql = this.resolve(realCustomSql);
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Log.EnteredCustomSQL", (String[])new String[]{realCustomSql}));
            }
            if (Utils.isEmpty((CharSequence)realCustomSql)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Error.NoCustomSQL", (String[])new String[0]));
                return result;
            }
        } else if (Utils.isEmpty((CharSequence)realTablename)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Error.NoTableName", (String[])new String[0]));
            return result;
        }
        try {
            this.checkConnection();
            long timeStart = System.currentTimeMillis() / 1000L;
            int nrRowsLimit = Const.toInt((String)this.resolve(this.rowsCountValue), (int)0);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionWaitForSQL.Log.nrRowsLimit", (String[])new String[]{"" + nrRowsLimit}));
            }
            long iMaximumTimeout = Const.toInt((String)this.resolve(this.maximumTimeout), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
            long iCycleTime = Const.toInt((String)this.resolve(this.checkCycleTime), (int)Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)0));
            if (iMaximumTimeout < 0L) {
                iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                this.logBasic("Maximum timeout invalid, reset to " + iMaximumTimeout);
            }
            if (iCycleTime < 1L) {
                iCycleTime = Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)1);
                this.logBasic("Check cycle time invalid, reset to " + iCycleTime);
            }
            if (iMaximumTimeout == 0L) {
                this.logBasic("Waiting indefinitely for SQL data");
            } else {
                this.logBasic("Waiting " + iMaximumTimeout + " seconds for SQL data");
            }
            boolean continueLoop = true;
            while (continueLoop && !this.parentWorkflow.isStopped()) {
                if (this.sqlDataOK(result, nrRowsLimit, realSchemaname, realTablename, realCustomSql)) {
                    this.logBasic("Detected SQL data within timeout");
                    result.setResult(true);
                    continueLoop = false;
                    continue;
                }
                long now = System.currentTimeMillis() / 1000L;
                if (iMaximumTimeout > 0L && now > timeStart + iMaximumTimeout) {
                    continueLoop = false;
                    if (this.isSuccessOnTimeout()) {
                        this.logBasic("Didn't detect SQL data before timeout, success");
                        result.setResult(true);
                    } else {
                        this.logBasic("Didn't detect SQL data before timeout, failure");
                        result.setResult(false);
                    }
                }
                long sleepTime = 0L;
                sleepTime = iMaximumTimeout == 0L ? iCycleTime : (now + iCycleTime < timeStart + iMaximumTimeout ? iCycleTime : iCycleTime - (now + iCycleTime - (timeStart + iMaximumTimeout)));
                try {
                    if (sleepTime <= 0L) continue;
                    if (this.log.isDetailed()) {
                        this.logDetailed("Sleeping " + sleepTime + " seconds before next check for SQL data");
                    }
                    Thread.sleep(sleepTime * 1000L);
                }
                catch (InterruptedException e) {
                    result.setResult(false);
                    continueLoop = false;
                }
            }
        }
        catch (Exception e) {
            this.logBasic("Exception while waiting for SQL data: " + e.getMessage());
        }
        if (result.getResult()) {
            result.setNrErrors(0L);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean sqlDataOK(Result result, long nrRowsLimit, String realSchemaName, String realTableName, String customSql) throws HopException {
        block26: {
            countStatement = null;
            rowsCount = 0L;
            successOK = false;
            ar = null;
            rowMeta = null;
            db = new Database((ILoggingObject)this, (IVariables)this, this.connection);
            try {
                db.connect();
                countStatement = this.isCustomSql != false ? customSql : (Utils.isEmpty((CharSequence)realSchemaName) == false ? "SELECT count(*) FROM " + db.getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, realSchemaName, realTableName) : "SELECT count(*) FROM " + db.getDatabaseMeta().quoteField(realTableName));
                if (countStatement == null) break block26;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionWaitForSql.PKG, (String)"ActionWaitForSQL.Log.RunSQLStatement", (String[])new String[]{countStatement}));
                }
                if (this.isCustomSql) {
                    ar = db.getRows(countStatement, 0);
                    if (ar != null) {
                        rowsCount = ar.size();
                    } else if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(ActionWaitForSql.PKG, (String)"ActionWaitForSQL.Log.customSQLreturnedNothing", (String[])new String[]{countStatement}));
                    }
                } else {
                    row = db.getOneRow(countStatement);
                    if (row != null) {
                        rowsCount = row.getInteger(0);
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionWaitForSql.PKG, (String)"ActionWaitForSQL.Log.NrRowsReturned", (String[])new String[]{"" + rowsCount}));
                }
                switch (this.successCondition) {
                    case 0: {
                        successOK = rowsCount == nrRowsLimit;
                        ** break;
lbl30:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        successOK = rowsCount != nrRowsLimit;
                        ** break;
lbl34:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        successOK = rowsCount < nrRowsLimit;
                        ** break;
lbl38:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        successOK = rowsCount <= nrRowsLimit;
                        ** break;
lbl42:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        successOK = rowsCount > nrRowsLimit;
                        ** break;
lbl46:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        successOK = rowsCount >= nrRowsLimit;
                        ** break;
lbl50:
                        // 1 sources

                        break;
                    }
                    ** default:
lbl52:
                    // 1 sources

                    break;
                }
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(ActionWaitForSql.PKG, (String)"ActionWaitForSQL.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
            }
            finally {
                if (db != null) {
                    if (this.isAddRowsResult && this.isCustomSql && ar != null) {
                        rowMeta = db.getQueryFields(countStatement, false);
                    }
                    db.disconnect();
                }
            }
        }
        if (successOK && this.isAddRowsResult && this.isCustomSql && ar != null) {
            rows = new ArrayList<RowMetaAndData>();
            for (i = 0; i < ar.size(); ++i) {
                rows.add(new RowMetaAndData(rowMeta, (Object[])ar.get(i)));
            }
            if (rows != null) {
                result.getRows().addAll(rows);
            }
        }
        return successOK;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "WaitForSQL", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public boolean isClearResultList() {
        return this.isClearResultList;
    }

    public void setClearResultList(boolean isClearResultList) {
        this.isClearResultList = isClearResultList;
    }

    public boolean isAddRowsResult() {
        return this.isAddRowsResult;
    }

    public void setAddRowsResult(boolean isAddRowsResult) {
        this.isAddRowsResult = isAddRowsResult;
    }

    public boolean isUseVars() {
        return this.isUseVars;
    }

    public void setUseVars(boolean isUseVars) {
        this.isUseVars = isUseVars;
    }

    public boolean isCustomSql() {
        return this.isCustomSql;
    }

    public void setCustomSql(boolean isCustomSql) {
        this.isCustomSql = isCustomSql;
    }

    public String getCustomSql() {
        return this.customSql;
    }

    public void setCustomSql(String customSql) {
        this.customSql = customSql;
    }

    public DatabaseMeta getConnection() {
        return this.connection;
    }

    public void setConnection(DatabaseMeta connection) {
        this.connection = connection;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public void setMaximumTimeout(String maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public String getCheckCycleTime() {
        return this.checkCycleTime;
    }

    public void setCheckCycleTime(String checkCycleTime) {
        this.checkCycleTime = checkCycleTime;
    }

    public boolean isSuccessOnTimeout() {
        return this.successOnTimeout;
    }

    public void setSuccessOnTimeout(boolean successOnTimeout) {
        this.successOnTimeout = successOnTimeout;
    }

    public static String getSelectCount() {
        return selectCount;
    }

    public static String[] getSuccessConditionsDesc() {
        return successConditionsDesc;
    }

    public static String[] getSuccessConditionsCode() {
        return successConditionsCode;
    }

    public String getRowsCountValue() {
        return this.rowsCountValue;
    }

    public void setRowsCountValue(String rowsCountValue) {
        this.rowsCountValue = rowsCountValue;
    }

    public void setSuccessCondition(int successCondition) {
        this.successCondition = successCondition;
    }
}

