/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.analyticquery;

import java.util.Objects;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.transforms.analyticquery.AnalyticQuery;

public class QueryField {
    private static final Class<?> PKG = AnalyticQuery.class;
    @HopMetadataProperty(key="aggregate", injectionKey="OUTPUT.AGGREGATE_FIELD")
    private String aggregateField;
    @HopMetadataProperty(key="subject", injectionKey="OUTPUT.SUBJECT_FIELD")
    private String subjectField;
    @HopMetadataProperty(key="type", injectionKey="OUTPUT.AGGREGATE_TYPE")
    private AggregateType aggregateType;
    @HopMetadataProperty(key="valuefield", injectionKey="OUTPUT.VALUE_FIELD")
    private int valueField;

    public QueryField() {
        this.aggregateType = AggregateType.NONE;
        this.valueField = 1;
    }

    public QueryField(String aggregateField, String subjectField, AggregateType aggregateType, int valueField) {
        this.aggregateField = aggregateField;
        this.subjectField = subjectField;
        this.aggregateType = aggregateType;
        this.valueField = valueField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryField that = (QueryField)o;
        return this.valueField == that.valueField && Objects.equals(this.aggregateField, that.aggregateField) && Objects.equals(this.subjectField, that.subjectField) && this.aggregateType == that.aggregateType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregateField, this.subjectField, this.aggregateType, this.valueField});
    }

    public String getAggregateField() {
        return this.aggregateField;
    }

    public void setAggregateField(String aggregateField) {
        this.aggregateField = aggregateField;
    }

    public String getSubjectField() {
        return this.subjectField;
    }

    public void setSubjectField(String subjectField) {
        this.subjectField = subjectField;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    public int getValueField() {
        return this.valueField;
    }

    public void setValueField(int valueField) {
        this.valueField = valueField;
    }

    static /* synthetic */ Class access$000() {
        return PKG;
    }

    public static enum AggregateType {
        NONE(""),
        LEAD(BaseMessages.getString((Class)QueryField.access$000(), (String)"AnalyticQueryMeta.TypeGroupLongDesc.LEAD", (String[])new String[0])),
        LAG(BaseMessages.getString((Class)QueryField.access$000(), (String)"AnalyticQueryMeta.TypeGroupLongDesc.LAG", (String[])new String[0]));

        private String description;

        private AggregateType(String description) {
            this.description = description;
        }

        public static final String[] getDescriptions() {
            return new String[]{AggregateType.LEAD.description, AggregateType.LAG.description};
        }

        public static final AggregateType findTypeWithName(String name) {
            for (AggregateType value : AggregateType.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return NONE;
        }

        public static final AggregateType findTypeWithDescription(String description) {
            for (AggregateType value : AggregateType.values()) {
                if (!value.description.equalsIgnoreCase(description)) continue;
                return value;
            }
            return NONE;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

