/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dimensionlookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.IProvidesModelerMeta;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.injection.InjectionTypeConverter;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookup;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupData;
import org.w3c.dom.Node;

@Transform(id="DimensionLookup", image="dimensionlookup.svg", name="i18n::BaseTransform.TypeLongDesc.DimensionUpdate", description="i18n::BaseTransform.TypeTooltipDesc.DimensionUpdate", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.DataWarehouse", documentationUrl="/pipeline/transforms/dimensionlookup.html")
@InjectionSupported(localizationPrefix="DimensionLookup.Injection.", groups={"KEYS", "FIELDS"})
public class DimensionLookupMeta
extends BaseTransformMeta
implements ITransformMeta<DimensionLookup, DimensionLookupData>,
IProvidesModelerMeta {
    private static final Class<?> PKG = DimensionLookupMeta.class;
    public static final int TYPE_UPDATE_DIM_INSERT = 0;
    public static final int TYPE_UPDATE_DIM_UPDATE = 1;
    public static final int TYPE_UPDATE_DIM_PUNCHTHROUGH = 2;
    public static final int TYPE_UPDATE_DATE_INSUP = 3;
    public static final int TYPE_UPDATE_DATE_INSERTED = 4;
    public static final int TYPE_UPDATE_DATE_UPDATED = 5;
    public static final int TYPE_UPDATE_LAST_VERSION = 6;
    public static final String[] typeDesc = new String[]{BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.Insert", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.Update", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.PunchThrough", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateInsertedOrUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateInserted", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.DateUpdated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.TypeDesc.LastVersion", (String[])new String[0])};
    public static final String[] typeCodes = new String[]{"Insert", "Update", "Punch through", "DateInsertedOrUpdated", "DateInserted", "DateUpdated", "LastVersion"};
    public static final String[] typeDescLookup = ValueMetaFactory.getValueMetaNames();
    public static final int START_DATE_ALTERNATIVE_NONE = 0;
    public static final int START_DATE_ALTERNATIVE_SYSDATE = 1;
    public static final int START_DATE_ALTERNATIVE_START_OF_PIPELINE = 2;
    public static final int START_DATE_ALTERNATIVE_NULL = 3;
    public static final int START_DATE_ALTERNATIVE_COLUMN_VALUE = 4;
    private static final String[] startDateAlternativeCodes = new String[]{"none", "sysdate", "pipeline_start", "null", "column_value"};
    private static final String[] startDateAlternativeDescs = new String[]{BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.None.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.Sysdate.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.PipelineStart.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.Null.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupMeta.StartDateAlternative.ColumnValue.Label", (String[])new String[0])};
    @Injection(name="TARGET_SCHEMA")
    private String schemaName;
    @Injection(name="TARGET_TABLE")
    private String tableName;
    private IHopMetadataProvider metadataProvider;
    private DatabaseMeta databaseMeta;
    @Injection(name="UPDATE_DIMENSION")
    private boolean update;
    @Injection(name="KEY_STREAM_FIELDNAME", group="KEYS")
    private String[] keyStream;
    @Injection(name="KEY_DATABASE_FIELDNAME", group="KEYS")
    private String[] keyLookup;
    @Injection(name="STREAM_DATE_FIELD")
    private String dateField;
    @Injection(name="DATE_RANGE_START_FIELD")
    private String dateFrom;
    @Injection(name="DATE_RANGE_END_FIELD")
    private String dateTo;
    @Injection(name="STREAM_FIELDNAME", group="FIELDS")
    private String[] fieldStream;
    @Injection(name="DATABASE_FIELDNAME", group="FIELDS")
    private String[] fieldLookup;
    @Injection(name="UPDATE_TYPE", group="FIELDS", converter=UpdateTypeCodeConverter.class)
    private int[] fieldUpdate;
    @Injection(name="TYPE_OF_RETURN_FIELD", group="FIELDS", converter=ReturnTypeCodeConverter.class)
    private int[] returnType = new int[0];
    @Injection(name="TECHNICAL_KEY_FIELD")
    private String keyField;
    @Injection(name="TECHNICAL_KEY_NEW_NAME")
    private String keyRename;
    private boolean autoIncrement;
    @Injection(name="VERSION_FIELD")
    private String versionField;
    @Injection(name="TECHNICAL_KEY_SEQUENCE")
    private String sequenceName;
    @Injection(name="COMMIT_SIZE")
    private int commitSize;
    private boolean useBatchUpdate;
    @Injection(name="MIN_YEAR")
    private int minYear;
    @Injection(name="MAX_YEAR")
    private int maxYear;
    @Injection(name="TECHNICAL_KEY_CREATION")
    private String techKeyCreation = null;
    public static String CREATION_METHOD_AUTOINC = "autoinc";
    public static String CREATION_METHOD_SEQUENCE = "sequence";
    public static String CREATION_METHOD_TABLEMAX = "tablemax";
    @Injection(name="CACHE_SIZE")
    private int cacheSize;
    @Injection(name="USE_ALTERNATIVE_START_DATE")
    private boolean usingStartDateAlternative;
    @Injection(name="ALTERNATIVE_START_OPTION", converter=StartDateCodeConverter.class)
    private int startDateAlternative;
    @Injection(name="ALTERNATIVE_START_COLUMN")
    private String startDateFieldName;
    @Injection(name="PRELOAD_CACHE")
    private boolean preloadingCache;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    @Injection(name="CONNECTION_NAME")
    public void setConnection(String connectionName) {
        try {
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.metadataProvider, (String)connectionName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading relational database connection '" + connectionName + "'", e);
        }
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setTechKeyCreation(String techKeyCreation) {
        this.techKeyCreation = techKeyCreation;
    }

    public String getTechKeyCreation() {
        return this.techKeyCreation;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getDateField() {
        return this.dateField;
    }

    public void setDateField(String dateField) {
        this.dateField = dateField;
    }

    public String getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    public String getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    public String[] getFieldLookup() {
        return this.fieldLookup;
    }

    public void setFieldLookup(String[] fieldLookup) {
        this.fieldLookup = fieldLookup;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public int[] getFieldUpdate() {
        return this.fieldUpdate;
    }

    public void setFieldUpdate(int[] fieldUpdate) {
        this.fieldUpdate = fieldUpdate;
    }

    public int[] getReturnType() {
        return this.returnType;
    }

    public void setReturnType(int[] returnType) {
        this.returnType = returnType;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String getKeyRename() {
        return this.keyRename;
    }

    public void setKeyRename(String keyRename) {
        this.keyRename = keyRename;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
    }

    public int getMinYear() {
        return this.minYear;
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public String getVersionField() {
        return this.versionField;
    }

    public void setVersionField(String versionField) {
        this.versionField = versionField;
    }

    public void actualizeWithInjectedValues() {
        if (!this.update && this.returnType.length > 0) {
            this.fieldUpdate = this.returnType;
        }
        this.normalizeAllocationFields();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrkeys, int nrFields) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.fieldStream = new String[nrFields];
        this.fieldLookup = new String[nrFields];
        this.fieldUpdate = new int[nrFields];
        this.returnType = new int[nrFields];
    }

    public Object clone() {
        DimensionLookupMeta retval = (DimensionLookupMeta)((Object)super.clone());
        int nrkeys = this.keyStream.length;
        int nrFields = this.fieldStream.length;
        retval.allocate(nrkeys, nrFields);
        System.arraycopy(this.keyStream, 0, retval.keyStream, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        System.arraycopy(this.fieldStream, 0, retval.fieldStream, 0, nrFields);
        System.arraycopy(this.fieldLookup, 0, retval.fieldLookup, 0, nrFields);
        System.arraycopy(this.fieldUpdate, 0, retval.fieldUpdate, 0, nrFields);
        System.arraycopy(this.returnType, 0, retval.returnType, 0, nrFields);
        return retval;
    }

    public static final int getUpdateType(boolean upd, String ty) {
        if (upd) {
            int i;
            for (i = 0; i < typeCodes.length; ++i) {
                if (!typeCodes[i].equalsIgnoreCase(ty)) continue;
                return i;
            }
            for (i = 0; i < typeDesc.length; ++i) {
                if (!typeDesc[i].equalsIgnoreCase(ty)) continue;
                return i;
            }
            if ("Y".equalsIgnoreCase(ty)) {
                return 2;
            }
            return 0;
        }
        int retval = ValueMetaFactory.getIdForValueMeta((String)ty);
        if (retval == 0) {
            retval = 2;
        }
        return retval;
    }

    public static final String getUpdateType(boolean upd, int t) {
        if (!upd) {
            return ValueMetaFactory.getValueMetaName((int)t);
        }
        return typeDesc[t];
    }

    public static final String getUpdateTypeCode(boolean upd, int t) {
        if (!upd) {
            return ValueMetaFactory.getValueMetaName((int)t);
        }
        return typeCodes[t];
    }

    public static final int getStartDateAlternative(String string) {
        int i;
        for (i = 0; i < startDateAlternativeCodes.length; ++i) {
            if (!startDateAlternativeCodes[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        for (i = 0; i < startDateAlternativeDescs.length; ++i) {
            if (!startDateAlternativeDescs[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return 0;
    }

    public static final String getStartDateAlternativeCode(int alternative) {
        return startDateAlternativeCodes[alternative];
    }

    public static final String getStartDateAlternativeDesc(int alternative) {
        return startDateAlternativeDescs[alternative];
    }

    public static final String[] getStartDateAlternativeCodes() {
        return startDateAlternativeCodes;
    }

    public static final String[] getStartDateAlternativeDescriptions() {
        return startDateAlternativeDescs;
    }

    public static final boolean isUpdateTypeWithoutArgument(boolean update, int type) {
        if (!update) {
            return false;
        }
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void setDefault() {
        int i;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.DefualtTableName", (String[])new String[0]);
        this.databaseMeta = null;
        this.commitSize = 100;
        this.update = true;
        int nrkeys = 0;
        int nrFields = 0;
        this.allocate(nrkeys, nrFields);
        for (i = 0; i < nrkeys; ++i) {
            this.keyStream[i] = "key" + i;
            this.keyLookup[i] = "keylookup" + i;
        }
        for (i = 0; i < nrFields; ++i) {
            this.fieldStream[i] = "field" + i;
            this.fieldLookup[i] = "lookup" + i;
            this.fieldUpdate[i] = 0;
        }
        this.dateField = "";
        this.dateFrom = "date_from";
        this.dateTo = "date_to";
        this.minYear = 1900;
        this.maxYear = 2199;
        this.keyField = "";
        this.keyRename = "";
        this.autoIncrement = false;
        this.versionField = "version";
        this.cacheSize = 5000;
        this.preloadingCache = false;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        block14: {
            for (IValueMeta valueMeta : row.getValueMetaList()) {
                valueMeta.setStorageType(0);
                valueMeta.setTrimType(0);
            }
            if (Utils.isEmpty((CharSequence)this.keyField)) {
                String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Error.NoTechnicalKeySpecified", (String[])new String[0]);
                this.logError(message);
                throw new HopTransformException(message);
            }
            ValueMetaInteger v = new ValueMetaInteger(this.keyField);
            if (this.keyRename != null && this.keyRename.length() > 0) {
                v.setName(this.keyRename);
            }
            v.setLength(9);
            v.setPrecision(0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
            if (!this.update && this.fieldLookup.length > 0) {
                Database db = null;
                try {
                    if (this.databaseMeta != null) {
                        db = this.createDatabaseObject(variables);
                        IRowMeta extraFields = this.getDatabaseTableFields(db, this.schemaName, this.tableName);
                        for (int i = 0; i < this.fieldLookup.length; ++i) {
                            v = extraFields.searchValueMeta(this.fieldLookup[i]);
                            if (v == null) {
                                String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToFindReturnField", (String[])new String[]{this.fieldLookup[i]});
                                this.logError(message);
                                throw new HopTransformException(message);
                            }
                            if (this.fieldStream[i] != null && this.fieldStream[i].length() > 0) {
                                v.setName(this.fieldStream[i]);
                            }
                            v.setOrigin(name);
                            row.addValueMeta((IValueMeta)v);
                        }
                        break block14;
                    }
                    String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToRetrieveDataTypeOfReturnField", (String[])new String[0]);
                    this.logError(message);
                    throw new HopTransformException(message);
                }
                catch (Exception e) {
                    String message = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToRetrieveDataTypeOfReturnField2", (String[])new String[0]);
                    this.logError(message);
                    throw new HopTransformException(message, (Throwable)e);
                }
                finally {
                    if (db != null) {
                        db.disconnect();
                    }
                }
            }
        }
    }

    public String getXml() {
        int i;
        this.actualizeWithInjectedValues();
        StringBuilder retval = new StringBuilder(512);
        retval.append("      ").append(XmlHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("      ").append(XmlHandler.addTagValue((String)"commit", (int)this.commitSize));
        retval.append("      ").append(XmlHandler.addTagValue((String)"update", (boolean)this.update));
        retval.append("      <fields>").append(Const.CR);
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("        <key>").append(Const.CR);
            retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("          ").append(XmlHandler.addTagValue((String)"lookup", (String)this.keyLookup[i]));
            retval.append("        </key>").append(Const.CR);
        }
        retval.append("        <date>").append(Const.CR);
        retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.dateField));
        retval.append("          ").append(XmlHandler.addTagValue((String)"from", (String)this.dateFrom));
        retval.append("          ").append(XmlHandler.addTagValue((String)"to", (String)this.dateTo));
        retval.append("        </date>").append(Const.CR);
        if (this.fieldStream != null) {
            for (i = 0; i < this.fieldStream.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)Const.NVL((String)this.fieldStream[i], (String)"")));
                retval.append("          ").append(XmlHandler.addTagValue((String)"lookup", (String)Const.NVL((String)this.fieldLookup[i], (String)"")));
                retval.append("          ").append(XmlHandler.addTagValue((String)"update", (String)DimensionLookupMeta.getUpdateTypeCode(this.update, this.fieldUpdate[i])));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("        <return>").append(Const.CR);
        retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.keyField));
        retval.append("          ").append(XmlHandler.addTagValue((String)"rename", (String)this.keyRename));
        retval.append("          ").append(XmlHandler.addTagValue((String)"creation_method", (String)this.techKeyCreation));
        retval.append("          ").append(XmlHandler.addTagValue((String)"use_autoinc", (boolean)this.autoIncrement));
        retval.append("          ").append(XmlHandler.addTagValue((String)"version", (String)this.versionField));
        retval.append("        </return>").append(Const.CR);
        retval.append("      </fields>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"sequence", (String)this.sequenceName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"min_year", (int)this.minYear));
        retval.append("      ").append(XmlHandler.addTagValue((String)"max_year", (int)this.maxYear));
        retval.append("      ").append(XmlHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        retval.append("      ").append(XmlHandler.addTagValue((String)"preload_cache", (boolean)this.preloadingCache));
        retval.append("      ").append(XmlHandler.addTagValue((String)"use_start_date_alternative", (boolean)this.usingStartDateAlternative));
        retval.append("      ").append(XmlHandler.addTagValue((String)"start_date_alternative", (String)DimensionLookupMeta.getStartDateAlternativeCode(this.startDateAlternative)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"start_date_field_name", (String)this.startDateFieldName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"useBatch", (boolean)this.useBatchUpdate));
        return retval.toString();
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.metadataProvider = metadataProvider;
        try {
            this.databases = this.databases;
            this.schemaName = XmlHandler.getTagValue((Node)transformNode, (String)"schema");
            this.tableName = XmlHandler.getTagValue((Node)transformNode, (String)"table");
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            String commit = XmlHandler.getTagValue((Node)transformNode, (String)"commit");
            this.commitSize = Const.toInt((String)commit, (int)0);
            String upd = XmlHandler.getTagValue((Node)transformNode, (String)"update");
            this.update = upd.equalsIgnoreCase("Y");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrkeys = XmlHandler.countNodes((Node)fields, (String)"key");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrkeys, nrFields);
            for (int i = 0; i < nrkeys; ++i) {
                Node knode = XmlHandler.getSubNodeByNr((Node)fields, (String)"key", (int)i);
                this.keyStream[i] = XmlHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XmlHandler.getTagValue((Node)knode, (String)"lookup");
            }
            Node dnode = XmlHandler.getSubNode((Node)fields, (String)"date");
            this.dateField = XmlHandler.getTagValue((Node)dnode, (String)"name");
            this.dateFrom = XmlHandler.getTagValue((Node)dnode, (String)"from");
            this.dateTo = XmlHandler.getTagValue((Node)dnode, (String)"to");
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldStream[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldLookup[i] = XmlHandler.getTagValue((Node)fnode, (String)"lookup");
                upd = XmlHandler.getTagValue((Node)fnode, (String)"update");
                this.fieldUpdate[i] = DimensionLookupMeta.getUpdateType(this.update, upd);
            }
            if (this.update) {
                this.sequenceName = XmlHandler.getTagValue((Node)transformNode, (String)"sequence");
            }
            this.maxYear = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"max_year"), (int)2199);
            this.minYear = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"min_year"), (int)1900);
            this.keyField = XmlHandler.getTagValue((Node)fields, (String)"return", (String)"name");
            this.keyRename = XmlHandler.getTagValue((Node)fields, (String)"return", (String)"rename");
            this.autoIncrement = !"N".equalsIgnoreCase(XmlHandler.getTagValue((Node)fields, (String)"return", (String)"use_autoinc"));
            this.versionField = XmlHandler.getTagValue((Node)fields, (String)"return", (String)"version");
            this.setTechKeyCreation(XmlHandler.getTagValue((Node)fields, (String)"return", (String)"creation_method"));
            this.cacheSize = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"cache_size"), (int)-1);
            this.preloadingCache = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"preload_cache"));
            this.useBatchUpdate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useBatch"));
            this.usingStartDateAlternative = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"use_start_date_alternative"));
            this.startDateAlternative = DimensionLookupMeta.getStartDateAlternative(XmlHandler.getTagValue((Node)transformNode, (String)"start_date_alternative"));
            this.startDateFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"start_date_field_name");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public Date getMinDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.minYear);
        mincal.set(2, 0);
        mincal.set(5, 1);
        mincal.set(11, 0);
        mincal.set(12, 0);
        mincal.set(13, 0);
        mincal.set(14, 0);
        return mincal.getTime();
    }

    public Date getMaxDate() {
        Calendar mincal = Calendar.getInstance();
        mincal.set(1, this.maxYear);
        mincal.set(2, 11);
        mincal.set(5, 31);
        mincal.set(11, 23);
        mincal.set(12, 59);
        mincal.set(13, 59);
        mincal.set(14, 999);
        return mincal.getTime();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.update) {
            this.checkUpdate(variables, remarks, transformMeta, prev);
        } else {
            this.checkLookup(variables, remarks, transformMeta, prev);
        }
        if (!(this.techKeyCreation == null || CREATION_METHOD_AUTOINC.equals(this.techKeyCreation) || CREATION_METHOD_SEQUENCE.equals(this.techKeyCreation) || CREATION_METHOD_TABLEMAX.equals(this.techKeyCreation))) {
            String errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.ErrorTechKeyCreation", (String[])new String[0]) + ": " + this.techKeyCreation + "!";
            CheckResult cr2 = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr2);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TransformReceiveInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.NoInputReceiveFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    private void checkUpdate(IVariables variables, List<ICheckResult> remarks, TransformMeta transforminfo, IRowMeta prev) {
        block30: {
            String errorMessage = "";
            if (this.databaseMeta != null) {
                Database db = this.createDatabaseObject(variables);
                try {
                    CheckResult cr;
                    boolean errorFound;
                    boolean first;
                    db.connect();
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        IRowMeta r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                        if (r != null) {
                            for (int i = 0; i < this.fieldLookup.length; ++i) {
                                String lufield = this.fieldLookup[i];
                                this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.CheckLookupField", (String[])new String[0]) + i + " --> " + lufield + " in lookup table...");
                                IValueMeta v = r.searchValueMeta(lufield);
                                if (v != null) continue;
                                if (first) {
                                    first = false;
                                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                                }
                                errorFound = true;
                                errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                            }
                            cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllLookupFieldFound", (String[])new String[0]), (ICheckResultSource)transforminfo);
                            remarks.add((ICheckResult)cr);
                            if (this.keyField != null && this.keyField.length() > 0) {
                                if (r.indexOfValue(this.keyField) < 0) {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{this.keyField}) + Const.CR;
                                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                                } else {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{this.keyField}) + Const.CR;
                                    cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                                }
                                remarks.add((ICheckResult)cr);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((ICheckResult)new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo));
                            }
                            if (this.versionField != null && this.versionField.length() > 0) {
                                if (r.indexOfValue(this.versionField) < 0) {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldNotFound", (String[])new String[]{this.versionField}) + Const.CR;
                                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                                } else {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldFound", (String[])new String[]{this.versionField}) + Const.CR;
                                    cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                                }
                                remarks.add((ICheckResult)cr);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((ICheckResult)new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo));
                            }
                            if (this.dateFrom != null && this.dateFrom.length() > 0) {
                                if (r.indexOfValue(this.dateFrom) < 0) {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartPointOfDaterangeNotFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                                } else {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartPointOfDaterangeFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                    cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                                }
                                remarks.add((ICheckResult)cr);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((ICheckResult)new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo));
                            }
                            if (this.dateTo != null && this.dateTo.length() > 0) {
                                if (r.indexOfValue(this.dateTo) < 0) {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndPointOfDaterangeNotFound", (String[])new String[]{this.dateTo}) + Const.CR;
                                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                                } else {
                                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndPointOfDaterangeFound", (String[])new String[]{this.dateTo}) + Const.CR;
                                    cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                                }
                                remarks.add((ICheckResult)cr);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndKeyRequired", (String[])new String[0]) + Const.CR;
                                remarks.add((ICheckResult)new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo));
                            }
                        } else {
                            errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                            remarks.add((ICheckResult)cr);
                        }
                    }
                    if (prev != null && prev.size() > 0) {
                        first = true;
                        errorMessage = "";
                        errorFound = false;
                        for (int i = 0; i < this.fieldStream.length; ++i) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.CheckField", (String[])new String[]{i + " --> " + this.fieldStream[i]}));
                            IValueMeta v = prev.searchValueMeta(this.fieldStream[i]);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.MissongFields", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = errorMessage + "\t\t" + this.fieldStream[i] + Const.CR;
                        }
                        cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transforminfo);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                        remarks.add((ICheckResult)cr);
                    }
                    if (!this.databaseMeta.supportsSequences() || !CREATION_METHOD_SEQUENCE.equals(this.getTechKeyCreation()) || this.sequenceName == null || this.sequenceName.length() == 0) break block30;
                    if (db.checkSequenceExists(this.sequenceName)) {
                        errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.SequenceExists", (String[])new String[]{this.sequenceName});
                        cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                        remarks.add((ICheckResult)cr);
                        break block30;
                    }
                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.SequenceCouldNotFound", (String[])new String[]{this.sequenceName});
                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
                catch (HopException e) {
                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotConectToDB", (String[])new String[0]) + e.getMessage();
                    CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.InvalidConnectionName", (String[])new String[0]);
                CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    private void checkLookup(IVariables variables, List<ICheckResult> remarks, TransformMeta transforminfo, IRowMeta prev) {
        block23: {
            boolean errorFound = false;
            String errorMessage = "";
            if (this.databaseMeta != null) {
                Database db = this.createDatabaseObject(variables);
                try {
                    db.connect();
                    if (Utils.isEmpty((CharSequence)this.tableName)) break block23;
                    IRowMeta tableFields = db.getTableFieldsMeta(this.schemaName, this.tableName);
                    if (tableFields != null) {
                        if (prev != null && prev.size() > 0) {
                            int i;
                            boolean first = true;
                            boolean warning_found = false;
                            for (i = 0; i < this.keyStream.length; ++i) {
                                String strfield = this.keyStream[i];
                                IValueMeta strvalue = prev.searchValueMeta(strfield);
                                if (strvalue == null) {
                                    if (first) {
                                        first = false;
                                        errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyhasProblem", (String[])new String[0]) + Const.CR;
                                    }
                                    errorFound = true;
                                    errorMessage = errorMessage + "\t\t" + this.keyField + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotPresentInStream", (String[])new String[0]) + Const.CR;
                                    continue;
                                }
                                String dimfield = this.keyLookup[i];
                                IValueMeta dimvalue = tableFields.searchValueMeta(dimfield);
                                if (dimvalue == null) {
                                    if (first) {
                                        first = false;
                                        errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyhasProblem2", (String[])new String[0]) + Const.CR;
                                    }
                                    errorFound = true;
                                    errorMessage = errorMessage + "\t\t" + dimfield + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotPresentInDimensiontable", (String[])new String[0]) + this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName) + ")" + Const.CR;
                                    continue;
                                }
                                if (strvalue.getType() == dimvalue.getType()) continue;
                                if (first) {
                                    first = false;
                                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyhasProblem3", (String[])new String[0]) + Const.CR;
                                }
                                warning_found = true;
                                errorMessage = errorMessage + "\t\t" + strfield + " (" + strvalue.getOrigin() + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.KeyNotTheSameTypeAs", (String[])new String[0]) + dimfield + " (" + this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName) + ")" + Const.CR;
                                errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.WarningInfoInDBConversion", (String[])new String[0]);
                            }
                            CheckResult cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo) : (warning_found ? new CheckResult(3, errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllKeysFieldsFound", (String[])new String[0]), (ICheckResultSource)transforminfo));
                            remarks.add((ICheckResult)cr);
                            errorFound = false;
                            for (i = 0; i < this.fieldLookup.length; ++i) {
                                IValueMeta v;
                                String lufield = this.fieldLookup[i];
                                if (lufield == null || lufield.length() <= 0 || (v = tableFields.searchValueMeta(lufield)) != null) continue;
                                if (first) {
                                    first = false;
                                    errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.FieldsToRetrieveNotExistInDimension", (String[])new String[0]) + Const.CR;
                                }
                                errorFound = true;
                                errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                            }
                            cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.AllFieldsToRetrieveFound", (String[])new String[0]), (ICheckResultSource)transforminfo);
                            remarks.add((ICheckResult)cr);
                            if (tableFields.indexOfValue(this.keyField) < 0) {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyNotFound", (String[])new String[]{this.keyField}) + Const.CR;
                                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.TechnicalKeyFound", (String[])new String[]{this.keyField}) + Const.CR;
                                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                            }
                            remarks.add((ICheckResult)cr);
                            if (tableFields.indexOfValue(this.versionField) < 0) {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldNotFound", (String[])new String[]{this.versionField}) + Const.CR;
                                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.VersionFieldFound", (String[])new String[]{this.versionField}) + Const.CR;
                                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                            }
                            remarks.add((ICheckResult)cr);
                            if (tableFields.indexOfValue(this.dateFrom) < 0) {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartOfDaterangeFieldNotFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.StartOfDaterangeFieldFound", (String[])new String[]{this.dateFrom}) + Const.CR;
                                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                            }
                            remarks.add((ICheckResult)cr);
                            if (tableFields.indexOfValue(this.dateTo) < 0) {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndOfDaterangeFieldNotFound", (String[])new String[]{this.dateTo}) + Const.CR;
                                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                            } else {
                                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.EndOfDaterangeFieldFound", (String[])new String[]{this.dateTo});
                                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transforminfo);
                            }
                            remarks.add((ICheckResult)cr);
                        } else {
                            errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
                            CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                            remarks.add((ICheckResult)cr);
                        }
                        break block23;
                    }
                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                    CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
                catch (HopException e) {
                    errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.CouldNotConnectDB", (String[])new String[0]) + e.getMessage();
                    CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"DimensionLookupMeta.CheckResult.InvalidConnection", (String[])new String[0]);
                CheckResult cr = new CheckResult(4, errorMessage, (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowMeta getTableFields(IVariables variables) {
        IRowMeta fields = null;
        if (this.databaseMeta != null) {
            Database db = this.createDatabaseObject(variables);
            try {
                db.connect();
                fields = db.getTableFieldsMeta(this.schemaName, this.tableName);
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.DatabaseErrorOccurred", (String[])new String[0]) + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) {
        SqlStatement retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
        if (this.update) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.Update", (String[])new String[0]));
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                    if (!Utils.isEmpty((CharSequence)schemaTable)) {
                        Database db = this.createDatabaseObject(variables);
                        try {
                            IValueMeta field;
                            IValueMeta vprev;
                            int i;
                            db.connect();
                            String sql = "";
                            RowMeta fields = new RowMeta();
                            ValueMetaInteger vkeyfield = new ValueMetaInteger(this.keyField);
                            vkeyfield.setLength(10);
                            fields.addValueMeta((IValueMeta)vkeyfield);
                            ValueMetaInteger vversion = new ValueMetaInteger(this.versionField);
                            vversion.setLength(5);
                            fields.addValueMeta((IValueMeta)vversion);
                            ValueMetaDate vdatefrom = new ValueMetaDate(this.dateFrom);
                            fields.addValueMeta((IValueMeta)vdatefrom);
                            ValueMetaDate vdateto = new ValueMetaDate(this.dateTo);
                            fields.addValueMeta((IValueMeta)vdateto);
                            String errors = "";
                            for (i = 0; i < this.keyLookup.length; ++i) {
                                vprev = prev.searchValueMeta(this.keyStream[i]);
                                if (vprev != null) {
                                    field = vprev.clone();
                                    field.setName(this.keyLookup[i]);
                                    fields.addValueMeta(field);
                                    continue;
                                }
                                if (errors.length() > 0) {
                                    errors = errors + ", ";
                                }
                                errors = errors + this.keyStream[i];
                            }
                            for (i = 0; i < this.fieldLookup.length; ++i) {
                                vprev = prev.searchValueMeta(this.fieldStream[i]);
                                if (vprev != null) {
                                    field = vprev.clone();
                                    field.setName(this.fieldLookup[i]);
                                    fields.addValueMeta(field);
                                    continue;
                                }
                                if (errors.length() > 0) {
                                    errors = errors + ", ";
                                }
                                errors = errors + this.fieldStream[i];
                            }
                            for (i = 0; i < this.fieldUpdate.length; ++i) {
                                ValueMetaDate valueMeta = null;
                                switch (this.fieldUpdate[i]) {
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        valueMeta = new ValueMetaDate(this.fieldLookup[i]);
                                        break;
                                    }
                                    case 6: {
                                        valueMeta = new ValueMetaBoolean(this.fieldLookup[i]);
                                        break;
                                    }
                                }
                                if (valueMeta == null) continue;
                                fields.addValueMeta(valueMeta);
                            }
                            if (errors.length() > 0) {
                                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.UnableToFindFields", (String[])new String[0]) + errors);
                            }
                            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.Log.GetDDLForTable", (String[])new String[0]) + schemaTable + "] : " + fields.toStringMeta());
                            sql = sql + db.getDDL(schemaTable, (IRowMeta)fields, (String)(this.sequenceName != null && this.sequenceName.length() != 0 ? null : this.keyField), this.autoIncrement, null, true);
                            this.logDebug("sql =" + sql);
                            CharSequence[] idxFields = null;
                            if (!Utils.isEmpty((CharSequence[])this.keyLookup)) {
                                idxFields = new String[this.keyLookup.length];
                                for (int i2 = 0; i2 < this.keyLookup.length; ++i2) {
                                    idxFields[i2] = this.keyLookup[i2];
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoKeyFieldsSpecified", (String[])new String[0]));
                            }
                            if (!Utils.isEmpty((CharSequence[])idxFields) && !db.checkIndexExists(schemaTable, (String[])idxFields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                sql = sql + db.getCreateIndexStatement(schemaTable, indexname, (String[])idxFields, false, false, false, true);
                            }
                            idxFields = new String[]{this.keyField};
                            if (!Utils.isEmpty((CharSequence)this.keyField)) {
                                if (!db.checkIndexExists(schemaTable, (String[])idxFields)) {
                                    String indexname = "idx_" + this.tableName + "_tk";
                                    sql = sql + db.getCreateIndexStatement(schemaTable, indexname, (String[])idxFields, true, false, true, true);
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.TechnicalKeyFieldRequired", (String[])new String[0]));
                            }
                            if (CREATION_METHOD_SEQUENCE.equals(this.getTechKeyCreation()) && !Utils.isEmpty((CharSequence)this.sequenceName) && !db.checkSequenceExists(this.schemaName, this.sequenceName)) {
                                sql = sql + db.getCreateSequenceStatement(this.schemaName, this.sequenceName, 1L, 1L, -1L, true);
                            }
                            if (sql.length() == 0) {
                                retval.setSql(null);
                            }
                            retval.setSql(variables.resolve(sql));
                        }
                        catch (HopDatabaseException dbe) {
                            retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + dbe.getMessage());
                        }
                        finally {
                            db.disconnect();
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"DimensionLookupMeta.ReturnValue.NoConnectionDefiendInTransform", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) {
        block6: {
            if (prev == null) break block6;
            if (!this.update) {
                DatabaseImpact ii;
                IValueMeta v;
                int i;
                for (i = 0; i < this.keyLookup.length; ++i) {
                    v = prev.searchValueMeta(this.keyStream[i]);
                    ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.fieldLookup.length; ++i) {
                    v = prev.searchValueMeta(this.fieldStream[i]);
                    ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.fieldLookup[i], this.fieldLookup[i], v == null ? "" : (v != null ? v.getOrigin() : "?"), "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            } else {
                DatabaseImpact ii;
                IValueMeta v;
                int i;
                for (i = 0; i < this.keyLookup.length; ++i) {
                    v = prev.searchValueMeta(this.keyStream[i]);
                    ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v == null ? "" : v.getOrigin(), "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
                for (i = 0; i < this.fieldLookup.length; ++i) {
                    v = prev.searchValueMeta(this.fieldStream[i]);
                    ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.fieldLookup[i], this.fieldLookup[i], v == null ? "" : v.getOrigin(), "", v == null ? "" : "Type = " + v.toStringMeta());
                    impact.add(ii);
                }
            }
        }
    }

    public DimensionLookup createTransform(TransformMeta transformMeta, DimensionLookupData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new DimensionLookup(transformMeta, this, data, cnr, tr, pipeline);
    }

    public DimensionLookupData getTransformData() {
        return new DimensionLookupData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isUsingStartDateAlternative() {
        return this.usingStartDateAlternative;
    }

    public void setUsingStartDateAlternative(boolean usingStartDateAlternative) {
        this.usingStartDateAlternative = usingStartDateAlternative;
    }

    public int getStartDateAlternative() {
        return this.startDateAlternative;
    }

    public void setStartDateAlternative(int startDateAlternative) {
        this.startDateAlternative = startDateAlternative;
    }

    public String getStartDateFieldName() {
        return this.startDateFieldName;
    }

    public void setStartDateFieldName(String startDateFieldName) {
        this.startDateFieldName = startDateFieldName;
    }

    public boolean isPreloadingCache() {
        return this.preloadingCache;
    }

    public void setPreloadingCache(boolean preloadingCache) {
        this.preloadingCache = preloadingCache;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    protected IRowMeta getDatabaseTableFields(Database db, String schemaName, String tableName) throws HopDatabaseException {
        IRowMeta extraFields = db.getTableFieldsMeta(schemaName, tableName);
        if (extraFields == null) {
            db.connect();
            extraFields = db.getTableFieldsMeta(schemaName, tableName);
        }
        return extraFields;
    }

    Database createDatabaseObject(IVariables variables) {
        return new Database(loggingObject, variables, this.databaseMeta);
    }

    public RowMeta getRowMeta(IVariables variables, ITransformData transformData) {
        try {
            return (RowMeta)this.getDatabaseTableFields(this.createDatabaseObject(variables), this.schemaName, this.tableName);
        }
        catch (HopDatabaseException e) {
            this.log.logError("", (Throwable)e);
            return new RowMeta();
        }
    }

    public List<String> getDatabaseFields() {
        ArrayList<String> fields = new ArrayList<String>(this.fieldLookup.length + this.keyLookup.length);
        fields.addAll(Arrays.asList(this.fieldLookup));
        fields.addAll(Arrays.asList(this.keyLookup));
        return fields;
    }

    public List<String> getStreamFields() {
        ArrayList<String> fields = new ArrayList<String>(this.fieldLookup.length + this.keyLookup.length);
        fields.addAll(Arrays.asList(this.fieldStream));
        fields.addAll(Arrays.asList(this.keyStream));
        return fields;
    }

    public void normalizeAllocationFields() {
        if (this.keyLookup != null) {
            int keysGroupSize = this.keyLookup.length;
            this.keyStream = this.normalizeAllocation(this.keyStream, keysGroupSize);
        }
        if (this.fieldLookup != null) {
            int fieldsGroupSize = this.fieldLookup.length;
            this.fieldStream = this.normalizeAllocation(this.fieldStream, fieldsGroupSize);
            this.fieldUpdate = this.normalizeAllocation(this.fieldUpdate, fieldsGroupSize);
            this.returnType = this.normalizeAllocation(this.returnType, fieldsGroupSize);
        }
    }

    private String[] normalizeAllocation(String[] oldAllocation, int length) {
        String[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new String[length];
            for (int i = 0; i < oldAllocation.length; ++i) {
                newAllocation[i] = oldAllocation[i];
            }
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    private int[] normalizeAllocation(int[] oldAllocation, int length) {
        int[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new int[length];
            for (int i = 0; i < oldAllocation.length; ++i) {
                newAllocation[i] = oldAllocation[i];
            }
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int nrStream;
        int n = nrStream = this.keyStream == null ? -1 : this.keyStream.length;
        if (nrStream > 0) {
            String[][] rtn = Utils.normalizeArrays((int)nrStream, (String[][])new String[][]{this.keyLookup});
            this.keyLookup = rtn[0];
        }
        int n2 = nrFields = this.fieldStream == null ? -1 : this.fieldStream.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] rtnFieldLookup = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.fieldLookup});
        this.fieldLookup = rtnFieldLookup[0];
        int[][] rtnFieldUpdate = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.fieldUpdate});
        this.fieldUpdate = rtnFieldUpdate[0];
    }

    public static class ReturnTypeCodeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws HopValueException {
            return DimensionLookupMeta.getUpdateType(false, v);
        }
    }

    public static class UpdateTypeCodeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws HopValueException {
            return DimensionLookupMeta.getUpdateType(true, v);
        }
    }

    public static class StartDateCodeConverter
    extends InjectionTypeConverter {
        public int string2intPrimitive(String v) throws HopValueException {
            return DimensionLookupMeta.getStartDateAlternative(v);
        }
    }
}

