/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dimensionlookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dimensionlookup.DimensionLookupMeta;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DimensionLookupDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DimensionLookupMeta.class;
    private CTabFolder wTabFolder;
    private CTabItem wFieldsTab;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wSchema;
    private TextVar wTable;
    private Label wlCommit;
    private Text wCommit;
    private Button wUseCache;
    private Label wlPreloadCache;
    private Button wPreloadCache;
    private Label wlCacheSize;
    private Text wCacheSize;
    private CCombo wTk;
    private Label wlTkRename;
    private Text wTkRename;
    private Label wlAutoinc;
    private Button wAutoinc;
    private Label wlTableMax;
    private Button wTableMax;
    private Label wlSeqButton;
    private Button wSeqButton;
    private Text wSeq;
    private Label wlVersion;
    private CCombo wVersion;
    private CCombo wDatefield;
    private CCombo wFromdate;
    private Button wUseAltStartDate;
    private CCombo wAltStartDate;
    private CCombo wAltStartDateField;
    private Label wlMinyear;
    private Text wMinyear;
    private CCombo wTodate;
    private Label wlMaxyear;
    private Text wMaxyear;
    private Button wUpdate;
    private TableView wKey;
    private TableView wUpIns;
    private Button wCreate;
    private final DimensionLookupMeta input;
    private boolean backupUpdate;
    private boolean backupAutoInc;
    private DatabaseMeta ci;
    private ColumnInfo[] ciUpIns;
    private ColumnInfo[] ciKey;
    private final Map<String, Integer> inputFields;
    private boolean gotPreviousFields = false;
    private boolean gotTableFields = false;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public DimensionLookupDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (DimensionLookupMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        FocusAdapter lsConnectionFocus = new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                DimensionLookupDialog.this.input.setChanged();
                DimensionLookupDialog.this.setTableFieldCombo();
            }
        };
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        this.backupChanged = this.input.hasChanged();
        this.backupUpdate = this.input.isUpdate();
        this.backupAutoInc = this.input.isAutoIncrement();
        this.ci = this.input.getDatabaseMeta();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        Composite sCompParent = new Composite((Composite)this.shell, 0);
        sCompParent.setLayout((Layout)new FillLayout(512));
        FormData fdCompGridData = new FormData();
        sCompParent.setLayoutData((Object)fdCompGridData);
        ScrolledComposite sComp = new ScrolledComposite(sCompParent, 768);
        sComp.setLayout((Layout)new FormLayout());
        sComp.setExpandHorizontal(true);
        sComp.setExpandVertical(true);
        Composite mainComposite = new Composite((Composite)sComp, 0);
        this.props.setLook((Control)mainComposite);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        mainComposite.setLayout((Layout)fileLayout);
        this.wlTransformName = new Label(mainComposite, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text(mainComposite, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlUpdate = new Label(mainComposite, 131072);
        wlUpdate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Update.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUpdate);
        FormData fdlUpdate = new FormData();
        fdlUpdate.left = new FormAttachment(0, 0);
        fdlUpdate.right = new FormAttachment(middle, -margin);
        fdlUpdate.top = new FormAttachment((Control)this.wTransformName, margin);
        wlUpdate.setLayoutData((Object)fdlUpdate);
        this.wUpdate = new Button(mainComposite, 32);
        this.props.setLook((Control)this.wUpdate);
        FormData fdUpdate = new FormData();
        fdUpdate.left = new FormAttachment(middle, 0);
        fdUpdate.top = new FormAttachment((Control)wlUpdate, 0, 0x1000000);
        fdUpdate.right = new FormAttachment(100, 0);
        this.wUpdate.setLayoutData((Object)fdUpdate);
        this.wUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionLookupDialog.this.input.setUpdate(!DimensionLookupDialog.this.input.isUpdate());
                DimensionLookupDialog.this.input.setChanged();
                DimensionLookupDialog.this.setFlags();
            }
        });
        this.wConnection = this.addConnectionLine(mainComposite, (Control)this.wUpdate, this.input.getDatabaseMeta(), lsMod);
        this.wConnection.addFocusListener((FocusListener)lsConnectionFocus);
        this.wConnection.addModifyListener(e -> {
            this.ci = this.pipelineMeta.findDatabase(this.wConnection.getText());
            this.setFlags();
        });
        Label wlSchema = new Label(mainComposite, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button(mainComposite, 0x1000008);
        this.props.setLook((Control)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, mainComposite, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label(mainComposite, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TargeTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button(mainComposite, 0x1000008);
        this.props.setLook((Control)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, mainComposite, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, 0);
        this.wTable.setLayoutData((Object)fdTable);
        this.wlCommit = new Label(mainComposite, 131072);
        this.wlCommit.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Commit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.right = new FormAttachment(middle, -margin);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        this.wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new Text(mainComposite, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlUseCache = new Label(mainComposite, 131072);
        wlUseCache.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UseCache.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUseCache);
        FormData fdlUseCache = new FormData();
        fdlUseCache.left = new FormAttachment(0, 0);
        fdlUseCache.right = new FormAttachment(middle, -margin);
        fdlUseCache.top = new FormAttachment((Control)this.wCommit, margin);
        wlUseCache.setLayoutData((Object)fdlUseCache);
        this.wUseCache = new Button(mainComposite, 32);
        this.props.setLook((Control)this.wUseCache);
        this.wUseCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DimensionLookupDialog.this.setFlags();
                DimensionLookupDialog.this.input.setChanged();
            }
        });
        FormData fdUseCache = new FormData();
        fdUseCache.left = new FormAttachment(middle, 0);
        fdUseCache.top = new FormAttachment((Control)wlUseCache, 0, 0x1000000);
        fdUseCache.right = new FormAttachment(100, 0);
        this.wUseCache.setLayoutData((Object)fdUseCache);
        this.wlPreloadCache = new Label(mainComposite, 131072);
        this.wlPreloadCache.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.PreloadCache.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPreloadCache);
        FormData fdlPreloadCache = new FormData();
        fdlPreloadCache.left = new FormAttachment(0, 0);
        fdlPreloadCache.right = new FormAttachment(middle, -margin);
        fdlPreloadCache.top = new FormAttachment((Control)this.wUseCache, margin);
        this.wlPreloadCache.setLayoutData((Object)fdlPreloadCache);
        this.wPreloadCache = new Button(mainComposite, 32);
        this.props.setLook((Control)this.wPreloadCache);
        this.wPreloadCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DimensionLookupDialog.this.setFlags();
                DimensionLookupDialog.this.input.setChanged();
            }
        });
        FormData fdPreloadCache = new FormData();
        fdPreloadCache.left = new FormAttachment(middle, 0);
        fdPreloadCache.top = new FormAttachment((Control)this.wlPreloadCache, 0, 0x1000000);
        fdPreloadCache.right = new FormAttachment(100, 0);
        this.wPreloadCache.setLayoutData((Object)fdPreloadCache);
        this.wlCacheSize = new Label(mainComposite, 131072);
        this.wlCacheSize.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.CacheSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCacheSize);
        FormData fdlCacheSize = new FormData();
        fdlCacheSize.left = new FormAttachment(0, 0);
        fdlCacheSize.right = new FormAttachment(middle, -margin);
        fdlCacheSize.top = new FormAttachment((Control)this.wPreloadCache, margin);
        this.wlCacheSize.setLayoutData((Object)fdlCacheSize);
        this.wCacheSize = new Text(mainComposite, 18436);
        this.props.setLook((Control)this.wCacheSize);
        this.wCacheSize.addModifyListener(lsMod);
        FormData fdCacheSize = new FormData();
        fdCacheSize.left = new FormAttachment(middle, 0);
        fdCacheSize.top = new FormAttachment((Control)this.wPreloadCache, margin);
        fdCacheSize.right = new FormAttachment(100, 0);
        this.wCacheSize.setLayoutData((Object)fdCacheSize);
        this.wlTkRename = new Label(mainComposite, 131072);
        this.wTabFolder = new CTabFolder(mainComposite, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        CTabItem wKeyTab = new CTabItem(this.wTabFolder, 0);
        wKeyTab.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.KeyTab.CTabItem", (String[])new String[0]));
        FormLayout keyLayout = new FormLayout();
        keyLayout.marginWidth = 3;
        keyLayout.marginHeight = 3;
        Composite wKeyComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wKeyComp);
        wKeyComp.setLayout((Layout)keyLayout);
        Label wlKey = new Label(wKeyComp, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.KeyFields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment(0, margin);
        fdlKey.right = new FormAttachment(100, 0);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 2;
        int nrKeyRows = this.input.getKeyStream() != null ? this.input.getKeyStream().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.DimensionField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.FieldInStream", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView(this.variables, wKeyComp, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment(100, 0);
        fdKey.bottom = new FormAttachment(100, 0);
        this.wKey.setLayoutData((Object)fdKey);
        FormData fdKeyComp = new FormData();
        fdKeyComp.left = new FormAttachment(0, 0);
        fdKeyComp.top = new FormAttachment(0, 0);
        fdKeyComp.right = new FormAttachment(100, 0);
        fdKeyComp.bottom = new FormAttachment(100, 0);
        wKeyComp.setLayoutData((Object)fdKeyComp);
        wKeyComp.layout();
        wKeyTab.setControl((Control)wKeyComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FieldsTab.CTabItem.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsCompLayout = new FormLayout();
        fieldsCompLayout.marginWidth = 5;
        fieldsCompLayout.marginHeight = 5;
        wFieldsComp.setLayout((Layout)fieldsCompLayout);
        Label wlUpIns = new Label(wFieldsComp, 0);
        wlUpIns.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUpIns);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        wlUpIns.setLayoutData((Object)fdlUpIns);
        int upInsCols = 3;
        int upInsRows = this.input.getFieldStream() != null ? this.input.getFieldStream().length : 1;
        this.ciUpIns = new ColumnInfo[upInsCols];
        this.ciUpIns[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.DimensionField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciUpIns[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciUpIns[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.TypeOfDimensionUpdate", (String[])new String[0]), 2, this.input.isUpdate() ? DimensionLookupMeta.typeDesc : DimensionLookupMeta.typeDescLookup);
        this.tableFieldColumns.add(this.ciUpIns[0]);
        this.wUpIns = new TableView(this.variables, wFieldsComp, 68354, this.ciUpIns, upInsRows, lsMod, this.props);
        FormData fdUpIns = new FormData();
        fdUpIns.left = new FormAttachment(0, 0);
        fdUpIns.top = new FormAttachment((Control)wlUpIns, margin);
        fdUpIns.right = new FormAttachment(100, 0);
        fdUpIns.bottom = new FormAttachment(100, 0);
        this.wUpIns.setLayoutData((Object)fdUpIns);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wCacheSize, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(55, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        Label wlTk = new Label(mainComposite, 131072);
        wlTk.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TechnicalKeyField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTk);
        FormData fdlTk = new FormData();
        fdlTk.left = new FormAttachment(0, 0);
        fdlTk.right = new FormAttachment(middle, -margin);
        fdlTk.top = new FormAttachment((Control)this.wTabFolder, 2 * margin);
        wlTk.setLayoutData((Object)fdlTk);
        this.wTk = new CCombo(mainComposite, 18436);
        this.props.setLook((Control)this.wTk);
        this.wTk.addModifyListener(lsMod);
        FormData fdTk = new FormData();
        fdTk.left = new FormAttachment(middle, 0);
        fdTk.top = new FormAttachment((Control)this.wTabFolder, 2 * margin);
        fdTk.right = new FormAttachment(50 + middle / 2, 0);
        this.wTk.setLayoutData((Object)fdTk);
        this.wTk.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DimensionLookupDialog.this.shell.getDisplay(), 1);
                DimensionLookupDialog.this.shell.setCursor(busy);
                DimensionLookupDialog.this.getFieldsFromTable();
                DimensionLookupDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlTkRename.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NewName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTkRename);
        FormData fdlTkRename = new FormData();
        fdlTkRename.left = new FormAttachment(50 + middle / 2, margin);
        fdlTkRename.top = new FormAttachment((Control)this.wTabFolder, 2 * margin);
        this.wlTkRename.setLayoutData((Object)fdlTkRename);
        this.wTkRename = new Text(mainComposite, 18436);
        this.props.setLook((Control)this.wTkRename);
        this.wTkRename.addModifyListener(lsMod);
        FormData fdTkRename = new FormData();
        fdTkRename.left = new FormAttachment((Control)this.wlTkRename, margin);
        fdTkRename.top = new FormAttachment((Control)this.wTabFolder, 2 * margin);
        fdTkRename.right = new FormAttachment(100, 0);
        this.wTkRename.setLayoutData((Object)fdTkRename);
        Group gTechGroup = new Group(mainComposite, 16);
        gTechGroup.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TechGroup.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginHeight = 10;
        groupLayout.marginWidth = 10;
        gTechGroup.setLayout((Layout)groupLayout);
        FormData fdTechGroup = new FormData();
        fdTechGroup.top = new FormAttachment((Control)this.wTkRename, margin);
        fdTechGroup.left = new FormAttachment(middle, 0);
        fdTechGroup.right = new FormAttachment(100, -margin);
        gTechGroup.setBackground(this.shell.getBackground());
        gTechGroup.setLayoutData((Object)fdTechGroup);
        this.wTableMax = new Button((Composite)gTechGroup, 16);
        this.props.setLook((Control)this.wTableMax);
        this.wTableMax.setSelection(false);
        FormData fdTableMax = new FormData();
        fdTableMax.left = new FormAttachment(0, 0);
        fdTableMax.top = new FormAttachment((Control)this.wTkRename, margin);
        this.wTableMax.setLayoutData((Object)fdTableMax);
        this.wTableMax.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TableMaximum.Tooltip", (String[])new String[]{Const.CR}));
        this.wlTableMax = new Label((Composite)gTechGroup, 16384);
        this.wlTableMax.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TableMaximum.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTableMax);
        FormData fdlTableMax = new FormData();
        fdlTableMax.left = new FormAttachment((Control)this.wTableMax, margin);
        fdlTableMax.top = new FormAttachment((Control)this.wTkRename, margin);
        fdlTableMax.right = new FormAttachment(100, 0);
        this.wlTableMax.setLayoutData((Object)fdlTableMax);
        this.wSeqButton = new Button((Composite)gTechGroup, 16);
        this.props.setLook((Control)this.wSeqButton);
        this.wSeqButton.setSelection(false);
        FormData fdSeqButton = new FormData();
        fdSeqButton.left = new FormAttachment(0, 0);
        fdSeqButton.top = new FormAttachment((Control)this.wTableMax, margin);
        this.wSeqButton.setLayoutData((Object)fdSeqButton);
        this.wSeqButton.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Sequence.Tooltip", (String[])new String[]{Const.CR}));
        this.wlSeqButton = new Label((Composite)gTechGroup, 16384);
        this.wlSeqButton.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Sequence.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSeqButton);
        FormData fdlSeqButton = new FormData();
        fdlSeqButton.left = new FormAttachment((Control)this.wSeqButton, 0);
        fdlSeqButton.top = new FormAttachment((Control)this.wTableMax, margin);
        fdlSeqButton.right = new FormAttachment(100, 0);
        this.wlSeqButton.setLayoutData((Object)fdlSeqButton);
        this.wSeq = new Text((Composite)gTechGroup, 18436);
        this.props.setLook((Control)this.wSeq);
        this.wSeq.addModifyListener(lsMod);
        FormData fdSeq = new FormData();
        fdSeq.left = new FormAttachment(0, 0);
        fdSeq.top = new FormAttachment((Control)this.wSeqButton, margin);
        fdSeq.right = new FormAttachment(100, 0);
        this.wSeq.setLayoutData((Object)fdSeq);
        this.wSeq.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                DimensionLookupDialog.this.input.setTechKeyCreation(DimensionLookupMeta.CREATION_METHOD_SEQUENCE);
                DimensionLookupDialog.this.wSeqButton.setSelection(true);
                DimensionLookupDialog.this.wAutoinc.setSelection(false);
                DimensionLookupDialog.this.wTableMax.setSelection(false);
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        this.wAutoinc = new Button((Composite)gTechGroup, 16);
        this.props.setLook((Control)this.wAutoinc);
        this.wAutoinc.setSelection(false);
        FormData fdAutoinc = new FormData();
        fdAutoinc.left = new FormAttachment(0, 0);
        fdAutoinc.top = new FormAttachment((Control)this.wSeq, margin);
        this.wAutoinc.setLayoutData((Object)fdAutoinc);
        this.wAutoinc.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AutoincButton.Tooltip", (String[])new String[]{Const.CR}));
        this.wlAutoinc = new Label((Composite)gTechGroup, 16384);
        this.wlAutoinc.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Autoincrement.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAutoinc);
        FormData fdlAutoinc = new FormData();
        fdlAutoinc.left = new FormAttachment((Control)this.wAutoinc, 0);
        fdlAutoinc.top = new FormAttachment((Control)this.wSeq, margin);
        fdlAutoinc.right = new FormAttachment(100, 0);
        this.wlAutoinc.setLayoutData((Object)fdlAutoinc);
        this.wlVersion = new Label(mainComposite, 131072);
        this.wlVersion.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Version.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlVersion);
        FormData fdlVersion = new FormData();
        fdlVersion.left = new FormAttachment(0, 0);
        fdlVersion.right = new FormAttachment(middle, -margin);
        fdlVersion.top = new FormAttachment((Control)gTechGroup, 2 * margin);
        this.wlVersion.setLayoutData((Object)fdlVersion);
        this.wVersion = new CCombo(mainComposite, 18436);
        this.props.setLook((Control)this.wVersion);
        this.wVersion.addModifyListener(lsMod);
        FormData fdVersion = new FormData();
        fdVersion.left = new FormAttachment(middle, 0);
        fdVersion.top = new FormAttachment((Control)gTechGroup, 2 * margin);
        fdVersion.right = new FormAttachment(100, 0);
        this.wVersion.setLayoutData((Object)fdVersion);
        this.wVersion.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DimensionLookupDialog.this.shell.getDisplay(), 1);
                DimensionLookupDialog.this.shell.setCursor(busy);
                DimensionLookupDialog.this.getFieldsFromTable();
                DimensionLookupDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlDatefield = new Label(mainComposite, 131072);
        wlDatefield.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Datefield.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDatefield);
        FormData fdlDatefield = new FormData();
        fdlDatefield.left = new FormAttachment(0, 0);
        fdlDatefield.right = new FormAttachment(middle, -margin);
        fdlDatefield.top = new FormAttachment((Control)this.wVersion, 2 * margin);
        wlDatefield.setLayoutData((Object)fdlDatefield);
        this.wDatefield = new CCombo(mainComposite, 18436);
        this.props.setLook((Control)this.wDatefield);
        this.wDatefield.addModifyListener(lsMod);
        FormData fdDatefield = new FormData();
        fdDatefield.left = new FormAttachment(middle, 0);
        fdDatefield.top = new FormAttachment((Control)this.wVersion, 2 * margin);
        fdDatefield.right = new FormAttachment(100, 0);
        this.wDatefield.setLayoutData((Object)fdDatefield);
        this.wDatefield.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DimensionLookupDialog.this.shell.getDisplay(), 1);
                DimensionLookupDialog.this.shell.setCursor(busy);
                DimensionLookupDialog.this.getFields();
                DimensionLookupDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlFromdate = new Label(mainComposite, 131072);
        wlFromdate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Fromdate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFromdate);
        FormData fdlFromdate = new FormData();
        fdlFromdate.left = new FormAttachment(0, 0);
        fdlFromdate.right = new FormAttachment(middle, -margin);
        fdlFromdate.top = new FormAttachment((Control)this.wDatefield, 2 * margin);
        wlFromdate.setLayoutData((Object)fdlFromdate);
        this.wFromdate = new CCombo(mainComposite, 18436);
        this.props.setLook((Control)this.wFromdate);
        this.wFromdate.addModifyListener(lsMod);
        FormData fdFromdate = new FormData();
        fdFromdate.left = new FormAttachment(middle, 0);
        fdFromdate.right = new FormAttachment(middle + (100 - middle) / 3, -margin);
        fdFromdate.top = new FormAttachment((Control)this.wDatefield, 2 * margin);
        this.wFromdate.setLayoutData((Object)fdFromdate);
        this.wFromdate.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DimensionLookupDialog.this.shell.getDisplay(), 1);
                DimensionLookupDialog.this.shell.setCursor(busy);
                DimensionLookupDialog.this.getFieldsFromTable();
                DimensionLookupDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlMinyear = new Label(mainComposite, 131072);
        this.wlMinyear.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Minyear.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMinyear);
        FormData fdlMinyear = new FormData();
        fdlMinyear.left = new FormAttachment((Control)this.wFromdate, margin);
        fdlMinyear.right = new FormAttachment(middle + 2 * (100 - middle) / 3, -margin);
        fdlMinyear.top = new FormAttachment((Control)this.wDatefield, 2 * margin);
        this.wlMinyear.setLayoutData((Object)fdlMinyear);
        this.wMinyear = new Text(mainComposite, 18436);
        this.props.setLook((Control)this.wMinyear);
        this.wMinyear.addModifyListener(lsMod);
        FormData fdMinyear = new FormData();
        fdMinyear.left = new FormAttachment((Control)this.wlMinyear, margin);
        fdMinyear.right = new FormAttachment(100, 0);
        fdMinyear.top = new FormAttachment((Control)this.wDatefield, 2 * margin);
        this.wMinyear.setLayoutData((Object)fdMinyear);
        this.wMinyear.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Minyear.ToolTip", (String[])new String[0]));
        Label wlUseAltStartDate = new Label(mainComposite, 131072);
        wlUseAltStartDate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UseAlternativeStartDate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUseAltStartDate);
        FormData fdlUseAltStartDate = new FormData();
        fdlUseAltStartDate.left = new FormAttachment(0, 0);
        fdlUseAltStartDate.right = new FormAttachment(middle, -margin);
        fdlUseAltStartDate.top = new FormAttachment((Control)this.wFromdate, margin);
        wlUseAltStartDate.setLayoutData((Object)fdlUseAltStartDate);
        this.wUseAltStartDate = new Button(mainComposite, 32);
        this.props.setLook((Control)this.wUseAltStartDate);
        this.wUseAltStartDate.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UseAlternativeStartDate.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdUseAltStartDate = new FormData();
        fdUseAltStartDate.left = new FormAttachment(middle, 0);
        fdUseAltStartDate.top = new FormAttachment((Control)wlUseAltStartDate, 0, 0x1000000);
        this.wUseAltStartDate.setLayoutData((Object)fdUseAltStartDate);
        this.wUseAltStartDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionLookupDialog.this.setFlags();
                DimensionLookupDialog.this.input.setChanged();
            }
        });
        this.wAltStartDate = new CCombo(mainComposite, 2048);
        this.props.setLook((Control)this.wAltStartDate);
        this.wAltStartDate.removeAll();
        for (int i = 1; i < DimensionLookupMeta.getStartDateAlternativeDescriptions().length; ++i) {
            this.wAltStartDate.add(DimensionLookupMeta.getStartDateAlternativeDescriptions()[i]);
        }
        this.wAltStartDate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AlternativeStartDate.SelectItemDefault", (String[])new String[0]));
        this.wAltStartDate.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AlternativeStartDate.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdAltStartDate = new FormData();
        fdAltStartDate.left = new FormAttachment((Control)this.wUseAltStartDate, 2 * margin);
        fdAltStartDate.right = new FormAttachment((Control)this.wUseAltStartDate, 200);
        fdAltStartDate.top = new FormAttachment((Control)this.wFromdate, margin);
        this.wAltStartDate.setLayoutData((Object)fdAltStartDate);
        this.wAltStartDate.addModifyListener(arg0 -> {
            this.setFlags();
            this.input.setChanged();
        });
        this.wAltStartDateField = new CCombo(mainComposite, 2052);
        this.props.setLook((Control)this.wAltStartDateField);
        this.wAltStartDateField.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AlternativeStartDateField.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdAltStartDateField = new FormData();
        fdAltStartDateField.left = new FormAttachment((Control)this.wAltStartDate, 2 * margin);
        fdAltStartDateField.right = new FormAttachment(100, 0);
        fdAltStartDateField.top = new FormAttachment((Control)this.wFromdate, margin);
        this.wAltStartDateField.setLayoutData((Object)fdAltStartDateField);
        this.wAltStartDateField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DimensionLookupDialog.this.shell.getDisplay(), 1);
                DimensionLookupDialog.this.shell.setCursor(busy);
                DimensionLookupDialog.this.getFieldsFromTable();
                DimensionLookupDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlTodate = new Label(mainComposite, 131072);
        wlTodate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Todate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTodate);
        FormData fdlTodate = new FormData();
        fdlTodate.left = new FormAttachment(0, 0);
        fdlTodate.right = new FormAttachment(middle, -margin);
        fdlTodate.top = new FormAttachment((Control)this.wAltStartDate, margin);
        wlTodate.setLayoutData((Object)fdlTodate);
        this.wTodate = new CCombo(mainComposite, 18436);
        this.props.setLook((Control)this.wTodate);
        this.wTodate.addModifyListener(lsMod);
        FormData fdTodate = new FormData();
        fdTodate.left = new FormAttachment(middle, 0);
        fdTodate.right = new FormAttachment(middle + (100 - middle) / 3, -margin);
        fdTodate.top = new FormAttachment((Control)this.wAltStartDate, margin);
        this.wTodate.setLayoutData((Object)fdTodate);
        this.wTodate.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DimensionLookupDialog.this.shell.getDisplay(), 1);
                DimensionLookupDialog.this.shell.setCursor(busy);
                DimensionLookupDialog.this.getFieldsFromTable();
                DimensionLookupDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlMaxyear = new Label(mainComposite, 131072);
        this.wlMaxyear.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Maxyear.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMaxyear);
        FormData fdlMaxyear = new FormData();
        fdlMaxyear.left = new FormAttachment((Control)this.wTodate, margin);
        fdlMaxyear.right = new FormAttachment(middle + 2 * (100 - middle) / 3, -margin);
        fdlMaxyear.top = new FormAttachment((Control)this.wAltStartDate, margin);
        this.wlMaxyear.setLayoutData((Object)fdlMaxyear);
        this.wMaxyear = new Text(mainComposite, 18436);
        this.props.setLook((Control)this.wMaxyear);
        this.wMaxyear.addModifyListener(lsMod);
        FormData fdMaxyear = new FormData();
        fdMaxyear.left = new FormAttachment((Control)this.wlMaxyear, margin);
        fdMaxyear.right = new FormAttachment(100, 0);
        fdMaxyear.top = new FormAttachment((Control)this.wAltStartDate, margin);
        this.wMaxyear.setLayoutData((Object)fdMaxyear);
        this.wMaxyear.setToolTipText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Maxyear.ToolTip", (String[])new String[0]));
        this.wOk = new Button(mainComposite, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wGet = new Button(mainComposite, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.GetFields.Button", (String[])new String[0]));
        wGet.addListener(13, e -> this.get());
        this.wCreate = new Button(mainComposite, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.SQL.Button", (String[])new String[0]));
        this.wCreate.addListener(13, e -> this.create());
        this.wCancel = new Button(mainComposite, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, wGet, this.wCreate, this.wCancel}, margin, (Control)this.wMaxyear);
        FormData fdComp = new FormData();
        fdComp.left = new FormAttachment(0, 0);
        fdComp.top = new FormAttachment(0, 0);
        fdComp.right = new FormAttachment(100, 0);
        fdComp.bottom = new FormAttachment(100, 0);
        mainComposite.setLayoutData((Object)fdComp);
        mainComposite.pack();
        Rectangle bounds = mainComposite.getBounds();
        sComp.setContent((Control)mainComposite);
        sComp.setExpandHorizontal(true);
        sComp.setExpandVertical(true);
        sComp.setMinWidth(bounds.width);
        sComp.setMinHeight(bounds.height);
        this.setTableMax();
        this.setSequence();
        this.setAutoincUse();
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionLookupDialog.this.getSchemaNames();
            }
        });
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionLookupDialog.this.getTableName();
            }
        });
        this.wTabFolder.setSelection(0);
        this.getData();
        this.setTableFieldCombo();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void setFlags() {
        ColumnInfo colinf = new ColumnInfo(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ColumnInfo.Type", (String[])new String[0]), 2, this.input.isUpdate() ? DimensionLookupMeta.typeDesc : DimensionLookupMeta.typeDescLookup);
        this.wUpIns.setColumnInfo(2, colinf);
        if (this.input.isUpdate()) {
            this.wUpIns.setColumnText(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnText.SteamFieldToCompare", (String[])new String[0]));
            this.wUpIns.setColumnText(3, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnTextTypeOfDimensionUpdate", (String[])new String[0]));
            this.wUpIns.setColumnToolTip(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnToolTip", (String[])new String[0]) + Const.CR + "Punch Through: Kimball Type I" + Const.CR + "Update: Correct error in last version");
        } else {
            this.wUpIns.setColumnText(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnText.NewNameOfOutputField", (String[])new String[0]));
            this.wUpIns.setColumnText(3, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnText.TypeOfReturnField", (String[])new String[0]));
            this.wUpIns.setColumnToolTip(2, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UpdateOrInsertFields.ColumnToolTip2", (String[])new String[0]));
        }
        this.wUpIns.optWidth(true);
        boolean update = this.wUpdate.getSelection();
        this.wlCommit.setEnabled(update);
        this.wCommit.setEnabled(update);
        this.wlMinyear.setEnabled(update);
        this.wMinyear.setEnabled(update);
        this.wlMaxyear.setEnabled(update);
        this.wMaxyear.setEnabled(update);
        this.wlMinyear.setEnabled(update);
        this.wMinyear.setEnabled(update);
        this.wlVersion.setEnabled(update);
        this.wVersion.setEnabled(update);
        this.wlTkRename.setEnabled(!update);
        this.wTkRename.setEnabled(!update);
        this.wCreate.setEnabled(update);
        this.setAutoincUse();
        this.setSequence();
        this.setTableMax();
        if (update) {
            this.setAutoincUse();
            this.setSequence();
            this.setTableMax();
        }
        this.wAltStartDate.setEnabled(this.wUseAltStartDate.getSelection());
        int alternative = DimensionLookupMeta.getStartDateAlternative(this.wAltStartDate.getText());
        this.wAltStartDateField.setEnabled(alternative == 4);
        this.wlPreloadCache.setEnabled(this.wUseCache.getSelection() && !this.wUpdate.getSelection());
        this.wPreloadCache.setEnabled(this.wUseCache.getSelection() && !this.wUpdate.getSelection());
        this.wlCacheSize.setEnabled(this.wUseCache.getSelection() && !this.wPreloadCache.getSelection());
        this.wCacheSize.setEnabled(this.wUseCache.getSelection() && !this.wPreloadCache.getSelection());
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[1].setComboValues(fieldNames);
        this.ciUpIns[1].setComboValues(fieldNames);
    }

    public void setAutoincUse() {
        boolean enable = this.ci == null || this.ci.supportsAutoinc() && this.ci.supportsAutoGeneratedKeys();
        this.wlAutoinc.setEnabled(enable);
        this.wAutoinc.setEnabled(enable);
        if (!enable && this.wAutoinc.getSelection()) {
            this.wAutoinc.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void setTableMax() {
        this.wlTableMax.setEnabled(true);
        this.wTableMax.setEnabled(true);
    }

    public void setSequence() {
        boolean seq = this.ci == null || this.ci.supportsSequences();
        this.wSeq.setEnabled(seq);
        this.wlSeqButton.setEnabled(seq);
        this.wSeqButton.setEnabled(seq);
        if (!seq && this.wSeqButton.getSelection()) {
            this.wAutoinc.setSelection(false);
            this.wSeqButton.setSelection(false);
            this.wTableMax.setSelection(true);
        }
    }

    public void getData() {
        String techKeyCreation;
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getKeyStream() != null) {
            for (i = 0; i < this.input.getKeyStream().length; ++i) {
                item = this.wKey.table.getItem(i);
                if (this.input.getKeyLookup()[i] != null) {
                    item.setText(1, this.input.getKeyLookup()[i]);
                }
                if (this.input.getKeyStream()[i] == null) continue;
                item.setText(2, this.input.getKeyStream()[i]);
            }
        }
        if (this.input.getFieldStream() != null) {
            for (i = 0; i < this.input.getFieldStream().length; ++i) {
                item = this.wUpIns.table.getItem(i);
                if (this.input.getFieldLookup()[i] != null) {
                    item.setText(1, this.input.getFieldLookup()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                item.setText(3, DimensionLookupMeta.getUpdateType(this.input.isUpdate(), this.input.getFieldUpdate()[i]));
            }
        }
        this.wUpdate.setSelection(this.input.isUpdate());
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getKeyField() != null) {
            this.wTk.setText(this.input.getKeyField());
        }
        if (this.input.getKeyRename() != null) {
            this.wTkRename.setText(this.input.getKeyRename());
        }
        this.wAutoinc.setSelection(this.input.isAutoIncrement());
        if (this.input.getVersionField() != null) {
            this.wVersion.setText(this.input.getVersionField());
        }
        if (this.input.getSequenceName() != null) {
            this.wSeq.setText(this.input.getSequenceName());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        if (this.input.getDateField() != null) {
            this.wDatefield.setText(this.input.getDateField());
        }
        if (this.input.getDateFrom() != null) {
            this.wFromdate.setText(this.input.getDateFrom());
        }
        if (this.input.getDateTo() != null) {
            this.wTodate.setText(this.input.getDateTo());
        }
        if ((techKeyCreation = this.input.getTechKeyCreation()) == null) {
            DatabaseMeta database = this.input.getDatabaseMeta();
            if (database == null || !database.supportsAutoinc()) {
                this.input.setAutoIncrement(false);
            }
            this.wAutoinc.setSelection(this.input.isAutoIncrement());
            this.wSeqButton.setSelection(this.input.getSequenceName() != null && this.input.getSequenceName().length() > 0);
            if (!(this.input.isAutoIncrement() || this.input.getSequenceName() != null && this.input.getSequenceName().length() > 0)) {
                this.wTableMax.setSelection(true);
            }
            if (database != null && database.supportsSequences() && this.input.getSequenceName() != null) {
                this.wSeq.setText(this.input.getSequenceName());
                this.input.setAutoIncrement(false);
                this.wTableMax.setSelection(false);
            }
        } else {
            if (DimensionLookupMeta.CREATION_METHOD_AUTOINC.equals(techKeyCreation)) {
                this.wAutoinc.setSelection(true);
                this.wSeqButton.setSelection(false);
                this.wTableMax.setSelection(false);
            } else if (DimensionLookupMeta.CREATION_METHOD_SEQUENCE.equals(techKeyCreation)) {
                this.wSeqButton.setSelection(true);
                this.wAutoinc.setSelection(false);
                this.wTableMax.setSelection(false);
            } else {
                this.wTableMax.setSelection(true);
                this.wAutoinc.setSelection(false);
                this.wSeqButton.setSelection(false);
                this.input.setTechKeyCreation(DimensionLookupMeta.CREATION_METHOD_TABLEMAX);
            }
            if (this.input.getSequenceName() != null) {
                this.wSeq.setText(this.input.getSequenceName());
            }
        }
        this.wCommit.setText("" + this.input.getCommitSize());
        this.wUseCache.setSelection(this.input.getCacheSize() >= 0);
        this.wPreloadCache.setSelection(this.input.isPreloadingCache());
        if (this.input.getCacheSize() >= 0) {
            this.wCacheSize.setText("" + this.input.getCacheSize());
        }
        this.wMinyear.setText("" + this.input.getMinYear());
        this.wMaxyear.setText("" + this.input.getMaxYear());
        this.wUpIns.removeEmptyRows();
        this.wUpIns.setRowNums();
        this.wUpIns.optWidth(true);
        this.wKey.removeEmptyRows();
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.ci = this.pipelineMeta.findDatabase(this.wConnection.getText());
        this.wUseAltStartDate.setSelection(this.input.isUsingStartDateAlternative());
        if (this.input.isUsingStartDateAlternative()) {
            this.wAltStartDate.setText(DimensionLookupMeta.getStartDateAlternativeDesc(this.input.getStartDateAlternative()));
        }
        this.wAltStartDateField.setText(Const.NVL((String)this.input.getStartDateFieldName(), (String)""));
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.input.setUpdate(this.backupUpdate);
        this.input.setAutoIncrement(this.backupAutoInc);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.transformName = this.wTransformName.getText();
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getInfo(DimensionLookupMeta in) {
        TableItem item;
        int i;
        in.setUpdate(this.wUpdate.getSelection());
        int nrkeys = this.wKey.nrNonEmpty();
        int nrFields = this.wUpIns.nrNonEmpty();
        in.allocate(nrkeys, nrFields);
        this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Log.FoundKeys", (String[])new String[]{String.valueOf(nrkeys)}));
        for (i = 0; i < nrkeys; ++i) {
            item = this.wKey.getNonEmpty(i);
            in.getKeyLookup()[i] = item.getText(1);
            in.getKeyStream()[i] = item.getText(2);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Log.FoundFields", (String[])new String[]{String.valueOf(nrFields)}));
        }
        for (i = 0; i < nrFields; ++i) {
            item = this.wUpIns.getNonEmpty(i);
            in.getFieldLookup()[i] = item.getText(1);
            in.getFieldStream()[i] = item.getText(2);
            in.getFieldUpdate()[i] = DimensionLookupMeta.getUpdateType(in.isUpdate(), item.getText(3));
        }
        in.setSchemaName(this.wSchema.getText());
        in.setTableName(this.wTable.getText());
        in.setKeyField(this.wTk.getText());
        in.setKeyRename(this.wTkRename.getText());
        if (this.wAutoinc.getSelection()) {
            in.setTechKeyCreation(DimensionLookupMeta.CREATION_METHOD_AUTOINC);
            in.setAutoIncrement(true);
            in.setSequenceName(null);
        } else if (this.wSeqButton.getSelection()) {
            in.setTechKeyCreation(DimensionLookupMeta.CREATION_METHOD_SEQUENCE);
            in.setAutoIncrement(false);
            in.setSequenceName(this.wSeq.getText());
        } else {
            in.setTechKeyCreation(DimensionLookupMeta.CREATION_METHOD_TABLEMAX);
            in.setAutoIncrement(false);
            in.setSequenceName(null);
        }
        in.setAutoIncrement(this.wAutoinc.getSelection());
        if (in.getKeyRename() != null && in.getKeyRename().equalsIgnoreCase(in.getKeyField())) {
            in.setKeyRename(null);
        }
        in.setVersionField(this.wVersion.getText());
        in.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText()));
        in.setDateField(this.wDatefield.getText());
        in.setDateFrom(this.wFromdate.getText());
        in.setDateTo(this.wTodate.getText());
        in.setCommitSize(Const.toInt((String)this.wCommit.getText(), (int)0));
        if (this.wUseCache.getSelection()) {
            in.setCacheSize(Const.toInt((String)this.wCacheSize.getText(), (int)-1));
        } else {
            in.setCacheSize(-1);
        }
        in.setPreloadingCache(this.wPreloadCache.getSelection());
        if (this.wPreloadCache.getSelection()) {
            in.setCacheSize(0);
        }
        in.setMinYear(Const.toInt((String)this.wMinyear.getText(), (int)1900));
        in.setMaxYear(Const.toInt((String)this.wMaxyear.getText(), (int)2199));
        in.setUsingStartDateAlternative(this.wUseAltStartDate.getSelection());
        in.setStartDateAlternative(DimensionLookupMeta.getStartDateAlternative(this.wAltStartDate.getText()));
        in.setStartDateFieldName(this.wAltStartDateField.getText());
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName);
        if (databaseMeta == null) {
            return;
        }
        this.logDebug(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
        DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
        std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
        if (std.open()) {
            this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
            this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            this.setTableFieldCombo();
        }
    }

    private void get() {
        if (this.wTabFolder.getSelection() == this.wFieldsTab) {
            if (this.input.isUpdate()) {
                this.getUpdate();
            } else {
                this.getLookup();
            }
        } else {
            this.getKeys();
        }
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wUpIns, (int)2, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (tableItem, v) -> {
                    tableItem.setText(3, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.TableItem.Insert.Label", (String[])new String[0]));
                    int idx = this.wKey.indexOfString(v.getName(), 2);
                    return idx < 0 && !v.getName().equalsIgnoreCase(this.wTk.getText()) && !v.getName().equalsIgnoreCase(this.wVersion.getText()) && !v.getName().equalsIgnoreCase(this.wFromdate.getText()) && !v.getName().equalsIgnoreCase(this.wTodate.getText());
                });
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta databaseMeta;
                String tableName = this.wTable.getText();
                String connectionName = this.wConnection.getText();
                String schemaName = this.wSchema.getText();
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
                this.gotTableFields = false;
                if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName)) != null) {
                    Database db = new Database(loggingObject, this.variables, databaseMeta);
                    try {
                        String[] fieldNames;
                        db.connect();
                        IRowMeta r = db.getTableFieldsMeta(this.variables.resolve(schemaName), this.variables.resolve(tableName));
                        if (null != r && null != (fieldNames = r.getFieldNames())) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                            this.wTk.setItems(fieldNames);
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo colInfo : this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (db != null) {
                                db.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            db = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLookup() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database db = new Database(loggingObject, this.variables, databaseMeta);
            try {
                db.connect();
                IRowMeta r = db.getTableFieldsMeta(this.wSchema.getText(), this.wTable.getText());
                if (r != null && !r.isEmpty()) {
                    BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wUpIns, (int)2, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, (tableItem, v) -> {
                        int idx = this.wKey.indexOfString(v.getName(), 2);
                        return idx < 0 && !v.getName().equalsIgnoreCase(this.wTk.getText()) && !v.getName().equalsIgnoreCase(this.wVersion.getText()) && !v.getName().equalsIgnoreCase(this.wFromdate.getText()) && !v.getName().equalsIgnoreCase(this.wTodate.getText());
                    });
                }
            }
            catch (HopException e) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorOccurred.DialogTitle", (String[])new String[0]));
                mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorOccurred.DialogMessage", (String[])new String[0]) + Const.CR + e.getMessage());
                mb.open();
            }
            finally {
                db.disconnect();
            }
        }
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wDatefield.getText();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wDatefield.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wDatefield.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorGettingFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorGettingFields.Message", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    private void getFieldsFromTable() {
        if (!this.gotTableFields) {
            DatabaseMeta databaseMeta;
            if (!Utils.isEmpty((CharSequence)this.wTable.getText()) && (databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText())) != null) {
                Database db = new Database(loggingObject, this.variables, databaseMeta);
                try {
                    String[] fieldNames;
                    db.connect();
                    IRowMeta r = db.getTableFieldsMeta(this.variables.resolve(this.wSchema.getText()), this.variables.resolve(this.wTable.getText()));
                    if (null != r && null != (fieldNames = r.getFieldNames())) {
                        String version = this.wVersion.getText();
                        this.wVersion.setItems(fieldNames);
                        if (version != null) {
                            this.wVersion.setText(version);
                        }
                        String fromdate = this.wFromdate.getText();
                        this.wFromdate.setItems(fieldNames);
                        if (fromdate != null) {
                            this.wFromdate.setText(fromdate);
                        }
                        String todate = this.wTodate.getText();
                        this.wTodate.setItems(fieldNames);
                        if (todate != null) {
                            this.wTodate.setText(todate);
                        }
                        String tk = this.wTk.getText();
                        this.wTk.setItems(fieldNames);
                        if (tk != null) {
                            this.wTk.setText(tk);
                        }
                        String sd = this.wAltStartDateField.getText();
                        this.wAltStartDateField.setItems(fieldNames);
                        if (sd != null) {
                            this.wAltStartDateField.setText(sd);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.gotTableFields = true;
        }
    }

    private void getKeys() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)2, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, (tableItem, v) -> {
                    int idx = this.wKey.indexOfString(v.getName(), 2);
                    return idx < 0 && !v.getName().equalsIgnoreCase(this.wTk.getText()) && !v.getName().equalsIgnoreCase(this.wVersion.getText()) && !v.getName().equalsIgnoreCase(this.wFromdate.getText()) && !v.getName().equalsIgnoreCase(this.wTodate.getText());
                });
                Table table = this.wKey.table;
                for (int i = 0; i < r.size(); ++i) {
                    IValueMeta v2 = r.getValueMeta(i);
                    int idx = this.wKey.indexOfString(v2.getName(), 2);
                    int idy = this.wUpIns.indexOfString(v2.getName(), 2);
                    if (idx >= 0 || idy >= 0 || v2.getName().equalsIgnoreCase(this.wTk.getText()) || v2.getName().equalsIgnoreCase(this.wVersion.getText()) || v2.getName().equalsIgnoreCase(this.wFromdate.getText()) || v2.getName().equalsIgnoreCase(this.wTodate.getText())) continue;
                    TableItem ti = new TableItem(table, 0);
                    ti.setText(1, v2.getName());
                    ti.setText(2, v2.getName());
                    ti.setText(3, v2.getTypeDesc());
                }
                this.wKey.removeEmptyRows();
                this.wKey.setRowNums();
                this.wKey.optWidth(true);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            DimensionLookupMeta info = new DimensionLookupMeta();
            this.getInfo(info);
            String name = this.transformName;
            TransformMeta transforminfo = new TransformMeta(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Transforminfo.Title", (String[])new String[0]), name, (ITransformMeta)info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            String message = null;
            if (Utils.isEmpty((CharSequence)info.getKeyField())) {
                message = BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Error.NoTechnicalKeySpecified", (String[])new String[0]);
            }
            if (Utils.isEmpty((CharSequence)info.getTableName())) {
                message = BaseMessages.getString(PKG, (String)"DimensionLookupDialog.Error.NoTableNameSpecified", (String[])new String[0]);
            }
            if (message == null) {
                SqlStatement sql = info.getSqlStatements(this.variables, this.pipelineMeta, transforminfo, prev, this.metadataProvider);
                if (!sql.hasError()) {
                    if (sql.hasSql()) {
                        SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, info.getDatabaseMeta(), DbCache.getInstance(), sql.getSql());
                        sqledit.open();
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 34);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(sql.getError());
                    mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.SQLError.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(message);
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UnableToBuildSQLError.DialogMessage", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.UnableToBuildSQLError.DialogTitle", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DimensionLookupDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DimensionLookupDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }
}

