/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.loadfileinput;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInput;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputData;
import org.apache.hop.pipeline.transforms.loadfileinput.LoadFileInputField;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="LoadFileInput", image="loadfileinput.svg", name="i18n::BaseTransform.TypeLongDesc.LoadFileInput", description="i18n::BaseTransform.TypeTooltipDesc.LoadFileInput", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/loadfileinput.html")
public class LoadFileInputMeta
extends BaseTransformMeta
implements ITransformMeta<LoadFileInput, LoadFileInputData> {
    private static final String INCLUDE = "include";
    private static final String INCLUDE_FIELD = "include_field";
    private static final String ROWNUM = "rownum";
    private static final String ADDRESULTFILE = "addresultfile";
    private static final String IS_IGNORE_EMPTY_FILE = "IsIgnoreEmptyFile";
    private static final String IS_IGNORE_MISSING_PATH = "IsIgnoreMissingPath";
    private static final String ROWNUM_FIELD = "rownum_field";
    private static final String ENCODING = "encoding";
    private static final String NAME = "name";
    private static final String FILEMASK = "filemask";
    private static final String EXCLUDE_FILEMASK = "exclude_filemask";
    private static final String FILE_REQUIRED = "file_required";
    private static final String INCLUDE_SUBFOLDERS = "include_subfolders";
    private static final String LIMIT = "limit";
    private static final String IS_IN_FIELDS = "IsInFields";
    private static final String DYNAMIC_FILENAME_FIELD = "DynamicFilenameField";
    private static final String SHORT_FILE_FIELD_NAME = "shortFileFieldName";
    private static final String PATH_FIELD_NAME = "pathFieldName";
    private static final String HIDDEN_FIELD_NAME = "hiddenFieldName";
    private static final String LAST_MODIFICATION_TIME_FIELD_NAME = "lastModificationTimeFieldName";
    private static final String URI_NAME_FIELD_NAME = "uriNameFieldName";
    private static final String ROOT_URI_NAME_FIELD_NAME = "rootUriNameFieldName";
    private static final String EXTENSION_FIELD_NAME = "extensionFieldName";
    private static final String FILE = "file";
    private static final String FIELDS = "fields";
    private static final Class<?> PKG = LoadFileInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String YES = "Y";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private LoadFileInputField[] inputFields;
    private String encoding;
    private String DynamicFilenameField;
    private boolean fileinfield;
    private boolean addresultfile;
    private String[] fileRequired;
    private boolean ignoreEmptyFile;
    private boolean ignoreMissingPath;
    private String[] includeSubFolders;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequired) {
        this.fileRequired = fileRequired;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public boolean getAddResultFile() {
        return this.addresultfile;
    }

    public boolean isIgnoreEmptyFile() {
        return this.ignoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean isIgnoreEmptyFile) {
        this.ignoreEmptyFile = isIgnoreEmptyFile;
    }

    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    public void setIgnoreMissingPath(boolean ignoreMissingPath) {
        this.ignoreMissingPath = ignoreMissingPath;
    }

    public void setAddResultFile(boolean addresultfile) {
        this.addresultfile = addresultfile;
    }

    public LoadFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LoadFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getDynamicFilenameField() {
        return this.DynamicFilenameField;
    }

    public void setDynamicFilenameField(String DynamicFilenameField) {
        this.DynamicFilenameField = DynamicFilenameField;
    }

    public boolean getFileInFields() {
        return this.fileinfield;
    }

    public void setFileInFields(boolean IsInFields) {
        this.fileinfield = IsInFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean getIncludeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean getIncludeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        LoadFileInputMeta retval = (LoadFileInputMeta)((Object)super.clone());
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LoadFileInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)INCLUDE, (boolean)this.includeFilename));
        retval.append("    " + XmlHandler.addTagValue((String)INCLUDE_FIELD, (String)this.filenameField));
        retval.append("    " + XmlHandler.addTagValue((String)ROWNUM, (boolean)this.includeRowNumber));
        retval.append("    " + XmlHandler.addTagValue((String)ADDRESULTFILE, (boolean)this.addresultfile));
        retval.append("    " + XmlHandler.addTagValue((String)IS_IGNORE_EMPTY_FILE, (boolean)this.ignoreEmptyFile));
        retval.append("    " + XmlHandler.addTagValue((String)IS_IGNORE_MISSING_PATH, (boolean)this.ignoreMissingPath));
        retval.append("    " + XmlHandler.addTagValue((String)ROWNUM_FIELD, (String)this.rowNumberField));
        retval.append("    " + XmlHandler.addTagValue((String)ENCODING, (String)this.encoding));
        retval.append("    <file>" + Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      " + XmlHandler.addTagValue((String)NAME, (String)this.fileName[i]));
            retval.append("      " + XmlHandler.addTagValue((String)FILEMASK, (String)this.fileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)EXCLUDE_FILEMASK, (String)this.excludeFileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)FILE_REQUIRED, (String)this.fileRequired[i]));
            retval.append("      " + XmlHandler.addTagValue((String)INCLUDE_SUBFOLDERS, (String)this.includeSubFolders[i]));
        }
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            LoadFileInputField field = this.inputFields[i];
            retval.append(field.getXml());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XmlHandler.addTagValue((String)LIMIT, (long)this.rowLimit));
        retval.append("    " + XmlHandler.addTagValue((String)IS_IN_FIELDS, (boolean)this.fileinfield));
        retval.append("    " + XmlHandler.addTagValue((String)DYNAMIC_FILENAME_FIELD, (String)this.DynamicFilenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)SHORT_FILE_FIELD_NAME, (String)this.shortFileFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)PATH_FIELD_NAME, (String)this.pathFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)HIDDEN_FIELD_NAME, (String)this.hiddenFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)LAST_MODIFICATION_TIME_FIELD_NAME, (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)URI_NAME_FIELD_NAME, (String)this.uriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)ROOT_URI_NAME_FIELD_NAME, (String)this.rootUriNameFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)EXTENSION_FIELD_NAME, (String)this.extensionFieldName));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            int i;
            this.includeFilename = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)INCLUDE));
            this.filenameField = XmlHandler.getTagValue((Node)transformNode, (String)INCLUDE_FIELD);
            this.addresultfile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)ADDRESULTFILE));
            this.ignoreEmptyFile = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)IS_IGNORE_EMPTY_FILE));
            this.ignoreMissingPath = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)IS_IGNORE_MISSING_PATH));
            this.includeRowNumber = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)ROWNUM));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)ROWNUM_FIELD);
            this.encoding = XmlHandler.getTagValue((Node)transformNode, (String)ENCODING);
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)FILE);
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)FIELDS);
            int nrFiles = XmlHandler.countNodes((Node)filenode, (String)NAME);
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)NAME, (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)FILEMASK, (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)EXCLUDE_FILEMASK, (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)FILE_REQUIRED, (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)INCLUDE_SUBFOLDERS, (int)i);
                this.fileName[i] = XmlHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                LoadFileInputField field;
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new LoadFileInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)LIMIT), (long)0L);
            this.fileinfield = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)IS_IN_FIELDS));
            this.DynamicFilenameField = XmlHandler.getTagValue((Node)transformNode, (String)DYNAMIC_FILENAME_FIELD);
            this.shortFileFieldName = XmlHandler.getTagValue((Node)transformNode, (String)SHORT_FILE_FIELD_NAME);
            this.pathFieldName = XmlHandler.getTagValue((Node)transformNode, (String)PATH_FIELD_NAME);
            this.hiddenFieldName = XmlHandler.getTagValue((Node)transformNode, (String)HIDDEN_FIELD_NAME);
            this.lastModificationTimeFieldName = XmlHandler.getTagValue((Node)transformNode, (String)LAST_MODIFICATION_TIME_FIELD_NAME);
            this.uriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)URI_NAME_FIELD_NAME);
            this.rootUriNameFieldName = XmlHandler.getTagValue((Node)transformNode, (String)ROOT_URI_NAME_FIELD_NAME);
            this.extensionFieldName = XmlHandler.getTagValue((Node)transformNode, (String)EXTENSION_FIELD_NAME);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"LoadFileInputMeta.Exception.ErrorLoadingXml", (String[])new String[]{e.toString()}));
        }
    }

    public void allocate(int nrfiles, int nrFields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new LoadFileInputField[nrFields];
    }

    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.encoding = "";
        this.ignoreEmptyFile = false;
        this.ignoreMissingPath = false;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.addresultfile = true;
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LoadFileInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.fileinfield = false;
        this.DynamicFilenameField = null;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        if (!this.getFileInFields()) {
            r.clear();
        }
        for (int i = 0; i < this.inputFields.length; ++i) {
            LoadFileInputField field = this.inputFields[i];
            int type = field.getType();
            switch (field.getElementType()) {
                case 0: {
                    if (type != 0) break;
                    type = 2;
                    break;
                }
                case 1: {
                    if (type != 0) break;
                    type = 5;
                    break;
                }
            }
            try {
                IValueMeta v2 = ValueMetaFactory.createValueMeta((String)variables.resolve(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setConversionMask(field.getFormat());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setTrimType(field.getTrimType());
                v2.setOrigin(name);
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            v = new ValueMetaString(variables.resolve(this.filenameField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getShortFileNameField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getExtensionField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getPathField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMetaBoolean(variables.resolve(this.isHiddenField()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMetaDate(variables.resolve(this.getLastModificationDateField()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMetaString(variables.resolve(this.getRootUriField()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public FileInputList getFiles(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.getFileInFields()) {
            CheckResult cr;
            if (input.length == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            if (Utils.isEmpty((CharSequence)this.getDynamicFilenameField())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoField", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.FieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(variables);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.fileinfield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName[i]));
                    this.fileName[i] = iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public LoadFileInput createTransform(TransformMeta transformMeta, LoadFileInputData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new LoadFileInput(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public LoadFileInputData getTransformData() {
        return new LoadFileInputData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadFileInputMeta)) {
            return false;
        }
        LoadFileInputMeta that = (LoadFileInputMeta)((Object)o);
        if (this.ignoreEmptyFile != that.ignoreEmptyFile) {
            return false;
        }
        if (this.ignoreMissingPath != that.ignoreMissingPath) {
            return false;
        }
        if (this.addresultfile != that.addresultfile) {
            return false;
        }
        if (this.fileinfield != that.fileinfield) {
            return false;
        }
        if (this.includeFilename != that.includeFilename) {
            return false;
        }
        if (this.includeRowNumber != that.includeRowNumber) {
            return false;
        }
        if (this.rowLimit != that.rowLimit) {
            return false;
        }
        if (this.DynamicFilenameField != null ? !this.DynamicFilenameField.equals(that.DynamicFilenameField) : that.DynamicFilenameField != null) {
            return false;
        }
        if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) {
            return false;
        }
        if (!Arrays.equals(this.excludeFileMask, that.excludeFileMask)) {
            return false;
        }
        if (this.extensionFieldName != null ? !this.extensionFieldName.equals(that.extensionFieldName) : that.extensionFieldName != null) {
            return false;
        }
        if (!Arrays.equals(this.fileMask, that.fileMask)) {
            return false;
        }
        if (!Arrays.equals(this.fileName, that.fileName)) {
            return false;
        }
        if (!Arrays.equals(this.fileRequired, that.fileRequired)) {
            return false;
        }
        if (this.filenameField != null ? !this.filenameField.equals(that.filenameField) : that.filenameField != null) {
            return false;
        }
        if (this.hiddenFieldName != null ? !this.hiddenFieldName.equals(that.hiddenFieldName) : that.hiddenFieldName != null) {
            return false;
        }
        if (!Arrays.equals(this.includeSubFolders, that.includeSubFolders)) {
            return false;
        }
        if (!Arrays.equals(this.inputFields, that.inputFields)) {
            return false;
        }
        if (this.lastModificationTimeFieldName != null ? !this.lastModificationTimeFieldName.equals(that.lastModificationTimeFieldName) : that.lastModificationTimeFieldName != null) {
            return false;
        }
        if (this.pathFieldName != null ? !this.pathFieldName.equals(that.pathFieldName) : that.pathFieldName != null) {
            return false;
        }
        if (this.rootUriNameFieldName != null ? !this.rootUriNameFieldName.equals(that.rootUriNameFieldName) : that.rootUriNameFieldName != null) {
            return false;
        }
        if (this.rowNumberField != null ? !this.rowNumberField.equals(that.rowNumberField) : that.rowNumberField != null) {
            return false;
        }
        if (this.shortFileFieldName != null ? !this.shortFileFieldName.equals(that.shortFileFieldName) : that.shortFileFieldName != null) {
            return false;
        }
        return !(this.uriNameFieldName == null ? that.uriNameFieldName != null : !this.uriNameFieldName.equals(that.uriNameFieldName));
    }

    public int hashCode() {
        int result = this.fileName != null ? Arrays.hashCode(this.fileName) : 0;
        result = 31 * result + (this.fileMask != null ? Arrays.hashCode(this.fileMask) : 0);
        result = 31 * result + (this.excludeFileMask != null ? Arrays.hashCode(this.excludeFileMask) : 0);
        result = 31 * result + (this.includeFilename ? 1 : 0);
        result = 31 * result + (this.filenameField != null ? this.filenameField.hashCode() : 0);
        result = 31 * result + (this.includeRowNumber ? 1 : 0);
        result = 31 * result + (this.rowNumberField != null ? this.rowNumberField.hashCode() : 0);
        result = 31 * result + (int)(this.rowLimit ^ this.rowLimit >>> 32);
        result = 31 * result + (this.inputFields != null ? Arrays.hashCode(this.inputFields) : 0);
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        result = 31 * result + (this.DynamicFilenameField != null ? this.DynamicFilenameField.hashCode() : 0);
        result = 31 * result + (this.fileinfield ? 1 : 0);
        result = 31 * result + (this.addresultfile ? 1 : 0);
        result = 31 * result + (this.fileRequired != null ? Arrays.hashCode(this.fileRequired) : 0);
        result = 31 * result + (this.ignoreEmptyFile ? 1 : 0);
        result = 31 * result + (this.ignoreMissingPath ? 1 : 0);
        result = 31 * result + (this.includeSubFolders != null ? Arrays.hashCode(this.includeSubFolders) : 0);
        result = 31 * result + (this.shortFileFieldName != null ? this.shortFileFieldName.hashCode() : 0);
        result = 31 * result + (this.pathFieldName != null ? this.pathFieldName.hashCode() : 0);
        result = 31 * result + (this.hiddenFieldName != null ? this.hiddenFieldName.hashCode() : 0);
        result = 31 * result + (this.lastModificationTimeFieldName != null ? this.lastModificationTimeFieldName.hashCode() : 0);
        result = 31 * result + (this.uriNameFieldName != null ? this.uriNameFieldName.hashCode() : 0);
        result = 31 * result + (this.rootUriNameFieldName != null ? this.rootUriNameFieldName.hashCode() : 0);
        result = 31 * result + (this.extensionFieldName != null ? this.extensionFieldName.hashCode() : 0);
        return result;
    }
}

