/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.samplerows;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.samplerows.SampleRowsMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SampleRowsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SampleRowsMeta.class;
    private LabelTextVar wLinesRange;
    private FormData fdLinesRange;
    private FormData fdLineNumberField;
    private LabelTextVar wLineNumberField;
    private SampleRowsMeta input;

    public SampleRowsDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (SampleRowsMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SampleRowsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SampleRowsDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wLinesRange = new LabelTextVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"SampleRowsDialog.LinesRange.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SampleRowsDialog.LinesRange.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLinesRange);
        this.wLinesRange.addModifyListener(lsMod);
        this.fdLinesRange = new FormData();
        this.fdLinesRange.left = new FormAttachment(0, -margin);
        this.fdLinesRange.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        this.fdLinesRange.right = new FormAttachment(100, -margin);
        this.wLinesRange.setLayoutData((Object)this.fdLinesRange);
        this.wLineNumberField = new LabelTextVar(this.variables, (Composite)this.shell, BaseMessages.getString(PKG, (String)"SampleRowsDialog.LineNumberField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SampleRowsDialog.LineNumberField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLinesRange);
        this.wLineNumberField.addModifyListener(lsMod);
        this.fdLineNumberField = new FormData();
        this.fdLineNumberField.left = new FormAttachment(0, -margin);
        this.fdLineNumberField.top = new FormAttachment((Control)this.wLinesRange, 2 * margin);
        this.fdLineNumberField.right = new FormAttachment(100, -margin);
        this.wLineNumberField.setLayoutData((Object)this.fdLineNumberField);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wLineNumberField);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getLinesRange() != null) {
            this.wLinesRange.setText(Const.NVL((String)this.input.getLinesRange(), (String)SampleRowsMeta.DEFAULT_RANGE));
        }
        if (this.input.getLineNumberField() != null) {
            this.wLineNumberField.setText(this.input.getLineNumberField());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(SampleRowsMeta inf) {
        inf.setLinesRange(Const.NVL((String)this.wLinesRange.getText(), (String)SampleRowsMeta.DEFAULT_RANGE));
        inf.setLineNumberField(this.wLineNumberField.getText());
        this.transformName = this.wTransformName.getText();
    }
}

