/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.transform;

import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.debug.transform.TransformDebugLevel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ConditionEditor;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TransformDebugLevelDialog
extends Dialog {
    private static final Class<?> PKG = TransformDebugLevelDialog.class;
    private TransformDebugLevel input;
    private TransformDebugLevel debugLevel;
    private IRowMeta inputRowMeta;
    private Shell shell;
    private Combo wLogLevel;
    private Text wStartRow;
    private Text wEndRow;
    private ConditionEditor wCondition;
    private Control lastControl;
    private PropsUi props;
    private int middle;
    private int margin;
    private boolean ok;

    public TransformDebugLevelDialog(Shell par, TransformDebugLevel debugLevel, IRowMeta inputRowMeta) {
        super(par, 0);
        this.input = debugLevel;
        this.inputRowMeta = inputRowMeta;
        this.props = PropsUi.getInstance();
        this.ok = false;
        this.debugLevel = this.input.clone();
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageServer());
        this.middle = this.props.getMiddlePct();
        this.margin = 6;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText("Transform debug Level");
        this.shell.setLayout((Layout)formLayout);
        Label wlName = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlName);
        wlName.setText("Log level to set ");
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, this.margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(this.middle, -this.margin);
        wlName.setLayoutData((Object)fdlName);
        this.wLogLevel = new Combo((Composite)this.shell, 18436);
        this.wLogLevel.setItems(LogLevel.getLogLevelDescriptions());
        this.props.setLook((Control)this.wLogLevel);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(this.middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wLogLevel.setLayoutData((Object)fdName);
        this.lastControl = this.wLogLevel;
        Label wlStartRow = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlStartRow);
        wlStartRow.setText("Start row ");
        FormData fdlStartRow = new FormData();
        fdlStartRow.top = new FormAttachment(this.lastControl, this.margin);
        fdlStartRow.left = new FormAttachment(0, 0);
        fdlStartRow.right = new FormAttachment(this.middle, -this.margin);
        wlStartRow.setLayoutData((Object)fdlStartRow);
        this.wStartRow = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStartRow);
        FormData fdStartRow = new FormData();
        fdStartRow.top = new FormAttachment((Control)wlStartRow, 0, 0x1000000);
        fdStartRow.left = new FormAttachment(this.middle, 0);
        fdStartRow.right = new FormAttachment(100, 0);
        this.wStartRow.setLayoutData((Object)fdStartRow);
        this.lastControl = this.wStartRow;
        Label wlEndRow = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlEndRow);
        wlEndRow.setText("End row ");
        FormData fdlEndRow = new FormData();
        fdlEndRow.top = new FormAttachment(this.lastControl, this.margin);
        fdlEndRow.left = new FormAttachment(0, 0);
        fdlEndRow.right = new FormAttachment(this.middle, -this.margin);
        wlEndRow.setLayoutData((Object)fdlEndRow);
        this.wEndRow = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEndRow);
        FormData fdEndRow = new FormData();
        fdEndRow.top = new FormAttachment((Control)wlEndRow, 0, 0x1000000);
        fdEndRow.left = new FormAttachment(this.middle, 0);
        fdEndRow.right = new FormAttachment(100, 0);
        this.wEndRow.setLayoutData((Object)fdEndRow);
        this.lastControl = this.wEndRow;
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOK.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        Button[] buttons = new Button[]{wOK, wCancel};
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])buttons, (int)this.margin, null);
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TransformDebugLevelDialog.this.ok();
            }
        };
        this.wLogLevel.addSelectionListener((SelectionListener)selAdapter);
        this.wStartRow.addSelectionListener((SelectionListener)selAdapter);
        this.wEndRow.addSelectionListener((SelectionListener)selAdapter);
        Label wlCondition = new Label((Composite)this.shell, 131072);
        wlCondition.setText("Condition : ");
        this.props.setLook((Control)wlCondition);
        FormData fdlCondition = new FormData();
        fdlCondition.top = new FormAttachment(this.lastControl, this.margin);
        fdlCondition.left = new FormAttachment(0, 0);
        fdlCondition.right = new FormAttachment(this.middle, -this.margin);
        wlCondition.setLayoutData((Object)fdlCondition);
        this.wCondition = new ConditionEditor((Composite)this.shell, 0, this.debugLevel.getCondition(), this.inputRowMeta);
        this.props.setLook((Control)this.wCondition);
        FormData fdCondition = new FormData();
        fdCondition.top = new FormAttachment(this.lastControl, this.margin);
        fdCondition.left = new FormAttachment(this.middle, 0);
        fdCondition.right = new FormAttachment(100, 0);
        fdCondition.bottom = new FormAttachment((Control)wOK, 0);
        this.wCondition.setLayoutData((Object)fdCondition);
        this.lastControl = this.wCondition;
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.ok;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wLogLevel.setText(this.debugLevel.getLogLevel().getDescription());
        this.wStartRow.setText(this.debugLevel.getStartRow() < 0 ? "" : Integer.toString(this.debugLevel.getStartRow()));
        this.wEndRow.setText(this.debugLevel.getEndRow() < 0 ? "" : Integer.toString(this.debugLevel.getEndRow()));
        this.wLogLevel.setFocus();
    }

    private void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void ok() {
        this.getInfo(this.input);
        this.ok = true;
        this.dispose();
    }

    private void getInfo(TransformDebugLevel level) {
        int index = Const.indexOfString((String)this.wLogLevel.getText(), (String[])LogLevel.getLogLevelDescriptions());
        level.setLogLevel(LogLevel.values()[index]);
        level.setStartRow(Const.toInt((String)this.wStartRow.getText(), (int)-1));
        level.setEndRow(Const.toInt((String)this.wEndRow.getText(), (int)-1));
        level.setCondition(this.debugLevel.getCondition());
    }
}

