/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.mariadb;

import com.google.common.collect.Sets;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.util.Set;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.mysql.MySqlDatabaseMeta;
import org.apache.hop.i18n.BaseMessages;

@DatabaseMetaPlugin(type="MARIADB", typeDescription="MariaDB")
@GuiPlugin(id="GUI-MariaDBDatabaseMeta")
public class MariaDBDatabaseMeta
extends MySqlDatabaseMeta {
    private static final Class<?> PKG = MariaDBDatabaseMeta.class;
    private static final Set<String> SHORT_MESSAGE_EXCEPTIONS = Sets.newHashSet((Object[])new String[]{"org.mariadb.jdbc.internal.stream.MaxAllowedPacketException"});

    public String getDriverClass() {
        return "org.mariadb.jdbc.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (Utils.isEmpty((CharSequence)port)) {
            return "jdbc:mariadb://" + hostname + "/" + databaseName;
        }
        return "jdbc:mariadb://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean fullExceptionLog(Exception e) {
        Throwable cause = e == null ? null : e.getCause();
        return cause == null || !SHORT_MESSAGE_EXCEPTIONS.contains(cause.getClass().getName());
    }

    public String getLegacyColumnName(DatabaseMetaData dbMetaData, ResultSetMetaData rsMetaData, int index) throws HopDatabaseException {
        if (dbMetaData == null) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, (String)"MariaDBDatabaseMeta.Exception.LegacyColumnNameNoDBMetaDataException", (String[])new String[0]));
        }
        if (rsMetaData == null) {
            throw new HopDatabaseException(BaseMessages.getString(PKG, (String)"MariaDBDatabaseMeta.Exception.LegacyColumnNameNoRSMetaDataException", (String[])new String[0]));
        }
        try {
            return rsMetaData.getColumnLabel(index);
        }
        catch (Exception e) {
            throw new HopDatabaseException(String.format("%s: %s", BaseMessages.getString(PKG, (String)"MariaDBDatabaseMeta.Exception.LegacyColumnNameException", (String[])new String[0]), e.getMessage()), (Throwable)e);
        }
    }
}

