/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator;

import java.util.Objects;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMeta;

public class CalculatorMetaFunction
implements Cloneable {
    private static final Class<?> PKG = CalculatorMeta.class;
    @HopMetadataProperty(key="field_name", injectionKeyDescription="CalculatorMeta.Injection.Calculation.FieldName")
    private String fieldName;
    @HopMetadataProperty(key="calc_type", injectionKeyDescription="CalculatorMeta.Injection.Calculation.CalculationType", storeWithCode=true)
    private CalculationType calcType;
    @HopMetadataProperty(key="field_a", injectionKeyDescription="CalculatorMeta.Injection.Calculation.FieldA")
    private String fieldA;
    @HopMetadataProperty(key="field_b", injectionKeyDescription="CalculatorMeta.Injection.Calculation.FieldB")
    private String fieldB;
    @HopMetadataProperty(key="field_c", injectionKeyDescription="CalculatorMeta.Injection.Calculation.FieldC")
    private String fieldC;
    @HopMetadataProperty(key="value_type", injectionKeyDescription="CalculatorMeta.Injection.Calculation.ValueType")
    private String valueType;
    @HopMetadataProperty(key="value_length", injectionKeyDescription="CalculatorMeta.Injection.Calculation.ValueLength")
    private int valueLength;
    @HopMetadataProperty(key="value_precision", injectionKeyDescription="CalculatorMeta.Injection.Calculation.ValuePrecision")
    private int valuePrecision;
    @HopMetadataProperty(key="conversion_mask", injectionKeyDescription="CalculatorMeta.Injection.Calculation.ValueFormat")
    private String conversionMask;
    @HopMetadataProperty(key="decimal_symbol", injectionKeyDescription="CalculatorMeta.Injection.Calculation.ValueDecimal")
    private String decimalSymbol;
    @HopMetadataProperty(key="grouping_symbol", injectionKeyDescription="CalculatorMeta.Injection.Calculation.ValueGroup")
    private String groupingSymbol;
    @HopMetadataProperty(key="currency_symbol", injectionKeyDescription="CalculatorMeta.Injection.Calculation.ValueCurrency")
    private String currencySymbol;
    @HopMetadataProperty(key="remove", injectionKeyDescription="CalculatorMeta.Injection.Calculation.Remove")
    private boolean removedFromResult;

    public CalculatorMetaFunction() {
        this.calcType = CalculationType.NONE;
    }

    public CalculatorMetaFunction(String fieldName, CalculationType calcType, String fieldA, String fieldB, String fieldC, String valueType, int valueLength, int valuePrecision, String conversionMask, String decimalSymbol, String groupingSymbol, String currencySymbol, boolean removedFromResult) {
        this.fieldName = fieldName;
        this.calcType = calcType;
        this.fieldA = fieldA;
        this.fieldB = fieldB;
        this.fieldC = fieldC;
        this.valueType = valueType;
        this.valueLength = valueLength;
        this.valuePrecision = valuePrecision;
        this.conversionMask = conversionMask;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.currencySymbol = currencySymbol;
        this.removedFromResult = removedFromResult;
    }

    public CalculatorMetaFunction(CalculatorMetaFunction f) {
        this.fieldName = f.fieldName;
        this.calcType = f.calcType;
        this.fieldA = f.fieldA;
        this.fieldB = f.fieldB;
        this.fieldC = f.fieldC;
        this.valueType = f.valueType;
        this.valueLength = f.valueLength;
        this.valuePrecision = f.valuePrecision;
        this.conversionMask = f.conversionMask;
        this.decimalSymbol = f.decimalSymbol;
        this.groupingSymbol = f.groupingSymbol;
        this.currencySymbol = f.currencySymbol;
        this.removedFromResult = f.removedFromResult;
    }

    public CalculatorMetaFunction clone() {
        return new CalculatorMetaFunction(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalculatorMetaFunction that = (CalculatorMetaFunction)o;
        return this.valueLength == that.valueLength && this.valuePrecision == that.valuePrecision && this.removedFromResult == that.removedFromResult && Objects.equals(this.fieldName, that.fieldName) && this.calcType == that.calcType && Objects.equals(this.fieldA, that.fieldA) && Objects.equals(this.fieldB, that.fieldB) && Objects.equals(this.fieldC, that.fieldC) && Objects.equals(this.valueType, that.valueType) && Objects.equals(this.conversionMask, that.conversionMask) && Objects.equals(this.decimalSymbol, that.decimalSymbol) && Objects.equals(this.groupingSymbol, that.groupingSymbol) && Objects.equals(this.currencySymbol, that.currencySymbol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.calcType, this.fieldA, this.fieldB, this.fieldC, this.valueType, this.valueLength, this.valuePrecision, this.conversionMask, this.decimalSymbol, this.groupingSymbol, this.currencySymbol, this.removedFromResult});
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public CalculationType getCalcType() {
        return this.calcType;
    }

    public void setCalcType(CalculationType calcType) {
        this.calcType = calcType;
    }

    public String getFieldA() {
        return this.fieldA;
    }

    public void setFieldA(String fieldA) {
        this.fieldA = fieldA;
    }

    public String getFieldB() {
        return this.fieldB;
    }

    public void setFieldB(String fieldB) {
        this.fieldB = fieldB;
    }

    public String getFieldC() {
        return this.fieldC;
    }

    public void setFieldC(String fieldC) {
        this.fieldC = fieldC;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public void setValueLength(int valueLength) {
        this.valueLength = valueLength;
    }

    public int getValuePrecision() {
        return this.valuePrecision;
    }

    public void setValuePrecision(int valuePrecision) {
        this.valuePrecision = valuePrecision;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public boolean isRemovedFromResult() {
        return this.removedFromResult;
    }

    public void setRemovedFromResult(boolean removedFromResult) {
        this.removedFromResult = removedFromResult;
    }

    static /* synthetic */ Class access$000() {
        return PKG;
    }

    public static enum CalculationType implements IEnumHasCode
    {
        NONE("-", "-", 0),
        CONSTANT("CONSTANT", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.SetFieldToConstant", (String[])new String[0]), 2),
        COPY_OF_FIELD("COPY_FIELD", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.CreateCopyOfField", (String[])new String[0]), 0),
        ADD("ADD", "A + B", 1),
        SUBTRACT("SUBTRACT", "A - B", 1),
        MULTIPLY("MULTIPLY", "A * B", 1),
        DIVIDE("DIVIDE", "A / B", 1),
        SQUARE("SQUARE", "A * A", 1),
        SQUARE_ROOT("SQUARE_ROOT", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.SQRT", (String[])new String[0]), 1),
        PERCENT_1("PERCENT_1", "100 * A / B", 1),
        PERCENT_2("PERCENT_2", "A - ( A * B / 100 )", 1),
        PERCENT_3("PERCENT_3", "A + ( A * B / 100 )", 1),
        COMBINATION_1("COMBINATION_1", "A + B * C", 1),
        COMBINATION_2("COMBINATION_2", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Hypotenuse", (String[])new String[0]), 1),
        ROUND_1("ROUND_1", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Round", (String[])new String[0]), 5),
        ROUND_2("ROUND_2", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Round2", (String[])new String[0]), 1),
        ROUND_STD_1("ROUND_STD_1", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RoundStd", (String[])new String[0]), 5),
        ROUND_STD_2("ROUND_STD_2", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RoundStd2", (String[])new String[0]), 1),
        CEIL("CEIL", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Ceil", (String[])new String[0]), 5),
        FLOOR("FLOOR", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Floor", (String[])new String[0]), 5),
        NVL("NVL", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.NVL", (String[])new String[0]), 0),
        ADD_DAYS("ADD_DAYS", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DatePlusDays", (String[])new String[0]), 3),
        YEAR_OF_DATE("YEAR_OF_DATE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.YearOfDate", (String[])new String[0]), 5),
        MONTH_OF_DATE("MONTH_OF_DATE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.MonthOfDate", (String[])new String[0]), 5),
        DAY_OF_YEAR("DAY_OF_YEAR", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DayOfYear", (String[])new String[0]), 5),
        DAY_OF_MONTH("DAY_OF_MONTH", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DayOfMonth", (String[])new String[0]), 5),
        DAY_OF_WEEK("DAY_OF_WEEK", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DayOfWeek", (String[])new String[0]), 5),
        WEEK_OF_YEAR("WEEK_OF_YEAR", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.WeekOfYear", (String[])new String[0]), 5),
        WEEK_OF_YEAR_ISO8601("WEEK_OF_YEAR_ISO8601", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.WeekOfYearISO8601", (String[])new String[0]), 5),
        YEAR_OF_DATE_ISO8601("YEAR_OF_DATE_ISO8601", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.YearOfDateISO8601", (String[])new String[0]), 5),
        BYTE_TO_HEX_ENCODE("BYTE_TO_HEX_ENCODE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.ByteToHexEncode", (String[])new String[0]), 2),
        HEX_TO_BYTE_DECODE("HEX_TO_BYTE_DECODE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.HexToByteDecode", (String[])new String[0]), 2),
        CHAR_TO_HEX_ENCODE("CHAR_TO_HEX_ENCODE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.CharToHexEncode", (String[])new String[0]), 2),
        HEX_TO_CHAR_DECODE("HEX_TO_CHAR_DECODE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.HexToCharDecode", (String[])new String[0]), 2),
        CRC32("CRC32", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.CRC32", (String[])new String[0]), 5),
        ADLER32("ADLER32", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Adler32", (String[])new String[0]), 5),
        MD5("MD5", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.MD5", (String[])new String[0]), 2),
        SHA1("SHA1", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.SHA1", (String[])new String[0]), 2),
        LEVENSHTEIN_DISTANCE("LEVENSHTEIN_DISTANCE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.LevenshteinDistance", (String[])new String[0]), 5),
        METAPHONE("METAPHONE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Metaphone", (String[])new String[0]), 2),
        DOUBLE_METAPHONE("DOUBLE_METAPHONE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DoubleMetaphone", (String[])new String[0]), 2),
        ABS("ABS", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Abs", (String[])new String[0]), 5),
        REMOVE_TIME_FROM_DATE("REMOVE_TIME_FROM_DATE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RemoveTimeFromDate", (String[])new String[0]), 3),
        DATE_DIFF("DATE_DIFF", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DateDiff", (String[])new String[0]), 5),
        ADD3("ADD3", "A + B + C", 1),
        INITCAP("INIT_CAP", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.InitCap", (String[])new String[0]), 2),
        UPPER_CASE("UPPER_CASE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.UpperCase", (String[])new String[0]), 2),
        LOWER_CASE("LOWER_CASE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.LowerCase", (String[])new String[0]), 2),
        MASK_XML("MASK_XML", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.MaskXML", (String[])new String[0]), 2),
        USE_CDATA("USE_CDATA", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.UseCDATA", (String[])new String[0]), 2),
        REMOVE_CR("REMOVE_CR", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RemoveCR", (String[])new String[0]), 2),
        REMOVE_LF("REMOVE_LF", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RemoveLF", (String[])new String[0]), 2),
        REMOVE_CRLF("REMOVE_CRLF", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RemoveCRLF", (String[])new String[0]), 2),
        REMOVE_TAB("REMOVE_TAB", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RemoveTAB", (String[])new String[0]), 2),
        GET_ONLY_DIGITS("GET_ONLY_DIGITS", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.GetOnlyDigits", (String[])new String[0]), 2),
        REMOVE_DIGITS("REMOVE_DIGITS", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RemoveDigits", (String[])new String[0]), 2),
        STRING_LEN("STRING_LEN", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.StringLen", (String[])new String[0]), 5),
        LOAD_FILE_CONTENT_BINARY("LOAD_FILE_CONTENT_BINARY", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.LoadFileContentInBinary", (String[])new String[0]), 8),
        ADD_TIME_TO_DATE("ADD_TIME_TO_DATE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.AddTimeToDate", (String[])new String[0]), 3),
        QUARTER_OF_DATE("QUARTER_OF_DATE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.QuarterOfDate", (String[])new String[0]), 5),
        SUBSTITUTE_VARIABLE("SUBSTITUTE_VARIABLE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.SubstituteVariable", (String[])new String[0]), 2),
        UNESCAPE_XML("UNESCAPE_XML", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.UnescapeXML", (String[])new String[0]), 2),
        ESCAPE_HTML("ESCAPE_HTML", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.EscapeHTML", (String[])new String[0]), 2),
        UNESCAPE_HTML("UNESCAPE_HTML", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.UnescapeHTML", (String[])new String[0]), 2),
        ESCAPE_SQL("ESCAPE_SQL", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.EscapeSQL", (String[])new String[0]), 2),
        DATE_WORKING_DIFF("DATE_WORKING_DIFF", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DateDiffWorking", (String[])new String[0]), 5),
        ADD_MONTHS("ADD_MONTHS", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DatePlusMonths", (String[])new String[0]), 3),
        CHECK_XML_FILE_WELL_FORMED("CHECK_XML_FILE_WELL_FORMED", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.CheckXmlFileWellFormed", (String[])new String[0]), 4),
        CHECK_XML_WELL_FORMED("CHECK_XML_WELL_FORMED", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.CheckXmlWellFormed", (String[])new String[0]), 4),
        GET_FILE_ENCODING("GET_FILE_ENCODING", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.GetFileEncoding", (String[])new String[0]), 2),
        DAMERAU_LEVENSHTEIN("DAMERAU_LEVENSHTEIN", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DamerauLevenshtein", (String[])new String[0]), 5),
        NEEDLEMAN_WUNSH("NEEDLEMAN_WUNSH", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.NeedlemanWunsch", (String[])new String[0]), 5),
        JARO("JARO", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Jaro", (String[])new String[0]), 1),
        JARO_WINKLER("JARO_WINKLER", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.JaroWinkler", (String[])new String[0]), 1),
        SOUNDEX("SOUNDEX", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.SoundEx", (String[])new String[0]), 2),
        REFINED_SOUNDEX("REFINED_SOUNDEX", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RefinedSoundEx", (String[])new String[0]), 2),
        ADD_HOURS("ADD_HOURS", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DatePlusHours", (String[])new String[0]), 3),
        ADD_MINUTES("ADD_MINUTES", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DatePlusMinutes", (String[])new String[0]), 3),
        DATE_DIFF_MSEC("DATE_DIFF_MSEC", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DateDiffMsec", (String[])new String[0]), 5),
        DATE_DIFF_SEC("DATE_DIFF_SEC", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DateDiffSec", (String[])new String[0]), 5),
        DATE_DIFF_MN("DATE_DIFF_MN", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DateDiffMn", (String[])new String[0]), 5),
        DATE_DIFF_HR("DATE_DIFF_HR", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.DateDiffHr", (String[])new String[0]), 5),
        HOUR_OF_DAY("HOUR_OF_DAY", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.HourOfDay", (String[])new String[0]), 5),
        MINUTE_OF_HOUR("MINUTE_OF_HOUR", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.MinuteOfHour", (String[])new String[0]), 5),
        SECOND_OF_MINUTE("SECOND_OF_MINUTE", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.SecondOfMinute", (String[])new String[0]), 5),
        ROUND_CUSTOM_1("ROUND_CUSTOM_1", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RoundCustom", (String[])new String[0]), 1),
        ROUND_CUSTOM_2("ROUND_CUSTOM_2", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.RoundCustom2", (String[])new String[0]), 1),
        ADD_SECONDS("ADD_SECONDS", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.AddSeconds", (String[])new String[0]), 3),
        REMAINDER("REMAINDER", BaseMessages.getString((Class)CalculatorMetaFunction.access$000(), (String)"CalculatorMetaFunction.CalcFunctions.Remainder", (String[])new String[0]), 1);

        private String code;
        private String description;
        private int defaultResultType;

        private CalculationType(String code, String description, int defaultResultType) {
            this.code = code;
            this.description = description;
            this.defaultResultType = defaultResultType;
        }

        public static String[] getDescriptions() {
            String[] descriptions = new String[CalculationType.values().length];
            for (int i = 0; i < descriptions.length; ++i) {
                descriptions[i] = CalculationType.values()[i].getDescription();
            }
            return descriptions;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public int getDefaultResultType() {
            return this.defaultResultType;
        }

        public static CalculationType getTypeWithCode(String code) {
            for (CalculationType value : CalculationType.values()) {
                if (!value.getCode().equals(code)) continue;
                return value;
            }
            return NONE;
        }

        public static CalculationType getTypeWithDescription(String description) {
            for (CalculationType value : CalculationType.values()) {
                if (!value.getDescription().equals(description)) continue;
                return value;
            }
            return NONE;
        }
    }
}

