/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import java.math.BigDecimal;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.core.util.Utils;

@ValueMetaPlugin(id="11", name="JSON", description="JSON object", image="json.svg")
public class ValueMetaJson
extends ValueMetaBase
implements IValueMeta {
    public static final int TYPE_JSON = 11;
    private boolean prettyPrinting = true;

    public int compare(Object data1, Object data2) throws HopValueException {
        JsonNode json1 = (JsonNode)data1;
        JsonNode json2 = (JsonNode)data2;
        String string1 = this.convertJsonToString(json1);
        String string2 = this.convertJsonToString(json2);
        return string1.compareTo(string2);
    }

    public String convertJsonToString(JsonNode jsonNode) throws HopValueException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (this.prettyPrinting) {
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            }
            return objectMapper.writeValueAsString((Object)jsonNode);
        }
        catch (Exception e) {
            throw new HopValueException("Error converting JSON value to String", (Throwable)e);
        }
    }

    public JsonNode convertStringToJson(String jsonString) throws HopValueException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readTree(jsonString);
        }
        catch (Exception e) {
            throw new HopValueException("Error converting string to JSON value: '" + jsonString + "'", (Throwable)e);
        }
    }

    public ValueMetaJson() {
        this(null);
    }

    public ValueMetaJson(String name) {
        super(name, 11);
    }

    public JsonNode getJson(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        switch (this.type) {
            case 11: {
                switch (this.storageType) {
                    case 0: {
                        return (JsonNode)object;
                    }
                    case 1: {
                        return this.convertStringToJson(this.convertBinaryStringToString((byte[])object));
                    }
                    case 2: {
                        return (JsonNode)this.index[(Integer)object];
                    }
                }
                throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        return this.convertStringToJson((String)object);
                    }
                    case 1: {
                        return this.convertStringToJson((String)this.convertBinaryStringToNativeType((byte[])object));
                    }
                    case 2: {
                        return this.convertStringToJson((String)this.index[(Integer)object]);
                    }
                }
                throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
            }
            case 1: {
                Double number;
                switch (this.storageType) {
                    case 0: {
                        number = (Double)object;
                        break;
                    }
                    case 1: {
                        number = this.convertStringToNumber(this.convertBinaryStringToString((byte[])object));
                        break;
                    }
                    case 2: {
                        number = (Double)this.index[(Integer)object];
                        break;
                    }
                    default: {
                        throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                    }
                }
                return new DoubleNode(number.doubleValue());
            }
            case 5: {
                Long integer;
                switch (this.storageType) {
                    case 0: {
                        integer = (Long)object;
                        break;
                    }
                    case 1: {
                        integer = (Long)this.convertBinaryStringToNativeType((byte[])object);
                        break;
                    }
                    case 2: {
                        integer = (Long)this.index[(Integer)object];
                        break;
                    }
                    default: {
                        throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                    }
                }
                return new LongNode(integer.longValue());
            }
            case 6: {
                BigDecimal bigDecimal;
                switch (this.storageType) {
                    case 0: {
                        bigDecimal = (BigDecimal)object;
                        break;
                    }
                    case 1: {
                        bigDecimal = (BigDecimal)this.convertBinaryStringToNativeType((byte[])object);
                        break;
                    }
                    case 2: {
                        bigDecimal = (BigDecimal)this.index[(Integer)object];
                        break;
                    }
                    default: {
                        throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                    }
                }
                return new DecimalNode(bigDecimal);
            }
            case 4: {
                boolean bool;
                switch (this.storageType) {
                    case 0: {
                        bool = (Boolean)object;
                        break;
                    }
                    case 1: {
                        bool = (Boolean)this.convertBinaryStringToNativeType((byte[])object);
                        break;
                    }
                    case 2: {
                        bool = (Boolean)this.index[(Integer)object];
                        break;
                    }
                    default: {
                        throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                    }
                }
                return BooleanNode.valueOf((boolean)bool);
            }
            case 3: {
                throw new HopValueException(this.toString() + " : I don't know how to convert a date to a JSON object.");
            }
            case 9: {
                throw new HopValueException(this.toString() + " : I don't know how to convert a timestamp to a JSON object.");
            }
            case 8: {
                throw new HopValueException(this.toString() + " : I don't know how to convert a binary value to JSON object.");
            }
            case 7: {
                throw new HopValueException(this.toString() + " : I don't know how to convert a serializable value to JSON object.");
            }
        }
        throw new HopValueException(this.toString() + " : Unknown type " + this.type + " specified.");
    }

    public String getString(Object object) throws HopValueException {
        return this.convertJsonToString(this.getJson(object));
    }

    public byte[] getBinaryString(Object object) throws HopValueException {
        if (this.isStorageBinaryString() && this.identicalFormat) {
            return (byte[])object;
        }
        if (object == null) {
            return null;
        }
        switch (this.storageType) {
            case 0: {
                return this.convertStringToBinaryString(this.getString(object));
            }
            case 1: {
                return this.convertStringToBinaryString(this.getString(this.convertStringToJson(this.convertBinaryStringToString((byte[])object))));
            }
            case 2: {
                return this.convertStringToBinaryString(this.convertJsonToString((JsonNode)this.index[(Integer)object]));
            }
        }
        throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
    }

    public Object convertDataFromString(String pol, IValueMeta convertMeta, String nullIf, String ifNull, int trimType) throws HopValueException {
        String nullValue = nullIf;
        if (nullValue == null) {
            switch (convertMeta.getType()) {
                case 4: {
                    nullValue = "";
                    break;
                }
                case 2: {
                    nullValue = "";
                    break;
                }
                case 6: {
                    nullValue = "";
                    break;
                }
                case 1: {
                    nullValue = "";
                    break;
                }
                case 5: {
                    nullValue = "";
                    break;
                }
                case 3: {
                    nullValue = "";
                    break;
                }
                case 8: {
                    nullValue = "";
                    break;
                }
                default: {
                    nullValue = "";
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)ifNull) && (Utils.isEmpty((CharSequence)pol) || pol.equalsIgnoreCase(Const.rightPad((StringBuilder)new StringBuilder(nullValue), (int)pol.length())))) {
            pol = ifNull;
        }
        if (Utils.isEmpty((CharSequence)pol)) {
            return null;
        }
        if (!Utils.isEmpty((CharSequence)nullValue) ? nullValue.length() <= pol.length() && pol.equalsIgnoreCase(Const.rightPad((StringBuilder)new StringBuilder(nullValue), (int)pol.length())) : Const.onlySpaces((String)pol)) {
            return null;
        }
        switch (trimType) {
            case 1: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                pol = strpol.toString();
                break;
            }
            case 2: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
            case 3: {
                StringBuilder strpol = new StringBuilder(pol);
                while (strpol.length() > 0 && strpol.charAt(0) == ' ') {
                    strpol.deleteCharAt(0);
                }
                while (strpol.length() > 0 && strpol.charAt(strpol.length() - 1) == ' ') {
                    strpol.deleteCharAt(strpol.length() - 1);
                }
                pol = strpol.toString();
                break;
            }
        }
        return this.convertData(convertMeta, pol);
    }

    public Object convertData(IValueMeta meta2, Object data2) throws HopValueException {
        switch (meta2.getType()) {
            case 2: {
                return this.convertStringToJson(meta2.getString(data2));
            }
        }
        throw new HopValueException(meta2.toStringMeta() + " : can't be converted to an Internet Address");
    }

    public Object cloneValueData(Object object) throws HopValueException {
        JsonNode jsonNode = this.getJson(object);
        if (jsonNode == null) {
            return null;
        }
        try {
            String jsonString = this.convertJsonToString(jsonNode);
            return this.convertStringToJson(jsonString);
        }
        catch (Exception e) {
            throw new HopValueException("Unable to clone JSON value", (Throwable)e);
        }
    }

    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getJson(object);
    }

    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return JsonNode.class;
    }

    public boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }
}

