/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getsubfolders;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFolders;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFoldersData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="GetSubFolders", image="getsubfolders.svg", name="i18n::BaseTransform.TypeLongDesc.GetSubFolders", description="i18n::BaseTransform.TypeTooltipDesc.GetSubFolders", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/getsubfolders.html")
public class GetSubFoldersMeta
extends BaseTransformMeta
implements ITransformMeta<GetSubFolders, GetSubFoldersData> {
    private static final Class<?> PKG = GetSubFoldersMeta.class;
    public static final String[] RequiredFoldersDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFoldersCode = new String[]{"N", "Y"};
    public static final String NO = "N";
    private String[] folderName;
    private String[] folderRequired;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String dynamicFoldernameField;
    private boolean isFoldernameDynamic;
    private long rowLimit;

    public String getRequiredFilesDesc(String tt) {
        if (Utils.isEmpty((CharSequence)tt)) {
            return RequiredFoldersDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFoldersCode[1])) {
            return RequiredFoldersDesc[1];
        }
        return RequiredFoldersDesc[0];
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setDynamicFoldernameField(String dynamicFoldernameField) {
        this.dynamicFoldernameField = dynamicFoldernameField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getDynamicFoldernameField() {
        return this.dynamicFoldernameField;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public boolean isFoldernameDynamic() {
        return this.isFoldernameDynamic;
    }

    public void setFolderField(boolean isFoldernameDynamic) {
        this.isFoldernameDynamic = isFoldernameDynamic;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public String[] getFolderRequired() {
        return this.folderRequired;
    }

    public String getRequiredFoldersCode(String tt) {
        if (tt == null) {
            return RequiredFoldersCode[0];
        }
        if (tt.equals(RequiredFoldersDesc[1])) {
            return RequiredFoldersCode[1];
        }
        return RequiredFoldersCode[0];
    }

    public void setFolderRequired(String[] folderRequiredin) {
        this.folderRequired = new String[folderRequiredin.length];
        for (int i = 0; i < folderRequiredin.length; ++i) {
            this.folderRequired[i] = this.getRequiredFoldersCode(folderRequiredin[i]);
        }
    }

    public String[] getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String[] folderName) {
        this.folderName = folderName;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        GetSubFoldersMeta retval = (GetSubFoldersMeta)((Object)super.clone());
        int nrfiles = this.folderName.length;
        retval.allocate(nrfiles);
        System.arraycopy(this.folderName, 0, retval.folderName, 0, nrfiles);
        System.arraycopy(this.folderRequired, 0, retval.folderRequired, 0, nrfiles);
        return retval;
    }

    public void allocate(int nrfiles) {
        this.folderName = new String[nrfiles];
        this.folderRequired = new String[nrfiles];
    }

    public void setDefault() {
        int nrfiles = 0;
        this.isFoldernameDynamic = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFoldernameField = "";
        this.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            this.folderName[i] = "folderName" + (i + 1);
            this.folderRequired[i] = NO;
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString folderName = new ValueMetaString("folderName");
        folderName.setLength(500);
        folderName.setPrecision(-1);
        folderName.setOrigin(name);
        row.addValueMeta((IValueMeta)folderName);
        ValueMetaString shortFolderName = new ValueMetaString("short_folderName");
        shortFolderName.setLength(500);
        shortFolderName.setPrecision(-1);
        shortFolderName.setOrigin(name);
        row.addValueMeta((IValueMeta)shortFolderName);
        ValueMetaString path = new ValueMetaString("path");
        path.setLength(500);
        path.setPrecision(-1);
        path.setOrigin(name);
        row.addValueMeta((IValueMeta)path);
        ValueMetaBoolean ishidden = new ValueMetaBoolean("ishidden");
        ishidden.setOrigin(name);
        row.addValueMeta((IValueMeta)ishidden);
        ValueMetaBoolean isreadable = new ValueMetaBoolean("isreadable");
        isreadable.setOrigin(name);
        row.addValueMeta((IValueMeta)isreadable);
        ValueMetaBoolean iswriteable = new ValueMetaBoolean("iswriteable");
        iswriteable.setOrigin(name);
        row.addValueMeta((IValueMeta)iswriteable);
        ValueMetaDate lastmodifiedtime = new ValueMetaDate("lastmodifiedtime");
        lastmodifiedtime.setOrigin(name);
        row.addValueMeta((IValueMeta)lastmodifiedtime);
        ValueMetaString uri = new ValueMetaString("uri");
        uri.setOrigin(name);
        row.addValueMeta((IValueMeta)uri);
        ValueMetaString rooturi = new ValueMetaString("rooturi");
        rooturi.setOrigin(name);
        row.addValueMeta((IValueMeta)rooturi);
        ValueMetaInteger childrens = new ValueMetaInteger(variables.resolve("childrens"));
        childrens.setLength(10, 0);
        childrens.setOrigin(name);
        row.addValueMeta((IValueMeta)childrens);
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"foldername_dynamic", (boolean)this.isFoldernameDynamic));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"foldername_field", (String)this.dynamicFoldernameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.folderName.length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.folderName[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.folderRequired[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.includeRowNumber = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            this.isFoldernameDynamic = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"foldername_dynamic"));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.dynamicFoldernameField = XmlHandler.getTagValue((Node)transformNode, (String)"foldername_field");
            this.rowLimit = Const.toLong((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (long)0L);
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            int nrfiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                Node folderNamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node folderRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                this.folderName[i] = XmlHandler.getNodeValue((Node)folderNamenode);
                this.folderRequired[i] = XmlHandler.getNodeValue((Node)folderRequirednode);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public FileInputList getFolderList(IVariables variables) {
        return FileInputList.createFolderList((IVariables)variables, (String[])this.folderName, (String[])this.folderRequired);
    }

    public FileInputList getDynamicFolderList(IVariables variables, String[] folderName, String[] folderRequired) {
        return FileInputList.createFolderList((IVariables)variables, (String[])folderName, (String[])folderRequired);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.isFoldernameDynamic) {
            CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.InputOk", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.InputErrorKo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            cr = Utils.isEmpty((CharSequence)this.dynamicFoldernameField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.FolderFieldnameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.FolderFieldnameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            FileInputList fileList = this.getFolderList(variables);
            if (fileList.nrOfFiles() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.ExpectedFoldersError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetSubFoldersMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public GetSubFolders createTransform(TransformMeta transformMeta, GetSubFoldersData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new GetSubFolders(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public GetSubFoldersData getTransformData() {
        return new GetSubFoldersData();
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.isFoldernameDynamic) {
                for (int i = 0; i < this.folderName.length; ++i) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.folderName[i]));
                    this.folderName[i] = iResourceNaming.nameResource(fileObject, variables, true);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

