/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.spark_project.jetty.http.DateGenerator;
import org.spark_project.jetty.http.DateParser;
import org.spark_project.jetty.http.HttpField;
import org.spark_project.jetty.http.HttpHeader;
import org.spark_project.jetty.http.HttpHeaderValue;
import org.spark_project.jetty.http.QuotedCSV;
import org.spark_project.jetty.http.QuotedCSVParser;
import org.spark_project.jetty.http.QuotedQualityCSV;
import org.spark_project.jetty.util.ArrayTernaryTrie;
import org.spark_project.jetty.util.QuotedStringTokenizer;
import org.spark_project.jetty.util.Trie;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class HttpFields
implements Iterable<HttpField> {
    @Deprecated
    public static final String __separators = ", \t";
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    private HttpField[] _fields;
    private int _size;
    @Deprecated
    private static final Float __one = new Float("1.0");
    @Deprecated
    private static final Float __zero = new Float("0.0");
    @Deprecated
    private static final Trie<Float> __qualities = new ArrayTernaryTrie<Float>();

    public HttpFields() {
        this(16);
    }

    public HttpFields(int capacity) {
        this._fields = new HttpField[capacity];
    }

    public HttpFields(HttpFields fields) {
        this._fields = Arrays.copyOf(fields._fields, fields._fields.length);
        this._size = fields._size;
    }

    public void computeField(HttpHeader header, BiFunction<HttpHeader, List<HttpField>, HttpField> computeFn) {
        this.computeField(header, computeFn, (f, h) -> f.getHeader() == h);
    }

    public void computeField(String name2, BiFunction<String, List<HttpField>, HttpField> computeFn) {
        this.computeField(name2, computeFn, HttpField::is);
    }

    private <T> void computeField(T header, BiFunction<T, List<HttpField>, HttpField> computeFn, BiFunction<HttpField, T, Boolean> matcher) {
        int first2 = -1;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!matcher.apply(f, (HttpField)header).booleanValue()) continue;
            first2 = i;
            break;
        }
        if (first2 < 0) {
            HttpField newField = computeFn.apply(header, null);
            if (newField != null) {
                this.add(newField);
            }
            return;
        }
        List<Object> found = null;
        for (int i = first2 + 1; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!matcher.apply(f, (HttpField)header).booleanValue()) continue;
            if (found == null) {
                found = new ArrayList();
                found.add(this._fields[first2]);
            }
            found.add(f);
            this.remove(i--);
        }
        HttpField newField = computeFn.apply(header, found = found == null ? Collections.singletonList(this._fields[first2]) : Collections.unmodifiableList(found));
        if (newField == null) {
            this.remove(first2);
        } else {
            this._fields[first2] = newField;
        }
    }

    public int size() {
        return this._size;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return new ListItr();
    }

    public ListIterator<HttpField> listIterator() {
        return new ListItr();
    }

    public Stream<HttpField> stream() {
        return Arrays.stream(this._fields).limit(this._size);
    }

    public Set<String> getFieldNamesCollection() {
        HashSet<String> set2 = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (set2 == null) {
                set2 = new HashSet<String>();
            }
            set2.add(f.getName());
        }
        return set2 == null ? Collections.emptySet() : set2;
    }

    public Enumeration<String> getFieldNames() {
        return Collections.enumeration(this.getFieldNamesCollection());
    }

    public HttpField getField(int index) {
        if (index >= this._size) {
            throw new NoSuchElementException();
        }
        return this._fields[index];
    }

    public HttpField getField(HttpHeader header) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return f;
        }
        return null;
    }

    public HttpField getField(String name2) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(name2)) continue;
            return f;
        }
        return null;
    }

    public List<HttpField> getFields(HttpHeader header) {
        ArrayList<HttpField> fields = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            if (fields == null) {
                fields = new ArrayList<HttpField>();
            }
            fields.add(f);
        }
        return fields == null ? Collections.emptyList() : fields;
    }

    public List<HttpField> getFields(String name2) {
        ArrayList<HttpField> fields = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(name2)) continue;
            if (fields == null) {
                fields = new ArrayList<HttpField>();
            }
            fields.add(f);
        }
        return fields == null ? Collections.emptyList() : fields;
    }

    public boolean contains(HttpField field) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.isSameName(field) || !f.equals(field) && !f.contains(field.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header, String value2) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header || !f.contains(value2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name2, String value2) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.is(name2) || !f.contains(value2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader header) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String name2) {
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.is(name2)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public String getStringField(HttpHeader header) {
        return this.get(header);
    }

    public String get(HttpHeader header) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            return f.getValue();
        }
        return null;
    }

    @Deprecated
    public String getStringField(String name2) {
        return this.get(name2);
    }

    public String get(String header) {
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(header)) continue;
            return f.getValue();
        }
        return null;
    }

    public List<String> getValuesList(HttpHeader header) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            list.add(f.getValue());
        }
        return list;
    }

    public List<String> getValuesList(String name2) {
        ArrayList<String> list = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(name2)) continue;
            if (list == null) {
                list = new ArrayList<String>(this.size() - i);
            }
            list.add(f.getValue());
        }
        return list == null ? Collections.emptyList() : list;
    }

    public boolean addCSV(HttpHeader header, String ... values2) {
        QuotedCSVParser existing = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (f.getHeader() != header) continue;
            if (existing == null) {
                existing = new QuotedCSV(false, new String[0]);
            }
            existing.addValue(f.getValue());
        }
        String value2 = this.addCSV((QuotedCSV)existing, values2);
        if (value2 != null) {
            this.add(header, value2);
            return true;
        }
        return false;
    }

    public boolean addCSV(String name2, String ... values2) {
        QuotedCSVParser existing = null;
        for (int i = 0; i < this._size; ++i) {
            HttpField f = this._fields[i];
            if (!f.is(name2)) continue;
            if (existing == null) {
                existing = new QuotedCSV(false, new String[0]);
            }
            existing.addValue(f.getValue());
        }
        String value2 = this.addCSV((QuotedCSV)existing, values2);
        if (value2 != null) {
            this.add(name2, value2);
            return true;
        }
        return false;
    }

    protected String addCSV(QuotedCSV existing, String ... values2) {
        boolean add = true;
        if (existing != null && !existing.isEmpty()) {
            add = false;
            int i = values2.length;
            while (i-- > 0) {
                String unquoted = QuotedCSV.unquote(values2[i]);
                if (existing.getValues().contains(unquoted)) {
                    values2[i] = null;
                    continue;
                }
                add = true;
            }
        }
        if (add) {
            StringBuilder value2 = new StringBuilder();
            for (String v : values2) {
                if (v == null) continue;
                if (value2.length() > 0) {
                    value2.append(", ");
                }
                value2.append(v);
            }
            if (value2.length() > 0) {
                return value2.toString();
            }
        }
        return null;
    }

    public List<String> getCSV(HttpHeader header, boolean keepQuotes) {
        QuotedCSV values2 = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values2 == null) {
                values2 = new QuotedCSV(keepQuotes, new String[0]);
            }
            values2.addValue(f.getValue());
        }
        return values2 == null ? Collections.emptyList() : values2.getValues();
    }

    public List<String> getCSV(String name2, boolean keepQuotes) {
        QuotedCSV values2 = null;
        for (HttpField f : this) {
            if (!f.is(name2)) continue;
            if (values2 == null) {
                values2 = new QuotedCSV(keepQuotes, new String[0]);
            }
            values2.addValue(f.getValue());
        }
        return values2 == null ? Collections.emptyList() : values2.getValues();
    }

    public List<String> getQualityCSV(HttpHeader header) {
        return this.getQualityCSV(header, null);
    }

    public List<String> getQualityCSV(HttpHeader header, ToIntFunction<String> secondaryOrdering) {
        QuotedQualityCSV values2 = null;
        for (HttpField f : this) {
            if (f.getHeader() != header) continue;
            if (values2 == null) {
                values2 = new QuotedQualityCSV(secondaryOrdering);
            }
            values2.addValue(f.getValue());
        }
        return values2 == null ? Collections.emptyList() : values2.getValues();
    }

    public List<String> getQualityCSV(String name2) {
        QuotedQualityCSV values2 = null;
        for (HttpField f : this) {
            if (!f.is(name2)) continue;
            if (values2 == null) {
                values2 = new QuotedQualityCSV();
            }
            values2.addValue(f.getValue());
        }
        return values2 == null ? Collections.emptyList() : values2.getValues();
    }

    public Enumeration<String> getValues(final String name2) {
        for (int i = 0; i < this._size; ++i) {
            final HttpField f = this._fields[i];
            if (!f.is(name2) || f.getValue() == null) continue;
            final int first2 = i;
            return new Enumeration<String>(){
                HttpField field;
                int i;
                {
                    this.field = f;
                    this.i = first2 + 1;
                }

                @Override
                public boolean hasMoreElements() {
                    if (this.field == null) {
                        while (this.i < HttpFields.this._size) {
                            this.field = HttpFields.this._fields[this.i++];
                            if (!this.field.is(name2) || this.field.getValue() == null) continue;
                            return true;
                        }
                        this.field = null;
                        return false;
                    }
                    return true;
                }

                @Override
                public String nextElement() throws NoSuchElementException {
                    if (this.hasMoreElements()) {
                        String value2 = this.field.getValue();
                        this.field = null;
                        return value2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }
        List empty2 = Collections.emptyList();
        return Collections.enumeration(empty2);
    }

    @Deprecated
    public Enumeration<String> getValues(String name2, final String separators) {
        final Enumeration<String> e = this.getValues(name2);
        if (e == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value2 = (String)e.nextElement();
                    if (value2 == null) continue;
                    this.tok = new QuotedStringTokenizer(value2, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next2 = (String)this.tok.nextElement();
                if (next2 != null) {
                    next2 = next2.trim();
                }
                return next2;
            }
        };
    }

    public void put(HttpField field) {
        boolean put2 = false;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.isSameName(field)) continue;
            if (put2) {
                --this._size;
                System.arraycopy(this._fields, i + 1, this._fields, i, this._size - i);
                continue;
            }
            this._fields[i] = field;
            put2 = true;
        }
        if (!put2) {
            this.add(field);
        }
    }

    public void put(String name2, String value2) {
        if (value2 == null) {
            this.remove(name2);
        } else {
            this.put(new HttpField(name2, value2));
        }
    }

    public void put(HttpHeader header, HttpHeaderValue value2) {
        this.put(header, value2.toString());
    }

    public void put(HttpHeader header, String value2) {
        Objects.requireNonNull(header, "header must not be null");
        if (value2 == null) {
            this.remove(header);
        } else {
            this.put(new HttpField(header, value2));
        }
    }

    public void put(String name2, List<String> list) {
        Objects.requireNonNull(name2, "name must not be null");
        this.remove(name2);
        if (list == null) {
            return;
        }
        for (String v : list) {
            if (v == null) continue;
            this.add(name2, v);
        }
    }

    public void add(String name2, String value2) {
        if (value2 == null) {
            return;
        }
        HttpField field = new HttpField(name2, value2);
        this.add(field);
    }

    public void add(HttpHeader header, HttpHeaderValue value2) {
        if (value2 != null) {
            this.add(header, value2.toString());
        }
    }

    public void add(HttpHeader header, String value2) {
        Objects.requireNonNull(header, "header must not be null");
        if (value2 == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField field = new HttpField(header, value2);
        this.add(field);
    }

    public HttpField remove(HttpHeader name2) {
        HttpField removed = null;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (f.getHeader() != name2) continue;
            removed = f;
            this.remove(i);
        }
        return removed;
    }

    public HttpField remove(String name2) {
        HttpField removed = null;
        int i = this._size;
        while (i-- > 0) {
            HttpField f = this._fields[i];
            if (!f.is(name2)) continue;
            removed = f;
            this.remove(i);
        }
        return removed;
    }

    private void remove(int i) {
        --this._size;
        System.arraycopy(this._fields, i + 1, this._fields, i, this._size - i);
        this._fields[this._size] = null;
    }

    public long getLongField(String name2) throws NumberFormatException {
        HttpField field = this.getField(name2);
        return field == null ? -1L : field.getLongValue();
    }

    public long getDateField(String name2) {
        HttpField field = this.getField(name2);
        if (field == null) {
            return -1L;
        }
        String val = HttpFields.valueParameters(field.getValue(), null);
        if (val == null) {
            return -1L;
        }
        long date = DateParser.parseDate(val);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        return date;
    }

    public void putLongField(HttpHeader name2, long value2) {
        String v = Long.toString(value2);
        this.put(name2, v);
    }

    public void putLongField(String name2, long value2) {
        String v = Long.toString(value2);
        this.put(name2, v);
    }

    public void putDateField(HttpHeader name2, long date) {
        String d = DateGenerator.formatDate(date);
        this.put(name2, d);
    }

    public void putDateField(String name2, long date) {
        String d = DateGenerator.formatDate(date);
        this.put(name2, d);
    }

    public void addDateField(String name2, long date) {
        String d = DateGenerator.formatDate(date);
        this.add(name2, d);
    }

    public int hashCode() {
        int hash = 0;
        for (HttpField field : this._fields) {
            hash += field.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpFields)) {
            return false;
        }
        HttpFields that = (HttpFields)o;
        if (this.size() != that.size()) {
            return false;
        }
        block0: for (HttpField fi : this) {
            for (HttpField fa : that) {
                if (!fi.equals(fa)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            StringBuilder buffer = new StringBuilder();
            for (HttpField field : this) {
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = field.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e) {
            LOG.warn(e);
            return e.toString();
        }
    }

    public void clear() {
        this._size = 0;
    }

    public void add(HttpField field) {
        if (field != null) {
            if (this._size == this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size * 2);
            }
            this._fields[this._size++] = field;
        }
    }

    public void addAll(HttpFields fields) {
        for (int i = 0; i < fields._size; ++i) {
            this.add(fields._fields[i]);
        }
    }

    @Deprecated
    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name2 = e.nextElement();
            Enumeration<String> values2 = fields.getValues(name2);
            while (values2.hasMoreElements()) {
                this.add(name2, values2.nextElement());
            }
        }
    }

    public static String stripParameters(String value2) {
        if (value2 == null) {
            return null;
        }
        int i = value2.indexOf(59);
        if (i < 0) {
            return value2;
        }
        return value2.substring(0, i).trim();
    }

    public static String valueParameters(String value2, Map<String, String> parameters) {
        if (value2 == null) {
            return null;
        }
        int i = value2.indexOf(59);
        if (i < 0) {
            return value2;
        }
        if (parameters == null) {
            return value2.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value2.substring(i), ";", false, true);
        while (((StringTokenizer)tok1).hasMoreTokens()) {
            String token = ((StringTokenizer)tok1).nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!((StringTokenizer)tok2).hasMoreTokens()) continue;
            String paramName = ((StringTokenizer)tok2).nextToken();
            String paramVal = null;
            if (((StringTokenizer)tok2).hasMoreTokens()) {
                paramVal = ((StringTokenizer)tok2).nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value2.substring(0, i).trim();
    }

    @Deprecated
    public static Float getQuality(String value2) {
        Float q;
        Float q2;
        if (value2 == null) {
            return __zero;
        }
        int qe = value2.indexOf(";");
        if (qe++ < 0 || qe == value2.length()) {
            return __one;
        }
        if (value2.charAt(qe++) == 'q' && (q2 = __qualities.get(value2, ++qe, value2.length() - qe)) != null) {
            return q2;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        HttpFields.valueParameters(value2, params);
        String qs = (String)params.get("q");
        if (qs == null) {
            qs = "*";
        }
        if ((q = __qualities.get(qs)) == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    @Deprecated
    public static List<String> qualityList(Enumeration<String> e) {
        if (e == null || !e.hasMoreElements()) {
            return Collections.emptyList();
        }
        QuotedQualityCSV values2 = new QuotedQualityCSV();
        while (e.hasMoreElements()) {
            values2.addValue(e.nextElement());
        }
        return values2.getValues();
    }

    static /* synthetic */ HttpField[] access$202(HttpFields x0, HttpField[] x1) {
        x0._fields = x1;
        return x1;
    }

    static {
        __qualities.put("*", __one);
        __qualities.put("1.0", __one);
        __qualities.put("1", __one);
        __qualities.put("0.9", new Float("0.9"));
        __qualities.put("0.8", new Float("0.8"));
        __qualities.put("0.7", new Float("0.7"));
        __qualities.put("0.66", new Float("0.66"));
        __qualities.put("0.6", new Float("0.6"));
        __qualities.put("0.5", new Float("0.5"));
        __qualities.put("0.4", new Float("0.4"));
        __qualities.put("0.33", new Float("0.33"));
        __qualities.put("0.3", new Float("0.3"));
        __qualities.put("0.2", new Float("0.2"));
        __qualities.put("0.1", new Float("0.1"));
        __qualities.put("0", __zero);
        __qualities.put("0.0", __zero);
    }

    private class ListItr
    implements ListIterator<HttpField> {
        int _cursor;
        int _current = -1;

        private ListItr() {
        }

        @Override
        public boolean hasNext() {
            return this._cursor != HttpFields.this._size;
        }

        @Override
        public HttpField next() {
            if (this._cursor == HttpFields.this._size) {
                throw new NoSuchElementException();
            }
            this._current = this._cursor++;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public void remove() {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            HttpFields.this.remove(this._current);
            ((HttpFields)HttpFields.this)._fields[((HttpFields)HttpFields.this)._size] = null;
            this._cursor = this._current;
            this._current = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public HttpField previous() {
            if (this._cursor == 0) {
                throw new NoSuchElementException();
            }
            this._current = --this._cursor;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public int nextIndex() {
            return this._cursor;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void set(HttpField field) {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            if (field == null) {
                this.remove();
            } else {
                ((HttpFields)HttpFields.this)._fields[this._current] = field;
            }
        }

        @Override
        public void add(HttpField field) {
            if (field != null) {
                HttpFields.access$202(HttpFields.this, Arrays.copyOf(HttpFields.this._fields, HttpFields.this._fields.length + 1));
                System.arraycopy(HttpFields.this._fields, this._cursor, HttpFields.this._fields, this._cursor + 1, HttpFields.this._size - this._cursor);
                ((HttpFields)HttpFields.this)._fields[this._cursor++] = field;
                HttpFields.this._size++;
                this._current = -1;
            }
        }
    }
}

