/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getserversequence;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getserversequence.GetServerSequenceData;
import org.apache.hop.pipeline.transforms.getserversequence.GetServerSequenceMeta;

public class GetServerSequence
extends BaseTransform<GetServerSequenceMeta, GetServerSequenceData>
implements ITransform<GetServerSequenceMeta, GetServerSequenceData> {
    private static final Class<?> PKG = GetServerSequence.class;

    public GetServerSequence(TransformMeta transformMeta, GetServerSequenceMeta meta, GetServerSequenceData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public Object[] addSequence(IRowMeta inputRowMeta, Object[] inputRowData) throws HopException {
        Long next = null;
        if (((GetServerSequenceData)this.data).value >= ((GetServerSequenceData)this.data).startValue + ((GetServerSequenceData)this.data).increment) {
            ((GetServerSequenceData)this.data).value = ((GetServerSequenceData)this.data).startValue = ((GetServerSequenceData)this.data).hopServer.getNextServerSequenceValue((IVariables)this, ((GetServerSequenceData)this.data).sequenceName, ((GetServerSequenceData)this.data).increment);
        }
        next = ((GetServerSequenceData)this.data).value;
        ++((GetServerSequenceData)this.data).value;
        if (next != null) {
            Object[] outputRowData = inputRowData;
            if (inputRowData.length < inputRowMeta.size() + 1) {
                outputRowData = RowDataUtil.resizeArray((Object[])inputRowData, (int)(inputRowMeta.size() + 1));
            }
            outputRowData[inputRowMeta.size()] = next;
            return outputRowData;
        }
        throw new HopTransformException(BaseMessages.getString(PKG, (String)"GetSequence.Exception.CouldNotFindNextValueForSequence", (String[])new String[0]) + ((GetServerSequenceMeta)this.meta).getValuename());
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((GetServerSequenceData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((GetServerSequenceMeta)this.meta).getFields(((GetServerSequenceData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((GetServerSequenceData)this.data).value = ((GetServerSequenceData)this.data).startValue = ((GetServerSequenceData)this.data).hopServer.getNextServerSequenceValue((IVariables)this, ((GetServerSequenceData)this.data).sequenceName, ((GetServerSequenceData)this.data).increment);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"GetSequence.Log.ReadRow", (String[])new String[0]) + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            this.putRow(((GetServerSequenceData)this.data).outputRowMeta, this.addSequence(this.getInputRowMeta(), r));
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"GetSequence.Log.WriteRow", (String[])new String[0]) + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"GetSequence.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetSequence.Log.ErrorInTransform", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((GetServerSequenceData)this.data).increment = Const.toLong((String)this.resolve(((GetServerSequenceMeta)this.meta).getIncrement()), (long)1000L);
            ((GetServerSequenceData)this.data).hopServer = this.getPipelineMeta().findHopServer(this.resolve(((GetServerSequenceMeta)this.meta).getHopServerName()));
            ((GetServerSequenceData)this.data).sequenceName = this.resolve(((GetServerSequenceMeta)this.meta).getSequenceName());
            ((GetServerSequenceData)this.data).value = -1L;
            return true;
        }
        return false;
    }
}

