/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.vectorwise;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.ingres.IngresDatabaseMeta;

@DatabaseMetaPlugin(type="VECTORWISE", typeDescription="Ingres VectorWise")
@GuiPlugin(id="GUI-VectorWiseDatabaseMeta")
public class VectorWiseDatabaseMeta
extends IngresDatabaseMeta
implements IDatabase {
    public String getURL(String hostname, String port, String databaseName) {
        if (Utils.isEmpty((CharSequence)port) || "-1".equals(port)) {
            return "jdbc:ingres://" + hostname + ":VW7/" + databaseName;
        }
        return "jdbc:ingres://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = retval + "GENERATED ALWAYS AS IDENTITY START WITH 1 INCREMENT BY 1";
                        break;
                    }
                    retval = retval + "BIGINT PRIMARY KEY NOT NULL";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length == -1 || length > 4) {
                        retval = retval + "INTEGER";
                        break;
                    }
                    if (length > 2) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER1";
                    break;
                }
                retval = retval + "FLOAT8";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length > 32000) {
                        retval = retval + "VARCHAR(32000)";
                        break;
                    }
                    retval = retval + "VARCHAR(" + length + ")";
                    break;
                }
                retval = retval + "VARCHAR(9999)";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String getTruncateTableStatement(String tableName) {
        return "CALL VECTORWISE( COMBINE '" + tableName + " - " + tableName + "' )";
    }

    public boolean supportsGetBlob() {
        return false;
    }
}

