/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.selectvalues;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.selectvalues.SelectMetadataChange;
import org.apache.hop.pipeline.transforms.selectvalues.SelectValuesMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SelectValuesDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SelectValuesMeta.class;
    private CTabFolder wTabFolder;
    private TableView wFields;
    private Button wUnspecified;
    private TableView wRemove;
    private TableView wMeta;
    private final SelectValuesMeta input;
    private final List<ColumnInfo> fieldColumns = new ArrayList<ColumnInfo>();
    private String[] charsets = null;
    private IRowMeta prevFields;
    private boolean bPreviousFieldsLoaded = false;
    private final Map<String, Integer> inputFields;

    public SelectValuesDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (SelectValuesMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SelectValuesDialog.this.input.setChanged();
            }
        };
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        CTabItem wSelectTab = new CTabItem(this.wTabFolder, 0);
        wSelectTab.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.SelectTab.TabItem", (String[])new String[0]));
        Composite wSelectComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSelectComp);
        FormLayout selectLayout = new FormLayout();
        selectLayout.marginWidth = margin;
        selectLayout.marginHeight = margin;
        wSelectComp.setLayout((Layout)selectLayout);
        Label wlUnspecified = new Label(wSelectComp, 131072);
        wlUnspecified.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.Unspecified.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUnspecified);
        FormData fdlUnspecified = new FormData();
        fdlUnspecified.left = new FormAttachment(0, 0);
        fdlUnspecified.right = new FormAttachment(middle, 0);
        fdlUnspecified.bottom = new FormAttachment(100, 0);
        wlUnspecified.setLayoutData((Object)fdlUnspecified);
        this.wUnspecified = new Button(wSelectComp, 32);
        this.props.setLook((Control)this.wUnspecified);
        FormData fdUnspecified = new FormData();
        fdUnspecified.left = new FormAttachment(middle, margin);
        fdUnspecified.right = new FormAttachment(100, 0);
        fdUnspecified.bottom = new FormAttachment((Control)wlUnspecified, 0, 0x1000000);
        this.wUnspecified.setLayoutData((Object)fdUnspecified);
        this.wUnspecified.addSelectionListener((SelectionListener)lsSel);
        Label wlFields = new Label(wSelectComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int fieldsCols = 4;
        int fieldsRows = this.input.getSelectFields().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Fieldname", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Loading", (String[])new String[0])}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.RenameTo", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.fieldColumns.add(colinf[0]);
        this.wFields = new TableView(this.variables, wSelectComp, 67586, colinf, fieldsRows, lsMod, this.props);
        Button wGetSelect = new Button(wSelectComp, 8);
        wGetSelect.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.GetSelect.Button", (String[])new String[0]));
        wGetSelect.addListener(13, e -> this.get());
        FormData fdGetSelect = new FormData();
        fdGetSelect.right = new FormAttachment(100, 0);
        fdGetSelect.top = new FormAttachment((Control)wlFields, margin);
        wGetSelect.setLayoutData((Object)fdGetSelect);
        Button wDoMapping = new Button(wSelectComp, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.Button", (String[])new String[0]));
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        fdGetSelect = new FormData();
        fdGetSelect.right = new FormAttachment(100, 0);
        fdGetSelect.top = new FormAttachment((Control)wGetSelect, 0);
        wDoMapping.setLayoutData((Object)fdGetSelect);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)wGetSelect, -margin);
        fdFields.bottom = new FormAttachment((Control)wlUnspecified, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdSelectComp = new FormData();
        fdSelectComp.left = new FormAttachment(0, 0);
        fdSelectComp.top = new FormAttachment(0, 0);
        fdSelectComp.right = new FormAttachment(100, 0);
        fdSelectComp.bottom = new FormAttachment(100, 0);
        wSelectComp.setLayoutData((Object)fdSelectComp);
        wSelectComp.layout();
        wSelectTab.setControl((Control)wSelectComp);
        CTabItem wRemoveTab = new CTabItem(this.wTabFolder, 0);
        wRemoveTab.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.RemoveTab.TabItem", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = margin;
        contentLayout.marginHeight = margin;
        Composite wRemoveComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wRemoveComp);
        wRemoveComp.setLayout((Layout)contentLayout);
        Label wlRemove = new Label(wRemoveComp, 0);
        wlRemove.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.Remove.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRemove);
        FormData fdlRemove = new FormData();
        fdlRemove.left = new FormAttachment(0, 0);
        fdlRemove.top = new FormAttachment(0, 0);
        wlRemove.setLayoutData((Object)fdlRemove);
        boolean RemoveCols = true;
        int RemoveRows = this.input.getDeleteName().length;
        ColumnInfo[] colrem = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Fieldname", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Loading", (String[])new String[0])}, false)};
        this.fieldColumns.add(colrem[0]);
        this.wRemove = new TableView(this.variables, wRemoveComp, 67586, colrem, RemoveRows, lsMod, this.props);
        Button wGetRemove = new Button(wRemoveComp, 8);
        wGetRemove.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.GetRemove.Button", (String[])new String[0]));
        wGetRemove.addListener(13, e -> this.get());
        FormData fdGetRemove = new FormData();
        fdGetRemove.right = new FormAttachment(100, 0);
        fdGetRemove.top = new FormAttachment(50, 0);
        wGetRemove.setLayoutData((Object)fdGetRemove);
        FormData fdRemove = new FormData();
        fdRemove.left = new FormAttachment(0, 0);
        fdRemove.top = new FormAttachment((Control)wlRemove, margin);
        fdRemove.right = new FormAttachment((Control)wGetRemove, -margin);
        fdRemove.bottom = new FormAttachment(100, 0);
        this.wRemove.setLayoutData((Object)fdRemove);
        FormData fdRemoveComp = new FormData();
        fdRemoveComp.left = new FormAttachment(0, 0);
        fdRemoveComp.top = new FormAttachment(0, 0);
        fdRemoveComp.right = new FormAttachment(100, 0);
        fdRemoveComp.bottom = new FormAttachment(100, 0);
        wRemoveComp.setLayoutData((Object)fdRemoveComp);
        wRemoveComp.layout();
        wRemoveTab.setControl((Control)wRemoveComp);
        CTabItem wMetaTab = new CTabItem(this.wTabFolder, 0);
        wMetaTab.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.MetaTab.TabItem", (String[])new String[0]));
        Composite wMetaComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wMetaComp);
        FormLayout metaLayout = new FormLayout();
        metaLayout.marginWidth = margin;
        metaLayout.marginHeight = margin;
        wMetaComp.setLayout((Layout)metaLayout);
        Label wlMeta = new Label(wMetaComp, 0);
        wlMeta.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.Meta.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMeta);
        FormData fdlMeta = new FormData();
        fdlMeta.left = new FormAttachment(0, 0);
        fdlMeta.top = new FormAttachment(0, 0);
        wlMeta.setLayoutData((Object)fdlMeta);
        int MetaRows = this.input.getMeta().length;
        ColumnInfo[] colmeta = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Fieldname", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Loading", (String[])new String[0])}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Renameto", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getAllValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Storage.Label", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Format", (String[])new String[0]), 5, 3), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.DateLenient", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.DateFormatLocale", (String[])new String[0]), 2, EnvUtil.getLocaleList()), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.DateFormatTimeZone", (String[])new String[0]), 2, EnvUtil.getTimeZones()), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.LenientStringToNumber", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Encoding", (String[])new String[0]), 2, this.getCharsets(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Grouping", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Currency", (String[])new String[0]), 1, false)};
        colmeta[5].setToolTip(BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Storage.Tooltip", (String[])new String[0]));
        this.fieldColumns.add(colmeta[0]);
        this.wMeta = new TableView(this.variables, wMetaComp, 67586, colmeta, MetaRows, lsMod, this.props);
        Button wGetMeta = new Button(wMetaComp, 8);
        wGetMeta.setText(BaseMessages.getString(PKG, (String)"SelectValuesDialog.GetMeta.Button", (String[])new String[0]));
        wGetMeta.addListener(13, e -> this.get());
        FormData fdGetMeta = new FormData();
        fdGetMeta.right = new FormAttachment(100, 0);
        fdGetMeta.top = new FormAttachment(50, 0);
        wGetMeta.setLayoutData((Object)fdGetMeta);
        FormData fdMeta = new FormData();
        fdMeta.left = new FormAttachment(0, 0);
        fdMeta.top = new FormAttachment((Control)wlMeta, margin);
        fdMeta.right = new FormAttachment((Control)wGetMeta, -margin);
        fdMeta.bottom = new FormAttachment(100, 0);
        this.wMeta.setLayoutData((Object)fdMeta);
        FormData fdMetaComp = new FormData();
        fdMetaComp.left = new FormAttachment(0, 0);
        fdMetaComp.top = new FormAttachment(0, 0);
        fdMetaComp.right = new FormAttachment(100, 0);
        fdMetaComp.bottom = new FormAttachment(100, 0);
        wMetaComp.setLayoutData((Object)fdMetaComp);
        wMetaComp.layout();
        wMetaTab.setControl((Control)wMetaComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row;
                    this.prevFields = row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        this.input.setChanged(this.changed);
        this.setComboValues();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setComboValues() {
        Runnable fieldLoader = () -> {
            try {
                this.prevFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            }
            catch (HopException e) {
                this.prevFields = new RowMeta();
                String msg = BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                this.logError(msg);
            }
            Object[] prevTransformFieldNames = this.prevFields != null ? this.prevFields.getFieldNames() : new String[]{};
            Arrays.sort(prevTransformFieldNames);
            this.bPreviousFieldsLoaded = true;
            for (ColumnInfo colInfo : this.fieldColumns) {
                colInfo.setComboValues((String[])prevTransformFieldNames);
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        TableItem item;
        int i;
        this.wTabFolder.setSelection(0);
        if (this.input.getSelectFields() != null && this.input.getSelectFields().length > 0) {
            for (i = 0; i < this.input.getSelectFields().length; ++i) {
                item = this.wFields.table.getItem(i);
                if (this.input.getSelectFields()[i].getName() != null) {
                    item.setText(1, this.input.getSelectFields()[i].getName());
                }
                if (this.input.getSelectFields()[i].getRename() != null && !this.input.getSelectFields()[i].getRename().equals(this.input.getSelectFields()[i].getName())) {
                    item.setText(2, this.input.getSelectFields()[i].getRename());
                }
                item.setText(3, this.input.getSelectFields()[i].getLength() < 0 ? "" : "" + this.input.getSelectFields()[i].getLength());
                item.setText(4, this.input.getSelectFields()[i].getPrecision() < 0 ? "" : "" + this.input.getSelectFields()[i].getPrecision());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
            this.wTabFolder.setSelection(0);
        }
        this.wUnspecified.setSelection(this.input.isSelectingAndSortingUnspecifiedFields());
        if (this.input.getDeleteName() != null && this.input.getDeleteName().length > 0) {
            for (i = 0; i < this.input.getDeleteName().length; ++i) {
                item = this.wRemove.table.getItem(i);
                if (this.input.getDeleteName()[i] == null) continue;
                item.setText(1, this.input.getDeleteName()[i]);
            }
            this.wRemove.setRowNums();
            this.wRemove.optWidth(true);
            this.wTabFolder.setSelection(1);
        }
        if (!Utils.isEmpty((Object[])this.input.getMeta())) {
            for (i = 0; i < this.input.getMeta().length; ++i) {
                SelectMetadataChange change = this.input.getMeta()[i];
                TableItem item2 = this.wMeta.table.getItem(i);
                int index = 1;
                item2.setText(index++, Const.NVL((String)change.getName(), (String)""));
                if (change.getRename() != null && !change.getRename().equals(change.getName())) {
                    item2.setText(index++, change.getRename());
                }
                int n = ++index;
                item2.setText(n, ValueMetaFactory.getValueMetaName((int)change.getType()));
                int n2 = ++index;
                ++index;
                item2.setText(n2, change.getLength() < 0 ? "" : "" + change.getLength());
                item2.setText(index++, change.getPrecision() < 0 ? "" : "" + change.getPrecision());
                item2.setText(index++, change.getStorageType() == 0 ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                item2.setText(index++, Const.NVL((String)change.getConversionMask(), (String)""));
                item2.setText(index++, change.isDateFormatLenient() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                item2.setText(index++, change.getDateFormatLocale() == null ? "" : change.getDateFormatLocale().toString());
                item2.setText(index++, change.getDateFormatTimeZone() == null ? "" : change.getDateFormatTimeZone().toString());
                item2.setText(index++, change.isLenientStringToNumber() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                item2.setText(index++, Const.NVL((String)change.getEncoding(), (String)""));
                item2.setText(index++, Const.NVL((String)change.getDecimalSymbol(), (String)""));
                item2.setText(index++, Const.NVL((String)change.getGroupingSymbol(), (String)""));
                item2.setText(index++, Const.NVL((String)change.getCurrencySymbol(), (String)""));
            }
            this.wMeta.setRowNums();
            this.wMeta.optWidth(true);
            this.wTabFolder.setSelection(2);
        }
        this.wTransformName.setFocus();
        this.wTransformName.selectAll();
    }

    private String[] getCharsets() {
        if (this.charsets == null) {
            Collection<Charset> charsetCol = Charset.availableCharsets().values();
            this.charsets = new String[charsetCol.size()];
            int i = 0;
            for (Charset charset : charsetCol) {
                this.charsets[i++] = charset.displayName();
            }
        }
        return this.charsets;
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        int nrFields = this.wFields.nrNonEmpty();
        int nrremove = this.wRemove.nrNonEmpty();
        int nrmeta = this.wMeta.nrNonEmpty();
        this.input.allocate(nrFields, nrremove, nrmeta);
        for (i = 0; i < nrFields; ++i) {
            item = this.wFields.getNonEmpty(i);
            this.input.getSelectFields()[i].setName(item.getText(1));
            this.input.getSelectFields()[i].setRename(item.getText(2));
            if (this.input.getSelectFields()[i].getRename() == null || this.input.getSelectFields()[i].getName().length() == 0) {
                this.input.getSelectFields()[i].setRename(this.input.getSelectFields()[i].getName());
            }
            this.input.getSelectFields()[i].setLength(Const.toInt((String)item.getText(3), (int)-2));
            this.input.getSelectFields()[i].setPrecision(Const.toInt((String)item.getText(4), (int)-2));
            if (this.input.getSelectFields()[i].getLength() < -2) {
                this.input.getSelectFields()[i].setLength(-2);
            }
            if (this.input.getSelectFields()[i].getPrecision() >= -2) continue;
            this.input.getSelectFields()[i].setPrecision(-2);
        }
        this.input.setSelectingAndSortingUnspecifiedFields(this.wUnspecified.getSelection());
        for (i = 0; i < nrremove; ++i) {
            item = this.wRemove.getNonEmpty(i);
            this.input.getDeleteName()[i] = item.getText(1);
        }
        for (i = 0; i < nrmeta; ++i) {
            SelectMetadataChange change;
            this.input.getMeta()[i] = change = new SelectMetadataChange();
            TableItem item2 = this.wMeta.getNonEmpty(i);
            int index = 1;
            change.setName(item2.getText(index++));
            change.setRename(item2.getText(index++));
            if (Utils.isEmpty((CharSequence)change.getRename())) {
                change.setRename(change.getName());
            }
            change.setType(ValueMetaFactory.getIdForValueMeta((String)item2.getText(index++)));
            change.setLength(Const.toInt((String)item2.getText(index++), (int)-2));
            change.setPrecision(Const.toInt((String)item2.getText(index++), (int)-2));
            if (change.getLength() < -2) {
                change.setLength(-2);
            }
            if (change.getPrecision() < -2) {
                change.setPrecision(-2);
            }
            if (BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item2.getText(index++))) {
                change.setStorageType(0);
            }
            change.setConversionMask(item2.getText(index++));
            change.setDateFormatLenient(item2.getText(index++).equalsIgnoreCase(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])));
            change.setDateFormatLocale(item2.getText(index++));
            change.setDateFormatTimeZone(item2.getText(index++));
            change.setLenientStringToNumber(item2.getText(index++).equalsIgnoreCase(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])));
            change.setEncoding(item2.getText(index++));
            change.setDecimalSymbol(item2.getText(index++));
            change.setGroupingSymbol(item2.getText(index++));
            change.setCurrencySymbol(item2.getText(index++));
        }
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                switch (this.wTabFolder.getSelectionIndex()) {
                    case 0: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
                        break;
                    }
                    case 1: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wRemove, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
                        break;
                    }
                    case 2: {
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wMeta, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)4, (int)5, null);
                        break;
                    }
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SelectValuesDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SelectValuesDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        if (!this.bPreviousFieldsLoaded) {
            BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Loading", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.ColumnInfo.Loading", (String[])new String[0]), (int)33);
            return;
        }
        if (this.wRemove.getItemCount() > 0 || this.wMeta.getItemCount() > 0) {
            String[] columns;
            int i;
            for (i = 0; i < this.wRemove.getItemCount(); ++i) {
                for (String column : columns = this.wRemove.getItem(i)) {
                    if (column.length() <= 0) continue;
                    BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.NoDeletOrMetaTitle", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.NoDeletOrMeta", (String[])new String[0]), (int)33);
                    return;
                }
            }
            for (i = 0; i < this.wMeta.getItemCount(); ++i) {
                for (String col : columns = this.wMeta.getItem(i)) {
                    if (col.length() <= 0) continue;
                    BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.NoDeletOrMetaTitle", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.NoDeletOrMeta", (String[])new String[0]), (int)33);
                    return;
                }
            }
        }
        IRowMeta nextTransformRequiredFields = null;
        TransformMeta transformMeta = new TransformMeta(this.transformName, (ITransformMeta)this.input);
        List nextTransforms = this.pipelineMeta.findNextTransforms(transformMeta);
        if (nextTransforms.size() == 0 || nextTransforms.size() > 1) {
            BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.NoNextTransformTitle", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.NoNextTransform", (String[])new String[0]), (int)33);
            return;
        }
        TransformMeta outputTransformMeta = (TransformMeta)nextTransforms.get(0);
        ITransformMeta transformMetaInterface = outputTransformMeta.getTransform();
        try {
            nextTransformRequiredFields = transformMetaInterface.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.UnableToFindOutput", (String[])new String[0]));
            nextTransformRequiredFields = new RowMeta();
        }
        String[] inputNames = new String[this.prevFields.size()];
        for (int i = 0; i < this.prevFields.size(); ++i) {
            IValueMeta value = this.prevFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        String[] outputNames = new String[nextTransformRequiredFields.size()];
        for (int i = 0; i < nextTransformRequiredFields.size(); ++i) {
            outputNames[i] = nextTransformRequiredFields.getValueMeta(i).getName();
        }
        String[] selectName = new String[this.wFields.getItemCount()];
        String[] selectRename = new String[this.wFields.getItemCount()];
        for (int i = 0; i < this.wFields.getItemCount(); ++i) {
            selectName[i] = this.wFields.getItem(i, 1);
            selectRename[i] = this.wFields.getItem(i, 2);
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingFields = new StringBuilder();
        for (int i = 0; i < selectName.length; ++i) {
            int outIndex;
            String valueName = selectName[i];
            String valueRename = selectRename[i];
            int inIndex = this.prevFields.indexOfValue(valueName);
            if (inIndex < 0) {
                missingFields.append(Const.CR + "   " + valueName + " --> " + valueRename);
                continue;
            }
            if (null == valueRename || valueRename.equals("")) {
                valueRename = valueName;
            }
            if ((outIndex = nextTransformRequiredFields.indexOfValue(valueRename)) < 0) {
                missingFields.append(Const.CR + "   " + valueName + " --> " + valueRename);
                continue;
            }
            SourceToTargetMapping mapping = new SourceToTargetMapping(inIndex, outIndex);
            mappings.add(mapping);
        }
        if (missingFields.length() > 0) {
            boolean goOn;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.SomeFieldsNotFound", (String[])new String[]{missingFields.toString()}), (int)196);
            boolean bl = goOn = (answer & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, inputNames, outputNames, mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, this.prevFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(2, outputNames[mapping.getTargetPosition()]);
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
            this.wTabFolder.setSelection(0);
        }
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.bPreviousFieldsLoaded = true;
        for (ColumnInfo colInfo : this.fieldColumns) {
            colInfo.setComboValues(fieldNames);
        }
    }
}

