/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.selectvalues;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopConversionException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.selectvalues.SelectMetadataChange;
import org.apache.hop.pipeline.transforms.selectvalues.SelectValuesData;
import org.apache.hop.pipeline.transforms.selectvalues.SelectValuesMeta;

public class SelectValues
extends BaseTransform<SelectValuesMeta, SelectValuesData>
implements ITransform<SelectValuesMeta, SelectValuesData> {
    private static final Class<?> PKG = SelectValuesMeta.class;

    public SelectValues(TransformMeta transformMeta, SelectValuesMeta meta, SelectValuesData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private synchronized Object[] selectValues(IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        if (((SelectValuesData)this.data).firstselect) {
            ((SelectValuesData)this.data).firstselect = false;
            ((SelectValuesData)this.data).fieldnrs = new int[((SelectValuesMeta)this.meta).getSelectFields().length];
            for (int i = 0; i < ((SelectValuesData)this.data).fieldnrs.length; ++i) {
                ((SelectValuesData)this.data).fieldnrs[i] = rowMeta.indexOfValue(((SelectValuesMeta)this.meta).getSelectFields()[i].getName());
                if (((SelectValuesData)this.data).fieldnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.CouldNotFindField", (String[])new String[]{((SelectValuesMeta)this.meta).getSelectFields()[i].getName()}));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            int[] cnt = new int[((SelectValuesMeta)this.meta).getSelectFields().length];
            for (int i = 0; i < ((SelectValuesMeta)this.meta).getSelectFields().length; ++i) {
                cnt[i] = 0;
                for (int j = 0; j < ((SelectValuesMeta)this.meta).getSelectFields().length; ++j) {
                    String two;
                    String one = Const.NVL((String)((SelectValuesMeta)this.meta).getSelectFields()[i].getRename(), (String)((SelectValuesMeta)this.meta).getSelectFields()[i].getName());
                    if (one.equals(two = Const.NVL((String)((SelectValuesMeta)this.meta).getSelectFields()[j].getRename(), (String)((SelectValuesMeta)this.meta).getSelectFields()[j].getName()))) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.FieldCouldNotSpecifiedMoreThanTwice", (String[])new String[]{one}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            if (((SelectValuesMeta)this.meta).isSelectingAndSortingUnspecifiedFields()) {
                ArrayList<String> extra = new ArrayList<String>();
                ArrayList<Integer> unspecifiedKeyNrs = new ArrayList<Integer>();
                for (int i = 0; i < rowMeta.size(); ++i) {
                    String fieldName = rowMeta.getValueMeta(i).getName();
                    if (Const.indexOfString((String)fieldName, (String[])((SelectValuesMeta)this.meta).getSelectName()) >= 0) continue;
                    extra.add(fieldName);
                }
                Collections.sort(extra);
                for (String fieldName : extra) {
                    int index = rowMeta.indexOfValue(fieldName);
                    unspecifiedKeyNrs.add(index);
                }
                ((SelectValuesData)this.data).extraFieldnrs = new int[unspecifiedKeyNrs.size()];
                for (int i = 0; i < ((SelectValuesData)this.data).extraFieldnrs.length; ++i) {
                    ((SelectValuesData)this.data).extraFieldnrs[i] = (Integer)unspecifiedKeyNrs.get(i);
                }
            } else {
                ((SelectValuesData)this.data).extraFieldnrs = new int[0];
            }
        }
        Object[] outputData = new Object[((SelectValuesData)this.data).selectRowMeta.size()];
        int outputIndex = 0;
        for (int idx : ((SelectValuesData)this.data).fieldnrs) {
            if (idx < rowMeta.size()) {
                IValueMeta valueMeta = rowMeta.getValueMeta(idx);
                outputData[outputIndex++] = valueMeta.cloneValueData(rowData[idx]);
                continue;
            }
            if (!this.log.isDetailed()) continue;
            this.logDetailed(BaseMessages.getString(PKG, (String)"SelectValues.Log.MixingStreamWithDifferentFields", (String[])new String[0]));
        }
        for (int idx : ((SelectValuesData)this.data).extraFieldnrs) {
            outputData[outputIndex++] = rowData[idx];
        }
        return outputData;
    }

    private synchronized Object[] removeValues(IRowMeta rowMeta, Object[] rowData) {
        if (((SelectValuesData)this.data).firstdeselect) {
            ((SelectValuesData)this.data).firstdeselect = false;
            ((SelectValuesData)this.data).removenrs = new int[((SelectValuesMeta)this.meta).getDeleteName().length];
            for (int i = 0; i < ((SelectValuesData)this.data).removenrs.length; ++i) {
                ((SelectValuesData)this.data).removenrs[i] = rowMeta.indexOfValue(((SelectValuesMeta)this.meta).getDeleteName()[i]);
                if (((SelectValuesData)this.data).removenrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.CouldNotFindField", (String[])new String[]{((SelectValuesMeta)this.meta).getDeleteName()[i]}));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            int[] cnt = new int[((SelectValuesMeta)this.meta).getDeleteName().length];
            for (int i = 0; i < ((SelectValuesMeta)this.meta).getDeleteName().length; ++i) {
                cnt[i] = 0;
                for (int j = 0; j < ((SelectValuesMeta)this.meta).getDeleteName().length; ++j) {
                    if (((SelectValuesMeta)this.meta).getDeleteName()[i].equals(((SelectValuesMeta)this.meta).getDeleteName()[j])) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.FieldCouldNotSpecifiedMoreThanTwice2", (String[])new String[]{((SelectValuesMeta)this.meta).getDeleteName()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            Arrays.sort(((SelectValuesData)this.data).removenrs);
        }
        return RowDataUtil.removeItems((Object[])rowData, (int[])((SelectValuesData)this.data).removenrs);
    }

    @VisibleForTesting
    synchronized Object[] metadataValues(IRowMeta rowMeta, Object[] rowData) throws HopException {
        if (((SelectValuesData)this.data).firstmetadata) {
            int i;
            ((SelectValuesData)this.data).firstmetadata = false;
            ((SelectValuesData)this.data).metanrs = new int[((SelectValuesMeta)this.meta).getMeta().length];
            for (int i2 = 0; i2 < ((SelectValuesData)this.data).metanrs.length; ++i2) {
                ((SelectValuesData)this.data).metanrs[i2] = rowMeta.indexOfValue(((SelectValuesMeta)this.meta).getMeta()[i2].getName());
                if (((SelectValuesData)this.data).metanrs[i2] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.CouldNotFindField", (String[])new String[]{((SelectValuesMeta)this.meta).getMeta()[i2].getName()}));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            int[] cnt = new int[((SelectValuesMeta)this.meta).getMeta().length];
            for (i = 0; i < ((SelectValuesMeta)this.meta).getMeta().length; ++i) {
                cnt[i] = 0;
                for (int j = 0; j < ((SelectValuesMeta)this.meta).getMeta().length; ++j) {
                    if (((SelectValuesMeta)this.meta).getMeta()[i].getName().equals(((SelectValuesMeta)this.meta).getMeta()[j].getName())) {
                        int n = i;
                        cnt[n] = cnt[n] + 1;
                    }
                    if (cnt[i] <= 1) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.FieldCouldNotSpecifiedMoreThanTwice2", (String[])new String[]{((SelectValuesMeta)this.meta).getMeta()[i].getName()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            for (i = 0; i < ((SelectValuesData)this.data).metanrs.length; ++i) {
                SelectMetadataChange change = ((SelectValuesMeta)this.meta).getMeta()[i];
                IValueMeta valueMeta = rowMeta.getValueMeta(((SelectValuesData)this.data).metanrs[i]);
                if (!Utils.isEmpty((CharSequence)change.getConversionMask())) {
                    valueMeta.setConversionMask(change.getConversionMask());
                }
                valueMeta.setDateFormatLenient(change.isDateFormatLenient());
                valueMeta.setDateFormatLocale(EnvUtil.createLocale((String)change.getDateFormatLocale()));
                valueMeta.setDateFormatTimeZone(EnvUtil.createTimeZone((String)change.getDateFormatTimeZone()));
                valueMeta.setLenientStringToNumber(change.isLenientStringToNumber());
                if (!Utils.isEmpty((CharSequence)change.getEncoding())) {
                    valueMeta.setStringEncoding(change.getEncoding());
                }
                if (!Utils.isEmpty((CharSequence)change.getDecimalSymbol())) {
                    valueMeta.setDecimalSymbol(change.getDecimalSymbol());
                }
                if (!Utils.isEmpty((CharSequence)change.getGroupingSymbol())) {
                    valueMeta.setGroupingSymbol(change.getGroupingSymbol());
                }
                if (Utils.isEmpty((CharSequence)change.getCurrencySymbol())) continue;
                valueMeta.setCurrencySymbol(change.getCurrencySymbol());
            }
        }
        for (int i = 0; i < ((SelectValuesData)this.data).metanrs.length; ++i) {
            int index = ((SelectValuesData)this.data).metanrs[i];
            IValueMeta fromMeta = rowMeta.getValueMeta(index);
            IValueMeta toMeta = ((SelectValuesData)this.data).metadataRowMeta.getValueMeta(index);
            try {
                if (fromMeta.isStorageBinaryString() && ((SelectValuesMeta)this.meta).getMeta()[i].getStorageType() == 0) {
                    rowData[index] = fromMeta.convertBinaryStringToNativeType((byte[])rowData[index]);
                }
                if (((SelectValuesMeta)this.meta).getMeta()[i].getType() == 0 || fromMeta.getType() == toMeta.getType()) continue;
                rowData[index] = toMeta.convertData(fromMeta, rowData[index]);
                continue;
            }
            catch (HopValueException e) {
                throw new HopConversionException(e.getMessage(), Collections.singletonList(e), Collections.singletonList(toMeta), rowData);
            }
        }
        return rowData;
    }

    public boolean processRow() throws HopException {
        Object[] rowData = this.getRow();
        if (rowData == null) {
            this.setOutputDone();
            return false;
        }
        Object[] rowCopy = null;
        if (this.getTransformMeta().isDoingErrorHandling()) {
            rowCopy = this.getInputRowMeta().cloneRow(rowData);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"SelectValues.Log.GotRowFromPreviousTransform", (String[])new String[0]) + this.getInputRowMeta().getString(rowData));
        }
        if (this.first) {
            this.first = false;
            ((SelectValuesData)this.data).selectRowMeta = this.getInputRowMeta().clone();
            ((SelectValuesMeta)this.meta).getSelectFields(((SelectValuesData)this.data).selectRowMeta, this.getTransformName());
            ((SelectValuesData)this.data).deselectRowMeta = ((SelectValuesData)this.data).selectRowMeta.clone();
            ((SelectValuesMeta)this.meta).getDeleteFields(((SelectValuesData)this.data).deselectRowMeta);
            ((SelectValuesData)this.data).metadataRowMeta = ((SelectValuesData)this.data).deselectRowMeta.clone();
            ((SelectValuesMeta)this.meta).getMetadataFields(((SelectValuesData)this.data).metadataRowMeta, this.getTransformName(), (IVariables)this);
        }
        try {
            Object[] outputData = rowData;
            if (((SelectValuesData)this.data).select) {
                outputData = this.selectValues(this.getInputRowMeta(), outputData);
            }
            if (((SelectValuesData)this.data).deselect) {
                outputData = this.removeValues(((SelectValuesData)this.data).selectRowMeta, outputData);
            }
            if (((SelectValuesData)this.data).metadata) {
                outputData = this.metadataValues(((SelectValuesData)this.data).deselectRowMeta, outputData);
            }
            if (outputData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(((SelectValuesData)this.data).metadataRowMeta, outputData);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SelectValues.Log.WroteRowToNextTransform", (String[])new String[0]) + ((SelectValuesData)this.data).metadataRowMeta.getString(outputData));
            }
        }
        catch (HopException e) {
            if (this.getTransformMeta().isDoingErrorHandling()) {
                List fields;
                String field = e instanceof HopConversionException ? ((fields = ((HopConversionException)e).getFields()).isEmpty() ? null : ((IValueMeta)fields.get(0)).getName()) : null;
                this.putError(this.getInputRowMeta(), rowCopy, 1L, e.getMessage(), field, "SELECT001");
            }
            throw e;
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SelectValues.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            boolean atLeastOne;
            ((SelectValuesData)this.data).firstselect = true;
            ((SelectValuesData)this.data).firstdeselect = true;
            ((SelectValuesData)this.data).firstmetadata = true;
            ((SelectValuesData)this.data).select = false;
            ((SelectValuesData)this.data).deselect = false;
            ((SelectValuesData)this.data).metadata = false;
            if (!Utils.isEmpty((Object[])((SelectValuesMeta)this.meta).getSelectFields())) {
                ((SelectValuesData)this.data).select = true;
            }
            if (!Utils.isEmpty((CharSequence[])((SelectValuesMeta)this.meta).getDeleteName())) {
                ((SelectValuesData)this.data).deselect = true;
            }
            if (!Utils.isEmpty((Object[])((SelectValuesMeta)this.meta).getMeta())) {
                ((SelectValuesData)this.data).metadata = true;
            }
            boolean bl = atLeastOne = ((SelectValuesData)this.data).select || ((SelectValuesData)this.data).deselect || ((SelectValuesData)this.data).metadata;
            if (!atLeastOne) {
                this.setErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"SelectValues.Log.InputShouldContainData", (String[])new String[0]));
            }
            return atLeastOne;
        }
        return false;
    }
}

