/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput.staxpoi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.spreadsheet.IKSheet;
import org.apache.hop.core.spreadsheet.IKWorkbook;
import org.apache.hop.pipeline.transforms.excelinput.staxpoi.StaxPoiSheet;
import org.apache.hop.pipeline.transforms.excelinput.staxpoi.StaxUtil;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;

public class StaxPoiWorkbook
implements IKWorkbook {
    private static final String RELATION_NS_URI = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    private ILogChannel log;
    private XSSFReader reader;
    private Map<String, String> sheetNameIDMap;
    private String[] sheetNames;
    private Map<String, StaxPoiSheet> openSheetsMap = new HashMap<String, StaxPoiSheet>();
    private OPCPackage opcpkg;

    protected StaxPoiWorkbook() {
        this.log = HopLogStore.getLogChannelFactory().create((Object)this);
    }

    public StaxPoiWorkbook(String filename, String encoding) throws HopException {
        this();
        try {
            this.opcpkg = OPCPackage.open((String)filename);
            this.openFile(this.opcpkg, encoding);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public StaxPoiWorkbook(InputStream inputStream, String encoding) throws HopException {
        this();
        try {
            this.opcpkg = OPCPackage.open((InputStream)inputStream);
            this.openFile(this.opcpkg, encoding);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    private void openFile(OPCPackage pkg, String encoding) throws HopException, IOException, XMLStreamException {
        InputStream workbookData = null;
        XMLStreamReader workbookReader = null;
        try {
            this.reader = new XSSFReader(pkg);
            this.sheetNameIDMap = new LinkedHashMap<String, String>();
            workbookData = this.reader.getWorkbookData();
            XMLInputFactory factory = StaxUtil.safeXMLInputFactory();
            workbookReader = factory.createXMLStreamReader(workbookData);
            while (workbookReader.hasNext()) {
                if (workbookReader.next() != 1 || !workbookReader.getLocalName().equals("sheet")) continue;
                String sheetName = workbookReader.getAttributeValue(null, "name");
                String sheetID = workbookReader.getAttributeValue(RELATION_NS_URI, "id");
                this.sheetNameIDMap.put(sheetName, sheetID);
            }
            this.sheetNames = new String[this.sheetNameIDMap.size()];
            int i = 0;
            for (String sheetName : this.sheetNameIDMap.keySet()) {
                this.sheetNames[i++] = sheetName;
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            if (workbookReader != null) {
                workbookReader.close();
            }
            if (workbookData != null) {
                workbookData.close();
            }
        }
    }

    public IKSheet getSheet(String sheetName) {
        String sheetID = this.sheetNameIDMap.get(sheetName);
        if (sheetID == null) {
            return null;
        }
        StaxPoiSheet sheet = this.openSheetsMap.get(sheetID);
        if (sheet == null) {
            try {
                sheet = new StaxPoiSheet(this.reader, sheetName, sheetID);
                this.openSheetsMap.put(sheetID, sheet);
            }
            catch (Exception e) {
                this.log.logError(sheetName, (Throwable)e);
            }
        }
        return sheet;
    }

    public String[] getSheetNames() {
        String[] sheets = new String[this.sheetNameIDMap.size()];
        return this.sheetNameIDMap.keySet().toArray(sheets);
    }

    public void close() {
        for (StaxPoiSheet sheet : this.openSheetsMap.values()) {
            try {
                sheet.close();
            }
            catch (IOException e) {
                this.log.logError("Could not close workbook", (Throwable)e);
            }
            catch (XMLStreamException e) {
                this.log.logError("Could not close xmlstream", (Throwable)e);
            }
        }
        if (this.opcpkg != null) {
            this.opcpkg.revert();
        }
    }

    public int getNumberOfSheets() {
        return this.sheetNameIDMap.size();
    }

    public IKSheet getSheet(int sheetNr) {
        if (sheetNr >= 0 && sheetNr < this.sheetNames.length) {
            return this.getSheet(this.sheetNames[sheetNr]);
        }
        return null;
    }

    public String getSheetName(int sheetNr) {
        if (sheetNr >= 0 && sheetNr < this.sheetNames.length) {
            return this.sheetNames[sheetNr];
        }
        return null;
    }
}

