/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput.poi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.spreadsheet.IKSheet;
import org.apache.hop.core.spreadsheet.IKWorkbook;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transforms.excelinput.poi.PoiSheet;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class PoiWorkbook
implements IKWorkbook {
    private ILogChannel log;
    private Workbook workbook;
    private String filename;
    private String encoding;
    private InputStream internalIS;
    private POIFSFileSystem poifs;
    private OPCPackage opcpkg;

    public PoiWorkbook(String filename, String encoding) throws HopException {
        block7: {
            this.filename = filename;
            this.encoding = encoding;
            this.log = HopLogStore.getLogChannelFactory().create((Object)this);
            try {
                FileObject fileObject = HopVfs.getFileObject((String)filename);
                if (fileObject instanceof LocalFile) {
                    String localFilename = HopVfs.getFilename((FileObject)fileObject);
                    File excelFile = new File(localFilename);
                    try {
                        this.poifs = new POIFSFileSystem(excelFile);
                        this.workbook = WorkbookFactory.create((POIFSFileSystem)this.poifs);
                    }
                    catch (Exception ofe) {
                        try {
                            this.opcpkg = OPCPackage.open((File)excelFile);
                            this.workbook = WorkbookFactory.create((OPCPackage)this.opcpkg);
                            break block7;
                        }
                        catch (Exception ex) {
                            this.workbook = WorkbookFactory.create((File)excelFile);
                        }
                    }
                    break block7;
                }
                this.internalIS = HopVfs.getInputStream((String)filename);
                this.workbook = WorkbookFactory.create((InputStream)this.internalIS);
            }
            catch (Exception e) {
                throw new HopException((Throwable)e);
            }
        }
    }

    public PoiWorkbook(InputStream inputStream, String encoding) throws HopException {
        this.encoding = encoding;
        try {
            this.workbook = WorkbookFactory.create((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.internalIS != null) {
                this.internalIS.close();
            }
            if (this.poifs != null) {
                this.poifs.close();
            }
            if (this.opcpkg != null) {
                this.opcpkg.revert();
            }
        }
        catch (IOException ex) {
            this.log.logError("Could not close workbook", (Throwable)ex);
        }
    }

    public IKSheet getSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            return null;
        }
        return new PoiSheet(sheet);
    }

    public String[] getSheetNames() {
        int nrSheets = this.workbook.getNumberOfSheets();
        String[] names = new String[nrSheets];
        for (int i = 0; i < nrSheets; ++i) {
            names[i] = this.workbook.getSheetName(i);
        }
        return names;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public IKSheet getSheet(int sheetNr) {
        Sheet sheet = this.workbook.getSheetAt(sheetNr);
        if (sheet == null) {
            return null;
        }
        return new PoiSheet(sheet);
    }

    public String getSheetName(int sheetNr) {
        Sheet sheet = (Sheet)this.getSheet(sheetNr);
        if (sheet == null) {
            return null;
        }
        return sheet.getSheetName();
    }
}

