/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelinput;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.spreadsheet.IKCell;
import org.apache.hop.core.spreadsheet.IKSheet;
import org.apache.hop.core.spreadsheet.IKWorkbook;
import org.apache.hop.core.spreadsheet.KCellType;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputField;
import org.apache.hop.pipeline.transforms.excelinput.ExcelInputMeta;
import org.apache.hop.pipeline.transforms.excelinput.SpreadSheetType;
import org.apache.hop.pipeline.transforms.excelinput.WorkbookFactory;
import org.apache.hop.pipeline.transforms.fileinput.text.DirectoryDialogButtonListenerFactory;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterListDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.core.widget.VariableButtonListenerFactory;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ExcelInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ExcelInputMeta.class;
    private static final String TAB_FLAG = "!";
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private CTabFolder wTabFolder;
    private CTabItem wFileTab;
    private CTabItem wSheetTab;
    private CTabItem wFieldsTab;
    private Label wlStatusMessage;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Label wlFilemask;
    private Text wFilemask;
    private Label wlExcludeFilemask;
    private TextVar wExcludeFilemask;
    private Button wAccFilenames;
    private Label wlAccField;
    private CCombo wAccField;
    private Label wlAccTransform;
    private CCombo wAccTransform;
    private Button wbShowFiles;
    private TableView wSheetnameList;
    private Button wHeader;
    private Button wNoEmpty;
    private Button wStopOnEmpty;
    private Text wInclFilenameField;
    private Text wInclSheetnameField;
    private Text wInclRownumField;
    private Text wInclSheetRownumField;
    private Text wLimit;
    private CCombo wSpreadSheetType;
    private CCombo wEncoding;
    private Button wbGetFields;
    private TableView wFields;
    private Button wStrictTypes;
    private Button wErrorIgnored;
    private Label wlSkipErrorLines;
    private Button wSkipErrorLines;
    private Label wlWarningDestDir;
    private Button wbbWarningDestDir;
    private Button wbvWarningDestDir;
    private TextVar wWarningDestDir;
    private Label wlWarningExt;
    private Text wWarningExt;
    private Label wlErrorDestDir;
    private Button wbbErrorDestDir;
    private Button wbvErrorDestDir;
    private TextVar wErrorDestDir;
    private Label wlErrorExt;
    private Text wErrorExt;
    private Label wlLineNrDestDir;
    private Button wbbLineNrDestDir;
    private Button wbvLineNrDestDir;
    private TextVar wLineNrDestDir;
    private Label wlLineNrExt;
    private Text wLineNrExt;
    private final ExcelInputMeta input;
    private int middle;
    private int margin;
    private boolean gotEncodings = false;
    private Button wAddResult;
    private ModifyListener lsMod;
    private Text wShortFileFieldName;
    private Text wPathFieldName;
    private Text wIsHiddenName;
    private Text wLastModificationTimeName;
    private Text wUriName;
    private Text wRootUriName;
    private Text wExtensionFieldName;
    private Text wSizeFieldName;

    public ExcelInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ExcelInputMeta)((Object)in);
    }

    public String open() {
        IRowMeta previousFields;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        this.lsMod = e -> {
            this.input.setChanged();
            this.checkAlerts();
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.PreviewRows.Button", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wlStatusMessage = new Label((Composite)this.shell, 131072);
        this.wlStatusMessage.setText("(This Space To Let)");
        this.wlStatusMessage.setForeground(this.shell.getDisplay().getSystemColor(3));
        this.props.setLook((Control)this.wlStatusMessage);
        FormData fdlStatusMessage = new FormData();
        fdlStatusMessage.left = new FormAttachment(0, 0);
        fdlStatusMessage.top = new FormAttachment((Control)this.wlTransformName, this.margin);
        fdlStatusMessage.right = new FormAttachment(this.middle, -this.margin);
        this.wlStatusMessage.setLayoutData((Object)fdlStatusMessage);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wFileTab = new CTabItem(this.wTabFolder, 0);
        this.wFileTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FileTab.TabTitle", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Label wlSpreadSheetType = new Label(wFileComp, 131072);
        wlSpreadSheetType.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SpreadSheetType.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSpreadSheetType);
        FormData fdlSpreadSheetType = new FormData();
        fdlSpreadSheetType.left = new FormAttachment(0, 0);
        fdlSpreadSheetType.right = new FormAttachment(this.middle, -this.margin);
        fdlSpreadSheetType.top = new FormAttachment(0, 0);
        wlSpreadSheetType.setLayoutData((Object)fdlSpreadSheetType);
        this.wSpreadSheetType = new CCombo(wFileComp, 2056);
        this.wSpreadSheetType.setEditable(true);
        this.props.setLook((Control)this.wSpreadSheetType);
        this.wSpreadSheetType.addModifyListener(this.lsMod);
        FormData fdSpreadSheetType = new FormData();
        fdSpreadSheetType.left = new FormAttachment(this.middle, 0);
        fdSpreadSheetType.right = new FormAttachment(100, 0);
        fdSpreadSheetType.top = new FormAttachment(0, 0);
        this.wSpreadSheetType.setLayoutData((Object)fdSpreadSheetType);
        for (SpreadSheetType type : SpreadSheetType.values()) {
            this.wSpreadSheetType.add(type.getDescription());
        }
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wSpreadSheetType, this.margin);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wSpreadSheetType, this.margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdbaFilename.top = new FormAttachment((Control)this.wSpreadSheetType, this.margin);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -this.margin);
        fdFilename.top = new FormAttachment((Control)this.wSpreadSheetType, this.margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlFilemask = new Label(wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Filemask.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilemask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, this.margin);
        fdlFilemask.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilemask.setLayoutData((Object)fdlFilemask);
        this.wFilemask = new Text(wFileComp, 18436);
        this.props.setLook((Control)this.wFilemask);
        this.wFilemask.addModifyListener(this.lsMod);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(this.middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wFilename, this.margin);
        fdFilemask.right = new FormAttachment((Control)this.wbaFilename, -this.margin);
        this.wFilemask.setLayoutData((Object)fdFilemask);
        this.wlExcludeFilemask = new Label(wFileComp, 131072);
        this.wlExcludeFilemask.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ExcludeFilemask.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlExcludeFilemask);
        FormData fdlExcludeFilemask = new FormData();
        fdlExcludeFilemask.left = new FormAttachment(0, 0);
        fdlExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdlExcludeFilemask.right = new FormAttachment(this.middle, -this.margin);
        this.wlExcludeFilemask.setLayoutData((Object)fdlExcludeFilemask);
        this.wExcludeFilemask = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wExcludeFilemask);
        this.wExcludeFilemask.addModifyListener(this.lsMod);
        FormData fdExcludeFilemask = new FormData();
        fdExcludeFilemask.left = new FormAttachment(this.middle, 0);
        fdExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdExcludeFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wExcludeFilemask.setLayoutData((Object)fdExcludeFilemask);
        this.wlFilenameList = new Label(wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdlFilenameList.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbdFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameDelete.Button", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameDelete.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wExcludeFilemask, 40);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.left = new FormAttachment((Control)this.wbdFilename, 0, 16384);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, this.margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(this.middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, -this.margin);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        Group gAccepting = new Group(wFileComp, 16);
        gAccepting.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptingGroup.Label", (String[])new String[0]));
        FormLayout acceptingLayout = new FormLayout();
        acceptingLayout.marginWidth = 3;
        acceptingLayout.marginHeight = 3;
        gAccepting.setLayout((Layout)acceptingLayout);
        this.props.setLook((Control)gAccepting);
        Label wlAccFilenames = new Label((Composite)gAccepting, 131072);
        wlAccFilenames.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptFilenames.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAccFilenames);
        FormData fdlAccFilenames = new FormData();
        fdlAccFilenames.top = new FormAttachment(0, this.margin);
        fdlAccFilenames.left = new FormAttachment(0, 0);
        fdlAccFilenames.right = new FormAttachment(this.middle, -this.margin);
        wlAccFilenames.setLayoutData((Object)fdlAccFilenames);
        this.wAccFilenames = new Button((Composite)gAccepting, 32);
        this.wAccFilenames.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptFilenames.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAccFilenames);
        FormData fdAccFilenames = new FormData();
        fdAccFilenames.top = new FormAttachment((Control)wlAccFilenames, 0, 0x1000000);
        fdAccFilenames.left = new FormAttachment(this.middle, 0);
        fdAccFilenames.right = new FormAttachment(100, 0);
        this.wAccFilenames.setLayoutData((Object)fdAccFilenames);
        this.wAccFilenames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExcelInputDialog.this.setFlags();
                ExcelInputDialog.this.input.setChanged();
            }
        });
        this.wlAccTransform = new Label((Composite)gAccepting, 131072);
        this.wlAccTransform.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptTransform.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAccTransform);
        FormData fdlAccTransform = new FormData();
        fdlAccTransform.top = new FormAttachment((Control)this.wAccFilenames, this.margin);
        fdlAccTransform.left = new FormAttachment(0, 0);
        fdlAccTransform.right = new FormAttachment(this.middle, -this.margin);
        this.wlAccTransform.setLayoutData((Object)fdlAccTransform);
        this.wAccTransform = new CCombo((Composite)gAccepting, 18436);
        this.wAccTransform.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptTransform.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAccTransform);
        FormData fdAccTransform = new FormData();
        fdAccTransform.top = new FormAttachment((Control)this.wAccFilenames, this.margin);
        fdAccTransform.left = new FormAttachment(this.middle, 0);
        fdAccTransform.right = new FormAttachment(100, 0);
        this.wAccTransform.setLayoutData((Object)fdAccTransform);
        this.wlAccField = new Label((Composite)gAccepting, 131072);
        this.wlAccField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAccField);
        FormData fdlAccField = new FormData();
        fdlAccField.top = new FormAttachment((Control)this.wAccTransform, this.margin);
        fdlAccField.left = new FormAttachment(0, 0);
        fdlAccField.right = new FormAttachment(this.middle, -this.margin);
        this.wlAccField.setLayoutData((Object)fdlAccField);
        this.wAccField = new CCombo((Composite)gAccepting, 18436);
        try {
            previousFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopTransformException e2) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorDialog.UnableToGetInputFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorDialog.UnableToGetInputFields.Message", (String[])new String[0]), (Exception)((Object)e2));
            previousFields = new RowMeta();
        }
        this.wAccField.setItems(previousFields.getFieldNames());
        this.wAccField.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AcceptField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAccField);
        FormData fdAccField = new FormData();
        fdAccField.top = new FormAttachment((Control)this.wAccTransform, this.margin);
        fdAccField.left = new FormAttachment(this.middle, 0);
        fdAccField.right = new FormAttachment(100, 0);
        this.wAccField.setLayoutData((Object)fdAccField);
        List prevTransforms = this.pipelineMeta.findPreviousTransforms(this.pipelineMeta.findTransform(this.transformName));
        for (TransformMeta prevTransform : prevTransforms) {
            this.wAccTransform.add(prevTransform.getName());
        }
        FormData fdAccepting = new FormData();
        fdAccepting.left = new FormAttachment(this.middle, 0);
        fdAccepting.right = new FormAttachment(100, 0);
        fdAccepting.bottom = new FormAttachment((Control)this.wbShowFiles, -this.margin * 2);
        gAccepting.setLayoutData((Object)fdAccepting);
        ColumnInfo[] colinfo = new ColumnInfo[5];
        colinfo[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FileDir.Column", (String[])new String[0]), 1, false);
        colinfo[0].setUsingVariables(true);
        colinfo[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Wildcard.Column", (String[])new String[0]), 1, false);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Wildcard.Tooltip", (String[])new String[0]));
        colinfo[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Files.ExcludeWildcard.Column", (String[])new String[0]), 1, false);
        colinfo[2].setUsingVariables(true);
        colinfo[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Required.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO);
        colinfo[4].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.IncludeSubDirs.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67588, colinfo, this.input.getFileName().length, this.lsMod, this.props);
        this.props.setLook((Control)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(this.middle, 0);
        fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -this.margin);
        fdFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdFilenameList.bottom = new FormAttachment((Control)gAccepting, -this.margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        this.wFileTab.setControl((Control)wFileComp);
        this.wSheetTab = new CTabItem(this.wTabFolder, 0);
        this.wSheetTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SheetsTab.TabTitle", (String[])new String[0]));
        Composite wSheetComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wSheetComp);
        FormLayout sheetLayout = new FormLayout();
        sheetLayout.marginWidth = 3;
        sheetLayout.marginHeight = 3;
        wSheetComp.setLayout((Layout)sheetLayout);
        Button wbGetSheets = new Button(wSheetComp, 0x1000008);
        this.props.setLook((Control)wbGetSheets);
        wbGetSheets.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.GetSheets.Button", (String[])new String[0]));
        FormData fdbGetSheets = new FormData();
        fdbGetSheets.left = new FormAttachment(this.middle, 0);
        fdbGetSheets.bottom = new FormAttachment(100, -this.margin);
        wbGetSheets.setLayoutData((Object)fdbGetSheets);
        Label wlSheetnameList = new Label(wSheetComp, 131072);
        wlSheetnameList.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SheetNameList.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSheetnameList);
        FormData fdlSheetnameList = new FormData();
        fdlSheetnameList.left = new FormAttachment(0, 0);
        fdlSheetnameList.top = new FormAttachment((Control)this.wFilename, this.margin);
        fdlSheetnameList.right = new FormAttachment(this.middle, -this.margin);
        wlSheetnameList.setLayoutData((Object)fdlSheetnameList);
        ColumnInfo[] shinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SheetName.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StartRow.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StartColumn.Column", (String[])new String[0]), 1, false)};
        this.wSheetnameList = new TableView(this.variables, wSheetComp, 67586, shinfo, this.input.getSheetName().length, this.lsMod, this.props);
        this.props.setLook((Control)this.wSheetnameList);
        fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(this.middle, 0);
        fdFilenameList.right = new FormAttachment(100, 0);
        fdFilenameList.top = new FormAttachment(0, 0);
        fdFilenameList.bottom = new FormAttachment((Control)wbGetSheets, -this.margin);
        this.wSheetnameList.setLayoutData((Object)fdFilenameList);
        this.wSheetnameList.addModifyListener(arg0 -> this.checkAlerts());
        FormData fdSheetComp = new FormData();
        fdSheetComp.left = new FormAttachment(0, 0);
        fdSheetComp.top = new FormAttachment(0, 0);
        fdSheetComp.right = new FormAttachment(100, 0);
        fdSheetComp.bottom = new FormAttachment(100, 0);
        wSheetComp.setLayoutData((Object)fdSheetComp);
        wSheetComp.layout();
        this.wSheetTab.setControl((Control)wSheetComp);
        CTabItem wContentTab = new CTabItem(this.wTabFolder, 0);
        wContentTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Label wlHeader = new Label(wContentComp, 131072);
        wlHeader.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Header.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHeader);
        FormData fdlHeader = new FormData();
        fdlHeader.left = new FormAttachment(0, 0);
        fdlHeader.top = new FormAttachment(0, 0);
        fdlHeader.right = new FormAttachment(this.middle, -this.margin);
        wlHeader.setLayoutData((Object)fdlHeader);
        this.wHeader = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wHeader);
        FormData fdHeader = new FormData();
        fdHeader.left = new FormAttachment(this.middle, 0);
        fdHeader.top = new FormAttachment((Control)wlHeader, 0, 0x1000000);
        fdHeader.right = new FormAttachment(100, 0);
        this.wHeader.setLayoutData((Object)fdHeader);
        this.wHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExcelInputDialog.this.setFlags();
                ExcelInputDialog.this.input.setChanged();
            }
        });
        Label wlNoEmpty = new Label(wContentComp, 131072);
        wlNoEmpty.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.NoEmpty.Label", (String[])new String[0]));
        this.props.setLook((Control)wlNoEmpty);
        FormData fdlNoEmpty = new FormData();
        fdlNoEmpty.left = new FormAttachment(0, 0);
        fdlNoEmpty.top = new FormAttachment((Control)this.wHeader, this.margin);
        fdlNoEmpty.right = new FormAttachment(this.middle, -this.margin);
        wlNoEmpty.setLayoutData((Object)fdlNoEmpty);
        this.wNoEmpty = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wNoEmpty);
        this.wNoEmpty.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.NoEmpty.Tooltip", (String[])new String[0]));
        FormData fdNoEmpty = new FormData();
        fdNoEmpty.left = new FormAttachment(this.middle, 0);
        fdNoEmpty.top = new FormAttachment((Control)wlNoEmpty, 0, 0x1000000);
        fdNoEmpty.right = new FormAttachment(100, 0);
        this.wNoEmpty.setLayoutData((Object)fdNoEmpty);
        this.wNoEmpty.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlStopOnEmpty = new Label(wContentComp, 131072);
        wlStopOnEmpty.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StopOnEmpty.Label", (String[])new String[0]));
        this.props.setLook((Control)wlStopOnEmpty);
        FormData fdlStopOnEmpty = new FormData();
        fdlStopOnEmpty.left = new FormAttachment(0, 0);
        fdlStopOnEmpty.top = new FormAttachment((Control)this.wNoEmpty, this.margin);
        fdlStopOnEmpty.right = new FormAttachment(this.middle, -this.margin);
        wlStopOnEmpty.setLayoutData((Object)fdlStopOnEmpty);
        this.wStopOnEmpty = new Button(wContentComp, 32);
        this.props.setLook((Control)this.wStopOnEmpty);
        this.wStopOnEmpty.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StopOnEmpty.Tooltip", (String[])new String[0]));
        FormData fdStopOnEmpty = new FormData();
        fdStopOnEmpty.left = new FormAttachment(this.middle, 0);
        fdStopOnEmpty.top = new FormAttachment((Control)wlStopOnEmpty, 0, 0x1000000);
        fdStopOnEmpty.right = new FormAttachment(100, 0);
        this.wStopOnEmpty.setLayoutData((Object)fdStopOnEmpty);
        this.wStopOnEmpty.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlLimit = new Label(wContentComp, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)this.wStopOnEmpty, this.margin);
        fdlLimit.right = new FormAttachment(this.middle, -this.margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text(wContentComp, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(this.lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(this.middle, 0);
        fdLimit.top = new FormAttachment((Control)this.wStopOnEmpty, this.margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlEncoding = new Label(wContentComp, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wLimit, this.margin);
        fdlEncoding.right = new FormAttachment(this.middle, -this.margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(this.lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(this.middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wLimit, this.margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ExcelInputDialog.this.shell.getDisplay(), 1);
                ExcelInputDialog.this.shell.setCursor(busy);
                ExcelInputDialog.this.setEncodings();
                ExcelInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Group wAddFileResult = new Group(wContentComp, 32);
        this.props.setLook((Control)wAddFileResult);
        wAddFileResult.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFileResult.Label", (String[])new String[0]));
        FormLayout AddFileResultgroupLayout = new FormLayout();
        AddFileResultgroupLayout.marginWidth = 10;
        AddFileResultgroupLayout.marginHeight = 10;
        wAddFileResult.setLayout((Layout)AddFileResultgroupLayout);
        Label wlAddResult = new Label((Composite)wAddFileResult, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdlAddResult.right = new FormAttachment(this.middle, -this.margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wAddFileResult, 32);
        this.props.setLook((Control)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(this.middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        FormData fdAddFileResult = new FormData();
        fdAddFileResult.left = new FormAttachment(0, this.margin);
        fdAddFileResult.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdAddFileResult.right = new FormAttachment(100, -this.margin);
        wAddFileResult.setLayoutData((Object)fdAddFileResult);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        this.addErrorTab();
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.wbGetFields = new Button(wFieldsComp, 0x1000008);
        this.props.setLook((Control)this.wbGetFields);
        this.wbGetFields.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.GetFields.Button", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wbGetFields}, this.margin, null);
        int FieldsRows = this.input.getField().length;
        int FieldsWidth = 600;
        int FieldsHeight = 150;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Type.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.TrimType.Column", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Repeat.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Format.Column", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Currency.Column", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Decimal.Column", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Grouping.Column", (String[])new String[0]), 1)};
        colinf[5].setToolTip(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Repeat.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, wFieldsComp, 65538, colinf, FieldsRows, this.lsMod, this.props);
        this.wFields.setSize(FieldsWidth, FieldsHeight);
        this.wFields.addModifyListener(arg0 -> this.checkAlerts());
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wbGetFields, -this.margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)wFieldsComp);
        this.props.setLook((Control)wFieldsComp);
        this.addAdditionalFieldsTab();
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wlStatusMessage, this.margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExcelInputDialog.this.wFilenameList.add(new String[]{ExcelInputDialog.this.wFilename.getText(), ExcelInputDialog.this.wFilemask.getText(), ExcelInputDialog.this.wExcludeFilemask.getText(), ExcelInputMeta.RequiredFilesCode[0], ExcelInputMeta.RequiredFilesCode[0]});
                ExcelInputDialog.this.wFilename.setText("");
                ExcelInputDialog.this.wFilemask.setText("");
                ExcelInputDialog.this.wExcludeFilemask.setText("");
                ExcelInputDialog.this.wFilenameList.removeEmptyRows();
                ExcelInputDialog.this.wFilenameList.setRowNums();
                ExcelInputDialog.this.wFilenameList.optWidth(true);
                ExcelInputDialog.this.checkAlerts();
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = ExcelInputDialog.this.wFilenameList.getSelectionIndices();
                ExcelInputDialog.this.wFilenameList.remove(idx);
                ExcelInputDialog.this.wFilenameList.removeEmptyRows();
                ExcelInputDialog.this.wFilenameList.setRowNums();
                ExcelInputDialog.this.checkAlerts();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = ExcelInputDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = ExcelInputDialog.this.wFilenameList.getItem(idx);
                    ExcelInputDialog.this.wFilename.setText(string[0]);
                    ExcelInputDialog.this.wFilemask.setText(string[1]);
                    ExcelInputDialog.this.wExcludeFilemask.setText(string[2]);
                    ExcelInputDialog.this.wFilenameList.remove(idx);
                }
                ExcelInputDialog.this.wFilenameList.removeEmptyRows();
                ExcelInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExcelInputDialog.this.showFiles();
            }
        });
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        this.wbbFilename.addListener(13, e -> {
            if (!Utils.isEmpty((CharSequence)this.wFilemask.getText()) || !Utils.isEmpty((CharSequence)this.wExcludeFilemask.getText())) {
                BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables);
            } else {
                String[] extentions;
                SpreadSheetType type = SpreadSheetType.getStpreadSheetTypeByDescription(this.wSpreadSheetType.getText());
                switch (type) {
                    case SAX_POI: {
                        extentions = new String[]{"*.xlsx;*.XLSX;*.xlsm;*.XLSM", "*"};
                        break;
                    }
                    case ODS: {
                        extentions = new String[]{"*.ods;*.ODS;", "*"};
                        break;
                    }
                    default: {
                        extentions = new String[]{"*.xls;*.XLS;*.xlsx;*.XLSX;*.xlsm;*.XLSM", "*"};
                    }
                }
                BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])extentions, (String[])new String[]{BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilterNames.ExcelFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
            }
        });
        wbGetSheets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExcelInputDialog.this.getSheets();
            }
        });
        this.wbGetFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExcelInputDialog.this.getFields();
            }
        });
        this.wTabFolder.setSelection(0);
        this.getData(this.input);
        this.wFields.optWidth(true);
        this.input.setChanged(this.changed);
        this.checkAlerts();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void setFlags() {
        this.wbGetFields.setEnabled(this.wHeader.getSelection());
        boolean accept = this.wAccFilenames.getSelection();
        this.wlAccField.setEnabled(accept);
        this.wAccField.setEnabled(accept);
        this.wlAccTransform.setEnabled(accept);
        this.wAccTransform.setEnabled(accept);
        this.wlFilename.setEnabled(!accept);
        this.wbbFilename.setEnabled(!accept);
        this.wbdFilename.setEnabled(!accept);
        this.wbeFilename.setEnabled(!accept);
        this.wbaFilename.setEnabled(!accept);
        this.wFilename.setEnabled(!accept);
        this.wlFilenameList.setEnabled(!accept);
        this.wFilenameList.setEnabled(!accept);
        this.wlFilemask.setEnabled(!accept);
        this.wlExcludeFilemask.setEnabled(!accept);
        this.wExcludeFilemask.setEnabled(!accept);
        this.wFilemask.setEnabled(!accept);
        this.wbShowFiles.setEnabled(!accept);
        this.wlSkipErrorLines.setEnabled(this.wErrorIgnored.getSelection());
        this.wSkipErrorLines.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wbvErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlWarningExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wWarningExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wbvWarningDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlLineNrExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wLineNrExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wbvLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
    }

    public void getData(ExcelInputMeta meta) {
        TableItem item;
        int i;
        if (meta.getFileName() != null) {
            this.wFilenameList.removeAll();
            for (i = 0; i < meta.getFileName().length; ++i) {
                this.wFilenameList.add(new String[]{meta.getFileName()[i], meta.getFileMask()[i], meta.getExcludeFileMask()[i], meta.getRequiredFilesDesc(meta.getFileRequired()[i]), meta.getRequiredFilesDesc(meta.getIncludeSubFolders()[i])});
            }
            this.wFilenameList.removeEmptyRows();
            this.wFilenameList.setRowNums();
            this.wFilenameList.optWidth(true);
        }
        this.wAccFilenames.setSelection(meta.isAcceptingFilenames());
        if (meta.getAcceptingField() != null && !meta.getAcceptingField().equals("")) {
            this.wAccField.select(this.wAccField.indexOf(meta.getAcceptingField()));
        }
        if (meta.getAcceptingTransformName() != null && !meta.getAcceptingTransformName().equals("")) {
            this.wAccTransform.select(this.wAccTransform.indexOf(meta.getAcceptingTransformName()));
        }
        this.wHeader.setSelection(meta.startsWithHeader());
        this.wNoEmpty.setSelection(meta.ignoreEmptyRows());
        this.wStopOnEmpty.setSelection(meta.stopOnEmpty());
        if (meta.getFileField() != null) {
            this.wInclFilenameField.setText(meta.getFileField());
        }
        if (meta.getSheetField() != null) {
            this.wInclSheetnameField.setText(meta.getSheetField());
        }
        if (meta.getSheetRowNumberField() != null) {
            this.wInclSheetRownumField.setText(meta.getSheetRowNumberField());
        }
        if (meta.getRowNumberField() != null) {
            this.wInclRownumField.setText(meta.getRowNumberField());
        }
        this.wLimit.setText("" + meta.getRowLimit());
        this.wEncoding.setText(Const.NVL((String)meta.getEncoding(), (String)""));
        this.wSpreadSheetType.setText(meta.getSpreadSheetType().getDescription());
        this.wAddResult.setSelection(meta.isAddResultFile());
        if (this.isDebug()) {
            this.logDebug("getting fields info...");
        }
        for (i = 0; i < meta.getField().length; ++i) {
            item = this.wFields.table.getItem(i);
            String field = meta.getField()[i].getName();
            String type = meta.getField()[i].getTypeDesc();
            String length = "" + meta.getField()[i].getLength();
            String prec = "" + meta.getField()[i].getPrecision();
            String trim = meta.getField()[i].getTrimTypeDesc();
            String rep = meta.getField()[i].isRepeated() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
            String format = meta.getField()[i].getFormat();
            String currency = meta.getField()[i].getCurrencySymbol();
            String decimal = meta.getField()[i].getDecimalSymbol();
            String grouping = meta.getField()[i].getGroupSymbol();
            if (field != null) {
                item.setText(1, field);
            }
            if (type != null) {
                item.setText(2, type);
            }
            if (length != null) {
                item.setText(3, length);
            }
            if (prec != null) {
                item.setText(4, prec);
            }
            if (trim != null) {
                item.setText(5, trim);
            }
            if (rep != null) {
                item.setText(6, rep);
            }
            if (format != null) {
                item.setText(7, format);
            }
            if (currency != null) {
                item.setText(8, currency);
            }
            if (decimal != null) {
                item.setText(9, decimal);
            }
            if (grouping == null) continue;
            item.setText(10, grouping);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.logDebug("getting sheets info...");
        for (i = 0; i < meta.getSheetName().length; ++i) {
            item = this.wSheetnameList.table.getItem(i);
            String sheetname = meta.getSheetName()[i];
            String startrow = "" + meta.getStartRow()[i];
            String startcol = "" + meta.getStartColumn()[i];
            if (sheetname != null) {
                item.setText(1, sheetname);
            }
            if (startrow != null) {
                item.setText(2, startrow);
            }
            if (startcol == null) continue;
            item.setText(3, startcol);
        }
        this.wSheetnameList.removeEmptyRows();
        this.wSheetnameList.setRowNums();
        this.wSheetnameList.optWidth(true);
        this.wErrorIgnored.setSelection(meta.isErrorIgnored());
        this.wStrictTypes.setSelection(meta.isStrictTypes());
        this.wSkipErrorLines.setSelection(meta.isErrorLineSkipped());
        if (meta.getWarningFilesDestinationDirectory() != null) {
            this.wWarningDestDir.setText(meta.getWarningFilesDestinationDirectory());
        }
        if (meta.getBadLineFilesExtension() != null) {
            this.wWarningExt.setText(meta.getBadLineFilesExtension());
        }
        if (meta.getErrorFilesDestinationDirectory() != null) {
            this.wErrorDestDir.setText(meta.getErrorFilesDestinationDirectory());
        }
        if (meta.getErrorFilesExtension() != null) {
            this.wErrorExt.setText(meta.getErrorFilesExtension());
        }
        if (meta.getLineNumberFilesDestinationDirectory() != null) {
            this.wLineNrDestDir.setText(meta.getLineNumberFilesDestinationDirectory());
        }
        if (meta.getLineNumberFilesExtension() != null) {
            this.wLineNrExt.setText(meta.getLineNumberFilesExtension());
        }
        if (meta.getPathField() != null) {
            this.wPathFieldName.setText(meta.getPathField());
        }
        if (meta.getShortFileNameField() != null) {
            this.wShortFileFieldName.setText(meta.getShortFileNameField());
        }
        if (meta.getPathField() != null) {
            this.wPathFieldName.setText(meta.getPathField());
        }
        if (meta.isHiddenField() != null) {
            this.wIsHiddenName.setText(meta.isHiddenField());
        }
        if (meta.getLastModificationDateField() != null) {
            this.wLastModificationTimeName.setText(meta.getLastModificationDateField());
        }
        if (meta.getUriField() != null) {
            this.wUriName.setText(meta.getUriField());
        }
        if (meta.getRootUriField() != null) {
            this.wRootUriName.setText(meta.getRootUriField());
        }
        if (meta.getExtensionField() != null) {
            this.wExtensionFieldName.setText(meta.getExtensionField());
        }
        if (meta.getSizeField() != null) {
            this.wSizeFieldName.setText(meta.getSizeField());
        }
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(ExcelInputMeta meta) {
        TableItem item;
        int i;
        TransformMeta currentTransformMeta = this.pipelineMeta.findTransform(this.transformName);
        this.transformName = this.wTransformName.getText();
        meta.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        meta.setEncoding(this.wEncoding.getText());
        meta.setSpreadSheetType(SpreadSheetType.values()[this.wSpreadSheetType.getSelectionIndex()]);
        meta.setFileField(this.wInclFilenameField.getText());
        meta.setSheetField(this.wInclSheetnameField.getText());
        meta.setSheetRowNumberField(this.wInclSheetRownumField.getText());
        meta.setRowNumberField(this.wInclRownumField.getText());
        meta.setAddResultFile(this.wAddResult.getSelection());
        meta.setStartsWithHeader(this.wHeader.getSelection());
        meta.setIgnoreEmptyRows(this.wNoEmpty.getSelection());
        meta.setStopOnEmpty(this.wStopOnEmpty.getSelection());
        meta.setAcceptingFilenames(this.wAccFilenames.getSelection());
        meta.setAcceptingField(this.wAccField.getText());
        meta.setAcceptingTransformName(this.wAccTransform.getText());
        meta.searchInfoAndTargetTransforms(this.pipelineMeta.findPreviousTransforms(currentTransformMeta));
        int nrfiles = this.wFilenameList.nrNonEmpty();
        int nrsheets = this.wSheetnameList.nrNonEmpty();
        int nrFields = this.wFields.nrNonEmpty();
        meta.allocate(nrfiles, nrsheets, nrFields);
        meta.setFileName(this.wFilenameList.getItems(0));
        meta.setFileMask(this.wFilenameList.getItems(1));
        meta.setExcludeFileMask(this.wFilenameList.getItems(2));
        meta.setFileRequired(this.wFilenameList.getItems(3));
        meta.setIncludeSubFolders(this.wFilenameList.getItems(4));
        for (i = 0; i < nrsheets; ++i) {
            item = this.wSheetnameList.getNonEmpty(i);
            meta.getSheetName()[i] = item.getText(1);
            meta.getStartRow()[i] = Const.toInt((String)item.getText(2), (int)0);
            meta.getStartColumn()[i] = Const.toInt((String)item.getText(3), (int)0);
        }
        for (i = 0; i < nrFields; ++i) {
            item = this.wFields.getNonEmpty(i);
            meta.getField()[i] = new ExcelInputField();
            meta.getField()[i].setName(item.getText(1));
            meta.getField()[i].setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(2)));
            String slength = item.getText(3);
            String sprec = item.getText(4);
            meta.getField()[i].setTrimType(ExcelInputMeta.getTrimTypeByDesc(item.getText(5)));
            meta.getField()[i].setRepeated(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(6)));
            meta.getField()[i].setLength(Const.toInt((String)slength, (int)-1));
            meta.getField()[i].setPrecision(Const.toInt((String)sprec, (int)-1));
            meta.getField()[i].setFormat(item.getText(7));
            meta.getField()[i].setCurrencySymbol(item.getText(8));
            meta.getField()[i].setDecimalSymbol(item.getText(9));
            meta.getField()[i].setGroupSymbol(item.getText(10));
        }
        meta.setStrictTypes(this.wStrictTypes.getSelection());
        meta.setErrorIgnored(this.wErrorIgnored.getSelection());
        meta.setErrorLineSkipped(this.wSkipErrorLines.getSelection());
        meta.setWarningFilesDestinationDirectory(this.wWarningDestDir.getText());
        meta.setBadLineFilesExtension(this.wWarningExt.getText());
        meta.setErrorFilesDestinationDirectory(this.wErrorDestDir.getText());
        meta.setErrorFilesExtension(this.wErrorExt.getText());
        meta.setLineNumberFilesDestinationDirectory(this.wLineNrDestDir.getText());
        meta.setLineNumberFilesExtension(this.wLineNrExt.getText());
        meta.setShortFileNameField(this.wShortFileFieldName.getText());
        meta.setPathField(this.wPathFieldName.getText());
        meta.setIsHiddenField(this.wIsHiddenName.getText());
        meta.setLastModificationDateField(this.wLastModificationTimeName.getText());
        meta.setUriField(this.wUriName.getText());
        meta.setRootUriField(this.wRootUriName.getText());
        meta.setExtensionField(this.wExtensionFieldName.getText());
        meta.setSizeField(this.wSizeFieldName.getText());
    }

    private void addErrorTab() {
        CTabItem wErrorTab = new CTabItem(this.wTabFolder, 0);
        wErrorTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorTab.TabTitle", (String[])new String[0]));
        FormLayout errorLayout = new FormLayout();
        errorLayout.marginWidth = 3;
        errorLayout.marginHeight = 3;
        Composite wErrorComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wErrorComp);
        wErrorComp.setLayout((Layout)errorLayout);
        Label wlStrictTypes = new Label(wErrorComp, 131072);
        wlStrictTypes.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StrictTypes.Label", (String[])new String[0]));
        this.props.setLook((Control)wlStrictTypes);
        FormData fdlStrictTypes = new FormData();
        fdlStrictTypes.left = new FormAttachment(0, 0);
        fdlStrictTypes.top = new FormAttachment(0, this.margin);
        fdlStrictTypes.right = new FormAttachment(this.middle, -this.margin);
        wlStrictTypes.setLayoutData((Object)fdlStrictTypes);
        this.wStrictTypes = new Button(wErrorComp, 32);
        this.props.setLook((Control)this.wStrictTypes);
        this.wStrictTypes.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.StrictTypes.Tooltip", (String[])new String[0]));
        FormData fdStrictTypes = new FormData();
        fdStrictTypes.left = new FormAttachment(this.middle, 0);
        fdStrictTypes.top = new FormAttachment((Control)wlStrictTypes, 0, 0x1000000);
        this.wStrictTypes.setLayoutData((Object)fdStrictTypes);
        Button previous = this.wStrictTypes;
        this.wStrictTypes.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlErrorIgnored = new Label(wErrorComp, 131072);
        wlErrorIgnored.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorIgnored.Label", (String[])new String[0]));
        this.props.setLook((Control)wlErrorIgnored);
        FormData fdlErrorIgnored = new FormData();
        fdlErrorIgnored.left = new FormAttachment(0, 0);
        fdlErrorIgnored.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorIgnored.right = new FormAttachment(this.middle, -this.margin);
        wlErrorIgnored.setLayoutData((Object)fdlErrorIgnored);
        this.wErrorIgnored = new Button(wErrorComp, 32);
        this.props.setLook((Control)this.wErrorIgnored);
        this.wErrorIgnored.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorIgnored.Tooltip", (String[])new String[0]));
        FormData fdErrorIgnored = new FormData();
        fdErrorIgnored.left = new FormAttachment(this.middle, 0);
        fdErrorIgnored.top = new FormAttachment((Control)wlErrorIgnored, 0, 0x1000000);
        this.wErrorIgnored.setLayoutData((Object)fdErrorIgnored);
        previous = this.wErrorIgnored;
        this.wErrorIgnored.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ExcelInputDialog.this.setFlags();
                ExcelInputDialog.this.input.setChanged();
            }
        });
        this.wlSkipErrorLines = new Label(wErrorComp, 131072);
        this.wlSkipErrorLines.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SkipErrorLines.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSkipErrorLines);
        FormData fdlSkipErrorLines = new FormData();
        fdlSkipErrorLines.left = new FormAttachment(0, 0);
        fdlSkipErrorLines.top = new FormAttachment((Control)previous, this.margin);
        fdlSkipErrorLines.right = new FormAttachment(this.middle, -this.margin);
        this.wlSkipErrorLines.setLayoutData((Object)fdlSkipErrorLines);
        this.wSkipErrorLines = new Button(wErrorComp, 32);
        this.props.setLook((Control)this.wSkipErrorLines);
        this.wSkipErrorLines.setToolTipText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SkipErrorLines.Tooltip", (String[])new String[0]));
        FormData fdSkipErrorLines = new FormData();
        fdSkipErrorLines.left = new FormAttachment(this.middle, 0);
        fdSkipErrorLines.top = new FormAttachment((Control)this.wlSkipErrorLines, 0, 0x1000000);
        this.wSkipErrorLines.setLayoutData((Object)fdSkipErrorLines);
        this.wSkipErrorLines.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        previous = this.wSkipErrorLines;
        this.wlWarningDestDir = new Label(wErrorComp, 131072);
        this.wlWarningDestDir.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.WarningDestDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlWarningDestDir);
        FormData fdlWarningDestDir = new FormData();
        fdlWarningDestDir.left = new FormAttachment(0, 0);
        fdlWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        fdlWarningDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlWarningDestDir.setLayoutData((Object)fdlWarningDestDir);
        this.wbbWarningDestDir = new Button(wErrorComp, 0x1000008);
        this.props.setLook((Control)this.wbbWarningDestDir);
        this.wbbWarningDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbWarningDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForDir", (String[])new String[0]));
        FormData fdbWarningDestDir = new FormData();
        fdbWarningDestDir.right = new FormAttachment(100, 0);
        fdbWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wbbWarningDestDir.setLayoutData((Object)fdbWarningDestDir);
        this.wbvWarningDestDir = new Button(wErrorComp, 0x1000008);
        this.props.setLook((Control)this.wbvWarningDestDir);
        this.wbvWarningDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Variable", (String[])new String[0]));
        this.wbvWarningDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.VariableToDir", (String[])new String[0]));
        FormData fdbvWarningDestDir = new FormData();
        fdbvWarningDestDir.right = new FormAttachment((Control)this.wbbWarningDestDir, -this.margin);
        fdbvWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wbvWarningDestDir.setLayoutData((Object)fdbvWarningDestDir);
        this.wWarningExt = new Text(wErrorComp, 18436);
        this.props.setLook((Control)this.wWarningExt);
        this.wWarningExt.addModifyListener(this.lsMod);
        FormData fdWarningDestExt = new FormData();
        fdWarningDestExt.left = new FormAttachment((Control)this.wbvWarningDestDir, -150);
        fdWarningDestExt.right = new FormAttachment((Control)this.wbvWarningDestDir, -this.margin);
        fdWarningDestExt.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wWarningExt.setLayoutData((Object)fdWarningDestExt);
        this.wlWarningExt = new Label(wErrorComp, 131072);
        this.wlWarningExt.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        this.props.setLook((Control)this.wlWarningExt);
        FormData fdlWarningDestExt = new FormData();
        fdlWarningDestExt.top = new FormAttachment((Control)previous, this.margin * 4);
        fdlWarningDestExt.right = new FormAttachment((Control)this.wWarningExt, -this.margin);
        this.wlWarningExt.setLayoutData((Object)fdlWarningDestExt);
        this.wWarningDestDir = new TextVar(this.variables, wErrorComp, 18436);
        this.props.setLook((Control)this.wWarningDestDir);
        this.wWarningDestDir.addModifyListener(this.lsMod);
        FormData fdWarningDestDir = new FormData();
        fdWarningDestDir.left = new FormAttachment(this.middle, 0);
        fdWarningDestDir.right = new FormAttachment((Control)this.wlWarningExt, -this.margin);
        fdWarningDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wWarningDestDir.setLayoutData((Object)fdWarningDestDir);
        this.wbbWarningDestDir.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wWarningDestDir, (IVariables)this.variables));
        this.wbvWarningDestDir.addSelectionListener((SelectionListener)VariableButtonListenerFactory.getSelectionAdapter((Composite)this.shell, (TextVar)this.wWarningDestDir, (IVariables)this.variables));
        this.wWarningDestDir.addModifyListener(ExcelInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wWarningDestDir));
        previous = this.wWarningDestDir;
        this.wlErrorDestDir = new Label(wErrorComp, 131072);
        this.wlErrorDestDir.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorDestDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlErrorDestDir);
        FormData fdlErrorDestDir = new FormData();
        fdlErrorDestDir.left = new FormAttachment(0, 0);
        fdlErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlErrorDestDir.setLayoutData((Object)fdlErrorDestDir);
        this.wbbErrorDestDir = new Button(wErrorComp, 0x1000008);
        this.props.setLook((Control)this.wbbErrorDestDir);
        this.wbbErrorDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbErrorDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForDir", (String[])new String[0]));
        FormData fdbErrorDestDir = new FormData();
        fdbErrorDestDir.right = new FormAttachment(100, 0);
        fdbErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbbErrorDestDir.setLayoutData((Object)fdbErrorDestDir);
        this.wbvErrorDestDir = new Button(wErrorComp, 0x1000008);
        this.props.setLook((Control)this.wbvErrorDestDir);
        this.wbvErrorDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Variable", (String[])new String[0]));
        this.wbvErrorDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.VariableToDir", (String[])new String[0]));
        FormData fdbvErrorDestDir = new FormData();
        fdbvErrorDestDir.right = new FormAttachment((Control)this.wbbErrorDestDir, -this.margin);
        fdbvErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbvErrorDestDir.setLayoutData((Object)fdbvErrorDestDir);
        this.wErrorExt = new Text(wErrorComp, 18436);
        this.props.setLook((Control)this.wErrorExt);
        this.wErrorExt.addModifyListener(this.lsMod);
        FormData fdErrorDestExt = new FormData();
        fdErrorDestExt.left = new FormAttachment((Control)this.wbvErrorDestDir, -150);
        fdErrorDestExt.right = new FormAttachment((Control)this.wbvErrorDestDir, -this.margin);
        fdErrorDestExt.top = new FormAttachment((Control)previous, this.margin);
        this.wErrorExt.setLayoutData((Object)fdErrorDestExt);
        this.wlErrorExt = new Label(wErrorComp, 131072);
        this.wlErrorExt.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        this.props.setLook((Control)this.wlErrorExt);
        FormData fdlErrorDestExt = new FormData();
        fdlErrorDestExt.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorDestExt.right = new FormAttachment((Control)this.wErrorExt, -this.margin);
        this.wlErrorExt.setLayoutData((Object)fdlErrorDestExt);
        this.wErrorDestDir = new TextVar(this.variables, wErrorComp, 18436);
        this.props.setLook((Control)this.wErrorDestDir);
        this.wErrorDestDir.addModifyListener(this.lsMod);
        FormData fdErrorDestDir = new FormData();
        fdErrorDestDir.left = new FormAttachment(this.middle, 0);
        fdErrorDestDir.right = new FormAttachment((Control)this.wlErrorExt, -this.margin);
        fdErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wErrorDestDir.setLayoutData((Object)fdErrorDestDir);
        this.wbbErrorDestDir.addSelectionListener((SelectionListener)DirectoryDialogButtonListenerFactory.getSelectionAdapter((Shell)this.shell, (TextVar)this.wErrorDestDir));
        this.wbvErrorDestDir.addSelectionListener((SelectionListener)VariableButtonListenerFactory.getSelectionAdapter((Composite)this.shell, (TextVar)this.wErrorDestDir, (IVariables)this.variables));
        this.wErrorDestDir.addModifyListener(ExcelInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wErrorDestDir));
        previous = this.wErrorDestDir;
        this.wlLineNrDestDir = new Label(wErrorComp, 131072);
        this.wlLineNrDestDir.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.LineNrDestDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLineNrDestDir);
        FormData fdlLineNrDestDir = new FormData();
        fdlLineNrDestDir.left = new FormAttachment(0, 0);
        fdlLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        fdlLineNrDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlLineNrDestDir.setLayoutData((Object)fdlLineNrDestDir);
        this.wbbLineNrDestDir = new Button(wErrorComp, 0x1000008);
        this.props.setLook((Control)this.wbbLineNrDestDir);
        this.wbbLineNrDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbLineNrDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForDir", (String[])new String[0]));
        FormData fdbLineNrDestDir = new FormData();
        fdbLineNrDestDir.right = new FormAttachment(100, 0);
        fdbLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbbLineNrDestDir.setLayoutData((Object)fdbLineNrDestDir);
        this.wbvLineNrDestDir = new Button(wErrorComp, 0x1000008);
        this.props.setLook((Control)this.wbvLineNrDestDir);
        this.wbvLineNrDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Variable", (String[])new String[0]));
        this.wbvLineNrDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.VariableToDir", (String[])new String[0]));
        FormData fdbvLineNrDestDir = new FormData();
        fdbvLineNrDestDir.right = new FormAttachment((Control)this.wbbLineNrDestDir, -this.margin);
        fdbvLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbvLineNrDestDir.setLayoutData((Object)fdbvLineNrDestDir);
        this.wLineNrExt = new Text(wErrorComp, 18436);
        this.props.setLook((Control)this.wLineNrExt);
        this.wLineNrExt.addModifyListener(this.lsMod);
        FormData fdLineNrDestExt = new FormData();
        fdLineNrDestExt.left = new FormAttachment((Control)this.wbvLineNrDestDir, -150);
        fdLineNrDestExt.right = new FormAttachment((Control)this.wbvLineNrDestDir, -this.margin);
        fdLineNrDestExt.top = new FormAttachment((Control)previous, this.margin);
        this.wLineNrExt.setLayoutData((Object)fdLineNrDestExt);
        this.wlLineNrExt = new Label(wErrorComp, 131072);
        this.wlLineNrExt.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        this.props.setLook((Control)this.wlLineNrExt);
        FormData fdlLineNrDestExt = new FormData();
        fdlLineNrDestExt.top = new FormAttachment((Control)previous, this.margin);
        fdlLineNrDestExt.right = new FormAttachment((Control)this.wLineNrExt, -this.margin);
        this.wlLineNrExt.setLayoutData((Object)fdlLineNrDestExt);
        this.wLineNrDestDir = new TextVar(this.variables, wErrorComp, 18436);
        this.props.setLook((Control)this.wLineNrDestDir);
        this.wLineNrDestDir.addModifyListener(this.lsMod);
        FormData fdLineNrDestDir = new FormData();
        fdLineNrDestDir.left = new FormAttachment(this.middle, 0);
        fdLineNrDestDir.right = new FormAttachment((Control)this.wlLineNrExt, -this.margin);
        fdLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wLineNrDestDir.setLayoutData((Object)fdLineNrDestDir);
        this.wbbLineNrDestDir.addSelectionListener((SelectionListener)DirectoryDialogButtonListenerFactory.getSelectionAdapter((Shell)this.shell, (TextVar)this.wLineNrDestDir));
        this.wbvLineNrDestDir.addSelectionListener((SelectionListener)VariableButtonListenerFactory.getSelectionAdapter((Composite)this.shell, (TextVar)this.wLineNrDestDir, (IVariables)this.variables));
        this.wLineNrDestDir.addModifyListener(ExcelInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wLineNrDestDir));
        wErrorComp.layout();
        wErrorTab.setControl((Control)wErrorComp);
    }

    private void preview() {
        ExcelInputMeta oneMeta = new ExcelInputMeta();
        this.getInfo(oneMeta);
        if (oneMeta.isAcceptingFilenames()) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Dialog.SpecifyASampleFile.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.Dialog.SpecifyASampleFile.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"ExcelInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    public void getSheets() {
        ArrayList<String> sheetnames = new ArrayList<String>();
        ExcelInputMeta info = new ExcelInputMeta();
        this.getInfo(info);
        FileInputList fileList = info.getFileList(this.variables);
        for (FileObject fileObject : fileList.getFiles()) {
            try {
                IKWorkbook workbook = WorkbookFactory.getWorkbook(info.getSpreadSheetType(), HopVfs.getFilename((FileObject)fileObject), info.getEncoding());
                int nrSheets = workbook.getNumberOfSheets();
                for (int j = 0; j < nrSheets; ++j) {
                    IKSheet sheet = workbook.getSheet(j);
                    String sheetname = sheet.getName();
                    if (Const.indexOfString((String)sheetname, sheetnames) >= 0) continue;
                    sheetnames.add(sheetname);
                }
                workbook.close();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorReadingFile.DialogMessage", (String[])new String[]{HopVfs.getFilename((FileObject)fileObject)}), e);
            }
        }
        String[] lst = sheetnames.toArray(new String[sheetnames.size()]);
        EnterListDialog esd = new EnterListDialog(this.shell, 0, lst);
        String[] selection = esd.open();
        if (selection != null) {
            for (String s : selection) {
                this.wSheetnameList.add(new String[]{s, ""});
            }
            this.wSheetnameList.removeEmptyRows();
            this.wSheetnameList.setRowNums();
            this.wSheetnameList.optWidth(true);
            this.checkAlerts();
        }
    }

    public void getFields() {
        RowMeta fields = new RowMeta();
        ExcelInputMeta info = new ExcelInputMeta();
        this.getInfo(info);
        int clearFields = 64;
        if (this.wFields.nrNonEmpty() > 0) {
            MessageBox messageBox = new MessageBox(this.shell, 452);
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ClearFieldList.DialogMessage", (String[])new String[0]));
            messageBox.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ClearFieldList.DialogTitle", (String[])new String[0]));
            clearFields = messageBox.open();
            if (clearFields == 256) {
                return;
            }
        }
        FileInputList fileList = info.getFileList(this.variables);
        for (FileObject file : fileList.getFiles()) {
            try {
                IKWorkbook workbook = WorkbookFactory.getWorkbook(info.getSpreadSheetType(), HopVfs.getFilename((FileObject)file), info.getEncoding());
                this.processingWorkbook((IRowMeta)fields, info, workbook);
                workbook.close();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.ErrorReadingFile2.DialogMessage", (String[])new String[]{HopVfs.getFilename((FileObject)file), e.toString()}), e);
            }
        }
        if (fields.size() > 0) {
            if (clearFields == 64) {
                this.wFields.clearAll(false);
            }
            for (int j = 0; j < fields.size(); ++j) {
                IValueMeta field = fields.getValueMeta(j);
                this.wFields.add(new String[]{field.getName(), field.getTypeDesc(), "", "", "none", "N"});
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        } else {
            MessageBox mb = new MessageBox(this.shell, 40);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.UnableToFindFields.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.UnableToFindFields.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.checkAlerts();
    }

    private void processingWorkbook(IRowMeta fields, ExcelInputMeta info, IKWorkbook workbook) throws HopPluginException {
        int nrSheets = workbook.getNumberOfSheets();
        for (int j = 0; j < nrSheets; ++j) {
            IKSheet sheet = workbook.getSheet(j);
            int sheetIndex = info.readAllSheets() ? 0 : Const.indexOfString((String)sheet.getName(), (String[])info.getSheetName());
            if (sheetIndex < 0) continue;
            int rownr = 0;
            int startcol = 0;
            if (info.readAllSheets()) {
                if (info.getStartColumn().length == 1) {
                    startcol = info.getStartColumn()[0];
                }
                if (info.getStartRow().length == 1) {
                    rownr = info.getStartRow()[0];
                }
            } else {
                rownr = info.getStartRow()[sheetIndex];
                startcol = info.getStartColumn()[sheetIndex];
            }
            boolean stop = false;
            int colnr = startcol;
            while (!stop) {
                try {
                    String fieldname = null;
                    int fieldtype = 0;
                    IKCell cell = sheet.getCell(colnr, rownr);
                    if (cell == null) {
                        stop = true;
                    } else {
                        IKCell below;
                        if (cell.getType() != KCellType.EMPTY) {
                            fieldname = cell.getContents();
                        }
                        fieldtype = (below = sheet.getCell(colnr, rownr + 1)) != null ? (below.getType() == KCellType.BOOLEAN ? 4 : (below.getType() == KCellType.DATE ? 3 : (below.getType() == KCellType.LABEL ? 2 : (below.getType() == KCellType.NUMBER ? 1 : 2)))) : 2;
                        if (Utils.isEmpty((CharSequence)fieldname)) {
                            stop = true;
                        } else if (fieldtype != 0) {
                            IValueMeta field = ValueMetaFactory.createValueMeta((String)fieldname, (int)fieldtype);
                            fields.addValueMeta(field);
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    stop = true;
                }
                ++colnr;
            }
        }
    }

    private void showFiles() {
        ExcelInputMeta eii = new ExcelInputMeta();
        this.getInfo(eii);
        String[] files = eii.getFilePaths(HopGui.getInstance().getVariables());
        if (files.length > 0) {
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, files, BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilesRead.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExcelInputDialog.FilesRead.DialogMessage", (String[])new String[0]));
            esd.setViewOnly();
            esd.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExcelInputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    private void checkAlerts() {
        this.logDebug("checkAlerts");
        boolean fieldsOk = this.wFields.nrNonEmpty() != 0;
        boolean sheetsOk = this.wSheetnameList.nrNonEmpty() != 0;
        boolean filesOk = this.wFilenameList.nrNonEmpty() != 0 || this.wAccFilenames.getSelection() && !Utils.isEmpty((CharSequence)this.wAccField.getText());
        String msgText = "";
        if (!fieldsOk) {
            msgText = BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFields", (String[])new String[0]);
        } else if (!sheetsOk) {
            msgText = BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddSheets", (String[])new String[0]);
        } else if (!filesOk) {
            msgText = BaseMessages.getString(PKG, (String)"ExcelInputDialog.AddFilenames", (String[])new String[0]);
        }
        this.tagTab(!fieldsOk, this.wFieldsTab, BaseMessages.getString(PKG, (String)"ExcelInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        this.tagTab(!sheetsOk, this.wSheetTab, BaseMessages.getString(PKG, (String)"ExcelInputDialog.SheetsTab.TabTitle", (String[])new String[0]));
        this.tagTab(!filesOk, this.wFileTab, BaseMessages.getString(PKG, (String)"ExcelInputDialog.FileTab.TabTitle", (String[])new String[0]));
        this.wPreview.setEnabled(fieldsOk && sheetsOk && filesOk);
        this.wlStatusMessage.setText(msgText);
    }

    private void tagTab(boolean hilightMe, CTabItem tabItem, String tabCaption) {
        if (hilightMe) {
            tabItem.setText(TAB_FLAG + tabCaption);
        } else {
            tabItem.setText(tabCaption);
        }
    }

    private void addAdditionalFieldsTab() {
        CTabItem wAdditionalFieldsTab = new CTabItem(this.wTabFolder, 0);
        wAdditionalFieldsTab.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.AdditionalFieldsTab.TabTitle", (String[])new String[0]));
        Composite wAdditionalFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wAdditionalFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wAdditionalFieldsComp.setLayout((Layout)fieldsLayout);
        Label wlInclFilenameField = new Label(wAdditionalFieldsComp, 131072);
        wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclFilenameField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInclFilenameField);
        FormData fdlInclFilenameField = new FormData();
        fdlInclFilenameField.left = new FormAttachment(0, 0);
        fdlInclFilenameField.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdlInclFilenameField.right = new FormAttachment(this.middle, -this.margin);
        wlInclFilenameField.setLayoutData((Object)fdlInclFilenameField);
        this.wInclFilenameField = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wInclFilenameField);
        this.wInclFilenameField.addModifyListener(this.lsMod);
        FormData fdInclFilenameField = new FormData();
        fdInclFilenameField.left = new FormAttachment(this.middle, 0);
        fdInclFilenameField.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)fdInclFilenameField);
        Label wlInclSheetnameField = new Label(wAdditionalFieldsComp, 131072);
        wlInclSheetnameField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclSheetnameField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInclSheetnameField);
        FormData fdlInclSheetnameField = new FormData();
        fdlInclSheetnameField.left = new FormAttachment(0, 0);
        fdlInclSheetnameField.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        fdlInclSheetnameField.right = new FormAttachment(this.middle, -this.margin);
        wlInclSheetnameField.setLayoutData((Object)fdlInclSheetnameField);
        this.wInclSheetnameField = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wInclSheetnameField);
        this.wInclSheetnameField.addModifyListener(this.lsMod);
        FormData fdInclSheetnameField = new FormData();
        fdInclSheetnameField.left = new FormAttachment(this.middle, 0);
        fdInclSheetnameField.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        fdInclSheetnameField.right = new FormAttachment(100, 0);
        this.wInclSheetnameField.setLayoutData((Object)fdInclSheetnameField);
        Label wlInclSheetRownumField = new Label(wAdditionalFieldsComp, 131072);
        wlInclSheetRownumField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclSheetRownumField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInclSheetRownumField);
        FormData fdlInclSheetRownumField = new FormData();
        fdlInclSheetRownumField.left = new FormAttachment(0, 0);
        fdlInclSheetRownumField.top = new FormAttachment((Control)this.wInclSheetnameField, this.margin);
        fdlInclSheetRownumField.right = new FormAttachment(this.middle, -this.margin);
        wlInclSheetRownumField.setLayoutData((Object)fdlInclSheetRownumField);
        this.wInclSheetRownumField = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wInclSheetRownumField);
        this.wInclSheetRownumField.addModifyListener(this.lsMod);
        FormData fdInclSheetRownumField = new FormData();
        fdInclSheetRownumField.left = new FormAttachment(this.middle, 0);
        fdInclSheetRownumField.top = new FormAttachment((Control)this.wInclSheetnameField, this.margin);
        fdInclSheetRownumField.right = new FormAttachment(100, 0);
        this.wInclSheetRownumField.setLayoutData((Object)fdInclSheetRownumField);
        Label wlInclRownumField = new Label(wAdditionalFieldsComp, 131072);
        wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.InclRownumField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInclRownumField);
        FormData fdlInclRownumField = new FormData();
        fdlInclRownumField.left = new FormAttachment(0, 0);
        fdlInclRownumField.top = new FormAttachment((Control)this.wInclSheetRownumField, this.margin);
        fdlInclRownumField.right = new FormAttachment(this.middle, -this.margin);
        wlInclRownumField.setLayoutData((Object)fdlInclRownumField);
        this.wInclRownumField = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(this.lsMod);
        FormData fdInclRownumField = new FormData();
        fdInclRownumField.left = new FormAttachment(this.middle, 0);
        fdInclRownumField.top = new FormAttachment((Control)this.wInclSheetRownumField, this.margin);
        fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)fdInclRownumField);
        Label wlShortFileFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlShortFileFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ShortFileFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlShortFileFieldName);
        FormData fdlShortFileFieldName = new FormData();
        fdlShortFileFieldName.left = new FormAttachment(0, 0);
        fdlShortFileFieldName.top = new FormAttachment((Control)this.wInclRownumField, this.margin);
        fdlShortFileFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlShortFileFieldName.setLayoutData((Object)fdlShortFileFieldName);
        this.wShortFileFieldName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wShortFileFieldName);
        this.wShortFileFieldName.addModifyListener(this.lsMod);
        FormData fdShortFileFieldName = new FormData();
        fdShortFileFieldName.left = new FormAttachment(this.middle, 0);
        fdShortFileFieldName.right = new FormAttachment(100, -this.margin);
        fdShortFileFieldName.top = new FormAttachment((Control)this.wInclRownumField, this.margin);
        this.wShortFileFieldName.setLayoutData((Object)fdShortFileFieldName);
        Label wlExtensionFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlExtensionFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.ExtensionFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlExtensionFieldName);
        FormData fdlExtensionFieldName = new FormData();
        fdlExtensionFieldName.left = new FormAttachment(0, 0);
        fdlExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        fdlExtensionFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlExtensionFieldName.setLayoutData((Object)fdlExtensionFieldName);
        this.wExtensionFieldName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wExtensionFieldName);
        this.wExtensionFieldName.addModifyListener(this.lsMod);
        FormData fdExtensionFieldName = new FormData();
        fdExtensionFieldName.left = new FormAttachment(this.middle, 0);
        fdExtensionFieldName.right = new FormAttachment(100, -this.margin);
        fdExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        this.wExtensionFieldName.setLayoutData((Object)fdExtensionFieldName);
        Label wlPathFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlPathFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.PathFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPathFieldName);
        FormData fdlPathFieldName = new FormData();
        fdlPathFieldName.left = new FormAttachment(0, 0);
        fdlPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        fdlPathFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlPathFieldName.setLayoutData((Object)fdlPathFieldName);
        this.wPathFieldName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wPathFieldName);
        this.wPathFieldName.addModifyListener(this.lsMod);
        FormData fdPathFieldName = new FormData();
        fdPathFieldName.left = new FormAttachment(this.middle, 0);
        fdPathFieldName.right = new FormAttachment(100, -this.margin);
        fdPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        this.wPathFieldName.setLayoutData((Object)fdPathFieldName);
        Label wlSizeFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlSizeFieldName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.SizeFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSizeFieldName);
        FormData fdlSizeFieldName = new FormData();
        fdlSizeFieldName.left = new FormAttachment(0, 0);
        fdlSizeFieldName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        fdlSizeFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlSizeFieldName.setLayoutData((Object)fdlSizeFieldName);
        this.wSizeFieldName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wSizeFieldName);
        this.wSizeFieldName.addModifyListener(this.lsMod);
        FormData fdSizeFieldName = new FormData();
        fdSizeFieldName.left = new FormAttachment(this.middle, 0);
        fdSizeFieldName.right = new FormAttachment(100, -this.margin);
        fdSizeFieldName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        this.wSizeFieldName.setLayoutData((Object)fdSizeFieldName);
        Label wlIsHiddenName = new Label(wAdditionalFieldsComp, 131072);
        wlIsHiddenName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.IsHiddenName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlIsHiddenName);
        FormData fdlIsHiddenName = new FormData();
        fdlIsHiddenName.left = new FormAttachment(0, 0);
        fdlIsHiddenName.top = new FormAttachment((Control)this.wSizeFieldName, this.margin);
        fdlIsHiddenName.right = new FormAttachment(this.middle, -this.margin);
        wlIsHiddenName.setLayoutData((Object)fdlIsHiddenName);
        this.wIsHiddenName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wIsHiddenName);
        this.wIsHiddenName.addModifyListener(this.lsMod);
        FormData fdIsHiddenName = new FormData();
        fdIsHiddenName.left = new FormAttachment(this.middle, 0);
        fdIsHiddenName.right = new FormAttachment(100, -this.margin);
        fdIsHiddenName.top = new FormAttachment((Control)this.wSizeFieldName, this.margin);
        this.wIsHiddenName.setLayoutData((Object)fdIsHiddenName);
        Label wlLastModificationTimeName = new Label(wAdditionalFieldsComp, 131072);
        wlLastModificationTimeName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.LastModificationTimeName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLastModificationTimeName);
        FormData fdlLastModificationTimeName = new FormData();
        fdlLastModificationTimeName.left = new FormAttachment(0, 0);
        fdlLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        fdlLastModificationTimeName.right = new FormAttachment(this.middle, -this.margin);
        wlLastModificationTimeName.setLayoutData((Object)fdlLastModificationTimeName);
        this.wLastModificationTimeName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wLastModificationTimeName);
        this.wLastModificationTimeName.addModifyListener(this.lsMod);
        FormData fdLastModificationTimeName = new FormData();
        fdLastModificationTimeName.left = new FormAttachment(this.middle, 0);
        fdLastModificationTimeName.right = new FormAttachment(100, -this.margin);
        fdLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        this.wLastModificationTimeName.setLayoutData((Object)fdLastModificationTimeName);
        Label wlUriName = new Label(wAdditionalFieldsComp, 131072);
        wlUriName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.UriName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUriName);
        FormData fdlUriName = new FormData();
        fdlUriName.left = new FormAttachment(0, 0);
        fdlUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        fdlUriName.right = new FormAttachment(this.middle, -this.margin);
        wlUriName.setLayoutData((Object)fdlUriName);
        this.wUriName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wUriName);
        this.wUriName.addModifyListener(this.lsMod);
        FormData fdUriName = new FormData();
        fdUriName.left = new FormAttachment(this.middle, 0);
        fdUriName.right = new FormAttachment(100, -this.margin);
        fdUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        this.wUriName.setLayoutData((Object)fdUriName);
        Label wlRootUriName = new Label(wAdditionalFieldsComp, 131072);
        wlRootUriName.setText(BaseMessages.getString(PKG, (String)"ExcelInputDialog.RootUriName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRootUriName);
        FormData fdlRootUriName = new FormData();
        fdlRootUriName.left = new FormAttachment(0, 0);
        fdlRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        fdlRootUriName.right = new FormAttachment(this.middle, -this.margin);
        wlRootUriName.setLayoutData((Object)fdlRootUriName);
        this.wRootUriName = new Text(wAdditionalFieldsComp, 18436);
        this.props.setLook((Control)this.wRootUriName);
        this.wRootUriName.addModifyListener(this.lsMod);
        FormData fdRootUriName = new FormData();
        fdRootUriName.left = new FormAttachment(this.middle, 0);
        fdRootUriName.right = new FormAttachment(100, -this.margin);
        fdRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        this.wRootUriName.setLayoutData((Object)fdRootUriName);
        FormData fdAdditionalFieldsComp = new FormData();
        fdAdditionalFieldsComp.left = new FormAttachment(0, 0);
        fdAdditionalFieldsComp.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdAdditionalFieldsComp.right = new FormAttachment(100, 0);
        fdAdditionalFieldsComp.bottom = new FormAttachment(100, 0);
        wAdditionalFieldsComp.setLayoutData((Object)fdAdditionalFieldsComp);
        wAdditionalFieldsComp.layout();
        wAdditionalFieldsTab.setControl((Control)wAdditionalFieldsComp);
    }
}

